/* testProgress.t.cc */
#include "osl/progress/ml/newProgress.h"
#include "osl/state/numEffectState.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include "osl/oslConfig.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>
#include <fstream>

class NewProgressTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE(NewProgressTest);
  CPPUNIT_TEST(testInit);
  CPPUNIT_TEST(testConsistentUpdate);
  CPPUNIT_TEST(testSymmetry);
  CPPUNIT_TEST_SUITE_END();
public:
  void testInit();
  void testConsistentUpdate();
  void testSymmetry();
};

CPPUNIT_TEST_SUITE_REGISTRATION(NewProgressTest);

using namespace osl::progress::ml;
void NewProgressTest::testInit()
{
  CPPUNIT_ASSERT(NewProgress::setUp());
}

void NewProgressTest::testConsistentUpdate()
{
  using namespace osl;

  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string file_name;
  for (int i=0;i<(OslConfig::inUnitTestShort() ? 10 : 200) && (ifs >> file_name) ; i++)
  {
    if (file_name == "") 
      break;
    file_name = OslConfig::testCsaFile(file_name);

    const Record rec=CsaFile(file_name).getRecord();
    const vector<osl::Move> moves=rec.getMoves();

    NumEffectState state(rec.getInitialState());
    NewProgress progress(state);
    
    for (unsigned int i=0; i<moves.size(); i++)
    {
      const Move m = moves[i];
      state.makeMove(m);
      progress.update(state, m);
      const NewProgress new_progress(state);
      CPPUNIT_ASSERT_EQUAL(new_progress.progress16(BLACK).value(),
			   progress.progress16(BLACK).value());
      CPPUNIT_ASSERT_EQUAL(new_progress.progress16(WHITE).value(),
			   progress.progress16(WHITE).value());
      CPPUNIT_ASSERT_EQUAL(new_progress.progress(), 
			   progress.progress());
      CPPUNIT_ASSERT(new_progress == progress);
      CPPUNIT_ASSERT(new_progress.progress() <= progress.maxProgress());
      CPPUNIT_ASSERT(new_progress.progress16().isValid());
      CPPUNIT_ASSERT(progress.progress16().isValid());
    }
  }
}

void NewProgressTest::testSymmetry()
{
  using namespace osl;

  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string file_name;
  for (int i=0;i<(OslConfig::inUnitTestShort() ? 10 : 200) && (ifs >> file_name) ; i++)
  {
    if (file_name == "") 
      break;
    file_name = OslConfig::testCsaFile(file_name);

    const Record rec=CsaFile(file_name).getRecord();
    const vector<osl::Move> moves=rec.getMoves();

    NumEffectState state(rec.getInitialState());
    NewProgress progress(state);
    for (unsigned int i=0; i<moves.size(); i++) {
      const Move m = moves[i];
      state.makeMove(m);
      progress.update(state, m);

      NumEffectState state_r(state.rotate180());
      NewProgress progress_r(state_r);
      CPPUNIT_ASSERT_EQUAL(progress.progress16(BLACK).value(),
			   progress_r.progress16(WHITE).value());
      CPPUNIT_ASSERT_EQUAL(progress.progress16(WHITE).value(),
			   progress_r.progress16(BLACK).value());
      CPPUNIT_ASSERT_EQUAL(progress.progressAttack(BLACK).value(),
			   progress_r.progressAttack(WHITE).value());
      CPPUNIT_ASSERT_EQUAL(progress.progressDefense(WHITE).value(),
			   progress_r.progressDefense(BLACK).value());
    }
  }
}
