#include "osl/record/opening/openingBook.h"
#include "osl/state/simpleState.h"
#include "osl/record/csa.h"
#include "osl/record/csaRecord.h"
#include "osl/stl/hash_map.h"
#include "osl/hash/hashKey.h"
#include "osl/oslConfig.h"
#include <boost/foreach.hpp>
#include <iostream>

using namespace osl;
using namespace osl::record;
using namespace osl::record::opening;
using namespace osl::stl;

typedef hash_map<HashKey, WeightedBook::WMoveContainer> state_map;
void show(const std::string& filename,
	  const state_map& states, const SimpleState& state)
{
  state_map::const_iterator it = states.find(HashKey(state));
  if (it == states.end())
  {
    std::cout << filename << "\t" << "Not found" << std::endl;
  }
  else
  {
    std::cout << filename;
    const WeightedBook::WMoveContainer &moves = it->second;
    for (size_t j = 0; j < moves.size(); ++j)
    {
      std::cout << "\t" << osl::record::csa::show(moves[j].getMove())
		<< "\t" << moves[j].getWeight();
    }
    std::cout << std::endl;
  }
}
int main(int argc, char **argv)
{
  std::string book_filename = OslConfig::openingBook();
  WeightedBook book(book_filename.c_str());

  state_map states;
  {
    std::vector<int> state_stack;
    state_stack.push_back(book.getStartState());

    while (!state_stack.empty())
    {
      const int index = state_stack.back();
      state_stack.pop_back();

      const SimpleState state = book.getBoard(index);
      const HashKey key = HashKey(state);
      if (states.find(key) == states.end())
      {
	WeightedBook::WMoveContainer moves = book.getMoves(index);
	for (size_t i = 0; i < moves.size(); ++i)
	{
	  state_stack.push_back(moves[i].getStateIndex());
	}
	states[key] = moves;
      }
    }
  }

  for (int i = 1; i < argc; ++i)
  {
    const std::string filename(argv[i]);
    osl::record::csa::CsaFile csa(filename);

    NumEffectState state = csa.getInitialState();
    vector<Move> record_moves = csa.getRecord().getMoves();
    if (record_moves.empty() || !(state == SimpleState(HIRATE)))
      show(filename, states, state);
    BOOST_FOREACH(Move move, record_moves) {
      state.makeMove(move);
      show(filename, states, state);
    }      
  }

  return 0;
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
