/* multimap.h
 */
#ifndef MULTIMAP_H
#define MULTIMAP_H

#include <map>
#include "osl/stl/pool_allocator.h"

namespace osl
{
  namespace stl
  {
    template <typename Key, typename Value, typename Compare = std::less<Key> > 
    struct multimap
      : public std::multimap<Key,Value,Compare,
			     pool_allocator<std::pair<const Key, Value> > >
    {
    };
  } // namespace stl
  using stl::multimap;
} // namespace stl

#endif /* MULTIMAP_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
