#ifndef OSL_PLAYER_H
#define OSL_PLAYER_H
#include <boost/static_assert.hpp>
#include <cassert>
#include <iosfwd>
namespace osl{
  enum Player{
    BLACK=0,
    WHITE= -1
  };
  
  inline Player alt(Player player){
    return static_cast<Player>(-1-static_cast<int>(player));
  }
  inline int playerToIndex(Player player){
    return -static_cast<int>(player);
  }
  inline Player indexToPlayer(int n) {
    assert(n == 0 || n == 1);
    return static_cast<Player>(-n);
  }
  inline int playerToMul(Player player){
    int ret=1+(static_cast<int>(player)<<1);
    assert(ret==1 || ret== -1);
    return ret;
  }
  inline int playerToSign(Player player)
  {
    return playerToMul(player);
  }
  inline int playerToMask(Player player){
    return static_cast<int>(player);
  }

  // These codes are intentionally DECLARED and NOT IMPLEMENTED.
  // you will get link error here if you write code such as "value += v * piece.owner() == BLACK ? 1.0 : -1.0;"
  int operator+(Player, int);	int operator+(int, Player);	
  int operator-(Player, int);	int operator-(int, Player);	
  int operator*(Player, int);	int operator*(int, Player);	
  int operator/(Player, int);	int operator/(int, Player);	
  
  /**
   * cast等で作られたplayerが正しいかどうかを返す
   */
  bool isValid(Player player);
    
  template<Player P>
  struct PlayerTraits;
  
  template<>
  struct PlayerTraits<BLACK>{
    static const int offsetMul=1;
    static const int index=0;
    static const int mask=0;
    static const Player opponent=WHITE;
  };
  
  template<>
  struct PlayerTraits<WHITE>{
    static const int offsetMul=-1;
    static const int index=1;
    static const int mask= -1;
    static const Player opponent=BLACK;
  };
  
  std::ostream& operator<<(std::ostream& os,Player player);
}
#endif /* OSL_PLAYER_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
