/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "tst_slider-parameter.h"

#include "../../src/slider-parameter.h"

#include <QtTest/QtTest>

void
TestSliderParameter::setMinimumValue()
{
    Ubuntu::HUD::SliderParameter param;

    QSignalSpy spy(&param, SIGNAL(minimumValueChanged(float)));

    QVERIFY(qFuzzyCompare(param.minimumValue(), 0.0f));

    param.setMinimumValue(-100.0f);
    QVERIFY(qFuzzyCompare(param.minimumValue(), -100.0f));
    QCOMPARE(spy.count(), 1);
    QVERIFY(qFuzzyCompare(spy.at(0).at(0).toFloat(), -100.0f));

    param.setMinimumValue(-100.0f);
    QCOMPARE(spy.count(), 1);
}

void
TestSliderParameter::setMaximumValue()
{
    Ubuntu::HUD::SliderParameter param;

    QSignalSpy spy(&param, SIGNAL(maximumValueChanged(float)));

    QVERIFY(qFuzzyCompare(param.maximumValue(), 100.0f));

    param.setMaximumValue(200.0f);
    QVERIFY(qFuzzyCompare(param.maximumValue(), 200.0f));
    QCOMPARE(spy.count(), 1);
    QVERIFY(qFuzzyCompare(spy.at(0).at(0).toFloat(), 200.0f));

    param.setMaximumValue(200.0f);
    QCOMPARE(spy.count(), 1);
}

void
TestSliderParameter::setStepSize()
{
    Ubuntu::HUD::SliderParameter param;

    QSignalSpy spy(&param, SIGNAL(stepSizeChanged(float)));

    QVERIFY(qFuzzyCompare(param.stepSize(), 1.0f));

    param.setStepSize(10.0f);
    QVERIFY(qFuzzyCompare(param.stepSize(), 10.0f));
    QCOMPARE(spy.count(), 1);
    QVERIFY(qFuzzyCompare(spy.at(0).at(0).toFloat(), 10.0f));

    param.setStepSize(10.0f);
    QCOMPARE(spy.count(), 1);
}

void
TestSliderParameter::setValue()
{
    Ubuntu::HUD::SliderParameter param;

    QSignalSpy spy(&param, SIGNAL(valueChanged(float)));

    QVERIFY(qFuzzyCompare(param.value(), 0.0f));

    param.setValue(50.0f);
    QVERIFY(qFuzzyCompare(param.value(), 50.0f));
    QCOMPARE(spy.count(), 1);
    QVERIFY(qFuzzyCompare(spy.at(0).at(0).toFloat(), 50.0f));

    param.setValue(50.0f);
    QCOMPARE(spy.count(), 1);
}

void
TestSliderParameter::setLive()
{
    Ubuntu::HUD::SliderParameter param;

    QSignalSpy spy(&param, SIGNAL(liveChanged(bool)));

    QVERIFY(param.live() == false);

    param.setLive(true);
    QVERIFY(param.live() == true);
    QCOMPARE(spy.count(), 1);
    QVERIFY(spy.at(0).at(0).toBool() == true);

    param.setLive(true);
    QCOMPARE(spy.count(), 1);
}

void
TestSliderParameter::setLabel()
{
    Ubuntu::HUD::SliderParameter param;

    QSignalSpy spy(&param, SIGNAL(labelChanged(QString)));
    QVERIFY(param.label().isEmpty());
    param.setLabel("Foo");
    QVERIFY(param.label() == "Foo");
    QCOMPARE(spy.count(), 1);
    QList<QVariant> arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).toString() == "Foo");

    spy.clear();
    param.setLabel("Foo");
    QCOMPARE(spy.count(), 0);
}
