/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.LinkedHashMap;
import java.util.Map;
import org.htmlcleaner.Utils;

public class TagTransformation {
    private String sourceTag;
    private String destTag;
    private boolean preserveSourceAttributes;
    private Map attributeTransformations;

    public TagTransformation(String sourceTag, String destTag, boolean preserveSourceAttributes) {
        this.sourceTag = sourceTag.toLowerCase();
        this.destTag = destTag == null ? null : (Utils.isValidXmlIdentifier(destTag) ? destTag.toLowerCase() : sourceTag);
        this.preserveSourceAttributes = preserveSourceAttributes;
    }

    public TagTransformation(String sourceTag, String destTag) {
        this(sourceTag, destTag, true);
    }

    public TagTransformation(String sourceTag) {
        this(sourceTag, null);
    }

    public void addAttributeTransformation(String targetAttName, String transformationDesc) {
        if (this.attributeTransformations == null) {
            this.attributeTransformations = new LinkedHashMap();
        }
        this.attributeTransformations.put(targetAttName.toLowerCase(), transformationDesc);
    }

    public void addAttributeTransformation(String targetAttName) {
        this.addAttributeTransformation(targetAttName, null);
    }

    boolean hasAttributeTransformations() {
        return this.attributeTransformations != null;
    }

    String getSourceTag() {
        return this.sourceTag;
    }

    String getDestTag() {
        return this.destTag;
    }

    boolean isPreserveSourceAttributes() {
        return this.preserveSourceAttributes;
    }

    Map getAttributeTransformations() {
        return this.attributeTransformations;
    }
}

