/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.HtmlSerializer;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;

public class PrettyHtmlSerializer
extends HtmlSerializer {
    private static final String DEFAULT_INDENTATION_STRING = "\t";
    private String indentString = "\t";
    private List<String> indents = new ArrayList<String>();

    public PrettyHtmlSerializer(CleanerProperties props) {
        this(props, DEFAULT_INDENTATION_STRING);
    }

    public PrettyHtmlSerializer(CleanerProperties props, String indentString) {
        super(props);
        this.indentString = indentString;
    }

    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        this.serializePrettyHtml(tagNode, writer, 0, false, true);
    }

    private synchronized String getIndent(int level) {
        int size = this.indents.size();
        if (size <= level) {
            String prevIndent = size == 0 ? null : this.indents.get(size - 1);
            for (int i = size; i <= level; ++i) {
                String currIndent = prevIndent == null ? "" : prevIndent + this.indentString;
                this.indents.add(currIndent);
                prevIndent = currIndent;
            }
        }
        return this.indents.get(level);
    }

    private String getIndentedText(String content, int level) {
        String indent = this.getIndent(level);
        StringBuilder result = new StringBuilder(content.length());
        StringTokenizer tokenizer = new StringTokenizer(content, "\n\r");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            if ("".equals(line)) continue;
            result.append(indent).append(line).append("\n");
        }
        return result.toString();
    }

    private String getSingleLineOfChildren(List children) {
        StringBuilder result = new StringBuilder();
        Iterator childrenIt = children.iterator();
        boolean isFirst = true;
        while (childrenIt.hasNext()) {
            Object child = childrenIt.next();
            if (!(child instanceof ContentNode)) {
                return null;
            }
            String content = child.toString();
            if (isFirst) {
                content = Utils.ltrim(content);
            }
            if (!childrenIt.hasNext()) {
                content = Utils.rtrim(content);
            }
            if (content.indexOf("\n") >= 0 || content.indexOf("\r") >= 0) {
                return null;
            }
            result.append(content);
            isFirst = false;
        }
        return result.toString();
    }

    protected void serializePrettyHtml(TagNode tagNode, Writer writer, int level, boolean isPreserveWhitespaces, boolean isLastNewLine) throws IOException {
        String indent;
        List tagChildren = tagNode.getChildren();
        String tagName = tagNode.getName();
        boolean isHeadlessNode = Utils.isEmptyString(tagName);
        String string = indent = isHeadlessNode ? "" : this.getIndent(level);
        if (!isPreserveWhitespaces) {
            if (!isLastNewLine) {
                writer.write("\n");
            }
            writer.write(indent);
        }
        this.serializeOpenTag(tagNode, writer, true);
        boolean preserveWhitespaces = isPreserveWhitespaces || "pre".equalsIgnoreCase(tagName);
        boolean lastWasNewLine = false;
        if (!this.isMinimizedTagSyntax(tagNode)) {
            String singleLine = this.getSingleLineOfChildren(tagChildren);
            boolean dontEscape = this.dontEscape(tagNode);
            if (!preserveWhitespaces && singleLine != null) {
                writer.write(!this.dontEscape(tagNode) ? this.escapeText(singleLine) : singleLine);
            } else {
                Iterator childIterator = tagChildren.iterator();
                while (childIterator.hasNext()) {
                    Object child = childIterator.next();
                    if (child instanceof TagNode) {
                        this.serializePrettyHtml((TagNode)child, writer, isHeadlessNode ? level : level + 1, preserveWhitespaces, lastWasNewLine);
                        lastWasNewLine = false;
                        continue;
                    }
                    if (child instanceof ContentNode) {
                        String content = dontEscape ? child.toString() : this.escapeText(child.toString());
                        if (content.length() <= 0) continue;
                        if (dontEscape || preserveWhitespaces) {
                            writer.write(content);
                            continue;
                        }
                        if (Character.isWhitespace(content.charAt(0))) {
                            if (!lastWasNewLine) {
                                writer.write("\n");
                                lastWasNewLine = false;
                            }
                            if (content.trim().length() > 0) {
                                writer.write(this.getIndentedText(Utils.rtrim(content), isHeadlessNode ? level : level + 1));
                                continue;
                            }
                            lastWasNewLine = true;
                            continue;
                        }
                        if (content.trim().length() > 0) {
                            writer.write(Utils.rtrim(content));
                        }
                        if (childIterator.hasNext()) continue;
                        writer.write("\n");
                        lastWasNewLine = true;
                        continue;
                    }
                    if (!(child instanceof CommentNode)) continue;
                    if (!lastWasNewLine && !preserveWhitespaces) {
                        writer.write("\n");
                        lastWasNewLine = false;
                    }
                    CommentNode commentNode = (CommentNode)child;
                    String content = commentNode.getCommentedContent();
                    writer.write(dontEscape ? content : this.getIndentedText(content, isHeadlessNode ? level : level + 1));
                }
            }
            if (singleLine == null && !preserveWhitespaces) {
                if (!lastWasNewLine) {
                    writer.write("\n");
                }
                writer.write(indent);
            }
            this.serializeEndTag(tagNode, writer, false);
        }
    }
}

