/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 12088 $ of $ 
 *
 * $Id:$
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "dessertMeshifTable.h"


/** @defgroup data_get data_get: Routines to get data
 *
 * TODO:230:M: Implement dessertMeshifTable get routines.
 * TODO:240:M: Implement dessertMeshifTable mapping routines (if any).
 *
 * These routine are used to get the value for individual objects. The
 * row context is passed, along with a pointer to the memory where the
 * value should be copied.
 *
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table dessertMeshifTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * DESSERT-MIB::dessertMeshifTable is subid 5 of dessertObjects.
 * Its status is Current.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.5, length: 12
 */

/*
 * ---------------------------------------------------------------------
 * * TODO:200:r: Implement dessertMeshifTable data context functions.
 */


/**
 * set mib index(es)
 *
 * @param tbl_idx mib index structure
 * @param meshifIndex_val
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This convenience function is useful for setting all the MIB index
 *  components with a single function call. It is assume that the C values
 *  have already been mapped from their native/rawformat to the MIB format.
 */
int
dessertMeshifTable_indexes_set_tbl_idx(dessertMeshifTable_mib_index *
                                       tbl_idx, long meshifIndex_val)
{
    DEBUGMSGTL(("verbose:dessertMeshifTable:dessertMeshifTable_indexes_set_tbl_idx", "called\n"));

    /*
     * meshifIndex(1)///()//L/a/w/e/r/d/h 
     */
    tbl_idx->meshifIndex = meshifIndex_val;


    return MFD_SUCCESS;
}                               /* dessertMeshifTable_indexes_set_tbl_idx */

/**
 * @internal
 * set row context indexes
 *
 * @param reqreq_ctx the row context that needs updated indexes
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This function sets the mib indexs, then updates the oid indexs
 *  from the mib index.
 */
int
dessertMeshifTable_indexes_set(dessertMeshifTable_rowreq_ctx * rowreq_ctx,
                               long meshifIndex_val)
{
    DEBUGMSGTL(("verbose:dessertMeshifTable:dessertMeshifTable_indexes_set", "called\n"));

    if (MFD_SUCCESS !=
        dessertMeshifTable_indexes_set_tbl_idx(&rowreq_ctx->tbl_idx,
                                               meshifIndex_val))
        return MFD_ERROR;

    /*
     * convert mib index to oid index
     */
    rowreq_ctx->oid_idx.len = sizeof(rowreq_ctx->oid_tmp) / sizeof(oid);
    if (0 != dessertMeshifTable_index_to_oid(&rowreq_ctx->oid_idx,
                                             &rowreq_ctx->tbl_idx)) {
        return MFD_ERROR;
    }

    return MFD_SUCCESS;
}                               /* dessertMeshifTable_indexes_set */


/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertMeshifEntry.meshifName
 * meshifName is subid 2 of dessertMeshifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.5.1.2
 * Description:
name of interface
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   1
 *   settable   0
 *   hint: 255a
 *
 * Ranges:  0 - 255;
 *
 * Its syntax is DisplayString (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 255)
 */
/**
 * Extract the current value of the meshifName data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param meshifName_val_ptr_ptr
 *        Pointer to storage for a char variable
 * @param meshifName_val_ptr_len_ptr
 *        Pointer to a size_t. On entry, it will contain the size (in bytes)
 *        pointed to by meshifName.
 *        On exit, this value should contain the data size (in bytes).
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
*
 * @note If you need more than (*meshifName_val_ptr_len_ptr) bytes of memory,
 *       allocate it using malloc() and update meshifName_val_ptr_ptr.
 *       <b>DO NOT</b> free the previous pointer.
 *       The MFD helper will release the memory you allocate.
 *
 * @remark If you call this function yourself, you are responsible
 *         for checking if the pointer changed, and freeing any
 *         previously allocated memory. (Not necessary if you pass
 *         in a pointer to static memory, obviously.)
 */
int
meshifName_get(dessertMeshifTable_rowreq_ctx * rowreq_ctx,
               char **meshifName_val_ptr_ptr,
               size_t *meshifName_val_ptr_len_ptr)
{
   /** we should have a non-NULL pointer and enough storage */
    netsnmp_assert((NULL != meshifName_val_ptr_ptr)
                   && (NULL != *meshifName_val_ptr_ptr));
    netsnmp_assert(NULL != meshifName_val_ptr_len_ptr);


    DEBUGMSGTL(("verbose:dessertMeshifTable:meshifName_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the meshifName data.
     * copy (* meshifName_val_ptr_ptr ) data and (* meshifName_val_ptr_len_ptr ) from rowreq_ctx->data
     */
    /*
     * make sure there is enough space for meshifName data
     */
    if ((NULL == (*meshifName_val_ptr_ptr)) ||
        ((*meshifName_val_ptr_len_ptr) <
         (rowreq_ctx->data.meshifName_len *
          sizeof(rowreq_ctx->data.meshifName[0])))) {
        /*
         * allocate space for meshifName data
         */
        (*meshifName_val_ptr_ptr) =
            malloc(rowreq_ctx->data.meshifName_len *
                   sizeof(rowreq_ctx->data.meshifName[0]));
        if (NULL == (*meshifName_val_ptr_ptr)) {
            snmp_log(LOG_ERR, "could not allocate memory\n");
            return MFD_ERROR;
        }
    }
    (*meshifName_val_ptr_len_ptr) =
        rowreq_ctx->data.meshifName_len *
        sizeof(rowreq_ctx->data.meshifName[0]);
    memcpy((*meshifName_val_ptr_ptr), rowreq_ctx->data.meshifName,
           rowreq_ctx->data.meshifName_len *
           sizeof(rowreq_ctx->data.meshifName[0]));

    return MFD_SUCCESS;
}                               /* meshifName_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertMeshifEntry.meshifMacAddress
 * meshifMacAddress is subid 3 of dessertMeshifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.5.1.3
 * Description:
hardware address of interface
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   1
 *   settable   0
 *   hint: 1x:
 *
 * Ranges:  6;
 *
 * Its syntax is MacAddress (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 6)
 */
/**
 * Extract the current value of the meshifMacAddress data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param meshifMacAddress_val_ptr_ptr
 *        Pointer to storage for a char variable
 * @param meshifMacAddress_val_ptr_len_ptr
 *        Pointer to a size_t. On entry, it will contain the size (in bytes)
 *        pointed to by meshifMacAddress.
 *        On exit, this value should contain the data size (in bytes).
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
*
 * @note If you need more than (*meshifMacAddress_val_ptr_len_ptr) bytes of memory,
 *       allocate it using malloc() and update meshifMacAddress_val_ptr_ptr.
 *       <b>DO NOT</b> free the previous pointer.
 *       The MFD helper will release the memory you allocate.
 *
 * @remark If you call this function yourself, you are responsible
 *         for checking if the pointer changed, and freeing any
 *         previously allocated memory. (Not necessary if you pass
 *         in a pointer to static memory, obviously.)
 */
int
meshifMacAddress_get(dessertMeshifTable_rowreq_ctx * rowreq_ctx,
                     char **meshifMacAddress_val_ptr_ptr,
                     size_t *meshifMacAddress_val_ptr_len_ptr)
{
   /** we should have a non-NULL pointer and enough storage */
    netsnmp_assert((NULL != meshifMacAddress_val_ptr_ptr)
                   && (NULL != *meshifMacAddress_val_ptr_ptr));
    netsnmp_assert(NULL != meshifMacAddress_val_ptr_len_ptr);


    DEBUGMSGTL(("verbose:dessertMeshifTable:meshifMacAddress_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the meshifMacAddress data.
     * copy (* meshifMacAddress_val_ptr_ptr ) data and (* meshifMacAddress_val_ptr_len_ptr ) from rowreq_ctx->data
     */
    /*
     * make sure there is enough space for meshifMacAddress data
     */
    if ((NULL == (*meshifMacAddress_val_ptr_ptr)) ||
        ((*meshifMacAddress_val_ptr_len_ptr) <
         (rowreq_ctx->data.meshifMacAddress_len *
          sizeof(rowreq_ctx->data.meshifMacAddress[0])))) {
        /*
         * allocate space for meshifMacAddress data
         */
        (*meshifMacAddress_val_ptr_ptr) =
            malloc(rowreq_ctx->data.meshifMacAddress_len *
                   sizeof(rowreq_ctx->data.meshifMacAddress[0]));
        if (NULL == (*meshifMacAddress_val_ptr_ptr)) {
            snmp_log(LOG_ERR, "could not allocate memory\n");
            return MFD_ERROR;
        }
    }
    (*meshifMacAddress_val_ptr_len_ptr) =
        rowreq_ctx->data.meshifMacAddress_len *
        sizeof(rowreq_ctx->data.meshifMacAddress[0]);
    memcpy((*meshifMacAddress_val_ptr_ptr),
           rowreq_ctx->data.meshifMacAddress,
           rowreq_ctx->data.meshifMacAddress_len *
           sizeof(rowreq_ctx->data.meshifMacAddress[0]));

    return MFD_SUCCESS;
}                               /* meshifMacAddress_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertMeshifEntry.meshifInPkts
 * meshifInPkts is subid 4 of dessertMeshifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.5.1.4
 * Description:
packet counter in
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the meshifInPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param meshifInPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
meshifInPkts_get(dessertMeshifTable_rowreq_ctx * rowreq_ctx,
                 U64 * meshifInPkts_val_ptr)
{
	 char inPkts[I64CHARSZ+1];

   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != meshifInPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy meshifInPkts data.
     * get (* meshifInPkts_val_ptr ).low and (* meshifInPkts_val_ptr ).high from rowreq_ctx->data
     */
    (*meshifInPkts_val_ptr).high = rowreq_ctx->data.meshifInPkts.high;
    (*meshifInPkts_val_ptr).low = rowreq_ctx->data.meshifInPkts.low;

    printU64(inPkts, meshifInPkts_val_ptr);

    return MFD_SUCCESS;
}                               /* meshifInPkts_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertMeshifEntry.meshifOutPkts
 * meshifOutPkts is subid 5 of dessertMeshifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.5.1.5
 * Description:
packet counter out
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the meshifOutPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param meshifOutPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
meshifOutPkts_get(dessertMeshifTable_rowreq_ctx * rowreq_ctx,
                  U64 * meshifOutPkts_val_ptr)
{
	char outPkts[I64CHARSZ+1];

   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != meshifOutPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy meshifOutPkts data.
     * get (* meshifOutPkts_val_ptr ).low and (* meshifOutPkts_val_ptr ).high from rowreq_ctx->data
     */
    (*meshifOutPkts_val_ptr).high = rowreq_ctx->data.meshifOutPkts.high;
    (*meshifOutPkts_val_ptr).low = rowreq_ctx->data.meshifOutPkts.low;

    printU64(outPkts, meshifOutPkts_val_ptr);




    return MFD_SUCCESS;
}                               /* meshifOutPkts_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertMeshifEntry.meshifInOctets
 * meshifInOctets is subid 6 of dessertMeshifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.5.1.6
 * Description:
octet counter in
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the meshifInOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param meshifInOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
meshifInOctets_get(dessertMeshifTable_rowreq_ctx * rowreq_ctx,
                   U64 * meshifInOctets_val_ptr)
{
	char inOctets[I64CHARSZ+1];
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != meshifInOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy meshifInOctets data.
     * get (* meshifInOctets_val_ptr ).low and (* meshifInOctets_val_ptr ).high from rowreq_ctx->data
     */
    (*meshifInOctets_val_ptr).high = rowreq_ctx->data.meshifInOctets.high;
    (*meshifInOctets_val_ptr).low = rowreq_ctx->data.meshifInOctets.low;

    printU64(inOctets, meshifInOctets_val_ptr);


    return MFD_SUCCESS;
}                               /* meshifInOctets_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertMeshifEntry.meshifOutOctets
 * meshifOutOctets is subid 7 of dessertMeshifEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.5.1.7
 * Description:
octet counter out
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the meshifOutOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param meshifOutOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
meshifOutOctets_get(dessertMeshifTable_rowreq_ctx * rowreq_ctx,
                    U64 * meshifOutOctets_val_ptr)
{
	char outOctets[I64CHARSZ+1];
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != meshifOutOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy meshifOutOctets data.
     * get (* meshifOutOctets_val_ptr ).low and (* meshifOutOctets_val_ptr ).high from rowreq_ctx->data
     */
    (*meshifOutOctets_val_ptr).high =
        rowreq_ctx->data.meshifOutOctets.high;
    (*meshifOutOctets_val_ptr).low = rowreq_ctx->data.meshifOutOctets.low;

    printU64(outOctets, meshifOutOctets_val_ptr);


    return MFD_SUCCESS;
}                               /* meshifOutOctets_get */



/** @} */
