/***************************************************************************
                           cbz.h  -  description
                             -------------------
    begin                : Wed May 15 2002
    copyright            : (C) 2002-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CBZ_H
#define CBZ_H

/**
  *@author Mathias Küster
  *
  * Does bzip2 compression or decompression for a buffer. That is
  * all that is required for dclib, some stream functions are not
  * needed.
  */

#include <dclib/dcos.h>

class CByteArray;
class CString;

class CBZ {

public:
	/**
	 * If it fails, dst will be empty unless src is null or empty,
	 * then dst is unchanged.
	 */
	static bool Decompress( CByteArray * src, CByteArray * dst );
	/**
	 * If it fails, dst will be empty unless src is null or empty,
	 * then dst is unchanged.
	 */
	static bool Compress( CByteArray * src, CByteArray * dst );
	/**
	 * If it fails, dst will be empty unless src is null or empty,
	 * then dst is unchanged.
	 */
	static bool Compress( const CString * src, CByteArray * dst );

protected:
	/** */
	CBZ();
	/** */
	~CBZ();

	/** */
	static bool Compress( char * src, unsigned int srclen, CByteArray * dst );
};

#endif
