/***************************************************************************
                     ctraffic.h  -  dclib network traffic stats
                             -------------------
    begin                : Fri Aug 09 2008
    copyright            : (C) 2001-2003 by Mathias Küster
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTRAFFIC_H
#define CTRAFFIC_H

/**
 * @author Mathias Küster
 *
 * Class split out of csocket.h
 * It's just a counter for network usage.
 */

#include <dclib/dcos.h>
#include <dclib/core/cmutex.h>

enum eTrafficType {
	ettRX=0,
	ettTX,
	ettDATARX,
	ettDATATX,
	ettCONTROLRX,
	ettCONTROLTX,
	ettRESET
};

class CTraffic {
public:
	/** Constructor - mutex must be locked until finished */
	CTraffic()
	{
		ResetTraffic();
	};
	/** Destructor */
	~CTraffic() {};
	
	/** Add bytes to the traffic stat */
	void AddTraffic( eTrafficType type, ulonglong n )
	{
		m_Mutex.Lock();
		
		switch ( type )
		{
			case ettRX:
				m_nRx += n;
				break;
			case ettTX:
				m_nTx += n;
				break;
			case ettDATARX:
				m_nDataRx += n;
				break;
			case ettDATATX:
				m_nDataTx += n;
				break;
			case ettCONTROLRX:
				m_nControlRx += n;
				break;
			case ettCONTROLTX:
				m_nControlTx += n;
				break;
			default:
				break;
		}
		
		m_Mutex.UnLock();
	}
	
	/** Get bytes for the traffic stat */
	ulonglong GetTraffic( eTrafficType type )
	{
		ulonglong n;
		
		m_Mutex.Lock();
		
		switch ( type )
		{
			case ettRX:
				n = m_nRx;
				break;
			case ettTX:
				n = m_nTx;
				break;
			case ettDATARX:
				n = m_nDataRx;
				break;
			case ettDATATX:
				n = m_nDataTx;
				break;
			case ettCONTROLRX:
				n = m_nControlRx;
				break;
			case ettCONTROLTX:
				n = m_nControlTx;
				break;
			default:
				n = 0;
				break;
		}
		
		m_Mutex.UnLock();
		
		return n;
	}
	
	/** Reset all traffic stats */
	void ResetTraffic()
	{
		m_Mutex.Lock();
		
		m_nRx        = 0;
		m_nTx        = 0;
		m_nDataRx    = 0;
		m_nDataTx    = 0;
		m_nControlRx = 0;
		m_nControlTx = 0;
		
		m_Mutex.UnLock();
	}
	
private:
	/** */
	CMutex m_Mutex;
	/** */
	ulonglong m_nRx;
	/** */
	ulonglong m_nTx;
	/** */
	ulonglong m_nDataRx;
	/** */
	ulonglong m_nDataTx;
	/** */
	ulonglong m_nControlRx;
	/** */
	ulonglong m_nControlTx;
};

#endif // CTRAFFIC_H
