/***************************************************************************
                          cclientssl.h  -  description
                             -------------------
    begin                : Sat Dec 7 2002
    copyright            : (C) 2002-2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CCLIENTSSL_H
#define CCLIENTSSL_H

/**
  *@author Mathias Küster
  *
  * Class for the encrypted private chat dclib system.
  * Not really a protocol extension, just special private chat messages
  * for a client to interpret.
  */

#include <dclib/dcos.h>
#include <dclib/core/cssl.h>
#include <dclib/core/cstringlist.h>

class CClient;
class CMessagePrivateChat;

class CClientSSL : public CSSL {
public:
	/** */
	CClientSSL();
	/** */
	virtual ~CClientSSL();

	/** */
	void PrivateChat( CClient * client, CMessagePrivateChat * msg );

	/** */
	void Init();
	/** */
	CString EncryptMessage( CClient * client, CString nick, CString message );
	/** */
	void LeaveHub( CClient * client, CString nick );

private:
	/** */
	CStringList<CSSLObject> * m_pCryptPrivateMessageList;
};

#endif
