; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse2    | FileCheck %s --check-prefix=SSE --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ssse3   | FileCheck %s --check-prefix=SSE --check-prefix=SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx     | FileCheck %s --check-prefix=AVX --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx2    | FileCheck %s --check-prefix=AVX --check-prefix=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx512f | FileCheck %s --check-prefix=AVX --check-prefix=AVX512

define <4 x i32> @test1(<4 x i32> %a) nounwind {
; SSE2-LABEL: test1:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    paddd %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test1:
; SSSE3:       # BB#0:
; SSSE3-NEXT:    pabsd %xmm0, %xmm0
; SSSE3-NEXT:    retq
;
; AVX-LABEL: test1:
; AVX:       # BB#0:
; AVX-NEXT:    vpabsd %xmm0, %xmm0
; AVX-NEXT:    retq
  %tmp1neg = sub <4 x i32> zeroinitializer, %a
  %b = icmp sgt <4 x i32> %a, <i32 -1, i32 -1, i32 -1, i32 -1>
  %abs = select <4 x i1> %b, <4 x i32> %a, <4 x i32> %tmp1neg
  ret <4 x i32> %abs
}

define <4 x i32> @test2(<4 x i32> %a) nounwind {
; SSE2-LABEL: test2:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    paddd %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test2:
; SSSE3:       # BB#0:
; SSSE3-NEXT:    pabsd %xmm0, %xmm0
; SSSE3-NEXT:    retq
;
; AVX-LABEL: test2:
; AVX:       # BB#0:
; AVX-NEXT:    vpabsd %xmm0, %xmm0
; AVX-NEXT:    retq
  %tmp1neg = sub <4 x i32> zeroinitializer, %a
  %b = icmp sge <4 x i32> %a, zeroinitializer
  %abs = select <4 x i1> %b, <4 x i32> %a, <4 x i32> %tmp1neg
  ret <4 x i32> %abs
}

define <8 x i16> @test3(<8 x i16> %a) nounwind {
; SSE2-LABEL: test3:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psraw $15, %xmm1
; SSE2-NEXT:    paddw %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test3:
; SSSE3:       # BB#0:
; SSSE3-NEXT:    pabsw %xmm0, %xmm0
; SSSE3-NEXT:    retq
;
; AVX-LABEL: test3:
; AVX:       # BB#0:
; AVX-NEXT:    vpabsw %xmm0, %xmm0
; AVX-NEXT:    retq
  %tmp1neg = sub <8 x i16> zeroinitializer, %a
  %b = icmp sgt <8 x i16> %a, zeroinitializer
  %abs = select <8 x i1> %b, <8 x i16> %a, <8 x i16> %tmp1neg
  ret <8 x i16> %abs
}

define <16 x i8> @test4(<16 x i8> %a) nounwind {
; SSE2-LABEL: test4:
; SSE2:       # BB#0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm1
; SSE2-NEXT:    paddb %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test4:
; SSSE3:       # BB#0:
; SSSE3-NEXT:    pabsb %xmm0, %xmm0
; SSSE3-NEXT:    retq
;
; AVX-LABEL: test4:
; AVX:       # BB#0:
; AVX-NEXT:    vpabsb %xmm0, %xmm0
; AVX-NEXT:    retq
  %tmp1neg = sub <16 x i8> zeroinitializer, %a
  %b = icmp slt <16 x i8> %a, zeroinitializer
  %abs = select <16 x i1> %b, <16 x i8> %tmp1neg, <16 x i8> %a
  ret <16 x i8> %abs
}

define <4 x i32> @test5(<4 x i32> %a) nounwind {
; SSE2-LABEL: test5:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    paddd %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test5:
; SSSE3:       # BB#0:
; SSSE3-NEXT:    pabsd %xmm0, %xmm0
; SSSE3-NEXT:    retq
;
; AVX-LABEL: test5:
; AVX:       # BB#0:
; AVX-NEXT:    vpabsd %xmm0, %xmm0
; AVX-NEXT:    retq
  %tmp1neg = sub <4 x i32> zeroinitializer, %a
  %b = icmp sle <4 x i32> %a, zeroinitializer
  %abs = select <4 x i1> %b, <4 x i32> %tmp1neg, <4 x i32> %a
  ret <4 x i32> %abs
}

define <8 x i32> @test6(<8 x i32> %a) nounwind {
; SSE2-LABEL: test6:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    paddd %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    paddd %xmm2, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test6:
; SSSE3:       # BB#0:
; SSSE3-NEXT:    pabsd %xmm0, %xmm0
; SSSE3-NEXT:    pabsd %xmm1, %xmm1
; SSSE3-NEXT:    retq
;
; AVX1-LABEL: test6:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm2
; AVX1-NEXT:    vpaddd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm3
; AVX1-NEXT:    vpaddd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm1
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test6:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpabsd %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test6:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpabsd %ymm0, %ymm0
; AVX512-NEXT:    retq
  %tmp1neg = sub <8 x i32> zeroinitializer, %a
  %b = icmp sgt <8 x i32> %a, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %abs = select <8 x i1> %b, <8 x i32> %a, <8 x i32> %tmp1neg
  ret <8 x i32> %abs
}

define <8 x i32> @test7(<8 x i32> %a) nounwind {
; SSE2-LABEL: test7:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    paddd %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    paddd %xmm2, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test7:
; SSSE3:       # BB#0:
; SSSE3-NEXT:    pabsd %xmm0, %xmm0
; SSSE3-NEXT:    pabsd %xmm1, %xmm1
; SSSE3-NEXT:    retq
;
; AVX1-LABEL: test7:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm2
; AVX1-NEXT:    vpaddd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm3
; AVX1-NEXT:    vpaddd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm1
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test7:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpabsd %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test7:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpabsd %ymm0, %ymm0
; AVX512-NEXT:    retq
  %tmp1neg = sub <8 x i32> zeroinitializer, %a
  %b = icmp sge <8 x i32> %a, zeroinitializer
  %abs = select <8 x i1> %b, <8 x i32> %a, <8 x i32> %tmp1neg
  ret <8 x i32> %abs
}

define <16 x i16> @test8(<16 x i16> %a) nounwind {
; SSE2-LABEL: test8:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    psraw $15, %xmm2
; SSE2-NEXT:    paddw %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psraw $15, %xmm2
; SSE2-NEXT:    paddw %xmm2, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test8:
; SSSE3:       # BB#0:
; SSSE3-NEXT:    pabsw %xmm0, %xmm0
; SSSE3-NEXT:    pabsw %xmm1, %xmm1
; SSSE3-NEXT:    retq
;
; AVX1-LABEL: test8:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsraw $15, %xmm1, %xmm2
; AVX1-NEXT:    vpaddw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsraw $15, %xmm0, %xmm3
; AVX1-NEXT:    vpaddw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm1
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test8:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpabsw %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test8:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpabsw %ymm0, %ymm0
; AVX512-NEXT:    retq
  %tmp1neg = sub <16 x i16> zeroinitializer, %a
  %b = icmp sgt <16 x i16> %a, zeroinitializer
  %abs = select <16 x i1> %b, <16 x i16> %a, <16 x i16> %tmp1neg
  ret <16 x i16> %abs
}

define <32 x i8> @test9(<32 x i8> %a) nounwind {
; SSE2-LABEL: test9:
; SSE2:       # BB#0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtb %xmm0, %xmm3
; SSE2-NEXT:    paddb %xmm3, %xmm0
; SSE2-NEXT:    pxor %xmm3, %xmm0
; SSE2-NEXT:    pcmpgtb %xmm1, %xmm2
; SSE2-NEXT:    paddb %xmm2, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test9:
; SSSE3:       # BB#0:
; SSSE3-NEXT:    pabsb %xmm0, %xmm0
; SSSE3-NEXT:    pabsb %xmm1, %xmm1
; SSSE3-NEXT:    retq
;
; AVX1-LABEL: test9:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm4
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test9:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpabsb %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test9:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpabsb %ymm0, %ymm0
; AVX512-NEXT:    retq
  %tmp1neg = sub <32 x i8> zeroinitializer, %a
  %b = icmp slt <32 x i8> %a, zeroinitializer
  %abs = select <32 x i1> %b, <32 x i8> %tmp1neg, <32 x i8> %a
  ret <32 x i8> %abs
}

define <8 x i32> @test10(<8 x i32> %a) nounwind {
; SSE2-LABEL: test10:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    paddd %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    paddd %xmm2, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test10:
; SSSE3:       # BB#0:
; SSSE3-NEXT:    pabsd %xmm0, %xmm0
; SSSE3-NEXT:    pabsd %xmm1, %xmm1
; SSSE3-NEXT:    retq
;
; AVX1-LABEL: test10:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm2
; AVX1-NEXT:    vpaddd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm3
; AVX1-NEXT:    vpaddd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm1
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test10:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpabsd %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test10:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpabsd %ymm0, %ymm0
; AVX512-NEXT:    retq
  %tmp1neg = sub <8 x i32> zeroinitializer, %a
  %b = icmp sle <8 x i32> %a, zeroinitializer
  %abs = select <8 x i1> %b, <8 x i32> %tmp1neg, <8 x i32> %a
  ret <8 x i32> %abs
}

define <16 x i32> @test11(<16 x i32> %a) nounwind {
; SSE2-LABEL: test11:
; SSE2:       # BB#0:
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm0
; SSE2-NEXT:    pxor %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    paddd %xmm4, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test11:
; SSSE3:       # BB#0:
; SSSE3-NEXT:    pabsd %xmm0, %xmm0
; SSSE3-NEXT:    pabsd %xmm1, %xmm1
; SSSE3-NEXT:    pabsd %xmm2, %xmm2
; SSSE3-NEXT:    pabsd %xmm3, %xmm3
; SSSE3-NEXT:    retq
;
; AVX1-LABEL: test11:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm3
; AVX1-NEXT:    vpaddd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm4
; AVX1-NEXT:    vpaddd %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm2
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm3
; AVX1-NEXT:    vpaddd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm4
; AVX1-NEXT:    vpaddd %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm2
; AVX1-NEXT:    vxorps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test11:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpabsd %ymm0, %ymm0
; AVX2-NEXT:    vpabsd %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test11:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpabsd %zmm0, %zmm0
; AVX512-NEXT:    retq
  %tmp1neg = sub <16 x i32> zeroinitializer, %a
  %b = icmp sle <16 x i32> %a, zeroinitializer
  %abs = select <16 x i1> %b, <16 x i32> %tmp1neg, <16 x i32> %a
  ret <16 x i32> %abs
}

define <8 x i64> @test12(<8 x i64> %a) nounwind {
; SSE-LABEL: test12:
; SSE:       # BB#0:
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    psrad $31, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    paddq %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    psrad $31, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    paddq %xmm4, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    psrad $31, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    paddq %xmm4, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    psrad $31, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    paddq %xmm4, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test12:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; AVX1-NEXT:    vpaddq %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm2
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; AVX1-NEXT:    vpaddq %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm2
; AVX1-NEXT:    vxorps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test12:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm1, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpaddq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test12:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    retq
  %tmp1neg = sub <8 x i64> zeroinitializer, %a
  %b = icmp sle <8 x i64> %a, zeroinitializer
  %abs = select <8 x i1> %b, <8 x i64> %tmp1neg, <8 x i64> %a
  ret <8 x i64> %abs
}

define <8 x i64> @test13(<8 x i64>* %a.ptr) nounwind {
; SSE-LABEL: test13:
; SSE:       # BB#0:
; SSE-NEXT:    movdqu (%rdi), %xmm0
; SSE-NEXT:    movdqu 16(%rdi), %xmm1
; SSE-NEXT:    movdqu 32(%rdi), %xmm2
; SSE-NEXT:    movdqu 48(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    psrad $31, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    paddq %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    psrad $31, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    paddq %xmm4, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    psrad $31, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    paddq %xmm4, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    psrad $31, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    paddq %xmm4, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test13:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovups (%rdi), %ymm0
; AVX1-NEXT:    vmovups 32(%rdi), %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; AVX1-NEXT:    vpaddq %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm2
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; AVX1-NEXT:    vpaddq %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm2
; AVX1-NEXT:    vxorps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test13:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovdqu (%rdi), %ymm0
; AVX2-NEXT:    vmovdqu 32(%rdi), %ymm1
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm1, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[1,1,3,3,5,5,7,7]
; AVX2-NEXT:    vpaddq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test13:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpabsq (%rdi), %zmm0
; AVX512-NEXT:    retq
  %a = load <8 x i64>, <8 x i64>* %a.ptr, align 8
  %tmp1neg = sub <8 x i64> zeroinitializer, %a
  %b = icmp sle <8 x i64> %a, zeroinitializer
  %abs = select <8 x i1> %b, <8 x i64> %tmp1neg, <8 x i64> %a
  ret <8 x i64> %abs
}
