; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

declare void @use(i32 %arg)
declare void @vec_use(<4 x i32> %arg)

; (x+c1)+c2

define i32 @add_const_add_const(i32 %arg) {
; CHECK-LABEL: @add_const_add_const(
; CHECK-NEXT:    [[T1:%.*]] = add i32 [[ARG:%.*]], 10
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = add i32 %arg, 8
  %t1 = add i32 %t0, 2
  ret i32 %t1
}

define i32 @add_const_add_const_extrause(i32 %arg) {
; CHECK-LABEL: @add_const_add_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[ARG:%.*]], 8
; CHECK-NEXT:    call void @use(i32 [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = add i32 [[ARG]], 10
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = add i32 %arg, 8
  call void @use(i32 %t0)
  %t1 = add i32 %t0, 2
  ret i32 %t1
}

define <4 x i32> @vec_add_const_add_const(<4 x i32> %arg) {
; CHECK-LABEL: @vec_add_const_add_const(
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 10, i32 10, i32 10, i32 10>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = add <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  %t1 = add <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_add_const_add_const_extrause(<4 x i32> %arg) {
; CHECK-LABEL: @vec_add_const_add_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 8, i32 8, i32 8, i32 8>
; CHECK-NEXT:    call void @vec_use(<4 x i32> [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG]], <i32 10, i32 10, i32 10, i32 10>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = add <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  call void @vec_use(<4 x i32> %t0)
  %t1 = add <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_add_const_add_const_nonsplat(<4 x i32> %arg) {
; CHECK-LABEL: @vec_add_const_add_const_nonsplat(
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 23, i32 undef, i32 undef, i32 10>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = add <4 x i32> %arg, <i32 21, i32 undef, i32 8, i32 8>
  %t1 = add <4 x i32> %t0, <i32 2, i32 3, i32 undef, i32 2>
  ret <4 x i32> %t1
}

; (x+c1)-c2

define i32 @add_const_sub_const(i32 %arg) {
; CHECK-LABEL: @add_const_sub_const(
; CHECK-NEXT:    [[T1:%.*]] = add i32 [[ARG:%.*]], 6
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = add i32 %arg, 8
  %t1 = sub i32 %t0, 2
  ret i32 %t1
}

define i32 @add_const_sub_const_extrause(i32 %arg) {
; CHECK-LABEL: @add_const_sub_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[ARG:%.*]], 8
; CHECK-NEXT:    call void @use(i32 [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = add i32 [[ARG]], 6
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = add i32 %arg, 8
  call void @use(i32 %t0)
  %t1 = sub i32 %t0, 2
  ret i32 %t1
}

define <4 x i32> @vec_add_const_sub_const(<4 x i32> %arg) {
; CHECK-LABEL: @vec_add_const_sub_const(
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 6, i32 6, i32 6, i32 6>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = add <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  %t1 = sub <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_add_const_sub_const_extrause(<4 x i32> %arg) {
; CHECK-LABEL: @vec_add_const_sub_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 8, i32 8, i32 8, i32 8>
; CHECK-NEXT:    call void @vec_use(<4 x i32> [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG]], <i32 6, i32 6, i32 6, i32 6>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = add <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  call void @vec_use(<4 x i32> %t0)
  %t1 = sub <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_add_const_sub_const_nonsplat(<4 x i32> %arg) {
; CHECK-LABEL: @vec_add_const_sub_const_nonsplat(
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 19, i32 undef, i32 undef, i32 6>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = add <4 x i32> %arg, <i32 21, i32 undef, i32 8, i32 8>
  %t1 = sub <4 x i32> %t0, <i32 2, i32 3, i32 undef, i32 2>
  ret <4 x i32> %t1
}

; c2-(x+c1)

define i32 @add_const_const_sub(i32 %arg) {
; CHECK-LABEL: @add_const_const_sub(
; CHECK-NEXT:    [[T1:%.*]] = sub i32 -6, [[ARG:%.*]]
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = add i32 %arg, 8
  %t1 = sub i32 2, %t0
  ret i32 %t1
}

define i32 @add_const_const_sub_extrause(i32 %arg) {
; CHECK-LABEL: @add_const_const_sub_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[ARG:%.*]], 8
; CHECK-NEXT:    call void @use(i32 [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = sub i32 -6, [[ARG]]
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = add i32 %arg, 8
  call void @use(i32 %t0)
  %t1 = sub i32 2, %t0
  ret i32 %t1
}

define <4 x i32> @vec_add_const_const_sub(<4 x i32> %arg) {
; CHECK-LABEL: @vec_add_const_const_sub(
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 -6, i32 -6, i32 -6, i32 -6>, [[ARG:%.*]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = add <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  %t1 = sub <4 x i32> <i32 2, i32 2, i32 2, i32 2>, %t0
  ret <4 x i32> %t1
}

define <4 x i32> @vec_add_const_const_sub_extrause(<4 x i32> %arg) {
; CHECK-LABEL: @vec_add_const_const_sub_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 8, i32 8, i32 8, i32 8>
; CHECK-NEXT:    call void @vec_use(<4 x i32> [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 -6, i32 -6, i32 -6, i32 -6>, [[ARG]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = add <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  call void @vec_use(<4 x i32> %t0)
  %t1 = sub <4 x i32> <i32 2, i32 2, i32 2, i32 2>, %t0
  ret <4 x i32> %t1
}

define <4 x i32> @vec_add_const_const_sub_nonsplat(<4 x i32> %arg) {
; CHECK-LABEL: @vec_add_const_const_sub_nonsplat(
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 -19, i32 undef, i32 undef, i32 -6>, [[ARG:%.*]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = add <4 x i32> %arg, <i32 21, i32 undef, i32 8, i32 8>
  %t1 = sub <4 x i32> <i32 2, i32 3, i32 undef, i32 2>, %t0
  ret <4 x i32> %t1
}

; (x-c1)+c2

define i32 @sub_const_add_const(i32 %arg) {
; CHECK-LABEL: @sub_const_add_const(
; CHECK-NEXT:    [[T1:%.*]] = add i32 [[ARG:%.*]], -6
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 %arg, 8
  %t1 = add i32 %t0, 2
  ret i32 %t1
}

define i32 @sub_const_add_const_extrause(i32 %arg) {
; CHECK-LABEL: @sub_const_add_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[ARG:%.*]], -8
; CHECK-NEXT:    call void @use(i32 [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = add i32 [[ARG]], -6
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 %arg, 8
  call void @use(i32 %t0)
  %t1 = add i32 %t0, 2
  ret i32 %t1
}

define <4 x i32> @vec_sub_const_add_const(<4 x i32> %arg) {
; CHECK-LABEL: @vec_sub_const_add_const(
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 -6, i32 -6, i32 -6, i32 -6>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  %t1 = add <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_sub_const_add_const_extrause(<4 x i32> %arg) {
; CHECK-LABEL: @vec_sub_const_add_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 -8, i32 -8, i32 -8, i32 -8>
; CHECK-NEXT:    call void @vec_use(<4 x i32> [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG]], <i32 -6, i32 -6, i32 -6, i32 -6>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  call void @vec_use(<4 x i32> %t0)
  %t1 = add <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_sub_const_add_const_nonsplat(<4 x i32> %arg) {
; CHECK-LABEL: @vec_sub_const_add_const_nonsplat(
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 -19, i32 undef, i32 undef, i32 -6>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> %arg, <i32 21, i32 undef, i32 8, i32 8>
  %t1 = add <4 x i32> %t0, <i32 2, i32 3, i32 undef, i32 2>
  ret <4 x i32> %t1
}

; (x-c1)-c2

define i32 @sub_const_sub_const(i32 %arg) {
; CHECK-LABEL: @sub_const_sub_const(
; CHECK-NEXT:    [[T1:%.*]] = add i32 [[ARG:%.*]], -10
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 %arg, 8
  %t1 = sub i32 %t0, 2
  ret i32 %t1
}

define i32 @sub_const_sub_const_extrause(i32 %arg) {
; CHECK-LABEL: @sub_const_sub_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[ARG:%.*]], -8
; CHECK-NEXT:    call void @use(i32 [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = add i32 [[ARG]], -10
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 %arg, 8
  call void @use(i32 %t0)
  %t1 = sub i32 %t0, 2
  ret i32 %t1
}

define <4 x i32> @vec_sub_const_sub_const(<4 x i32> %arg) {
; CHECK-LABEL: @vec_sub_const_sub_const(
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 -10, i32 -10, i32 -10, i32 -10>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  %t1 = sub <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_sub_const_sub_const_extrause(<4 x i32> %arg) {
; CHECK-LABEL: @vec_sub_const_sub_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 -8, i32 -8, i32 -8, i32 -8>
; CHECK-NEXT:    call void @vec_use(<4 x i32> [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG]], <i32 -10, i32 -10, i32 -10, i32 -10>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  call void @vec_use(<4 x i32> %t0)
  %t1 = sub <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_sub_const_sub_const_nonsplat(<4 x i32> %arg) {
; CHECK-LABEL: @vec_sub_const_sub_const_nonsplat(
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 -23, i32 undef, i32 undef, i32 -10>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> %arg, <i32 21, i32 undef, i32 8, i32 8>
  %t1 = sub <4 x i32> %t0, <i32 2, i32 3, i32 undef, i32 2>
  ret <4 x i32> %t1
}

; c2-(x-c1)

define i32 @sub_const_const_sub(i32 %arg) {
; CHECK-LABEL: @sub_const_const_sub(
; CHECK-NEXT:    [[T1:%.*]] = sub i32 10, [[ARG:%.*]]
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 %arg, 8
  %t1 = sub i32 2, %t0
  ret i32 %t1
}

define i32 @sub_const_const_sub_extrause(i32 %arg) {
; CHECK-LABEL: @sub_const_const_sub_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[ARG:%.*]], -8
; CHECK-NEXT:    call void @use(i32 [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = sub i32 10, [[ARG]]
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 %arg, 8
  call void @use(i32 %t0)
  %t1 = sub i32 2, %t0
  ret i32 %t1
}

define <4 x i32> @vec_sub_const_const_sub(<4 x i32> %arg) {
; CHECK-LABEL: @vec_sub_const_const_sub(
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 10, i32 10, i32 10, i32 10>, [[ARG:%.*]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  %t1 = sub <4 x i32> <i32 2, i32 2, i32 2, i32 2>, %t0
  ret <4 x i32> %t1
}

define <4 x i32> @vec_sub_const_const_sub_extrause(<4 x i32> %arg) {
; CHECK-LABEL: @vec_sub_const_const_sub_extrause(
; CHECK-NEXT:    [[T0:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 -8, i32 -8, i32 -8, i32 -8>
; CHECK-NEXT:    call void @vec_use(<4 x i32> [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 10, i32 10, i32 10, i32 10>, [[ARG]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> %arg, <i32 8, i32 8, i32 8, i32 8>
  call void @vec_use(<4 x i32> %t0)
  %t1 = sub <4 x i32> <i32 2, i32 2, i32 2, i32 2>, %t0
  ret <4 x i32> %t1
}

define <4 x i32> @vec_sub_const_const_sub_nonsplat(<4 x i32> %arg) {
; CHECK-LABEL: @vec_sub_const_const_sub_nonsplat(
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 23, i32 undef, i32 undef, i32 10>, [[ARG:%.*]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> %arg, <i32 21, i32 undef, i32 8, i32 8>
  %t1 = sub <4 x i32> <i32 2, i32 3, i32 undef, i32 2>, %t0
  ret <4 x i32> %t1
}

; (c1-x)+c2

define i32 @const_sub_add_const(i32 %arg) {
; CHECK-LABEL: @const_sub_add_const(
; CHECK-NEXT:    [[T1:%.*]] = sub i32 10, [[ARG:%.*]]
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 8, %arg
  %t1 = add i32 %t0, 2
  ret i32 %t1
}

define i32 @const_sub_add_const_extrause(i32 %arg) {
; CHECK-LABEL: @const_sub_add_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = sub i32 8, [[ARG:%.*]]
; CHECK-NEXT:    call void @use(i32 [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = sub i32 10, [[ARG]]
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 8, %arg
  call void @use(i32 %t0)
  %t1 = add i32 %t0, 2
  ret i32 %t1
}

define <4 x i32> @vec_const_sub_add_const(<4 x i32> %arg) {
; CHECK-LABEL: @vec_const_sub_add_const(
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 10, i32 10, i32 10, i32 10>, [[ARG:%.*]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> <i32 8, i32 8, i32 8, i32 8>, %arg
  %t1 = add <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_const_sub_add_const_extrause(<4 x i32> %arg) {
; CHECK-LABEL: @vec_const_sub_add_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = sub <4 x i32> <i32 8, i32 8, i32 8, i32 8>, [[ARG:%.*]]
; CHECK-NEXT:    call void @vec_use(<4 x i32> [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 10, i32 10, i32 10, i32 10>, [[ARG]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> <i32 8, i32 8, i32 8, i32 8>, %arg
  call void @vec_use(<4 x i32> %t0)
  %t1 = add <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_const_sub_add_const_nonsplat(<4 x i32> %arg) {
; CHECK-LABEL: @vec_const_sub_add_const_nonsplat(
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 23, i32 undef, i32 undef, i32 10>, [[ARG:%.*]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> <i32 21, i32 undef, i32 8, i32 8>, %arg
  %t1 = add <4 x i32> %t0, <i32 2, i32 3, i32 undef, i32 2>
  ret <4 x i32> %t1
}

; (c1-x)-c2

define i32 @const_sub_sub_const(i32 %arg) {
; CHECK-LABEL: @const_sub_sub_const(
; CHECK-NEXT:    [[T1:%.*]] = sub i32 6, [[ARG:%.*]]
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 8, %arg
  %t1 = sub i32 %t0, 2
  ret i32 %t1
}

define i32 @const_sub_sub_const_extrause(i32 %arg) {
; CHECK-LABEL: @const_sub_sub_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = sub i32 8, [[ARG:%.*]]
; CHECK-NEXT:    call void @use(i32 [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = sub i32 6, [[ARG]]
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 8, %arg
  call void @use(i32 %t0)
  %t1 = sub i32 %t0, 2
  ret i32 %t1
}

define <4 x i32> @vec_const_sub_sub_const(<4 x i32> %arg) {
; CHECK-LABEL: @vec_const_sub_sub_const(
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 6, i32 6, i32 6, i32 6>, [[ARG:%.*]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> <i32 8, i32 8, i32 8, i32 8>, %arg
  %t1 = sub <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_const_sub_sub_const_extrause(<4 x i32> %arg) {
; CHECK-LABEL: @vec_const_sub_sub_const_extrause(
; CHECK-NEXT:    [[T0:%.*]] = sub <4 x i32> <i32 8, i32 8, i32 8, i32 8>, [[ARG:%.*]]
; CHECK-NEXT:    call void @vec_use(<4 x i32> [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 6, i32 6, i32 6, i32 6>, [[ARG]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> <i32 8, i32 8, i32 8, i32 8>, %arg
  call void @vec_use(<4 x i32> %t0)
  %t1 = sub <4 x i32> %t0, <i32 2, i32 2, i32 2, i32 2>
  ret <4 x i32> %t1
}

define <4 x i32> @vec_const_sub_sub_const_nonsplat(<4 x i32> %arg) {
; CHECK-LABEL: @vec_const_sub_sub_const_nonsplat(
; CHECK-NEXT:    [[T1:%.*]] = sub <4 x i32> <i32 19, i32 undef, i32 undef, i32 6>, [[ARG:%.*]]
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> <i32 21, i32 undef, i32 8, i32 8>, %arg
  %t1 = sub <4 x i32> %t0, <i32 2, i32 3, i32 undef, i32 2>
  ret <4 x i32> %t1
}

; c2-(c1-x)
; FIXME

define i32 @const_sub_const_sub(i32 %arg) {
; CHECK-LABEL: @const_sub_const_sub(
; CHECK-NEXT:    [[T1:%.*]] = add i32 [[ARG:%.*]], -6
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 8, %arg
  %t1 = sub i32 2, %t0
  ret i32 %t1
}

define i32 @const_sub_const_sub_extrause(i32 %arg) {
; CHECK-LABEL: @const_sub_const_sub_extrause(
; CHECK-NEXT:    [[T0:%.*]] = sub i32 8, [[ARG:%.*]]
; CHECK-NEXT:    call void @use(i32 [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = add i32 [[ARG]], -6
; CHECK-NEXT:    ret i32 [[T1]]
;
  %t0 = sub i32 8, %arg
  call void @use(i32 %t0)
  %t1 = sub i32 2, %t0
  ret i32 %t1
}

define <4 x i32> @vec_const_sub_const_sub(<4 x i32> %arg) {
; CHECK-LABEL: @vec_const_sub_const_sub(
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 -6, i32 -6, i32 -6, i32 -6>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> <i32 8, i32 8, i32 8, i32 8>, %arg
  %t1 = sub <4 x i32> <i32 2, i32 2, i32 2, i32 2>, %t0
  ret <4 x i32> %t1
}

define <4 x i32> @vec_const_sub_const_sub_extrause(<4 x i32> %arg) {
; CHECK-LABEL: @vec_const_sub_const_sub_extrause(
; CHECK-NEXT:    [[T0:%.*]] = sub <4 x i32> <i32 8, i32 8, i32 8, i32 8>, [[ARG:%.*]]
; CHECK-NEXT:    call void @vec_use(<4 x i32> [[T0]])
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG]], <i32 -6, i32 -6, i32 -6, i32 -6>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> <i32 8, i32 8, i32 8, i32 8>, %arg
  call void @vec_use(<4 x i32> %t0)
  %t1 = sub <4 x i32> <i32 2, i32 2, i32 2, i32 2>, %t0
  ret <4 x i32> %t1
}

define <4 x i32> @vec_const_sub_const_sub_nonsplat(<4 x i32> %arg) {
; CHECK-LABEL: @vec_const_sub_const_sub_nonsplat(
; CHECK-NEXT:    [[T1:%.*]] = add <4 x i32> [[ARG:%.*]], <i32 -19, i32 undef, i32 undef, i32 -6>
; CHECK-NEXT:    ret <4 x i32> [[T1]]
;
  %t0 = sub <4 x i32> <i32 21, i32 undef, i32 8, i32 8>, %arg
  %t1 = sub <4 x i32> <i32 2, i32 3, i32 undef, i32 2>, %t0
  ret <4 x i32> %t1
}
