; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=sparc-linux-gnu < %s | FileCheck %s -check-prefix=V8 -check-prefix=V8-BE
; RUN: llc -mtriple=sparcel-linux-gnu < %s | FileCheck %s -check-prefix=V8 -check-prefix=V8-EL
; RUN: llc -mtriple=sparc-linux-gnu -O0 < %s | FileCheck %s -check-prefix=V8-UNOPT
; RUN: llc -mtriple=sparc-linux-gnu -mattr=v9 < %s | FileCheck %s -check-prefix=V9
; RUN: llc -mtriple=sparc64-unknown-linux < %s | FileCheck %s -check-prefix=SPARC64

define void @test_load_store(half* %p, half* %q) nounwind {
; V8-LABEL: test_load_store:
; V8:       ! %bb.0:
; V8-NEXT:    lduh [%o0], %o0
; V8-NEXT:    retl
; V8-NEXT:    sth %o0, [%o1]
;
; V8-UNOPT-LABEL: test_load_store:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    lduh [%o0], %o0
; V8-UNOPT-NEXT:    retl
; V8-UNOPT-NEXT:    sth %o0, [%o1]
;
; V9-LABEL: test_load_store:
; V9:       ! %bb.0:
; V9-NEXT:    lduh [%o0], %o0
; V9-NEXT:    retl
; V9-NEXT:    sth %o0, [%o1]
;
; SPARC64-LABEL: test_load_store:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    lduh [%o0], %o0
; SPARC64-NEXT:    retl
; SPARC64-NEXT:    sth %o0, [%o1]
  %a = load half, half* %p
  store half %a, half* %q
  ret void
}

define float @test_fpextend_float(half* %p) nounwind {
; V8-LABEL: test_fpextend_float:
; V8:       ! %bb.0:
; V8-NEXT:    save %sp, -96, %sp
; V8-NEXT:    call __gnu_h2f_ieee
; V8-NEXT:    lduh [%i0], %o0
; V8-NEXT:    ret
; V8-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fpextend_float:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -96, %sp
; V8-UNOPT-NEXT:    call __gnu_h2f_ieee
; V8-UNOPT-NEXT:    lduh [%i0], %o0
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fpextend_float:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -96, %sp
; V9-NEXT:    call __gnu_h2f_ieee
; V9-NEXT:    lduh [%i0], %o0
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fpextend_float:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -176, %sp
; SPARC64-NEXT:    call __gnu_h2f_ieee
; SPARC64-NEXT:    lduh [%i0], %o0
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = load half, half* %p
  %r = fpext half %a to float
  ret float %r
}

define double @test_fpextend_double(half* %p) nounwind {
; V8-LABEL: test_fpextend_double:
; V8:       ! %bb.0:
; V8-NEXT:    save %sp, -96, %sp
; V8-NEXT:    call __gnu_h2f_ieee
; V8-NEXT:    lduh [%i0], %o0
; V8-NEXT:    fstod %f0, %f0
; V8-NEXT:    ret
; V8-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fpextend_double:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -96, %sp
; V8-UNOPT-NEXT:    call __gnu_h2f_ieee
; V8-UNOPT-NEXT:    lduh [%i0], %o0
; V8-UNOPT-NEXT:    fstod %f0, %f0
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fpextend_double:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -96, %sp
; V9-NEXT:    call __gnu_h2f_ieee
; V9-NEXT:    lduh [%i0], %o0
; V9-NEXT:    fstod %f0, %f0
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fpextend_double:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -176, %sp
; SPARC64-NEXT:    call __gnu_h2f_ieee
; SPARC64-NEXT:    lduh [%i0], %o0
; SPARC64-NEXT:    fstod %f0, %f0
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = load half, half* %p
  %r = fpext half %a to double
  ret double %r
}

define void @test_fptrunc_float(float %f, half* %p) nounwind {
; V8-LABEL: test_fptrunc_float:
; V8:       ! %bb.0:
; V8-NEXT:    save %sp, -96, %sp
; V8-NEXT:    call __gnu_f2h_ieee
; V8-NEXT:    mov %i0, %o0
; V8-NEXT:    sth %o0, [%i1]
; V8-NEXT:    ret
; V8-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fptrunc_float:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -104, %sp
; V8-UNOPT-NEXT:    st %i0, [%fp+-4]
; V8-UNOPT-NEXT:    ld [%fp+-4], %f0
; V8-UNOPT-NEXT:    mov %i0, %o0
; V8-UNOPT-NEXT:    st %i1, [%fp+-8] ! 4-byte Folded Spill
; V8-UNOPT-NEXT:    call __gnu_f2h_ieee
; V8-UNOPT-NEXT:    st %f0, [%fp+-12]
; V8-UNOPT-NEXT:    ld [%fp+-8], %i0 ! 4-byte Folded Reload
; V8-UNOPT-NEXT:    sth %o0, [%i0]
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fptrunc_float:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -96, %sp
; V9-NEXT:    call __gnu_f2h_ieee
; V9-NEXT:    mov %i0, %o0
; V9-NEXT:    sth %o0, [%i1]
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fptrunc_float:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -176, %sp
; SPARC64-NEXT:    call __gnu_f2h_ieee
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    sth %o0, [%i1]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = fptrunc float %f to half
  store half %a, half* %p
  ret void
}

define void @test_fptrunc_double(double %d, half* %p) nounwind {
; V8-LABEL: test_fptrunc_double:
; V8:       ! %bb.0:
; V8-NEXT:    save %sp, -112, %sp
; V8-NEXT:    ! kill: def $i1 killed $i1 killed $i0_i1 def $i0_i1
; V8-NEXT:    ! kill: def $i0 killed $i0 killed $i0_i1 def $i0_i1
; V8-NEXT:    std %i0, [%fp+-8]
; V8-NEXT:    ldd [%fp+-8], %f0
; V8-NEXT:    std %f0, [%fp+-16]
; V8-NEXT:    call __truncdfhf2
; V8-NEXT:    ldd [%fp+-16], %o0
; V8-NEXT:    sth %o0, [%i2]
; V8-NEXT:    ret
; V8-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fptrunc_double:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -112, %sp
; V8-UNOPT-NEXT:    ! implicit-def: $i4_i5
; V8-UNOPT-NEXT:    mov %i0, %i4
; V8-UNOPT-NEXT:    mov %i1, %i5
; V8-UNOPT-NEXT:    std %i4, [%fp+-8]
; V8-UNOPT-NEXT:    ldd [%fp+-8], %f0
; V8-UNOPT-NEXT:    std %f0, [%fp+-16]
; V8-UNOPT-NEXT:    ldd [%fp+-16], %i4
; V8-UNOPT-NEXT:    mov %i4, %i0
; V8-UNOPT-NEXT:    ! kill: def $i5 killed $i5 killed $i4_i5
; V8-UNOPT-NEXT:    mov %i0, %o0
; V8-UNOPT-NEXT:    mov %i5, %o1
; V8-UNOPT-NEXT:    call __truncdfhf2
; V8-UNOPT-NEXT:    st %i2, [%fp+-20]
; V8-UNOPT-NEXT:    ld [%fp+-20], %i0 ! 4-byte Folded Reload
; V8-UNOPT-NEXT:    sth %o0, [%i0]
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fptrunc_double:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -112, %sp
; V9-NEXT:    ! kill: def $i1 killed $i1 killed $i0_i1 def $i0_i1
; V9-NEXT:    ! kill: def $i0 killed $i0 killed $i0_i1 def $i0_i1
; V9-NEXT:    std %i0, [%fp+-8]
; V9-NEXT:    ldd [%fp+-8], %f0
; V9-NEXT:    std %f0, [%fp+-16]
; V9-NEXT:    call __truncdfhf2
; V9-NEXT:    ldd [%fp+-16], %o0
; V9-NEXT:    sth %o0, [%i2]
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fptrunc_double:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -176, %sp
; SPARC64-NEXT:    call __truncdfhf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    sth %o0, [%i1]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = fptrunc double %d to half
  store half %a, half* %p
  ret void
}

define void @test_fadd(half* %p, half* %q) nounwind {
; V8-LABEL: test_fadd:
; V8:       ! %bb.0:
; V8-NEXT:    save %sp, -104, %sp
; V8-NEXT:    call __gnu_h2f_ieee
; V8-NEXT:    lduh [%i0], %o0
; V8-NEXT:    st %f0, [%fp+-8] ! 4-byte Folded Spill
; V8-NEXT:    call __gnu_h2f_ieee
; V8-NEXT:    lduh [%i1], %o0
; V8-NEXT:    ld [%fp+-8], %f1 ! 4-byte Folded Reload
; V8-NEXT:    fadds %f1, %f0, %f0
; V8-NEXT:    st %f0, [%fp+-4]
; V8-NEXT:    call __gnu_f2h_ieee
; V8-NEXT:    ld [%fp+-4], %o0
; V8-NEXT:    sth %o0, [%i0]
; V8-NEXT:    ret
; V8-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fadd:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -112, %sp
; V8-UNOPT-NEXT:    lduh [%i0], %o0
; V8-UNOPT-NEXT:    st %i1, [%fp+-8] ! 4-byte Folded Spill
; V8-UNOPT-NEXT:    call __gnu_h2f_ieee
; V8-UNOPT-NEXT:    st %i0, [%fp+-12]
; V8-UNOPT-NEXT:    ld [%fp+-8], %i0 ! 4-byte Folded Reload
; V8-UNOPT-NEXT:    lduh [%i0], %o0
; V8-UNOPT-NEXT:    call __gnu_h2f_ieee
; V8-UNOPT-NEXT:    st %f0, [%fp+-16]
; V8-UNOPT-NEXT:    ld [%fp+-16], %f1 ! 4-byte Folded Reload
; V8-UNOPT-NEXT:    fadds %f1, %f0, %f0
; V8-UNOPT-NEXT:    st %f0, [%fp+-4]
; V8-UNOPT-NEXT:    call __gnu_f2h_ieee
; V8-UNOPT-NEXT:    ld [%fp+-4], %o0
; V8-UNOPT-NEXT:    ld [%fp+-12], %i0 ! 4-byte Folded Reload
; V8-UNOPT-NEXT:    sth %o0, [%i0]
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fadd:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -104, %sp
; V9-NEXT:    call __gnu_h2f_ieee
; V9-NEXT:    lduh [%i0], %o0
; V9-NEXT:    st %f0, [%fp+-8] ! 4-byte Folded Spill
; V9-NEXT:    call __gnu_h2f_ieee
; V9-NEXT:    lduh [%i1], %o0
; V9-NEXT:    ld [%fp+-8], %f1 ! 4-byte Folded Reload
; V9-NEXT:    fadds %f1, %f0, %f0
; V9-NEXT:    st %f0, [%fp+-4]
; V9-NEXT:    call __gnu_f2h_ieee
; V9-NEXT:    ld [%fp+-4], %o0
; V9-NEXT:    sth %o0, [%i0]
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fadd:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -192, %sp
; SPARC64-NEXT:    call __gnu_h2f_ieee
; SPARC64-NEXT:    lduh [%i0], %o0
; SPARC64-NEXT:    st %f0, [%fp+2043] ! 4-byte Folded Spill
; SPARC64-NEXT:    call __gnu_h2f_ieee
; SPARC64-NEXT:    lduh [%i1], %o0
; SPARC64-NEXT:    ld [%fp+2043], %f1 ! 4-byte Folded Reload
; SPARC64-NEXT:    call __gnu_f2h_ieee
; SPARC64-NEXT:    fadds %f1, %f0, %f1
; SPARC64-NEXT:    sth %o0, [%i0]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = load half, half* %p
  %b = load half, half* %q
  %r = fadd half %a, %b
  store half %r, half* %p
  ret void
}

define void @test_fmul(half* %p, half* %q) nounwind {
; V8-LABEL: test_fmul:
; V8:       ! %bb.0:
; V8-NEXT:    save %sp, -104, %sp
; V8-NEXT:    call __gnu_h2f_ieee
; V8-NEXT:    lduh [%i0], %o0
; V8-NEXT:    st %f0, [%fp+-8] ! 4-byte Folded Spill
; V8-NEXT:    call __gnu_h2f_ieee
; V8-NEXT:    lduh [%i1], %o0
; V8-NEXT:    ld [%fp+-8], %f1 ! 4-byte Folded Reload
; V8-NEXT:    fmuls %f1, %f0, %f0
; V8-NEXT:    st %f0, [%fp+-4]
; V8-NEXT:    call __gnu_f2h_ieee
; V8-NEXT:    ld [%fp+-4], %o0
; V8-NEXT:    sth %o0, [%i0]
; V8-NEXT:    ret
; V8-NEXT:    restore
;
; V8-UNOPT-LABEL: test_fmul:
; V8-UNOPT:       ! %bb.0:
; V8-UNOPT-NEXT:    save %sp, -112, %sp
; V8-UNOPT-NEXT:    lduh [%i0], %o0
; V8-UNOPT-NEXT:    st %i1, [%fp+-8] ! 4-byte Folded Spill
; V8-UNOPT-NEXT:    call __gnu_h2f_ieee
; V8-UNOPT-NEXT:    st %i0, [%fp+-12]
; V8-UNOPT-NEXT:    ld [%fp+-8], %i0 ! 4-byte Folded Reload
; V8-UNOPT-NEXT:    lduh [%i0], %o0
; V8-UNOPT-NEXT:    call __gnu_h2f_ieee
; V8-UNOPT-NEXT:    st %f0, [%fp+-16]
; V8-UNOPT-NEXT:    ld [%fp+-16], %f1 ! 4-byte Folded Reload
; V8-UNOPT-NEXT:    fmuls %f1, %f0, %f0
; V8-UNOPT-NEXT:    st %f0, [%fp+-4]
; V8-UNOPT-NEXT:    call __gnu_f2h_ieee
; V8-UNOPT-NEXT:    ld [%fp+-4], %o0
; V8-UNOPT-NEXT:    ld [%fp+-12], %i0 ! 4-byte Folded Reload
; V8-UNOPT-NEXT:    sth %o0, [%i0]
; V8-UNOPT-NEXT:    ret
; V8-UNOPT-NEXT:    restore
;
; V9-LABEL: test_fmul:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -104, %sp
; V9-NEXT:    call __gnu_h2f_ieee
; V9-NEXT:    lduh [%i0], %o0
; V9-NEXT:    st %f0, [%fp+-8] ! 4-byte Folded Spill
; V9-NEXT:    call __gnu_h2f_ieee
; V9-NEXT:    lduh [%i1], %o0
; V9-NEXT:    ld [%fp+-8], %f1 ! 4-byte Folded Reload
; V9-NEXT:    fmuls %f1, %f0, %f0
; V9-NEXT:    st %f0, [%fp+-4]
; V9-NEXT:    call __gnu_f2h_ieee
; V9-NEXT:    ld [%fp+-4], %o0
; V9-NEXT:    sth %o0, [%i0]
; V9-NEXT:    ret
; V9-NEXT:    restore
;
; SPARC64-LABEL: test_fmul:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -192, %sp
; SPARC64-NEXT:    call __gnu_h2f_ieee
; SPARC64-NEXT:    lduh [%i0], %o0
; SPARC64-NEXT:    st %f0, [%fp+2043] ! 4-byte Folded Spill
; SPARC64-NEXT:    call __gnu_h2f_ieee
; SPARC64-NEXT:    lduh [%i1], %o0
; SPARC64-NEXT:    ld [%fp+2043], %f1 ! 4-byte Folded Reload
; SPARC64-NEXT:    call __gnu_f2h_ieee
; SPARC64-NEXT:    fmuls %f1, %f0, %f1
; SPARC64-NEXT:    sth %o0, [%i0]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %a = load half, half* %p
  %b = load half, half* %q
  %r = fmul half %a, %b
  store half %r, half* %p
  ret void
}
