/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class LisaacApplicationShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        Object firstSelection;
        if (selection instanceof IStructuredSelection && (firstSelection = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            ILaunchConfiguration config = this.findLaunchConfiguration((IFile)firstSelection, mode);
            try {
                if (config != null) {
                    config.launch(mode, null);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void launch(IEditorPart editor, String mode) {
        editor.getEditorSite().getPage().saveEditor(editor, true);
        IEditorInput input = editor.getEditorInput();
        StructuredSelection selection = new StructuredSelection(input.getAdapter(IFile.class));
        this.launch((ISelection)selection, mode);
    }

    protected ILaunchConfiguration findLaunchConfiguration(IFile file, String mode) {
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = null;
        try {
            ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute("mainPrototype", "").equals(file.getFullPath().lastSegment()) && config.getAttribute("launchProject", "").equals(file.getProject().getFullPath().lastSegment())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        switch (candidateConfigs.size()) {
            case 0: {
                return this.createConfiguration(file);
            }
        }
        return (ILaunchConfiguration)candidateConfigs.get(0);
    }

    protected ILaunchConfiguration createConfiguration(IFile file) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(file.getName()));
            wc.setAttribute("launchProject", file.getProject().getName());
            wc.setAttribute("mainPrototype", file.getName());
            config = wc.doSave();
        }
        catch (CoreException coreException) {}
        return config;
    }

    protected ILaunchConfigurationType getLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.lisaac.ldt.launchConfiguration");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

