/***********************************************************************
 *                                                                      *
 *               This software is part of the ast package               *
 *          Copyright (c) 1999-2011 AT&T Intellectual Property          *
 *                      and is licensed under the                       *
 *                 Eclipse Public License, Version 1.0                  *
 *                    by AT&T Intellectual Property                     *
 *                                                                      *
 *                A copy of the License is available at                 *
 *          http://www.eclipse.org/org/documents/epl-v10.html           *
 *         (with md5 checksum b35adb5213ca9657e911e9befb180842)         *
 *                                                                      *
 *              Information and Software Systems Research               *
 *                            AT&T Research                             *
 *                           Florham Park NJ                            *
 *                                                                      *
 *               Glenn Fowler <glenn.s.fowler@gmail.com>                *
 *                                                                      *
 ***********************************************************************/
#include "config_ast.h"  // IWYU pragma: keep

#include <string.h>

#include "sfio.h"
#include "terror.h"

tmain() {
    UNUSED(argc);
    UNUSED(argv);
    int i;
    char wbuf[1023];
    char rbuf[1023];
    Sfio_t *fp;

    for (i = 0; i < sizeof(wbuf); ++i) wbuf[i] = (i % 26) + 'a';
    wbuf[sizeof(wbuf) - 1] = '\0';

    if (!(fp = sftmp(0))) terror("Opening temp file");

    for (i = 0; i < 256; ++i) {
        if (sfwrite(fp, wbuf, sizeof(wbuf)) != sizeof(wbuf)) terror("Writing");
    }

    sfseek(fp, (Sfoff_t)0, 0);
    sfset(fp, SF_WRITE, 0);
    sfsetbuf(fp, NULL, 0);
    sfsetbuf(fp, NULL, (size_t)SF_UNBOUND);

    for (i = 0; i < 256; ++i) {
        if (sfread(fp, rbuf, sizeof(rbuf)) != sizeof(rbuf)) terror("Reading");

        if (strcmp(rbuf, wbuf) != 0) terror("Unmatched record");
    }

    texit(0);
}
