/*
    AddressBookSelectorWidget
    Copyright (c) 2005 by Duncan Mac-Vicar Prett <duncan@kde.org>

    Based on LinkAddressBookUI whose code was shamelessly stolen from
    kopete's add new contact wizard, used in Konversation, and then
    reappropriated by Kopete.

    LinkAddressBookUI:
    Copyright (c) 2004 by John Tapsell           <john@geola.co.uk>
    Copyright (c) 2003-2005 by Will Stephenson   <will@stevello.free-online.co.uk>
    Copyright (c) 2002 by Nick Betcher           <nbetcher@kde.org>
    Copyright (c) 2002 by Duncan Mac-Vicar Prett <duncan@kde.org>

    Kopete    (c) 2002-2004 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef AddressBookSelectorWidget_H
#define AddressBookSelectorWidget_H

#include <kcontacts/address.h>
#include <kcontacts/addressee.h>
#include <kcontacts/addresseelist.h>


#include "libkopete_export.h"

#include "ui_addressbookselectorwidget_base.h"

namespace KContacts {
class Picture;
class Address;
class Addressee;
}

namespace Kopete {
namespace UI {
class LIBKOPETE_EXPORT AddressBookSelectorWidget : public QWidget, private Ui::AddressBookSelectorWidget_Base
{
    Q_OBJECT
public:
    explicit AddressBookSelectorWidget(QWidget *parent = nullptr, const char *name = 0);
    ~AddressBookSelectorWidget();
    KContacts::Addressee addressee();
    /**
     * sets the widget label message
     * example: Please select a contact
     * or, Choose a contact to delete
     */
    void setLabelMessage(const QString &msg);
    /**
     * pre-selects a contact
     */
    void selectAddressee(const QString &uid);
    /**
     * @return true if there is a contact selected
     */
    bool addresseeSelected();

private:
    //KContacts::AddressBook * m_addressBook;
    KContacts::Addressee m_addressee;

protected Q_SLOTS:
    void slotAddAddresseeClicked();
    /**
     * Utility function, populates the addressee list
     */
    void slotLoadAddressees();
Q_SIGNALS:
    void addresseeListClicked(QTreeWidgetItem *addressee);
    void addAddresseeClicked();
};
} // namespace UI
} // namespace Kopete

#endif

// vim: set noet ts=4 sts=4 sw=4:
