/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.record.BinaryRecordInput;
import org.apache.hadoop.record.BinaryRecordOutput;
import org.apache.hadoop.record.CsvRecordOutput;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.record.RecordOutput;

public abstract class Record
implements WritableComparable,
Cloneable {
    public abstract void serialize(RecordOutput var1, String var2) throws IOException;

    public abstract void deserialize(RecordInput var1, String var2) throws IOException;

    @Override
    public abstract int compareTo(Object var1) throws ClassCastException;

    public void serialize(RecordOutput rout) throws IOException {
        this.serialize(rout, "");
    }

    public void deserialize(RecordInput rin) throws IOException {
        this.deserialize(rin, "");
    }

    @Override
    public void write(DataOutput out) throws IOException {
        BinaryRecordOutput bout = BinaryRecordOutput.get(out);
        this.serialize(bout);
    }

    @Override
    public void readFields(DataInput din) throws IOException {
        BinaryRecordInput rin = BinaryRecordInput.get(din);
        this.deserialize(rin);
    }

    public String toString() {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            CsvRecordOutput a = new CsvRecordOutput(s);
            this.serialize(a);
            return new String(s.toByteArray(), "UTF-8");
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

