/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.algorithm;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import jonelo.jacksum.algorithm.AbstractChecksum;
import jonelo.jacksum.util.Service;
import jonelo.sugar.util.GeneralString;

public class CrcGeneric
extends AbstractChecksum {
    private int width;
    private long poly;
    private long initialValue;
    private boolean refIn;
    private boolean refOut;
    private long xorOut;
    private long[] table;
    private long topBit;
    private long maskAllBits;
    private long maskHelp;

    public CrcGeneric(int n, long l, long l2, boolean bl, boolean bl2, long l3) throws NoSuchAlgorithmException {
        this.width = n;
        this.poly = l;
        this.initialValue = l2;
        this.refIn = bl;
        this.refOut = bl2;
        this.xorOut = l3;
        this.init();
    }

    public CrcGeneric(String string) throws NoSuchAlgorithmException {
        String[] stringArray = GeneralString.split(string, ",");
        if (stringArray.length != 6) {
            throw new NoSuchAlgorithmException("Can't create the algorithm, 6 parameters are expected");
        }
        try {
            this.width = Integer.parseInt(stringArray[0]);
            this.poly = Long.parseLong(stringArray[1], 16);
            this.initialValue = new BigInteger(stringArray[2], 16).longValue();
            this.refIn = stringArray[3].equalsIgnoreCase("true");
            this.refOut = stringArray[4].equalsIgnoreCase("true");
            this.xorOut = new BigInteger(stringArray[5], 16).longValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new NoSuchAlgorithmException("Unknown algorithm: invalid parameters. " + numberFormatException.toString());
        }
        this.init();
    }

    private void init() throws NoSuchAlgorithmException {
        this.topBit = 1L << this.width - 1;
        this.maskAllBits = -1L >>> 64 - this.width;
        this.maskHelp = this.maskAllBits >>> 8;
        this.check();
        this.fillTable();
        this.reset();
    }

    private void check() throws NoSuchAlgorithmException {
        if (this.width < 8 || this.width > 64) {
            throw new NoSuchAlgorithmException("Error: width has to be in range [8..64].");
        }
        if (this.poly != (this.poly & this.maskAllBits)) {
            throw new NoSuchAlgorithmException("Error: invalid polynomial for the " + this.width + " bit CRC.");
        }
        if (this.initialValue != (this.initialValue & this.maskAllBits)) {
            throw new NoSuchAlgorithmException("Error: invalid init value for the " + this.width + " bit CRC.");
        }
        if (this.xorOut != (this.xorOut & this.maskAllBits)) {
            throw new NoSuchAlgorithmException("Error: invalid xorOut value for the " + this.width + " bit CRC.");
        }
    }

    public void reset() {
        this.length = 0L;
        this.value = this.initialValue;
        if (this.refIn) {
            this.value = CrcGeneric.reflect(this.value, this.width);
        }
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.width / 4 + (this.width % 4 > 0 ? 1 : 0);
        stringBuffer.append(this.width);
        stringBuffer.append(",");
        stringBuffer.append(Service.hexformat(this.poly, n).toUpperCase());
        stringBuffer.append(",");
        stringBuffer.append(Service.hexformat(this.initialValue, n).toUpperCase());
        stringBuffer.append(",");
        stringBuffer.append(this.refIn ? "true" : "false");
        stringBuffer.append(",");
        stringBuffer.append(this.refOut ? "true" : "false");
        stringBuffer.append(",");
        stringBuffer.append(Service.hexformat(this.xorOut, n).toUpperCase());
        return stringBuffer.toString();
    }

    public String getName() {
        if (this.name == null) {
            return this.getString();
        }
        return this.name;
    }

    public void setInitialValue(long l) {
        this.initialValue = l;
    }

    public long getInitialValue() {
        return this.initialValue;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setPoly(long l) {
        this.poly = l;
    }

    public long getPoly() {
        return this.poly;
    }

    public void setRefIn(boolean bl) {
        this.refIn = bl;
    }

    public boolean getRefIn() {
        return this.refIn;
    }

    public void setRefOut(boolean bl) {
        this.refOut = bl;
    }

    public boolean getRefOut() {
        return this.refOut;
    }

    public void setXorOut(long l) {
        this.xorOut = l;
    }

    public long getXorOut() {
        return this.xorOut;
    }

    private static long reflect(long l, int n) {
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            l2 <<= 1;
            l2 |= l & 1L;
            l >>>= 1;
        }
        return l << n | l2;
    }

    private void fillTable() {
        this.table = new long[256];
        for (int i = 0; i < 256; ++i) {
            long l = i;
            if (this.refIn) {
                l = CrcGeneric.reflect(l, 8);
            }
            l <<= this.width - 8;
            for (int j = 0; j < 8; ++j) {
                boolean bl = (l & this.topBit) != 0L;
                l <<= 1;
                if (!bl) continue;
                l ^= this.poly;
            }
            if (this.refIn) {
                l = CrcGeneric.reflect(l, this.width);
            }
            this.table[i] = l & this.maskAllBits;
        }
    }

    public void update(byte by) {
        int n;
        if (this.refIn) {
            n = (int)(this.value ^ (long)by) & 0xFF;
            this.value >>>= 8;
            this.value &= this.maskHelp;
        } else {
            n = (int)(this.value >>> this.width - 8 ^ (long)by) & 0xFF;
            this.value <<= 8;
        }
        this.value ^= this.table[n];
        ++this.length;
    }

    public void update(int n) {
        this.update((byte)(n & 0xFF));
    }

    public long getValue() {
        return this.getFinal();
    }

    private long getFinal() {
        long l = this.value;
        if (this.refIn != this.refOut) {
            l = CrcGeneric.reflect(l, this.width);
        }
        return (l ^ this.xorOut) & this.maskAllBits;
    }

    public byte[] getByteArray() {
        long l = this.getFinal();
        byte[] byArray = new byte[this.width / 8 + (this.width % 8 > 0 ? 1 : 0)];
        for (int i = byArray.length - 1; i > -1; --i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        return byArray;
    }
}

