# Contributing

We appreciate contributions from the community.

Click here to see the full [Guidelines](docs/source/contributing.md):

- issues are managed by the `@meeseeksdev` bot
- When opening an issue, make sure that it hasn't been solved
  - Search on Google or Github.
- Include your system information

```
python -c "import IPython; print(IPython.sys_info())"
```

- **All work is submitted through pull requests (PRs)**
  - PRs are submitted as soon as there is code to be discussed

---

# Check these resources:

Now that we went through the basics, Here are more detailed documentation on areas of contribution:

## Installing

[Developer install information](docs/source/dev_install.md) for installation steps.

## Releasing

[Release procedures](docs/source/dev_release.md)

## Testing

[Testing Contributions](docs/source/dev_testing.md)

## Documenting

[Documentation Contributions](docs/source/dev_docs.md)

---

# Good First Issues

This is a link for issues that don't require deep knowledge of the project:

Click here: [Good First Issues](https://github.com/jupyter-widgets/ipywidgets/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22)
