### Platform Support

The following chart shows the availability of each N-API function on each platform.
The functions point to the related part of the official N-API documentation.

| Supported features | Linux<br/>(Ubuntu) | 
| :---: | :---: |
| [napi_add_env_cleanup_hook](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_add_env_cleanup_hook)  | O |
| [napi_async_complete_callback](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_async_complete_callback)  | O |
| [napi_async_destroy](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_async_destroy)  | O |
| [napi_async_execute_callback](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_async_execute_callback)  | O |
| [napi_async_init](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_async_init)  | O |
| [napi_callback](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_callback_info)  | O |
| [napi_callback_info](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_callback_info)  | O |
| [napi_call_function](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_call_function)  | O |
| [napi_cancel_async_work](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_cancel_async_work)  | O |
| [napi_close_callback_scope](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_close_callback_scope)  | O |
| [napi_close_escapable_handle_scope](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_close_escapable_handle_scope)  | O |
| [napi_close_handle_scope](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_close_handle_scope)  | O |
| [napi_coerce_to_bool](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_coerce_to_bool)  | O |
| [napi_coerce_to_number](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_coerce_to_number)  | O |
| [napi_coerce_to_object](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_coerce_to_object)  | O |
| [napi_coerce_to_string](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_coerce_to_string)  | O |
| [napi_create_array](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_array)  | O |
| [napi_create_arraybuffer](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_arraybuffer)  | O |
| [napi_create_array_with_length](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_array_with_length)  | O |
| [napi_create_async_work](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_async_work)  | O |
| [napi_create_buffer](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_buffer)  | O |
| [napi_create_buffer_copy](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_buffer_copy)  | O |
| [napi_create_dataview](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_dataview)  | O |
| [napi_create_double](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_double)  | O |
| [napi_create_error](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_error)  | O |
| [napi_create_external](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_external)  | O |
| [napi_create_external_arraybuffer](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_external_arraybuffer)  | O |
| [napi_create_external_buffer](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_external_buffer)  | O |
| [napi_create_function](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_function)  | O |
| [napi_create_int32](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_int32)  | O |
| [napi_create_int64](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_int64)  | O |
| [napi_create_object](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_object)  | O |
| [napi_create_promise](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_promise)  | O |
| [napi_create_range_error](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_range_error)  | O |
| [napi_create_reference](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_reference)  | O |
| [napi_create_string_latin1](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_string_latin1)  | O |
| [napi_create_string_utf16](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_string_utf16)  | O |
| [napi_create_string_utf8](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_string_utf8)  | O |
| [napi_create_symbol](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_symbol)  | O |
| [napi_create_threadsafe_function](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_threadsafe_function)  | O |
| [napi_create_typedarray](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_typedarray)  | O |
| [napi_create_type_error](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_type_error)  | O |
| [napi_create_uint32](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_uint32)  | O |
| [napi_define_class](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_define_class)  | O |
| [napi_define_properties](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_define_properties)  | O |
| [napi_delete_async_work](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_delete_async_work)  | O |
| [napi_delete_element](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_delete_element)  | O |
| [napi_delete_property](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_delete_property)  | O |
| [napi_delete_reference](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_delete_reference)  | O |
| [napi_env](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_env)  | O |
| [napi_escapable_handle_scope](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_escapable_handle_scope)  | O |
| [napi_escape_handle](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_escape_handle)  | O |
| [napi_extended_error_info](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_extended_error_info)  | O |
| [napi_fatal_error](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_fatal_error)  | O |
| [napi_fatal_exception](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_fatal_exception)  | O |
| [napi_finalize](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_finalize)  | O |
| [napi_get_and_clear_last_exception](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_and_clear_last_exception)  | O |
| [napi_get_arraybuffer_info](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_arraybuffer_info)  | O |
| [napi_get_array_length](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_array_length)  | O |
| [napi_get_boolean](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_boolean)  | O |
| [napi_get_buffer_info](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_buffer_info)  | O |
| [napi_get_cb_info](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_cb_info)  | O |
| [napi_get_dataview_info](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_dataview_info)  | O |
| [napi_get_element](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_element)  | O |
| [napi_get_global](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_global)  | O |
| [napi_get_last_error_info](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_last_error_info)  | O |
| [napi_get_named_property](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_named_property)  | O |
| [napi_get_new_target](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_new_target)  | O |
| [napi_get_node_version](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_node_version)  | O |
| [napi_get_null](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_null)  | O |
| [napi_get_property](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_property_names)  | O |
| [napi_get_property_names](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_property_names)  | O |
| [napi_get_prototype](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_prototype)  | O |
| [napi_get_reference_value](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_reference_value)  | O |
| [napi_get_typedarray_info](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_typedarray_info)  | O |
| [napi_get_undefined](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_undefined)  | O |
| [napi_get_uv_event_loop](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_uv_event_loop)  | O |
| [napi_get_value_bool](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_bool)  | O |
| [napi_get_value_double](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_double)  | O |
| [napi_get_value_external](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_external)  | O |
| [napi_get_value_int32](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_int32)  | O |
| [napi_get_value_int64](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_int64)  | O |
| [napi_get_value_string_latin1](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_string_latin1)  | O |
| [napi_get_value_string_utf16](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_string_utf16)  | O |
| [napi_get_value_string_utf8](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_string_utf8)  | O |
| [napi_get_value_uint32](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_uint32)  | O |
| [napi_get_version](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_version)  | O |
| [napi_handle_scope](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_handle_scope)  | O |
| [napi_has_element](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_has_element)  | O |
| [napi_has_named_property](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_has_named_property)  | O |
| [napi_has_own_property](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_has_own_property)  | O |
| [napi_has_property](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_has_property)  | O |
| [napi_instanceof](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_instanceof)  | O |
| [napi_is_array](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_is_array)  | O |
| [napi_is_arraybuffer](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_is_arraybuffer)  | O |
| [napi_is_buffer](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_is_buffer)  | O |
| [napi_is_dataview](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_is_dataview)  | O |
| [napi_is_error](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_is_error)  | O |
| [napi_is_exception_pending](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_is_exception_pending)  | O |
| [napi_is_promise](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_is_promise)  | O |
| [napi_is_typedarray](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_is_typedarray)  | O |
| [napi_make_callback](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_make_callback)  | O |
| [napi_new_instance](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_new_instance)  | O |
| [napi_open_callback_scope](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_open_callback_scope)  | O |
| [napi_open_escapable_handle_scope](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_open_escapable_handle_scope)  | O |
| [napi_open_handle_scope](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_open_handle_scope)  | O |
| [napi_property_attributes](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_property_attributes)  | O |
| [napi_property_descriptor](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_property_descriptor)  | O |
| [napi_queue_async_work](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_queue_async_work)  | O |
| [napi_ref](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_ref)  | O |
| [napi_reference_ref](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_reference_ref)  | O |
| [napi_reference_unref](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_reference_unref)  | O |
| [napi_reject_deferred](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_reject_deferred)  | O |
| [napi_remove_env_cleanup_hook](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_remove_env_cleanup_hook)  | O |
| [napi_remove_wrap](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_remove_wrap)  | O |
| [napi_resolve_deferred](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_resolve_deferred)  | O |
| [napi_set_element](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_set_element)  | O |
| [napi_set_named_property](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_set_named_property)  | O |
| [napi_set_property](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_set_property)  | O |
| [napi_status](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_status)  | O |
| [napi_strict_equals](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_strict_equals)  | O |
| [napi_throw](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_throw)  | O |
| [napi_throw_error](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_throw_error)  | O |
| [napi_throw_range_error](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_throw_range_error)  | O |
| [napi_throw_type_error](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_throw_type_error)  | O |
| [napi_typedarray_type](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_typedarray_type)  | O |
| [napi_typeof](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_typeof)  | O |
| [napi_unwrap](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_unwrap)  | O |
| [napi_value](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_value)  | O |
| [napi_valuetype](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_valuetype)  | O |
| [napi_wrap](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_wrap)  | O |

### The API does not support the following features:
  - [napi_threadsafe_function](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_threadsafe_function)
  - [napi_threadsafe_function_release_mode](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_threadsafe_function_release_mode)
  - [napi_threadsafe_function_call_mode](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_threadsafe_function_call_mode)
  - [napi_threadsafe_function_call_js](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_threadsafe_function_call_js)
  - [napi_create_bigint_int64](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_bigint_int64)
  - [napi_create_bigint_uint64](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_bigint_uint64)
  - [napi_create_bigint_words](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_bigint_words)
  - [napi_get_value_bigint_int64](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_bigint_int64)
  - [napi_get_value_bigint_uint64](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_bigint_uint64)
  - [napi_get_value_bigint_words](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_value_bigint_words)
  - [napi_add_finalizer](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_add_finalizer)
  - [Asynchronous Thread-safe Function Calls:](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_asynchronous_thread_safe_function_calls)
    - [napi_create_threadsafe_function](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_create_threadsafe_function)
    - [napi_get_threadsafe_function_context](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_get_threadsafe_function_context)
    - [napi_call_threadsafe_function](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_call_threadsafe_function)
    - [napi_acquire_threadsafe_function](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_acquire_threadsafe_function)
    - [napi_release_threadsafe_function](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_release_threadsafe_function)
    - [napi_ref_threadsafe_function](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_ref_threadsafe_function)
    - [napi_unref_threadsafe_function](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_napi_unref_threadsafe_function)


# N-API

Based on Node.js v10.15 (LTS)

N-API (pronounced N as in the letter, followed by API) is an API for building native Addons. N-API is generally used to create and manipulate JavaScript values. You can read more about N-API [here](https://nodejs.org/dist/latest-v10.x/docs/api/n-api.html#n_api_n_api).

Our implementation works with either ES2015 enabled or disabled. All of the N-API ES2015 features throw an exception when IoT.js isn't compiled with ES2015 yet they are used.

### Building N-API with IoT.js

You need to append the `--n-api` parameter to the build command (e.g. `tools/build.py --n-api`).
This automatically adds the N-API module to IoT.js.

To run N-API test you should also append `--n-api` after the `testrunner.py`.

### Building a simple module

### node-gyp

C++ code needs to be compiled into executable form whether it be as an object
file to linked with others, a shared library, or a standalone executable.

The main reason for this is that we need to link to the Node.js dependencies and
headers correctly, another reason is that we need a cross platform way to build
C++ source into binary for the target platform.

Until now **node-gyp** is the **de-facto** standard build tool for writing
Node.js addons. It's based on Google's **gyp** build tool, which abstract away
many of the tedious issues related to cross platform building.

**node-gyp** uses a file called ```binding.gyp``` that is located on the root of
your addon project.

```binding.gyp``` file, contains all building configurations organized with a
JSON like syntax. The most important parameter is the  **target** that must be
set to the same value used on the initialization code of the addon as in the
examples reported below:

#### **binding.gyp**

```gyp
{
  "targets": [
    {
      # myModule is the name of your native addon
      "target_name": "myModule",
      "sources": ["src/my_module.cc", ...],
      ...
  ]
}
```

#### **my_module.cc**

```cpp
#include <napi.h>

// ...

/**
* This code is our entry-point. We receive two arguments here, the first is the
* environment that represent an independent instance of the JavaScript runtime,
* the second is exports, the same as module.exports in a .js file.
* You can either add properties to the exports object passed in or create your
* own exports object. In either case you must return the object to be used as
* the exports for the module when you return from the Init function.
*/
Napi::Object Init(Napi::Env env, Napi::Object exports) {

  // ...

  return exports;
}

/**
* This code defines the entry-point for the Node addon, it tells Node where to go
* once the library has been loaded into active memory. The first argument must
* match the "target" in our *binding.gyp*. Using NODE_GYP_MODULE_NAME ensures
* that the argument will be correct, as long as the module is built with
* node-gyp (which is the usual way of building modules). The second argument
* points to the function to invoke. The function must not be namespaced.
*/
NODE_API_MODULE(NODE_GYP_MODULE_NAME, Init)
```

#### **node-gyp** reference

  - [Installation](https://www.npmjs.com/package/node-gyp#installation)
  - [How to use](https://www.npmjs.com/package/node-gyp#how-to-use)
  - [The binding.gyp file](https://www.npmjs.com/package/node-gyp#the-bindinggyp-file)
  - [Commands](https://www.npmjs.com/package/node-gyp#commands)
  - [Command options](https://www.npmjs.com/package/node-gyp#command-options)
  - [Configuration](https://www.npmjs.com/package/node-gyp#configuration)

Sometimes finding the right settings for ```binding.gyp``` is not easy so to
accomplish at most complicated task please refer to:

- [GYP documentation](https://gyp.gsrc.io/index.md)
- [node-gyp wiki](https://github.com/nodejs/node-gyp/wiki)
The most important parameter is the target that must be set to the same value used on the initialization code of the addon.
To use the N-API functions you need to include `node-api.h` in your native module.