/*
    Copyright (C) 2004 by Jorrit Tyberghein

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __CS_PROTOMESHLDR_H__
#define __CS_PROTOMESHLDR_H__

#include "imap/reader.h"
#include "imap/writer.h"
#include "iutil/eventh.h"
#include "iutil/comp.h"
#include "csutil/strhash.h"

struct iEngine;
struct iReporter;
struct iPluginManager;
struct iObjectRegistry;
struct iSyntaxService;
struct iProtoFactoryState;

namespace CS
{
namespace Plugins
{
namespace ProtoMeshLoader
{


/**
 * Proto Mesh factory loader.
 */
class csProtoFactoryLoader : 
  public scfImplementation2<csProtoFactoryLoader, 
                            iLoaderPlugin,
                            iComponent>
{
private:
  iObjectRegistry* object_reg;
  csRef<iSyntaxService> synldr;

  csStringHash xmltokens;
#define CS_TOKEN_ITEM_FILE \
  "plugins/mesh/protomesh/persist/standard/protomesh_factory.tok"
#include "cstool/tokenlist.h"
#undef CS_TOKEN_ITEM_FILE

public:
  /// Constructor.
  csProtoFactoryLoader (iBase*);

  /// Destructor.
  virtual ~csProtoFactoryLoader ();

  /// Register plugin with the system driver
  virtual bool Initialize (iObjectRegistry *object_reg);

  /// Parse a given node and return a new object for it.
  virtual csPtr<iBase> Parse (iDocumentNode* node,
    iStreamSource*, iLoaderContext* ldr_context, iBase* context);

  virtual bool IsThreadSafe() { return true; }
};

/**
 * Proto Mesh factory saver.
 */
class csProtoFactorySaver : 
  public scfImplementation2<csProtoFactorySaver,
                            iSaverPlugin,
                            iComponent>
{
private:
  iObjectRegistry* object_reg;
  csRef<iSyntaxService> synldr;

public:
  /// Constructor.
  csProtoFactorySaver (iBase*);

  /// Destructor.
  virtual ~csProtoFactorySaver ();

  /// Register plugin with the system driver
  virtual bool Initialize (iObjectRegistry *object_reg);

  /// Write down given object and add to iDocumentNode.
  virtual bool WriteDown (iBase *obj, iDocumentNode* parent,
  	iStreamSource*);
};

/**
 * Proto Mesh loader.
 */
class csProtoMeshLoader : 
  public scfImplementation2<csProtoMeshLoader, 
                            iLoaderPlugin,
                            iComponent>
{
private:
  iObjectRegistry* object_reg;
  csRef<iSyntaxService> synldr;

  csStringHash xmltokens;
#define CS_TOKEN_ITEM_FILE \
  "plugins/mesh/protomesh/persist/standard/protomesh_meshobject.tok"
#include "cstool/tokenlist.h"
#undef CS_TOKEN_ITEM_FILE

public:
  /// Constructor.
  csProtoMeshLoader (iBase*);

  /// Destructor.
  virtual ~csProtoMeshLoader ();

  /// Register plugin with the system driver
  virtual bool Initialize (iObjectRegistry *object_reg);

  /// Parse a given node and return a new object for it.
  virtual csPtr<iBase> Parse (iDocumentNode* node,
    iStreamSource*, iLoaderContext* ldr_context, iBase* context);

  virtual bool IsThreadSafe() { return true; }
};

/**
 * Proto Mesh saver.
 */
class csProtoMeshSaver :
  public scfImplementation2<csProtoMeshSaver,
                            iSaverPlugin,
                            iComponent>
{
private:
  iObjectRegistry* object_reg;
  csRef<iSyntaxService> synldr;

public:
  /// Constructor.
  csProtoMeshSaver (iBase*);

  /// Destructor.
  virtual ~csProtoMeshSaver ();

  /// Register plugin with the system driver
  virtual bool Initialize (iObjectRegistry *object_reg);

  /// Write down given object and add to iDocumentNode.
  virtual bool WriteDown (iBase *obj, iDocumentNode* parent,
  	iStreamSource*);
};

} // namespace ProtoMeshLoader
} // namespace Plugins
} // namespace CS

#endif // __CS_PROTOMESHLDR_H__

