/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Comparator;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;

public class ExpressionContext
implements XSLTStaticContext {
    private StyleElement element;
    private NamePool namePool;

    public ExpressionContext(StyleElement styleElement) {
        this.element = styleElement;
        this.namePool = styleElement.getTargetNamePool();
    }

    public Configuration getConfiguration() {
        return this.element.getConfiguration();
    }

    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration(), this.element.getPrincipalStylesheet().getCollationMap());
    }

    public LocationMap getLocationMap() {
        return this.element.getPrincipalStylesheet().getLocationMap();
    }

    public void issueWarning(String string, SourceLocator sourceLocator) {
        this.element.issueWarning(string, sourceLocator);
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public String getSystemId() {
        return this.element.getSystemId();
    }

    public int getLineNumber() {
        return this.element.getLineNumber();
    }

    public String getBaseURI() {
        return this.element.getBaseURI();
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = this.element.getURIForPrefix(string, false);
        if (string2 == null) {
            StaticError staticError = new StaticError("Undeclared namespace prefix " + Err.wrap(string));
            staticError.setErrorCode("XPST0081");
            throw staticError;
        }
        return string2;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.element.makeNamespaceContext();
    }

    public int getFingerprint(String string, boolean bl) throws XPathException {
        String[] stringArray;
        try {
            stringArray = this.getConfiguration().getNameChecker().getQNameParts(string);
        }
        catch (QNameException qNameException) {
            throw new StaticError(qNameException.getMessage());
        }
        String string2 = stringArray[0];
        if (string2.equals("")) {
            String string3 = "";
            if (bl) {
                string3 = this.getURIForPrefix(string2);
            }
            return this.namePool.getFingerprint(string3, string);
        }
        String string4 = this.getURIForPrefix(string2);
        return this.namePool.getFingerprint(string4, stringArray[1]);
    }

    public VariableReference bindVariable(int n) throws StaticError {
        return new VariableReference(this.element.bindVariable(n));
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.element.getPrincipalStylesheet().getFunctionLibrary();
    }

    public boolean isElementAvailable(String string) throws XPathException {
        try {
            String[] stringArray = this.getConfiguration().getNameChecker().getQNameParts(string);
            String string2 = stringArray[0].equals("") ? this.getNamePool().getURIFromURICode(this.getDefaultElementNamespace()) : this.getURIForPrefix(stringArray[0]);
            return this.element.getPreparedStylesheet().getStyleNodeFactory().isElementAvailable(string2, stringArray[1]);
        }
        catch (QNameException qNameException) {
            StaticError staticError = new StaticError("Invalid element name. " + qNameException.getMessage());
            staticError.setErrorCode("XTDE1440");
            throw staticError;
        }
    }

    public Comparator getCollation(String string) {
        return this.element.getPrincipalStylesheet().findCollation(string);
    }

    public String getDefaultCollationName() {
        return this.element.getDefaultCollationName();
    }

    public short getDefaultElementNamespace() {
        return this.element.getDefaultXPathNamespace();
    }

    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    public boolean isInBackwardsCompatibleMode() {
        return this.element.backwardsCompatibleModeIsEnabled();
    }

    public boolean isImportedSchema(String string) {
        return this.getXSLStylesheet().isImportedSchema(string);
    }

    public Set getImportedSchemaNamespaces() {
        return this.getXSLStylesheet().getImportedSchemaTable();
    }

    public boolean isAllowedBuiltInType(AtomicType atomicType) {
        if (this.getConfiguration().isSchemaAware(50)) {
            return true;
        }
        if (atomicType instanceof BuiltInAtomicType) {
            return ((BuiltInAtomicType)atomicType).isAllowedInBasicXSLT() || this.getXSLStylesheet().allowsAllBuiltInTypes();
        }
        return false;
    }

    public XSLStylesheet getXSLStylesheet() {
        return this.element.getPrincipalStylesheet();
    }

    public StyleElement getStyleElement() {
        return this.element;
    }
}

