/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public abstract class SingleNodeExpression
extends ComputedExpression {
    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (itemType == null) {
            StaticError staticError = new StaticError("Cannot select a node here: the context item is undefined");
            staticError.setErrorCode("XPDY0002");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        if (itemType.isAtomicType()) {
            StaticError staticError = new StaticError("Cannot select a node here: the context item is an atomic value");
            staticError.setErrorCode("XPTY0020");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        return this.typeCheck(staticContext, itemType);
    }

    public int computeCardinality() {
        return 24576;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return AnyNodeTest.getInstance();
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public int computeSpecialProperties() {
        return 0xC30000;
    }

    public abstract NodeInfo getNode(XPathContext var1) throws XPathException;

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return SingletonIterator.makeIterator(this.getNode(xPathContext));
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.getNode(xPathContext);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return this.getNode(xPathContext) != null;
    }
}

