/****************************************************************************
 *    lib/c/Formula.h - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef FORMULA_H
#define FORMULA_H
#include "Types.h"

#include <string>
#include <vector>
#include <set>
#include <assert.h>

namespace C {

class FluentAction;

class Formula
{
public:
	Formula();
	Formula(char, Formula*);
	Formula(char, vector<Formula*>*);
	
	virtual ~Formula();

	void addPart(Formula*);
	char getType();
	Formula* getFirstFormula();
	vector<Formula*>::iterator begin();
	vector<Formula*>::iterator end();
	void insert(vector<Formula*>::iterator, vector<Formula*>::iterator, vector<Formula*>::iterator);

	Formula* invert();
	FluentAction* getFluentAction();
	bool isTrue();
	bool isFalse();

	void print(Printer*, set<Variable*>*, string T="");
	void printAlsoActions(Printer*, set<Variable*>*, string T="");
	void printCompositeFluents(Printer*, Types*);
	void printCompositeFluentActions(Printer*, Types*);

protected:
	char type_;

private:
	vector<Formula*>* I_;

};

}; // end of package namespace

#endif // FORMULA_H
