#ifndef H_CDW_MAIN
#define H_CDW_MAIN





/* About 'ENTER' and 'ESCAPE':
   ncurses defines some symbolic names for the two keys, but
   they tend not to work. '10' and '27' seem to work fine. */
#define CDW_KEY_ENTER    10
#define CDW_KEY_ESCAPE   27
#define CDW_KEY_TAB    '\t'



/* boolean, but with three values */
enum {
	CDW_UNKNOWN = -1, /* also known as "init" */
	CDW_FALSE   =  0,
	CDW_TRUE    = +1
};



/**
 * \brief Return values of most of cdw functions
 *
 * Introduced to avoid using magic numbers and to increase redability of code.
 */
typedef enum cdw_return_value {
	CDW_OK = 0,        /**< \brief usually means that function call was successful, also means pressing CDW_ENTER in buttonless widgets or OK/YES button in widgets with buttons */
	CDW_CANCEL = -1,   /**< \brief use e.g after user pressed CDW_ESCAPE in buttonless widgets, when user selected Cancel in widgets with buttons or sometimes when function returns with failure */
	CDW_NO = -2,       /**< \brief use after user pressed NO in widgets with buttons */
	CDW_ERROR = -3     /**< \brief general error, may be used when no other error applies */
} cdw_rv_t;


typedef long long signed int cdw_id_t;

typedef struct {
	cdw_id_t id;
	const char *label;
} cdw_id_clabel_t;

typedef struct {
	cdw_id_t id;
	char *label;
} cdw_id_label_t;


/* ugly, this belong to user interface */
struct cdw_form_type;
typedef struct cdw_form_type cdw_form_t;
typedef int (* cdw_form_widget_function_t)(cdw_form_t *, void *);

typedef void (* cdw_deallocator_t)(void *ptr);


#endif /* H_CDW_MAIN */
