//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Fit/SliderSettingsWidget.h
//! @brief     Defines class SliderSettingsWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_FIT_SLIDERSETTINGSWIDGET_H
#define BORNAGAIN_GUI_VIEW_FIT_SLIDERSETTINGSWIDGET_H

#include "GUI/View/Common/DataAccessWidget.h"
#include <QCheckBox>
#include <QRadioButton>

class SliderSettingsWidget : public DataAccessWidget {
    Q_OBJECT

public:
    SliderSettingsWidget(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_item) override;

signals:
    void sliderRangeFactorChanged(int value);
    void lockzChanged(bool value);

private slots:
    void rangeChanged();
    void onLockZChanged(int state);

private:
    void initSlider();
    void initZlock();

private:
    QRadioButton* m_radio1;
    QRadioButton* m_radio2;
    QRadioButton* m_radio3;
    QCheckBox* m_lockzCheckBox;
};

#endif // BORNAGAIN_GUI_VIEW_FIT_SLIDERSETTINGSWIDGET_H
