// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __MacroUnit__
#define __MacroUnit__

// Special unit for macro expansions

#include "Puma/Unit.h"
#include "Puma/Token.h"

namespace Puma {


class MacroUnit : public Unit {
  Unit *_CallingUnit;
  Token *_StartToken;
  Token *_EndToken;

public:
  MacroUnit () : _CallingUnit (0) {}
  MacroUnit (const Unit &u) : 
    Unit (u), _CallingUnit (0), _StartToken (0), _EndToken (0) {}
  virtual ~MacroUnit () {}
  
  // unit is a macro expansion
  virtual bool isMacroExp () const { return true; }

  // unit wherein the macro was called
  void CallingUnit (Unit *u) { _CallingUnit = u; }
  Unit *CallingUnit () const { return (Unit*)_CallingUnit; }
  
  // begin and end token of the macro call
  void MacroBegin (Token *t) { _StartToken = t; }
  void MacroEnd (Token *t) { _EndToken = t; }
  Token *MacroBegin () const { return _StartToken; }
  Token *MacroEnd () const { return _EndToken; }
  
  // get the first/last token of the whole macro expansion 
  // if the given token is the first/last token of this 
  // (sub-)expansion
  Token *ExpansionBegin (Token *) const;
  Token *ExpansionEnd (Token *) const;
};


} // namespace Puma

#endif /* __MacroUnit__ */
