/*
 * Copyright (c) 2015-2019, Renesas Electronics Corporation
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef BOOT_INIT_DRAM_REGDEF_H_
#define BOOT_INIT_DRAM_REGDEF_H_

/* DBSC registers */
#define DBSC_DBSYSCONF0		0xE6790000U
#define DBSC_DBSYSCONF1		0xE6790004U
#define DBSC_DBPHYCONF0		0xE6790010U
#define DBSC_DBKIND		0xE6790020U
#define DBSC_DBMEMCONF(ch, cs)	(0xE6790030U + 0x10U * (ch) + 0x04U * (cs))
#define DBSC_DBMEMCONF_0_0	0xE6790030U
#define DBSC_DBMEMCONF_0_1	0xE6790034U
#define DBSC_DBMEMCONF_0_2	0xE6790038U
#define DBSC_DBMEMCONF_0_3	0xE679003CU
#define DBSC_DBMEMCONF_1_2	0xE6790048U
#define DBSC_DBMEMCONF_1_3	0xE679004CU
#define DBSC_DBMEMCONF_1_0	0xE6790040U
#define DBSC_DBMEMCONF_1_1	0xE6790044U
#define DBSC_DBMEMCONF_2_0	0xE6790050U
#define DBSC_DBMEMCONF_2_1	0xE6790054U
#define DBSC_DBMEMCONF_2_2	0xE6790058U
#define DBSC_DBMEMCONF_2_3	0xE679005CU
#define DBSC_DBMEMCONF_3_0	0xE6790060U
#define DBSC_DBMEMCONF_3_1	0xE6790064U
#define DBSC_DBMEMCONF_3_2	0xE6790068U
#define DBSC_DBMEMCONF_3_3	0xE679006CU
#define DBSC_DBSYSCNT0		0xE6790100U
#define DBSC_DBSVCR1		0xE6790104U
#define DBSC_DBSTATE0		0xE6790108U
#define DBSC_DBSTATE1		0xE679010CU
#define DBSC_DBINTEN		0xE6790180U
#define DBSC_DBINTSTAT0		0xE6790184U
#define DBSC_DBACEN		0xE6790200U
#define DBSC_DBRFEN		0xE6790204U
#define DBSC_DBCMD		0xE6790208U
#define DBSC_DBWAIT		0xE6790210U
#define DBSC_DBSYSCTRL0		0xE6790280U
#define DBSC_DBTR(x)		(0xE6790300U + 0x04U * (x))
#define DBSC_DBTR0		0xE6790300U
#define DBSC_DBTR1		0xE6790304U
#define DBSC_DBTR2		0xE6790308U
#define DBSC_DBTR3		0xE679030CU
#define DBSC_DBTR4		0xE6790310U
#define DBSC_DBTR5		0xE6790314U
#define DBSC_DBTR6		0xE6790318U
#define DBSC_DBTR7		0xE679031CU
#define DBSC_DBTR8		0xE6790320U
#define DBSC_DBTR9		0xE6790324U
#define DBSC_DBTR10		0xE6790328U
#define DBSC_DBTR11		0xE679032CU
#define DBSC_DBTR12		0xE6790330U
#define DBSC_DBTR13		0xE6790334U
#define DBSC_DBTR14		0xE6790338U
#define DBSC_DBTR15		0xE679033CU
#define DBSC_DBTR16		0xE6790340U
#define DBSC_DBTR17		0xE6790344U
#define DBSC_DBTR18		0xE6790348U
#define DBSC_DBTR19		0xE679034CU
#define DBSC_DBTR20		0xE6790350U
#define DBSC_DBTR21		0xE6790354U
#define DBSC_DBTR22		0xE6790358U
#define DBSC_DBTR23		0xE679035CU
#define DBSC_DBTR24		0xE6790360U
#define DBSC_DBTR25		0xE6790364U
#define DBSC_DBTR26		0xE6790368U
#define DBSC_DBBL		0xE6790400U
#define DBSC_DBRFCNF1		0xE6790414U
#define DBSC_DBRFCNF2		0xE6790418U
#define DBSC_DBTSPCNF		0xE6790420U
#define DBSC_DBCALCNF		0xE6790424U
#define DBSC_DBRNK(x)		(0xE6790430U + 0x04U * (x))
#define DBSC_DBRNK2		0xE6790438U
#define DBSC_DBRNK3		0xE679043CU
#define DBSC_DBRNK4		0xE6790440U
#define DBSC_DBRNK5		0xE6790444U
#define DBSC_DBPDNCNF		0xE6790450U
#define DBSC_DBODT(x)		(0xE6790460U + 0x04U * (x))
#define DBSC_DBODT0		0xE6790460U
#define DBSC_DBODT1		0xE6790464U
#define DBSC_DBODT2		0xE6790468U
#define DBSC_DBODT3		0xE679046CU
#define DBSC_DBODT4		0xE6790470U
#define DBSC_DBODT5		0xE6790474U
#define DBSC_DBODT6		0xE6790478U
#define DBSC_DBODT7		0xE679047CU
#define DBSC_DBADJ0		0xE6790500U
#define DBSC_DBDBICNT		0xE6790518U
#define DBSC_DBDFIPMSTRCNF	0xE6790520U
#define DBSC_DBDFICUPDCNF	0xE679052CU
#define DBSC_DBDFISTAT(ch)	(0xE6790600U + 0x40U * (ch))
#define DBSC_DBDFISTAT_0	0xE6790600U
#define DBSC_DBDFISTAT_1	0xE6790640U
#define DBSC_DBDFISTAT_2	0xE6790680U
#define DBSC_DBDFISTAT_3	0xE67906C0U
#define DBSC_DBDFICNT(ch)	(0xE6790604U + 0x40U * (ch))
#define DBSC_DBDFICNT_0		0xE6790604U
#define DBSC_DBDFICNT_1		0xE6790644U
#define DBSC_DBDFICNT_2		0xE6790684U
#define DBSC_DBDFICNT_3		0xE67906C4U
#define DBSC_DBPDCNT0(ch)	(0xE6790610U + 0x40U * (ch))
#define DBSC_DBPDCNT0_0		0xE6790610U
#define DBSC_DBPDCNT0_1		0xE6790650U
#define DBSC_DBPDCNT0_2		0xE6790690U
#define DBSC_DBPDCNT0_3		0xE67906D0U
#define DBSC_DBPDCNT1(ch)	(0xE6790614U + 0x40U * (ch))
#define DBSC_DBPDCNT1_0		0xE6790614U
#define DBSC_DBPDCNT1_1		0xE6790654U
#define DBSC_DBPDCNT1_2		0xE6790694U
#define DBSC_DBPDCNT1_3		0xE67906D4U
#define DBSC_DBPDCNT2(ch)	(0xE6790618U + 0x40U * (ch))
#define DBSC_DBPDCNT2_0		0xE6790618U
#define DBSC_DBPDCNT2_1		0xE6790658U
#define DBSC_DBPDCNT2_2		0xE6790698U
#define DBSC_DBPDCNT2_3		0xE67906D8U
#define DBSC_DBPDCNT3(ch)	(0xE679061CU + 0x40U * (ch))
#define DBSC_DBPDCNT3_0		0xE679061CU
#define DBSC_DBPDCNT3_1		0xE679065CU
#define DBSC_DBPDCNT3_2		0xE679069CU
#define DBSC_DBPDCNT3_3		0xE67906DCU
#define DBSC_DBPDLK(ch)		(0xE6790620U + 0x40U * (ch))
#define DBSC_DBPDLK_0		0xE6790620U
#define DBSC_DBPDLK_1		0xE6790660U
#define DBSC_DBPDLK_2		0xE67906a0U
#define DBSC_DBPDLK_3		0xE67906e0U
#define DBSC_DBPDRGA(ch)	(0xE6790624U + 0x40U * (ch))
#define DBSC_DBPDRGD(ch)	(0xE6790628U + 0x40U * (ch))
#define DBSC_DBPDRGA_0		0xE6790624U
#define DBSC_DBPDRGD_0		0xE6790628U
#define DBSC_DBPDRGA_1		0xE6790664U
#define DBSC_DBPDRGD_1		0xE6790668U
#define DBSC_DBPDRGA_2		0xE67906A4U
#define DBSC_DBPDRGD_2		0xE67906A8U
#define DBSC_DBPDRGA_3		0xE67906E4U
#define DBSC_DBPDRGD_3		0xE67906E8U
#define DBSC_DBPDSTAT(ch)	(0xE6790630U + 0x40U * (ch))
#define DBSC_DBPDSTAT_0		0xE6790630U
#define DBSC_DBPDSTAT_1		0xE6790670U
#define DBSC_DBPDSTAT_2		0xE67906B0U
#define DBSC_DBPDSTAT_3		0xE67906F0U
#define DBSC_DBBUS0CNF0		0xE6790800U
#define DBSC_DBBUS0CNF1		0xE6790804U
#define DBSC_DBCAM0CNF1		0xE6790904U
#define DBSC_DBCAM0CNF2		0xE6790908U
#define DBSC_DBCAM0CNF3		0xE679090CU
#define DBSC_DBBSWAP		0xE67909F0U
#define DBSC_DBBCAMDIS		0xE67909FCU
#define DBSC_DBSCHCNT0		0xE6791000U
#define DBSC_DBSCHCNT1		0xE6791004U
#define DBSC_DBSCHSZ0		0xE6791010U
#define DBSC_DBSCHRW0		0xE6791020U
#define DBSC_DBSCHRW1		0xE6791024U
#define DBSC_DBSCHQOS_0(x)	(0xE6791030U + 0x10U * (x))
#define DBSC_DBSCHQOS_1(x)	(0xE6791034U + 0x10U * (x))
#define DBSC_DBSCHQOS_2(x)	(0xE6791038U + 0x10U * (x))
#define DBSC_DBSCHQOS_3(x)	(0xE679103CU + 0x10U * (x))
#define DBSC_DBSCHQOS00		0xE6791030U
#define DBSC_DBSCHQOS01		0xE6791034U
#define DBSC_DBSCHQOS02		0xE6791038U
#define DBSC_DBSCHQOS03		0xE679103CU
#define DBSC_DBSCHQOS10		0xE6791040U
#define DBSC_DBSCHQOS11		0xE6791044U
#define DBSC_DBSCHQOS12		0xE6791048U
#define DBSC_DBSCHQOS13		0xE679104CU
#define DBSC_DBSCHQOS20		0xE6791050U
#define DBSC_DBSCHQOS21		0xE6791054U
#define DBSC_DBSCHQOS22		0xE6791058U
#define DBSC_DBSCHQOS23		0xE679105CU
#define DBSC_DBSCHQOS30		0xE6791060U
#define DBSC_DBSCHQOS31		0xE6791064U
#define DBSC_DBSCHQOS32		0xE6791068U
#define DBSC_DBSCHQOS33		0xE679106CU
#define DBSC_DBSCHQOS40		0xE6791070U
#define DBSC_DBSCHQOS41		0xE6791074U
#define DBSC_DBSCHQOS42		0xE6791078U
#define DBSC_DBSCHQOS43		0xE679107CU
#define DBSC_DBSCHQOS50		0xE6791080U
#define DBSC_DBSCHQOS51		0xE6791084U
#define DBSC_DBSCHQOS52		0xE6791088U
#define DBSC_DBSCHQOS53		0xE679108CU
#define DBSC_DBSCHQOS60		0xE6791090U
#define DBSC_DBSCHQOS61		0xE6791094U
#define DBSC_DBSCHQOS62		0xE6791098U
#define DBSC_DBSCHQOS63		0xE679109CU
#define DBSC_DBSCHQOS70		0xE67910A0U
#define DBSC_DBSCHQOS71		0xE67910A4U
#define DBSC_DBSCHQOS72		0xE67910A8U
#define DBSC_DBSCHQOS73		0xE67910ACU
#define DBSC_DBSCHQOS80		0xE67910B0U
#define DBSC_DBSCHQOS81		0xE67910B4U
#define DBSC_DBSCHQOS82		0xE67910B8U
#define DBSC_DBSCHQOS83		0xE67910BCU
#define DBSC_DBSCHQOS90		0xE67910C0U
#define DBSC_DBSCHQOS91		0xE67910C4U
#define DBSC_DBSCHQOS92		0xE67910C8U
#define DBSC_DBSCHQOS93		0xE67910CCU
#define DBSC_DBSCHQOS100	0xE67910D0U
#define DBSC_DBSCHQOS101	0xE67910D4U
#define DBSC_DBSCHQOS102	0xE67910D8U
#define DBSC_DBSCHQOS103	0xE67910DCU
#define DBSC_DBSCHQOS110	0xE67910E0U
#define DBSC_DBSCHQOS111	0xE67910E4U
#define DBSC_DBSCHQOS112	0xE67910E8U
#define DBSC_DBSCHQOS113	0xE67910ECU
#define DBSC_DBSCHQOS120	0xE67910F0U
#define DBSC_DBSCHQOS121	0xE67910F4U
#define DBSC_DBSCHQOS122	0xE67910F8U
#define DBSC_DBSCHQOS123	0xE67910FCU
#define DBSC_DBSCHQOS130	0xE6791100U
#define DBSC_DBSCHQOS131	0xE6791104U
#define DBSC_DBSCHQOS132	0xE6791108U
#define DBSC_DBSCHQOS133	0xE679110CU
#define DBSC_DBSCHQOS140	0xE6791110U
#define DBSC_DBSCHQOS141	0xE6791114U
#define DBSC_DBSCHQOS142	0xE6791118U
#define DBSC_DBSCHQOS143	0xE679111CU
#define DBSC_DBSCHQOS150	0xE6791120U
#define DBSC_DBSCHQOS151	0xE6791124U
#define DBSC_DBSCHQOS152	0xE6791128U
#define DBSC_DBSCHQOS153	0xE679112CU
#define DBSC_DBSCTR0		0xE6791700U
#define DBSC_DBSCTR1		0xE6791708U
#define DBSC_DBSCHRW2		0xE679170CU
#define DBSC_SCFCTST01(x)	(0xE6791700U + 0x08U * (x))
#define DBSC_SCFCTST0		0xE6791700U
#define DBSC_SCFCTST1		0xE6791708U
#define DBSC_SCFCTST2		0xE679170CU
#define DBSC_DBMRRDR(chab)	(0xE6791800U + 0x04U * (chab))
#define DBSC_DBMRRDR_0		0xE6791800U
#define DBSC_DBMRRDR_1		0xE6791804U
#define DBSC_DBMRRDR_2		0xE6791808U
#define DBSC_DBMRRDR_3		0xE679180CU
#define DBSC_DBMRRDR_4		0xE6791810U
#define DBSC_DBMRRDR_5		0xE6791814U
#define DBSC_DBMRRDR_6		0xE6791818U
#define DBSC_DBMRRDR_7		0xE679181CU
#define DBSC_DBMEMSWAPCONF0	0xE6792000U

/* CPG registers */
#define CPG_BASE		0xE6150000U
#define CPG_FRQCRB		(CPG_BASE + 0x0004U)
#define CPG_PLLECR		(CPG_BASE + 0x00D0U)
#define CPG_MSTPSR5		(CPG_BASE + 0x003CU)
#define CPG_SRCR4		(CPG_BASE + 0x00BCU)
#define CPG_PLL3CR		(CPG_BASE + 0x00DCU)
#define CPG_ZB3CKCR		(CPG_BASE + 0x0380U)
#define CPG_FRQCRD		(CPG_BASE + 0x00E4U)
#define CPG_SMSTPCR5		(CPG_BASE + 0x0144U)
#define CPG_CPGWPR		(CPG_BASE + 0x0900U)
#define CPG_SRSTCLR4		(CPG_BASE + 0x0950U)

#endif /* BOOT_INIT_DRAM_REGDEF_H_*/
