
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The method hasAttributes returns whether this node (if it is an element) has any attributes.
 *  Create a new Document, Element and Attr node.  Add the Attr to the Element and append the 
 *  Element to the Document.  Retreive the newly created element node from the document and check
 *  if it has attributes using hasAttributes.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeHasAttrs">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-NodeHasAttrs</a>
*/
public final class nodehasattributes04 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodehasattributes04(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "staffNS", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Document newDoc;
      DocumentType docType = null;

      DOMImplementation domImpl;
      Element element;
      Element elementTest;
      Element elementDoc;
      Attr attribute;
      Node setNode;
      Node appendedChild;
      NodeList elementList;
      boolean hasAttributes;
      doc = (Document) load("staffNS", false);
      domImpl = doc.getImplementation();
      newDoc = domImpl.createDocument("http://www.w3.org/DOM/Test", "test", docType);
      element = newDoc.createElementNS("http://www.w3.org/DOM/Test", "dom:elem");
      attribute = newDoc.createAttribute("attr");
      setNode = element.setAttributeNode(attribute);
      elementDoc = newDoc.getDocumentElement();
      appendedChild = elementDoc.appendChild(element);
      elementList = newDoc.getElementsByTagNameNS("http://www.w3.org/DOM/Test", "elem");
      elementTest = (Element) elementList.item(0);
      hasAttributes = elementTest.hasAttributes();
      assertTrue("nodehasattributes04", hasAttributes);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/nodehasattributes04";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodehasattributes04.class, args);
   }
}

