
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The method setNamedItemNS adds a node using its namespaceURI and localName. If a node with 
 *  that namespace URI and that local name is already present in this map, it is replaced 
 *  by the new one.
 *  
 *  Create a new element and attribute Node and add the newly created attribute node to the elements 
 *  NamedNodeMap.  Verify if the new attr node has been successfully added to the map by checking 
 *  the nodeName of the retreived atttribute from the list of attribute nodes in this map.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS</a>
*/
public final class namednodemapsetnameditemns02 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public namednodemapsetnameditemns02(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "staffNS", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NamedNodeMap attributes;
      Element element;
      Attr attribute;
      Attr attribute1;
      Node newNode;
      String attrName;
      doc = (Document) load("staffNS", true);
      element = doc.createElementNS("http://www.w3.org/DOM/Test", "root");
      attribute1 = doc.createAttributeNS("http://www.w3.org/DOM/L1", "L1:att");
      attributes = element.getAttributes();
      newNode = attributes.setNamedItemNS(attribute1);
      attribute = (Attr) attributes.getNamedItemNS("http://www.w3.org/DOM/L1", "att");
      attrName = attribute.getNodeName();
      assertEquals("namednodemapsetnameditemns02", "L1:att", attrName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/namednodemapsetnameditemns02";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(namednodemapsetnameditemns02.class, args);
   }
}

