#include <stdio.h>
#include <stdlib.h>
#include <QtWidgets/QSlider>
#include "model.h"
#include "modslider.h"

ModSlider::ModSlider(Model *p_model, Qt::Orientation orientation, QWidget *parent) : QSlider(orientation, parent) {

  int i1;
  
  model = p_model;
  for (i1 = 0; i1 < model->getPoly(); i1++) {
    modValue[i1] = 0;
  }  
}

ModSlider::~ModSlider() {

}

double ModSlider::getModValue(int voiceIndex) {
  
  int vStart, vEnd;
    
  if (voiceIndex < 0) {
    model->getEditRange(vStart, vEnd);
    return(modValue[vStart]);
  } else {    
    return(modValue[voiceIndex]);
  }  
}

double ModSlider::getModValue() {

  int vStart, vEnd;
    
  model->getEditRange(vStart, vEnd);
  return(modValue[vStart]);
}

void ModSlider::setModValue(int voiceIndex, double p_value) {

  int vStart, vEnd, i1;
  
  if (voiceIndex < 0) {
    model->getEditRange(vStart, vEnd);
    for (i1 = vStart; i1 <= vEnd; i1++) {
      modValue[i1] = p_value;
    }  
  } else {               
    modValue[voiceIndex] = p_value;
  }  
}

void ModSlider::setModValue(double p_value) {

  int i1;
  int vStart, vEnd;
    
  model->getEditRange(vStart, vEnd);
  for (i1 = vStart; i1 <= vEnd; i1++) {
    modValue[i1] = p_value;
  }  
}

void ModSlider::setValues(double p_modValue, int p_value) {

  int i1;
  int vStart, vEnd;
    
  model->getEditRange(vStart, vEnd);
//  printf("setValues: %d  %f\n", p_value, p_modValue);
  if (p_modValue < 1234) {
    for (i1 = vStart; i1 <= vEnd; i1++) {
      modValue[i1] = p_modValue;
    }  
  }  
  if (p_value < 1234) {
    setValue(p_value);
  } 
  emit valueChanged(p_value); 
}

void ModSlider::setValues(int voiceIndex, double p_modValue, int p_value) {

  int vStart, vEnd, i1;
        
//  printf("setValues: %d  %f\n", p_value, p_modValue);
  if (p_modValue < 1234) {
    if (voiceIndex < 0) {
      model->getEditRange(vStart, vEnd);
      for (i1 = vStart; i1 <= vEnd; i1++) {
        modValue[i1] = p_modValue;
      }
    } else {
      modValue[voiceIndex] = p_modValue;
    }  
  }  
  if (p_value < 1234) {
    setValue(p_value);
  } 
  emit valueChanged(p_value); 
}

double ModSlider::getValue(int voiceIndex) {

  double val;
  int vStart, vEnd;
  
  if (voiceIndex < 0) { 
    model->getEditRange(vStart, vEnd);
    val = value() + modValue[vStart];
  } else {
    val = value() + modValue[voiceIndex];
  }  
  if (val > maximum()) {
    val = maximum();
  } else if (val < minimum()) {
    val = minimum();
  }
//  printf("getValue: %d  %f  %f\n", value(), modValue, val);
  return(val);
}

