/* xoreos-tools - Tools to help with xoreos development
 *
 * xoreos-tools is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos-tools is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos-tools. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Game-specific NWScript information for Jade Empire.
 */

#ifndef NWSCRIPT_GAME_JADE_H
#define NWSCRIPT_GAME_JADE_H

#include "src/nwscript/game.h"

namespace NWScript {

namespace Jade {

static const char * const kEngineTypeNames[] = {
	"Effect", "Event", "Location", "Talent"
};

static const char * const kFunctionNames[] = {
	/*    0 */ "Random",
	/*    1 */ "PrintString",
	/*    2 */ "PrintFloat",
	/*    3 */ "FloatToString",
	/*    4 */ "PrintInteger",
	/*    5 */ "PrintObject",
	/*    6 */ "AssignCommand",
	/*    7 */ "DelayCommand",
	/*    8 */ "ExecuteScript",
	/*    9 */ "ClearAllActions",
	/*   10 */ "SetFacing",
	/*   11 */ "SetCalendar",
	/*   12 */ "SetTime",
	/*   13 */ "DesignerAssert",
	/*   14 */ "ActionPlayerCombat",
	/*   15 */ "CanUse",
	/*   16 */ "GetTimeHour",
	/*   17 */ "GetTimeMinute",
	/*   18 */ "GetTimeSecond",
	/*   19 */ "GetTimeMillisecond",
	/*   20 */ "ActionRandomWalk",
	/*   21 */ "ActionMoveToLocation",
	/*   22 */ "ActionMoveToObject",
	/*   23 */ "ActionMoveAwayFromObject",
	/*   24 */ "GetArea",
	/*   25 */ "GetEnteringObject",
	/*   26 */ "GetExitingObject",
	/*   27 */ "GetPosition",
	/*   28 */ "GetFacing",
	/*   29 */ "Use",
	/*   30 */ "GetIsItemPossessedBy",
	/*   31 */ "GetFirstUse",
	/*   32 */ "GetNextUse",
	/*   33 */ "GetState",
	/*   34 */ "GetCameraTagEntry",
	/*   35 */ "GetCameraTagReplies",
	/*   36 */ "PauseConversation",
	/*   37 */ "LockCombatTarget",
	/*   38 */ "UnlockCombatTarget",
	/*   39 */ "SetConversationAutoFace",
	/*   40 */ "ActionPlayAnimation",
	/*   41 */ "GetDistanceToObject",
	/*   42 */ "GetIsObjectValid",
	/*   43 */ "ActionOpenDoor",
	/*   44 */ "ActionCloseDoor",
	/*   45 */ "SetCameraFacing",
	/*   46 */ "PlaySound2D",
	/*   47 */ "PlaySound3D",
	/*   48 */ "PlaySoundAtPosition",
	/*   49 */ "GetHealth",
	/*   50 */ "GetMaxHealth",
	/*   51 */ "GetLocalInt",
	/*   52 */ "GetLocalFloat",
	/*   53 */ "ZZ_HIDDEN_GetLocalString",
	/*   54 */ "GetLocalObject",
	/*   55 */ "SetLocalInt",
	/*   56 */ "SetLocalFloat",
	/*   57 */ "ZZ_HIDDEN_SetLocalString",
	/*   58 */ "SetLocalObject",
	/*   59 */ "GetStringLength",
	/*   60 */ "GetStringUpperCase",
	/*   61 */ "GetStringLowerCase",
	/*   62 */ "GetStringRight",
	/*   63 */ "GetStringLeft",
	/*   64 */ "InsertString",
	/*   65 */ "GetSubString",
	/*   66 */ "FindSubString",
	/*   67 */ "fabs",
	/*   68 */ "cos",
	/*   69 */ "sin",
	/*   70 */ "tan",
	/*   71 */ "acos",
	/*   72 */ "asin",
	/*   73 */ "atan",
	/*   74 */ "log",
	/*   75 */ "pow",
	/*   76 */ "sqrt",
	/*   77 */ "abs",
	/*   78 */ "RemoveCombatStyle",
	/*   79 */ "PlaySoundSet",
	/*   80 */ "EffectAbilityIncrease",
	/*   81 */ "GetIsSpeedLoadMode",
	/*   82 */ "EffectResurrection",
	/*   83 */ "GetGoreSetting",
	/*   84 */ "SetCreatureMaterial",
	/*   85 */ "GetFirstEffect",
	/*   86 */ "GetNextEffect",
	/*   87 */ "RemoveEffect",
	/*   88 */ "GetIsEffectValid",
	/*   89 */ "GetEffectDurationType",
	/*   90 */ "GetEffectSubType",
	/*   91 */ "GetEffectCreator",
	/*   92 */ "IntToString",
	/*   93 */ "RestoreCreatureMaterial",
	/*   94 */ "ClearDelayCommands",
	/*   95 */ "d2",
	/*   96 */ "d3",
	/*   97 */ "d4",
	/*   98 */ "d6",
	/*   99 */ "d8",
	/*  100 */ "d10",
	/*  101 */ "d12",
	/*  102 */ "d20",
	/*  103 */ "d100",
	/*  104 */ "VectorMagnitude",
	/*  105 */ "ConsoleCommand",
	/*  106 */ "GetObjectType",
	/*  107 */ "StoreFXStates",
	/*  108 */ "RestoreFXStates",
	/*  109 */ "GetAppearance",
	/*  110 */ "SignalWait",
	/*  111 */ "SetUnselectable",
	/*  112 */ "SetConversationOwnerForCamera",
	/*  113 */ "GetConversationNumber",
	/*  114 */ "GetConversationOwnerForCamera",
	/*  115 */ "GetCutsceneFromScriptCommand",
	/*  116 */ "GetPlayerConversationOwner",
	/*  117 */ "GetObjectConversationResref",
	/*  118 */ "SetAppearance",
	/*  119 */ "GetHeadType",
	/*  120 */ "GetInCutsceneMode",
	/*  121 */ "RoundsToSeconds",
	/*  122 */ "HoursToSeconds",
	/*  123 */ "TurnsToSeconds",
	/*  124 */ "SetGoodEvilValue",
	/*  125 */ "GetGoodEvilValue",
	/*  126 */ "ArtPlaceableGetPreviousState",
	/*  127 */ "ZZ_CUT_GetAlignmentGoodEvil",
	/*  128 */ "GetFirstObjectInShape",
	/*  129 */ "GetNextObjectInShape",
	/*  130 */ "SetOnClickedDeadTime",
	/*  131 */ "SignalEvent",
	/*  132 */ "EventUserDefined",
	/*  133 */ "StopConversation",
	/*  134 */ "GetTagOfAreaFrom",
	/*  135 */ "ActionGiveItem",
	/*  136 */ "ActionTakeItem",
	/*  137 */ "VectorNormalize",
	/*  138 */ "GetCombatStyleLevel",
	/*  139 */ "GetAbilityScore",
	/*  140 */ "GetIsDead",
	/*  141 */ "PrintVector",
	/*  142 */ "Vector",
	/*  143 */ "SetFacingPoint",
	/*  144 */ "AngleToVector",
	/*  145 */ "VectorToAngle",
	/*  146 */ "SetLookAtObject",
	/*  147 */ "StartMinigame",
	/*  148 */ "ClearCombatAnimations",
	/*  149 */ "CreateGroundPile",
	/*  150 */ "DisableHexgrid",
	/*  151 */ "GetDistanceBetween",
	/*  152 */ "ZZ_HIDDEN_SetLocalLocation",
	/*  153 */ "ZZ_HIDDEN_GetLocalLocation",
	/*  154 */ "IsCreatureInViewVolume",
	/*  155 */ "GetMGStats",
	/*  156 */ "SetHealth",
	/*  157 */ "GetGemInAmulet",
	/*  158 */ "SetFloatingTextAlpha",
	/*  159 */ "GetPriorActivation",
	/*  160 */ "ActionSetFacing",
	/*  161 */ "GetBuildType",
	/*  162 */ "SetCommandable",
	/*  163 */ "GetCommandable",
	/*  164 */ "EnableOrientationChanges",
	/*  165 */ "EffectMovementSpeedIncrease",
	/*  166 */ "Cutscene_PropLoad",
	/*  167 */ "ActionFollowCreature",
	/*  168 */ "GetTag",
	/*  169 */ "Cutscene_PropUnload",
	/*  170 */ "GetEffectType",
	/*  171 */ "GetTimePlayed",
	/*  172 */ "Cutscene_PropAttach",
	/*  173 */ "ChangeFaction",
	/*  174 */ "CreateItem",
	/*  175 */ "DestroyItem",
	/*  176 */ "TransferItem",
	/*  177 */ "Cutscene_PropDetach",
	/*  178 */ "Cutscene_PropSetPosition",
	/*  179 */ "Cutscene_PropSetOrientation",
	/*  180 */ "Cutscene_PropPlayAnimation",
	/*  181 */ "Cutscene_Start",
	/*  182 */ "Cutscene_End",
	/*  183 */ "Cutscene_TargetPosition",
	/*  184 */ "Cutscene_TargetObject",
	/*  185 */ "Cutscene_MoveToPosition",
	/*  186 */ "Cutscene_MoveToObject",
	/*  187 */ "Cutscene_OrbitPosition",
	/*  188 */ "Cutscene_OrbitObject",
	/*  189 */ "Cutscene_PlayAnimation",
	/*  190 */ "Cutscene_Truck",
	/*  191 */ "Cutscene_Dolly",
	/*  192 */ "Cutscene_Boom",
	/*  193 */ "Cutscene_Pan",
	/*  194 */ "Cutscene_Tilt",
	/*  195 */ "GetLoadedFromAreaTransition",
	/*  196 */ "ActionJumpToObject",
	/*  197 */ "GetWaypointByTag",
	/*  198 */ "GetTransitionTarget",
	/*  199 */ "EffectLinkEffects",
	/*  200 */ "GetObjectByTag",
	/*  201 */ "Cutscene_Roll",
	/*  202 */ "ActionWait",
	/*  203 */ "SetAreaTransitionMovie",
	/*  204 */ "ActionStartConversation",
	/*  205 */ "ActionPauseConversation",
	/*  206 */ "ActionResumeConversation",
	/*  207 */ "GetObjectScript",
	/*  208 */ "ShowAreaTransGui",
	/*  209 */ "ApplyVisualEffectToObject",
	/*  210 */ "Cutscene_Zoom",
	/*  211 */ "Cutscene_ClearTarget",
	/*  212 */ "SetUserDefinedEventNumber",
	/*  213 */ "GetLocation",
	/*  214 */ "ActionJumpToLocation",
	/*  215 */ "Location",
	/*  216 */ "ApplyVisualEffectAtLocation",
	/*  217 */ "GetIsPC",
	/*  218 */ "FeetToMeters",
	/*  219 */ "YardsToMeters",
	/*  220 */ "ApplyEffectToObject",
	/*  221 */ "Cutscene_StopOrbit",
	/*  222 */ "GetSpellTargetLocation",
	/*  223 */ "GetPositionFromLocation",
	/*  224 */ "ZZ_CUT_GetAreaFromLocation",
	/*  225 */ "GetFacingFromLocation",
	/*  226 */ "MGConfirmation",
	/*  227 */ "GetNearestObject",
	/*  228 */ "GetNearestObjectToLocation",
	/*  229 */ "UnlockMGGroup",
	/*  230 */ "IntToFloat",
	/*  231 */ "FloatToInt",
	/*  232 */ "StringToInt",
	/*  233 */ "StringToFloat",
	/*  234 */ "ActionCastSpell",
	/*  235 */ "GetIsEnemy",
	/*  236 */ "GetIsFriend",
	/*  237 */ "GetIsNeutral",
	/*  238 */ "Cutscene_Stop",
	/*  239 */ "GetStringByStrRef",
	/*  240 */ "ActionSpeakStringByStrRef",
	/*  241 */ "DestroyObject",
	/*  242 */ "Cutscene_SetZoom",
	/*  243 */ "CreateObject",
	/*  244 */ "EventSpellCastAt",
	/*  245 */ "Cutscene_SetOrientation",
	/*  246 */ "Cutscene_LoadCamera",
	/*  247 */ "GetUserDefinedEventNumber",
	/*  248 */ "GetSpellId",
	/*  249 */ "RandomName",
	/*  250 */ "EffectPoison",
	/*  251 */ "GetBuildNumber",
	/*  252 */ "GetOneLinerSpeaker",
	/*  253 */ "Cutscene_CameraAnimation",
	/*  254 */ "GetLastSpeaker",
	/*  255 */ "BeginConversation",
	/*  256 */ "Cutscene_StuntAnimation",
	/*  257 */ "Cutscene_DialogShot",
	/*  258 */ "Cutscene_StuntSetPosition",
	/*  259 */ "Cutscene_StuntSetOrientation",
	/*  260 */ "GetOwner",
	/*  261 */ "AcquireHenchmanStore",
	/*  262 */ "GetFirstInObject",
	/*  263 */ "GetNextInObject",
	/*  264 */ "ZZ_CUT_GetAreaOfEffectCreator",
	/*  265 */ "DeleteLocalInt",
	/*  266 */ "DeleteLocalFloat",
	/*  267 */ "DeleteLocalString",
	/*  268 */ "DeleteLocalObject",
	/*  269 */ "DeleteLocalLocation",
	/*  270 */ "ZY_EFFECT_EffectHaste",
	/*  271 */ "ZY_EFFECT_EffectSlow",
	/*  272 */ "ObjectToString",
	/*  273 */ "ZY_EFFECT_EffectImmunity",
	/*  274 */ "ZY_EFFECT_GetIsImmune",
	/*  275 */ "ZY_EFFECT_EffectDamageImmunityIncrease",
	/*  276 */ "GetCharm",
	/*  277 */ "SetCharm",
	/*  278 */ "GetIntimidate",
	/*  279 */ "SetIntimidate",
	/*  280 */ "GetIntuition",
	/*  281 */ "SetIntuition",
	/*  282 */ "SetCreatureEmotionalState",
	/*  283 */ "GetCreatureEmotionalState",
	/*  284 */ "SetCustomToken",
	/*  285 */ "GetAILevel",
	/*  286 */ "SetAILevel",
	/*  287 */ "SetObjectNoCollide",
	/*  288 */ "ToggleHexGridPatch",
	/*  289 */ "GetPlayerSeenByObject",
	/*  290 */ "EnableDepthOfField",
	/*  291 */ "SetDepthOfField",
	/*  292 */ "SetHenchmanLockStrRef",
	/*  293 */ "Cutscene_ForceAnimation",
	/*  294 */ "ActionDoCommand",
	/*  295 */ "EventConversation",
	/*  296 */ "GetLastWorldMapDestination",
	/*  297 */ "PolymorphPlayerToHenchman",
	/*  298 */ "GetDistanceBetweenLocations",
	/*  299 */ "SetHenchmanAppearance",
	/*  300 */ "PlayAnimation",
	/*  301 */ "Get2DAEntryIntByString",
	/*  302 */ "Get2DAEntryFloatByString",
	/*  303 */ "Get2DAEntryStringByString",
	/*  304 */ "GetHasSpellEffect",
	/*  305 */ "GetEffectSpellId",
	/*  306 */ "GetHenchmanAvailable",
	/*  307 */ "SetHenchmanState",
	/*  308 */ "GetHenchmanState",
	/*  309 */ "ActivateHenchman",
	/*  310 */ "SetLockCamera",
	/*  311 */ "DeactivateHenchman",
	/*  312 */ "SetHenchmanLevel",
	/*  313 */ "JumpToLocation",
	/*  314 */ "ZY_EFFECT_EffectTemporaryHitpoints",
	/*  315 */ "GetHenchmanLevel",
	/*  316 */ "SetHenchmanCombatMode",
	/*  317 */ "GetHenchmanCombatMode",
	/*  318 */ "GetStyleOfHarmonicCombo",
	/*  319 */ "SaveCombatRetry",
	/*  320 */ "GetIsInCombat",
	/*  321 */ "LockCurrentHenchman",
	/*  322 */ "GiveGoldToPlayer",
	/*  323 */ "Cutscene_TargetMidpoint",
	/*  324 */ "SetLocked",
	/*  325 */ "GetLocked",
	/*  326 */ "GetSelectedHenchman",
	/*  327 */ "SetSelectedHenchman",
	/*  328 */ "DeactivateAllHenchmen",
	/*  329 */ "ActionInteractObject",
	/*  330 */ "GetLastUsedBy",
	/*  331 */ "GetSelectedHenchmanSubtype",
	/*  332 */ "Cutscene_EnableAllTriggers",
	/*  333 */ "Cutscene_LoadRim",
	/*  334 */ "Cutscene_UnloadRim",
	/*  335 */ "SetTravelGiver",
	/*  336 */ "GetBlockingDoor",
	/*  337 */ "GetIsDoorActionPossible",
	/*  338 */ "DoDoorAction",
	/*  339 */ "GetFirstItemInInventory",
	/*  340 */ "GetNextItemInInventory",
	/*  341 */ "GetClass",
	/*  342 */ "Cutscene_DialogShotVerified",
	/*  343 */ "GetLevel",
	/*  344 */ "GetDamageDealtByType",
	/*  345 */ "GetTotalDamageDealt",
	/*  346 */ "GetLastDamager",
	/*  347 */ "GetLastDisarmed",
	/*  348 */ "Cutscene_SetDialogShotConstraint",
	/*  349 */ "GetLastLockedBy",
	/*  350 */ "GetLastUnlockedBy",
	/*  351 */ "Cutscene_GetObjectHeight",
	/*  352 */ "Cutscene_GetDialogSide",
	/*  353 */ "Cutscene_GetObjectAnim",
	/*  354 */ "Cutscene_GetSpeaker",
	/*  355 */ "Cutscene_GetListener",
	/*  356 */ "Cutscene_GetPosition",
	/*  357 */ "Cutscene_GetOrientation",
	/*  358 */ "GetGender",
	/*  359 */ "Cutscene_GetWaypointOrientation",
	/*  360 */ "ActionMoveAwayFromLocation",
	/*  361 */ "ZZ_COMBAT_GetAttemptedAttackTarget",
	/*  362 */ "Cutscene_SetAnimScale",
	/*  363 */ "Cutscene_WaitOnSoundReady",
	/*  364 */ "ZZ_CUT_GetAssociate",
	/*  365 */ "ZZ_CUT_AddHenchman",
	/*  266 */ "ZZ_CUT_RemoveHenchman",
	/*  367 */ "ZZ_CUT_AddJournalQuestEntry",
	/*  368 */ "ZZ_CUT_RemoveJournalQuestEntry",
	/*  369 */ "ZZ_CUT_GetPCPublicCDKey",
	/*  370 */ "ZZ_CUT_GetPCIPAddress",
	/*  371 */ "ZZ_CUT_GetPCPlayerName",
	/*  372 */ "ZZ_CUT_SetPCLike",
	/*  373 */ "ZZ_CUT_SetPCDislike",
	/*  374 */ "ZZ_CUT_SendMessageToPC",
	/*  375 */ "ZZ_COMBAT_GetAttemptedSpellTarget",
	/*  376 */ "GetLastOpenedBy",
	/*  377 */ "DisplayFloatyFeedback",
	/*  378 */ "OpenStore",
	/*  379 */ "SetItemBuyPrice",
	/*  380 */ "SetItemSellPrice",
	/*  381 */ "GetItemBuyPrice",
	/*  382 */ "ActionForceMoveToLocation",
	/*  383 */ "ActionForceMoveToObject",
	/*  384 */ "GetJournalQuestExperience",
	/*  385 */ "JumpToObject",
	/*  386 */ "SetMapPinEnabled",
	/*  387 */ "GetItemSellPrice",
	/*  388 */ "PopUpGUIPanel",
	/*  389 */ "ZZ_CUT_ClearPersonalReputation",
	/*  390 */ "ZZ_COMBAT_SetIsTemporaryFriend",
	/*  391 */ "ZZ_COMBAT_SetIsTemporaryEnemy",
	/*  392 */ "ZZ_COMBAT_SetIsTemporaryNeutral",
	/*  393 */ "GiveXPToPlayer",
	/*  394 */ "SetXP",
	/*  395 */ "GetXP",
	/*  396 */ "IntToHexString",
	/*  397 */ "ZZ_CUT_GetBaseItemType",
	/*  398 */ "ZZ_CUT_GetItemHasItemProperty",
	/*  399 */ "ZZ_CUT_ActionEquipMostDamagingMelee",
	/*  400 */ "ZZ_CUT_ActionEquipMostDamagingRanged",
	/*  401 */ "ZZ_CUT_GetItemACValue",
	/*  402 */ "ZZ_CUT_ActionRest",
	/*  403 */ "ExploreArea",
	/*  404 */ "ZZ_CUT_ActionEquipMostEffectiveArmor",
	/*  405 */ "GetIsDay",
	/*  406 */ "GetIsNight",
	/*  407 */ "GetIsDawn",
	/*  408 */ "GetIsDusk",
	/*  409 */ "GetIsEncounterCreature",
	/*  410 */ "ZZ_CUT_GetLastPlayerDying",
	/*  411 */ "ZZ_CUT_GetStartingLocation",
	/*  412 */ "ChangeToStandardFaction",
	/*  413 */ "SoundObjectPlay",
	/*  414 */ "SoundObjectStop",
	/*  415 */ "SoundObjectSetVolume",
	/*  416 */ "SoundObjectSetPosition",
	/*  417 */ "SpeakOneLinerConversation",
	/*  418 */ "GetGold",
	/*  419 */ "GetItemAquired",
	/*  420 */ "ZZ_CUT_GetIsDM",
	/*  421 */ "ZZ_CUT_PlayVoiceChat",
	/*  422 */ "ZZ_CUT_GetIsWeaponEffective",
	/*  423 */ "ZZ_CUT_GetLastSpellHarmful",
	/*  424 */ "ZZ_CUT_EventActivateItem",
	/*  425 */ "PauseSound",
	/*  426 */ "DisableSoundSet",
	/*  427 */ "DisableMusicStateChanges",
	/*  428 */ "SetMusicState",
	/*  429 */ "GetMusicState",
	/*  430 */ "SetAreaMusicState",
	/*  431 */ "StartCutsceneAudio",
	/*  432 */ "ZZ_CUT_MusicBattleChange",
	/*  433 */ "ZZ_CUT_AmbientSoundPlay",
	/*  434 */ "ZZ_CUT_AmbientSoundStop",
	/*  435 */ "ZZ_CUT_AmbientSoundChange",
	/*  436 */ "ZZ_CUT_AmbientSoundChangeNight",
	/*  437 */ "GetLastKiller",
	/*  438 */ "ZZ_CUT_GetSpellCastItem",
	/*  439 */ "ZZ_CUT_GetItemActivated",
	/*  440 */ "ZZ_CUT_GetItemActivator",
	/*  441 */ "ZZ_CUT_GetItemActivatedTargetLocation",
	/*  442 */ "ZZ_CUT_GetItemActivatedTarget",
	/*  443 */ "GetIsOpen",
	/*  444 */ "TakeGoldFromPlayer",
	/*  445 */ "GetIsInConversation",
	/*  446 */ "EffectAbilityDecrease",
	/*  447 */ "ZY_EFFECT_EffectAttackDecrease",
	/*  448 */ "ZY_EFFECT_EffectDamageDecrease",
	/*  449 */ "ZY_EFFECT_EffectDamageImmunityDecrease",
	/*  450 */ "ZY_EFFECT_EffectACDecrease",
	/*  451 */ "EffectMovementSpeedDecrease",
	/*  452 */ "ZY_EFFECT_EffectSavingThrowDecrease",
	/*  453 */ "ZY_EFFECT_EffectSkillDecrease",
	/*  454 */ "ZY_EFFECT_EffectForceResistanceDecrease",
	/*  455 */ "GetPlotFlag",
	/*  456 */ "SetPlotFlag",
	/*  457 */ "ZY_EFFECT_EffectInvisibility",
	/*  458 */ "ZY_EFFECT_EffectConcealment",
	/*  459 */ "ZY_EFFECT_EffectDarkness",
	/*  460 */ "ZY_EFFECT_EffectDispelMagicAll",
	/*  461 */ "ZY_EFFECT_EffectElementalShield",
	/*  462 */ "ZY_EFFECT_EffectLevelDrain",
	/*  463 */ "ZY_EFFECT_EffectPolymorph",
	/*  464 */ "ZY_EFFECT_EffectSanctuary",
	/*  465 */ "ZY_EFFECT_EffectTrueSeeing",
	/*  466 */ "ZY_EFFECT_EffectSeeInvisible",
	/*  467 */ "ZY_EFFECT_EffectTimeStop",
	/*  468 */ "ZY_EFFECT_EffectBlindness",
	/*  469 */ "ZZ_CUT_GetIsReactionTypeFriendly",
	/*  470 */ "ZZ_CUT_GetIsReactionTypeNeutral",
	/*  471 */ "ZZ_CUT_GetIsReactionTypeHostile",
	/*  472 */ "ZY_EFFECT_EffectSpellLevelAbsorption",
	/*  473 */ "ZY_EFFECT_EffectDispelMagicBest",
	/*  474 */ "ZZ_CUT_ActivatePortal",
	/*  475 */ "GetItemCount",
	/*  476 */ "SurrenderToEnemies",
	/*  477 */ "ZY_EFFECT_EffectMissChance",
	/*  478 */ "ZZ_CUT_GetTurnResistanceHD",
	/*  479 */ "GetCreatureSize",
	/*  480 */ "ZY_EFFECT_EffectDisappearAppear",
	/*  481 */ "ZY_EFFECT_EffectDisappear",
	/*  482 */ "ZY_EFFECT_EffectAppear",
	/*  483 */ "ActionUnlockObject",
	/*  484 */ "ActionLockObject",
	/*  485 */ "ZY_EFFECT_EffectModifyAttacks",
	/*  486 */ "ZZ_CUT_GetLastTrapDetected",
	/*  487 */ "ZY_EFFECT_EffectDamageShield",
	/*  488 */ "ZZ_CUT_GetNearestTrapToObject",
	/*  489 */ "ZZ_DELETED_44",
	/*  490 */ "ZZ_DELETED_45",
	/*  491 */ "ZZ_CUT_GetFortitudeSavingThrow",
	/*  492 */ "ZZ_CUT_GetWillSavingThrow",
	/*  493 */ "ZZ_CUT_GetReflexSavingThrow",
	/*  494 */ "ZZ_CUT_GetChallengeRating",
	/*  495 */ "ZZ_DELETED_46",
	/*  496 */ "GetMovementRate",
	/*  497 */ "SetRegisteredScript",
	/*  498 */ "GetRunningRegisteredScript",
	/*  499 */ "GetHasStyle",
	/*  500 */ "GetNumberOfStyles",
	/*  501 */ "GetStyle",
	/*  502 */ "GetRoom",
	/*  503 */ "GetConversationResref",
	/*  504 */ "SetCutSceneCameraMode",
	/*  505 */ "ZZ_DELETED_51",
	/*  506 */ "ZZ_DELETED_52",
	/*  507 */ "ZZ_DELETED_53",
	/*  508 */ "ZZ_DELETED_54",
	/*  509 */ "StartNewArea",
	/*  510 */ "ZZ_DELETED_55",
	/*  511 */ "ZZ_CUT_GetWeaponRanged",
	/*  512 */ "DoAutoSavePlotPoint",
	/*  513 */ "GetGameDifficulty",
	/*  514 */ "DoAutoSave",
	/*  515 */ "ZZ_DELETED_57",
	/*  516 */ "ZZ_DELETED_58",
	/*  517 */ "ZZ_DELETED_59",
	/*  518 */ "ZZ_DELETED_60",
	/*  519 */ "ZZ_DELETED_61",
	/*  520 */ "ZZ_DELETED_62",
	/*  521 */ "ZZ_DELETED_63",
	/*  522 */ "GetCurrentAction",
	/*  523 */ "ZZ_DELETED_64",
	/*  524 */ "ZZ_DELETED_65",
	/*  525 */ "ZZ_CUT_FloatingTextStrRefOnCreature",
	/*  526 */ "ZZ_CUT_FloatingTextStringOnCreature",
	/*  527 */ "ZZ_CUT_GetTrapDisarmable",
	/*  528 */ "ZZ_CUT_GetTrapDetectable",
	/*  529 */ "ZZ_CUT_GetTrapDetectedBy",
	/*  530 */ "ZZ_CUT_GetTrapFlagged",
	/*  531 */ "ZZ_CUT_GetTrapBaseType",
	/*  532 */ "ZZ_CUT_GetTrapOneShot",
	/*  533 */ "ZZ_CUT_GetTrapCreator",
	/*  534 */ "ZZ_CUT_GetTrapKeyTag",
	/*  535 */ "ZZ_CUT_GetTrapDisarmDC",
	/*  536 */ "ZZ_CUT_GetTrapDetectDC",
	/*  537 */ "GetLockKeyRequired",
	/*  538 */ "GetLockKeyItem",
	/*  539 */ "ZZ_CUT_GetLockLockable",
	/*  540 */ "ZZ_CUT_GetLockUnlockDC",
	/*  541 */ "ZZ_CUT_GetLockLockDC",
	/*  542 */ "ZZ_CUT_GetPCLevellingUp",
	/*  543 */ "ZZ_CUT_GetHasFeatEffect",
	/*  544 */ "SetPlaceableIllumination",
	/*  545 */ "GetPlaceableIllumination",
	/*  546 */ "GetIsPlaceableObjectActionPossible",
	/*  547 */ "DoPlaceableObjectAction",
	/*  548 */ "GetPlayer",
	/*  549 */ "ZZ_CUT_GetNextPC",
	/*  550 */ "ZZ_CUT_SetTrapDetectedBy",
	/*  551 */ "ZZ_CUT_GetIsTrapped",
	/*  552 */ "ZZ_DELETED_66",
	/*  553 */ "ZZ_DELETED_67",
	/*  554 */ "PopUpDeathGUIPanel",
	/*  555 */ "ZZ_CUT_SetTrapDisabled",
	/*  556 */ "ZZ_COMBAT_GetLastHostileActor",
	/*  557 */ "ZZ_CUT_ExportAllCharacters",
	/*  558 */ "ZZ_CUT_MusicBackgroundGetTrack",
	/*  559 */ "ZZ_CUT_MusicBackgroundGetNightTrack",
	/*  560 */ "WriteTimestampedLogEntry",
	/*  561 */ "ZZ_CUT_GetModuleName",
	/*  562 */ "ZZ_CUT_GetFactionLeader",
	/*  563 */ "ZZ_DELETED_68",
	/*  564 */ "EndGame",
	/*  565 */ "GetRunScriptVar",
	/*  566 */ "GetIsObjectInCombatMode",
	/*  567 */ "IgnoreCombatEndTransition",
	/*  568 */ "SetNoReactionAnimations",
	/*  569 */ "ResetCombatInput",
	/*  570 */ "ZZ_CUT_GetHasInventory",
	/*  571 */ "ZZ_CUT_GetStrRefSoundDuration",
	/*  572 */ "ZZ_CUT_AddToParty",
	/*  573 */ "ZZ_CUT_RemoveFromParty",
	/*  574 */ "GetGlobalObject",
	/*  575 */ "SetGlobalObject",
	/*  576 */ "ZZ_HIDDEN_GetGlobalString",
	/*  577 */ "ZZ_HIDDEN_SetGlobalString",
	/*  578 */ "GetGlobalFloat",
	/*  579 */ "SetGlobalFloat",
	/*  580 */ "GetGlobalInt",
	/*  581 */ "SetGlobalInt",
	/*  582 */ "AurPostString",
	/*  583 */ "MG_GetLastEvent",
	/*  584 */ "MG_GetLastEventModelName",
	/*  585 */ "MG_GetObjectByName",
	/*  586 */ "MG_PlayAnimation",
	/*  587 */ "MG_GetLastBulletHitDamage",
	/*  588 */ "MG_GetLastBulletHitTarget",
	/*  589 */ "MG_GetLastBulletHitShooter",
	/*  590 */ "MG_AdjustFollowerHitPoints",
	/*  591 */ "MG_OnBulletHit",
	/*  592 */ "MG_OnObstacleHit",
	/*  593 */ "MG_GetLastFollowerHit",
	/*  594 */ "MG_GetLastObstacleHit",
	/*  595 */ "MG_GetLastBulletFiredDamage",
	/*  596 */ "MG_GetLastBulletFiredTarget",
	/*  597 */ "MG_GetObjectName",
	/*  598 */ "MG_OnDeath",
	/*  599 */ "MG_GetIsFollower",
	/*  600 */ "MG_GetIsPlayer",
	/*  601 */ "MG_GetIsEnemy",
	/*  602 */ "MG_GetIsTrigger",
	/*  603 */ "MG_GetIsObstacle",
	/*  604 */ "MG_SetFollowerHitPoints",
	/*  605 */ "MG_OnDamage",
	/*  606 */ "MG_GetLastHPChange",
	/*  607 */ "MG_RemoveAnimation",
	/*  608 */ "MG_GetCameraNearClip",
	/*  609 */ "MG_GetCameraFarClip",
	/*  610 */ "MG_SetCameraClip",
	/*  611 */ "MG_GetPlayer",
	/*  612 */ "MG_GetEnemyCount",
	/*  613 */ "MG_GetEnemy",
	/*  614 */ "MG_GetObstacleCount",
	/*  615 */ "MG_GetObstacle",
	/*  616 */ "MG_GetHitPoints",
	/*  617 */ "MG_GetMaxHitPoints",
	/*  618 */ "MG_SetMaxHitPoints",
	/*  619 */ "MG_GetSphereRadius",
	/*  620 */ "MG_SetSphereRadius",
	/*  621 */ "MG_GetNumLoops",
	/*  622 */ "MG_SetNumLoops",
	/*  623 */ "MG_GetPosition",
	/*  624 */ "MG_GetGunBankCount",
	/*  625 */ "MG_GetGunBankBulletModel",
	/*  626 */ "MG_GetGunBankGunModel",
	/*  627 */ "MG_GetGunBankDamage",
	/*  628 */ "MG_GetGunBankTimeBetweenShots",
	/*  629 */ "MG_GetGunBankLifespan",
	/*  630 */ "MG_GetGunBankSpeed",
	/*  631 */ "MG_GetGunBankTarget",
	/*  632 */ "MG_SetGunBankBulletModel",
	/*  633 */ "MG_SetGunBankGunModel",
	/*  634 */ "MG_SetGunBankDamage",
	/*  635 */ "MG_SetGunBankTimeBetweenShots",
	/*  636 */ "MG_SetGunBankLifespan",
	/*  637 */ "MG_SetGunBankSpeed",
	/*  638 */ "MG_SetGunBankTarget",
	/*  639 */ "MG_GetLastBulletHitPart",
	/*  640 */ "MG_GetIsGunBankTargetting",
	/*  641 */ "MG_GetPlayerOffset",
	/*  642 */ "MG_GetPlayerInvincibility",
	/*  643 */ "MG_GetPlayerSpeed",
	/*  644 */ "MG_GetPlayerMinSpeed",
	/*  645 */ "MG_GetPlayerAccelerationPerSecond",
	/*  646 */ "MG_GetPlayerTunnelPos",
	/*  647 */ "MG_SetPlayerOffset",
	/*  648 */ "MG_SetPlayerInvincibility",
	/*  649 */ "MG_SetPlayerSpeed",
	/*  650 */ "MG_SetPlayerMinSpeed",
	/*  651 */ "MG_SetPlayerAccelerationPerSecond",
	/*  652 */ "MG_SetPlayerTunnelPos",
	/*  653 */ "MG_GetPlayerTunnelNeg",
	/*  654 */ "MG_SetPlayerTunnelNeg",
	/*  655 */ "MG_GetPlayerOrigin",
	/*  656 */ "MG_SetPlayerOrigin",
	/*  657 */ "MG_GetGunBankHorizontalSpread",
	/*  658 */ "MG_GetGunBankVerticalSpread",
	/*  659 */ "MG_GetGunBankSensingRadius",
	/*  660 */ "MG_GetGunBankInaccuracy",
	/*  661 */ "MG_SetGunBankHorizontalSpread",
	/*  662 */ "MG_SetGunBankVerticalSpread",
	/*  663 */ "MG_SetGunBankSensingRadius",
	/*  664 */ "MG_SetGunBankInaccuracy",
	/*  665 */ "MG_GetIsInvulnerable",
	/*  666 */ "MG_StartInvulnerability",
	/*  667 */ "MG_GetPlayerMaxSpeed",
	/*  668 */ "MG_SetPlayerMaxSpeed",
	/*  669 */ "ZZ_CUT_AddJournalWorldEntry",
	/*  670 */ "ZZ_CUT_AddJournalWorldEntryStrref",
	/*  671 */ "BarkString",
	/*  672 */ "BarkStringPlaying",
	/*  673 */ "ZZ_CUT_DeleteJournalWorldEntry",
	/*  674 */ "ZZ_CUT_DeleteJournalWorldEntryStrref",
	/*  675 */ "ZZ_CUT_EffectForceDrain",
	/*  676 */ "ZZ_CUT_EffectPsychicStatic",
	/*  677 */ "ZZ_CUT_PlayVisualAreaEffect",
	/*  678 */ "ZZ_CUT_SetJournalQuestEntryPicture",
	/*  679 */ "ZZ_CUT_GetLocalBoolean",
	/*  680 */ "ZZ_CUT_SetLocalBoolean",
	/*  681 */ "ZZ_CUT_GetLocalNumber",
	/*  682 */ "ZZ_CUT_SetLocalNumber",
	/*  683 */ "ZZ_CUT_MG_GetSoundFrequency",
	/*  684 */ "ZZ_CUT_MG_SetSoundFrequency",
	/*  685 */ "ZZ_CUT_MG_GetSoundFrequencyIsRandom",
	/*  686 */ "ZZ_CUT_MG_SetSoundFrequencyIsRandom",
	/*  687 */ "ZZ_CUT_MG_GetSoundVolume",
	/*  688 */ "ZZ_CUT_MG_SetSoundVolume",
	/*  689 */ "ZZ_CUT_SoundObjectGetPitchVariance",
	/*  690 */ "ZZ_CUT_SoundObjectSetPitchVariance",
	/*  691 */ "ZZ_CUT_SoundObjectGetVolume",
	/*  692 */ "ZZ_HIDDEN_GetGlobalLocation",
	/*  693 */ "ZZ_HIDDEN_SetGlobalLocation",
	/*  694 */ "ZZ_CUT_AddAvailableNPCByObject",
	/*  695 */ "ZZ_CUT_RemoveAvailableNPC",
	/*  696 */ "ZZ_CUT_GetIsAvailableCreature",
	/*  697 */ "ZZ_CUT_AddAvailableNPCByTemplate",
	/*  698 */ "ZZ_CUT_SpawnAvailableNPC",
	/*  699 */ "ZZ_CUT_GetIsNPCPartyMember",
	/*  700 */ "ZZ_CUT_ActionBarkString",
	/*  701 */ "ZZ_CUT_GetIsConversationActive",
	/*  702 */ "ZZ_CUT_EffectLightsaberThrow",
	/*  703 */ "ZZ_CUT_EffectWhirlWind",
	/*  704 */ "ZZ_CUT_SetPartyAIStyle",
	/*  705 */ "ZZ_CUT_SetNPCAIStyle",
	/*  706 */ "ZZ_CUT_SetNPCSelectability",
	/*  707 */ "ZZ_CUT_GetNPCSelectability",
	/*  708 */ "GetCurrentStyle",
	/*  709 */ "SetCurrentStyle",
	/*  710 */ "ClearAllEffects",
	/*  711 */ "GetLastConversation",
	/*  712 */ "GetFaction",
	/*  713 */ "GetStandardFaction",
	/*  714 */ "ZZ_CUT_GivePlotXP",
	/*  715 */ "GetMinimumHealth",
	/*  716 */ "SetMinimumHealth",
	/*  717 */ "MG_GetPlayerTunnelInfinite",
	/*  718 */ "MG_SetPlayerTunnelInfinite",
	/*  719 */ "ZZ_CUT_SetGlobalFadeIn",
	/*  720 */ "ZZ_CUT_SetGlobalFadeOut",
	/*  721 */ "ZZ_COMBAT_GetLastHostileTarget",
	/*  722 */ "ZZ_COMBAT_GetLastAttackAction",
	/*  723 */ "ZZ_CUT_GetLastForcePowerUsed",
	/*  724 */ "ZZ_CUT_GetLastCombatFeatUsed",
	/*  725 */ "ZZ_COMBAT_GetLastAttackResult",
	/*  726 */ "ZZ_CUT_GetWasForcePowerSuccessful",
	/*  727 */ "ZZ_COMBAT_GetFirstAttacker",
	/*  728 */ "ZZ_COMBAT_GetNextAttacker",
	/*  729 */ "ZZ_CUT_SetFormation",
	/*  730 */ "ZZ_CUT_ActionFollowLeader",
	/*  731 */ "ZZ_CUT_SetForcePowerUnsuccessful",
	/*  732 */ "ZZ_CUT_GetIsDebilitated",
	/*  733 */ "PlayMovie",
	/*  734 */ "ZZ_CUT_SaveNPCState",
	/*  735 */ "ZZ_CUT_GetCategoryFromTalent",
	/*  736 */ "FadeScreen",
	/*  737 */ "PauseMovie",
	/*  738 */ "StopMovie",
	/*  739 */ "PlayMovieBlocking",
	/*  740 */ "ActionPlaySound2D",
	/*  741 */ "ActionPlaySound3D",
	/*  742 */ "ActionPlaySoundAtPosition",
	/*  743 */ "LoadTaskGroup",
	/*  744 */ "GetTaskComplete",
	/*  745 */ "GetTaskGroupComplete",
	/*  746 */ "EffectModifyHealth",
	/*  747 */ "EffectModifyFocus",
	/*  748 */ "EffectModifyChi",
	/*  749 */ "SetTaskComplete",
	/*  750 */ "SetAreaFogColor",
	/*  751 */ "GetIsLiveContentAvailable",
	/*  752 */ "ShowWorldMap",
	/*  753 */ "GetAreaState",
	/*  754 */ "SetAreaState",
	/*  755 */ "GetObjectActive",
	/*  756 */ "SetObjectActive",
	/*  757 */ "FailQuest",
	/*  758 */ "GetPlayerCreatureCombatTarget",
	/*  759 */ "SetCombatCounter",
	/*  760 */ "GetCombatCounter",
	/*  761 */ "SetCombatTimerCurrent",
	/*  762 */ "SetCombatTimerFinish",
	/*  763 */ "SetCombatTimerOn",
	/*  764 */ "GetCombatTimerCurrent",
	/*  765 */ "GetCombatTimerOn",
	/*  766 */ "SetPosition",
	/*  767 */ "GetCombatTeam",
	/*  768 */ "SetCombatTeam",
	/*  769 */ "GetAggressivenessValue",
	/*  770 */ "SetAggressivenessValue",
	/*  771 */ "EffectDamageHealth",
	/*  772 */ "EffectDamageChi",
	/*  773 */ "EffectDamageFocus",
	/*  774 */ "EffectDamageDrunk",
	/*  775 */ "SetFactionReputation",
	/*  776 */ "GetGlobalBoolean",
	/*  777 */ "SetGlobalBoolean",
	/*  778 */ "GetLocalBoolean",
	/*  779 */ "SetLocalBoolean",
	/*  780 */ "EffectSlowed",
	/*  781 */ "EffectParalyzed",
	/*  782 */ "EffectDazed",
	/*  783 */ "EffectHealing",
	/*  784 */ "GetRecoveryTime",
	/*  785 */ "SetRecoveryTime",
	/*  786 */ "SetQuestActive",
	/*  787 */ "GetQuestActive",
	/*  788 */ "ZZ_CUT_CompleteQuest",
	/*  789 */ "GetQuestComplete",
	/*  790 */ "GetQuestFailed",
	/*  791 */ "GetFavoredMove",
	/*  792 */ "SetFavoredMove",
	/*  793 */ "GetCombatProbAttack",
	/*  794 */ "GetCombatProbBlock",
	/*  795 */ "GetCombatProbHeal",
	/*  796 */ "GetCombatProbMove",
	/*  797 */ "GetCombatProbSwitchStyle",
	/*  798 */ "GetCombatProbIdle",
	/*  799 */ "SetCombatProbabilities",
	/*  800 */ "GetAccumulationRatio",
	/*  801 */ "GetFogColour",
	/*  802 */ "GetFogNear",
	/*  803 */ "GetFogFar",
	/*  804 */ "GetForceDistortion",
	/*  805 */ "GetNoise",
	/*  806 */ "GetOceanFresnel",
	/*  807 */ "GetOceanHeight",
	/*  808 */ "GetOceanWaveClip",
	/*  809 */ "GetOceanWaveHeight",
	/*  810 */ "GetOceanWaveOffset",
	/*  811 */ "GetOceanWaveFreq",
	/*  812 */ "GetOceanWaveDirX",
	/*  813 */ "GetOceanWaveDirY",
	/*  814 */ "GetPixelFlareThresholdColour",
	/*  815 */ "GetPixelFlareThresholdMaxScale",
	/*  816 */ "GetSaturation",
	/*  817 */ "GetWindDirection",
	/*  818 */ "GetWindVariation",
	/*  819 */ "SetAccumulationRatio",
	/*  820 */ "SetFogColour",
	/*  821 */ "SetFogNear",
	/*  822 */ "SetFogFar",
	/*  823 */ "SetForceDistortion",
	/*  824 */ "SetNoise",
	/*  825 */ "SetOceanFresnel",
	/*  826 */ "SetOceanHeight",
	/*  827 */ "SetOceanWaveClip",
	/*  828 */ "SetOceanWaveHeight",
	/*  829 */ "SetOceanWaveOffset",
	/*  830 */ "SetOceanWaveFreq",
	/*  831 */ "SetOceanWaveDirX",
	/*  832 */ "SetOceanWaveDirY",
	/*  833 */ "SetPixelFlareThresholdColour",
	/*  834 */ "SetPixelFlareThresholdMaxScale",
	/*  835 */ "SetSaturation",
	/*  836 */ "SetWindDirection",
	/*  837 */ "SetWindVariation",
	/*  838 */ "AnimateAccumulationRatio",
	/*  839 */ "AnimateFogColour",
	/*  840 */ "AnimateFogNear",
	/*  841 */ "AnimateFogFar",
	/*  842 */ "AnimateForceDistortion",
	/*  843 */ "AnimateNoise",
	/*  844 */ "AnimateOceanFresnel",
	/*  845 */ "AnimateOceanHeight",
	/*  846 */ "AnimateOceanWaveClip",
	/*  847 */ "AnimateOceanWaveHeights",
	/*  848 */ "AnimateOceanWaveOffsets",
	/*  849 */ "AnimateOceanWaveFreqs",
	/*  850 */ "AnimateOceanWaveDirX",
	/*  851 */ "AnimateOceanWaveDirY",
	/*  852 */ "AnimatePixelFlareThreshold",
	/*  853 */ "AnimateSaturation",
	/*  854 */ "AnimateWindDirection",
	/*  855 */ "AnimateWindVariation",
	/*  856 */ "AnimateRestoreRoomDefaults",
	/*  857 */ "Create2DAEffect",
	/*  858 */ "Create2DAEffectByLabel",
	/*  859 */ "Get2DAEntryString",
	/*  860 */ "Get2DAEntryFloat",
	/*  861 */ "Get2DAEntryInt",
	/*  862 */ "GetUseDefaultStyleAI",
	/*  863 */ "SetUseDefaultStyleAI",
	/*  864 */ "GetCombatTemplate",
	/*  865 */ "SetCombatTemplate",
	/*  866 */ "GetObtainPowerUp",
	/*  867 */ "SetObtainPowerUp",
	/*  868 */ "ApplyEffectInRadius",
	/*  869 */ "SetCombatCounterOn",
	/*  870 */ "AddCombatStyle",
	/*  871 */ "AddCombatStylePoints",
	/*  872 */ "SetCombatAreaActive",
	/*  873 */ "SetCombatAreaEnterable",
	/*  874 */ "SetCombatAreaExitable",
	/*  875 */ "AddCombatAreaParticipant",
	/*  876 */ "RemoveCombatAreaParticipant",
	/*  877 */ "AddCombatAreaTeam",
	/*  878 */ "RemoveCombatAreaTeam",
	/*  879 */ "SetCombatAreaInvulnerable",
	/*  880 */ "SetCombatAreaCutsceneMode",
	/*  881 */ "GetCombatAreaParticipantByIndex",
	/*  882 */ "GetCombatAreaTotalParticipants",
	/*  883 */ "GetCombatAreaActive",
	/*  884 */ "GetIsObjectInCombatArea",
	/*  885 */ "GetCombatAreaParticipantByTag",
	/*  886 */ "EffectModifyHealthBase",
	/*  887 */ "EffectModifyChiBase",
	/*  888 */ "EffectModifyFocusBase",
	/*  889 */ "EffectModifyDrunkBase",
	/*  890 */ "SetCombatAreaCombatOverride",
	/*  891 */ "SetAmuletState",
	/*  892 */ "GetIsLastParticipantInCombatArea",
	/*  893 */ "GetCombatAreaNoQuestXP",
	/*  894 */ "SetCombatAreaNoQuestXP",
	/*  895 */ "SetCombatAreaNoRewards",
	/*  896 */ "SetObjectUntargettable",
	/*  897 */ "ShowScoreBoard",
	/*  898 */ "GetScoreBoardPosition",
	/*  899 */ "WriteToScoreBoard",
	/*  900 */ "ShowChapterScreen",
	/*  901 */ "GetTaskGroupActive",
	/*  902 */ "SetCreatureHalfShadow",
	/*  903 */ "SetCreatureFullShadow",
	/*  904 */ "SetAllCreaturesHalfShadow",
	/*  905 */ "LoadAMPFile",
	/*  906 */ "ClearAMPSettings",
	/*  907 */ "GetMaxChi",
	/*  908 */ "GetMaxFocus",
	/*  909 */ "GetChi",
	/*  910 */ "GetFocus",
	/*  911 */ "GetFocusTime",
	/*  912 */ "GetFocusPackets",
	/*  913 */ "GetMaxFocusTime",
	/*  914 */ "GetMaxFocusPackets",
	/*  915 */ "GetInitialCombatCameraAngle",
	/*  916 */ "SetInitialCombatCameraAngle",
	/*  917 */ "SetLoadHintOverride",
	/*  918 */ "SplashScreens",
	/*  919 */ "SetInvulnerable",
	/*  920 */ "SetDeathHintOverride",
	/*  921 */ "RemoveFromAllCombatAreas",
	/*  922 */ "StartSpeedBlur",
	/*  923 */ "EndSpeedBlur",
	/*  924 */ "MapStyleToQuickSlot",
	/*  925 */ "GetAvoidCombatState",
	/*  926 */ "SetAvoidCombatState",
	/*  927 */ "EffectDeath",
	/*  928 */ "GetArtPlaceableTransparent",
	/*  929 */ "SetArtPlaceableTransparent",
	/*  930 */ "SetDisableCombatAI",
	/*  931 */ "SetGameSpeed",
	/*  932 */ "SetDecalTint",
	/*  933 */ "ShowFloaties",
	/*  934 */ "ClearScoreBoard",
	/*  935 */ "SetDisableCreatureCombatAI",
	/*  936 */ "UpdateScriptedProgressString",
	/*  937 */ "RemoveScriptedProgressString",
	/*  938 */ "SetRomanceIndex",
	/*  939 */ "GetCurrentCombatArea",
	/*  940 */ "PlayCombatAnimation",
	/*  941 */ "GetAttackPattern",
	/*  942 */ "SetAttackPattern",
	/*  943 */ "ShowAmuletGui",
	/*  944 */ "ShowDialogBox",
	/*  945 */ "ShowHint",
	/*  946 */ "EffectEvade",
	/*  947 */ "ShowTutorial",
	/*  948 */ "ShowRewardScreen",
	/*  949 */ "CreateCrustEffect",
	/*  950 */ "FinishCrustEffect",
	/*  951 */ "DestroyCrustEffect",
	/*  952 */ "ShowGroundPiles",
	/*  953 */ "GetE3Num",
	/*  954 */ "SetCombatStyleShoutOverride",
	/*  955 */ "ResetCamera",
	/*  956 */ "OverrideBodyMaterial",
	/*  957 */ "OverrideHeadMaterial",
	/*  958 */ "AnimateBrightening",
	/*  959 */ "GetRandomRewardXP",
	/*  960 */ "GetRandomRewardSilver",
	/*  961 */ "GetRandomRewardTreasure",
	/*  962 */ "GetRandomRewardMaxItem",
	/*  963 */ "GetRandomRewardPowerUpClass",
	/*  964 */ "GetRandomRewardPowerUpChance",
	/*  965 */ "GetRandomRewardWeight",
	/*  966 */ "GetRandomRewardRefreshOnActivate",
	/*  967 */ "GetRandomRewardWeightOverload",
	/*  968 */ "GetRandomRewardActive",
	/*  969 */ "SetRandomRewardXP",
	/*  970 */ "SetRandomRewardSilver",
	/*  971 */ "SetRandomRewardTreasure",
	/*  972 */ "SetRandomRewardMaxItem",
	/*  973 */ "SetRandomRewardPowerUpClass",
	/*  974 */ "SetRandomRewardPowerUpChance",
	/*  975 */ "SetRandomRewardWeight",
	/*  976 */ "SetRandomRewardRefreshOnActivate",
	/*  977 */ "SetRandomRewardWeightOverload",
	/*  978 */ "SetRandomRewardActive",
	/*  979 */ "FadeObjectAlpha",
	/*  980 */ "PerformStyleMove",
	/*  981 */ "CreateRandomReward",
	/*  982 */ "CreateRandomRewardTag",
	/*  983 */ "GetCombatNeutralBehavior",
	/*  984 */ "SetCombatNeutralBehavior",
	/*  985 */ "GetLastDamagerStyle",
	/*  986 */ "DisableAllCombatButtons",
	/*  987 */ "EnableAllCombatButtons",
	/*  988 */ "ChangeCombatButtonState",
	/*  989 */ "ApplyStyleAdvanceLine",
	/*  990 */ "CleanCutsceneMoveQueue",
	/*  991 */ "PerformStyleMoveNoQueue",
	/*  992 */ "ZZ_GetPlayerCreatureAlignment",
	/*  993 */ "ZZ_SetPlayerCreatureAlignment",
	/*  994 */ "SetTutorialMode",
	/*  995 */ "SetMonitoredButton",
	/*  996 */ "GetChapter",
	/*  997 */ "SetChapter",
	/*  998 */ "GetTutorialMode",
	/*  999 */ "SetNoiseTexture",
	/* 1000 */ "ToggleNoise",
	/* 1001 */ "CombatAreaSubCombatEnd",
	/* 1002 */ "OceanEnable",
	/* 1003 */ "LockCurrentStyle",
	/* 1004 */ "GetOverrideCombatStance",
	/* 1005 */ "SetOverrideCombatStance",
	/* 1006 */ "SetCreatureIllumination",
	/* 1007 */ "RestoreCreatureIllumination",
	/* 1008 */ "GetUseDefaultDeathType",
	/* 1009 */ "SetUseDefaultDeathType",
	/* 1010 */ "CombatMoveCreature",
	/* 1011 */ "SetCreatureSpeed",
	/* 1012 */ "SetMiniMapMode",
	/* 1013 */ "SetOverrideEffectDuration",
	/* 1014 */ "GetCreatureRank",
	/* 1015 */ "Get2DANumRows",
	/* 1016 */ "Get2DANumColumn",
	/* 1017 */ "SetCombatCollision",
	/* 1018 */ "LogMemory",
	/* 1019 */ "SetHenchmanPortraitType",
	/* 1020 */ "SetResistanceOverride",
	/* 1021 */ "GetResistanceOverride",
	/* 1022 */ "GetPlotGiver",
	/* 1023 */ "SetPlotGiver",
	/* 1024 */ "ToggleDistortion",
	/* 1025 */ "ShowGuiRing",
	/* 1026 */ "SetSepiaEffect",
	/* 1027 */ "SetFogOfWarExplored",
	/* 1028 */ "ResetTaskGroup",
	/* 1029 */ "AddKnownRecipe",
	/* 1030 */ "AttachObjectToObject",
	/* 1031 */ "DetachObject",
	/* 1032 */ "RemoveFogOfWarFromCurrentArea",
	/* 1033 */ "PlayAnimationAdvanced",
	/* 1034 */ "GetFileExists",
	/* 1035 */ "AllowQuickTravel",
	/* 1036 */ "GetStyleType",
	/* 1037 */ "GetAutoBalance",
	/* 1038 */ "RemoveQuest",
	/* 1039 */ "GetLastHostileAttacker",
	/* 1040 */ "SaveVisibilityGraph",
	/* 1041 */ "RestoreVisibiltyGraph",
	/* 1042 */ "PreloadRoom",
	/* 1043 */ "UnloadRoom",
	/* 1044 */ "PlaceableCastSpell",
	/* 1045 */ "SetHenchmanFollowPlayerInCombat",
	/* 1046 */ "SetChi",
	/* 1047 */ "GetSystemTime",
	/* 1048 */ "HaveSaveGames",
	/* 1049 */ "GetUnspentStylePoints",
	/* 1050 */ "GetUnspentAttributePoints",
	/* 1051 */ "SetStayTransformed",
	/* 1052 */ "SetDoNotEnterCombatArea",
	/* 1053 */ "SetCombatVFXOverride",
	/* 1054 */ "TransformHenchman",
	/* 1055 */ "DisableEvade",
	/* 1056 */ "GetIsInFocus",
	/* 1057 */ "SetIsInPOPBattle2",
	/* 1058 */ "CreateJadeMasterSave"
};

static const VariableType kFunctionSignatures[][GameInfo::kMaxSignatureSize] = {
	/*    0 */ { kTypeInt, kTypeInt },
	/*    1 */ { kTypeVoid, kTypeString, kTypeInt },
	/*    2 */ { kTypeVoid, kTypeFloat, kTypeInt, kTypeInt, kTypeInt },
	/*    3 */ { kTypeString, kTypeFloat, kTypeInt, kTypeInt },
	/*    4 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*    5 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*    6 */ { kTypeVoid, kTypeObject, kTypeScriptState },
	/*    7 */ { kTypeVoid, kTypeFloat, kTypeScriptState },
	/*    8 */ { kTypeVoid, kTypeObject, kTypeString },
	/*    9 */ { kTypeVoid },
	/*   10 */ { kTypeVoid, kTypeFloat, kTypeInt, kTypeObject, kTypeInt },
	/*   11 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/*   12 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*   13 */ { kTypeVoid, kTypeString, kTypeInt, kTypeInt },
	/*   14 */ { kTypeVoid },
	/*   15 */ { kTypeInt, kTypeObject, kTypeString },
	/*   16 */ { kTypeInt },
	/*   17 */ { kTypeInt },
	/*   18 */ { kTypeInt },
	/*   19 */ { kTypeInt },
	/*   20 */ { kTypeVoid, kTypeInt },
	/*   21 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeInt },
	/*   22 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat, kTypeInt },
	/*   23 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat, kTypeInt },
	/*   24 */ { kTypeObject, kTypeObject },
	/*   25 */ { kTypeObject },
	/*   26 */ { kTypeObject },
	/*   27 */ { kTypeVector, kTypeObject },
	/*   28 */ { kTypeFloat, kTypeObject },
	/*   29 */ { kTypeInt, kTypeObject, kTypeString, kTypeObject },
	/*   30 */ { kTypeInt, kTypeObject, kTypeInt },
	/*   31 */ { kTypeString, kTypeObject },
	/*   32 */ { kTypeString, kTypeObject },
	/*   33 */ { kTypeString, kTypeObject },
	/*   34 */ { kTypeString },
	/*   35 */ { kTypeString },
	/*   36 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*   37 */ { kTypeInt, kTypeObject, kTypeObject },
	/*   38 */ { kTypeVoid, kTypeObject },
	/*   39 */ { kTypeVoid, kTypeInt },
	/*   40 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat },
	/*   41 */ { kTypeFloat, kTypeObject },
	/*   42 */ { kTypeInt, kTypeObject },
	/*   43 */ { kTypeVoid, kTypeObject },
	/*   44 */ { kTypeVoid, kTypeObject },
	/*   45 */ { kTypeVoid, kTypeFloat },
	/*   46 */ { kTypeVoid, kTypeString },
	/*   47 */ { kTypeVoid, kTypeString },
	/*   48 */ { kTypeVoid, kTypeString, kTypeVector },
	/*   49 */ { kTypeInt, kTypeObject },
	/*   50 */ { kTypeInt, kTypeObject },
	/*   51 */ { kTypeInt, kTypeObject, kTypeInt },
	/*   52 */ { kTypeFloat, kTypeObject, kTypeInt },
	/*   53 */ { kTypeString, kTypeObject, kTypeInt },
	/*   54 */ { kTypeObject, kTypeObject, kTypeInt },
	/*   55 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*   56 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*   57 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeString },
	/*   58 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeObject },
	/*   59 */ { kTypeInt, kTypeString },
	/*   60 */ { kTypeString, kTypeString },
	/*   61 */ { kTypeString, kTypeString },
	/*   62 */ { kTypeString, kTypeString, kTypeInt },
	/*   63 */ { kTypeString, kTypeString, kTypeInt },
	/*   64 */ { kTypeString, kTypeString, kTypeString, kTypeInt },
	/*   65 */ { kTypeString, kTypeString, kTypeInt, kTypeInt },
	/*   66 */ { kTypeInt, kTypeString, kTypeString },
	/*   67 */ { kTypeFloat, kTypeFloat },
	/*   68 */ { kTypeFloat, kTypeFloat },
	/*   69 */ { kTypeFloat, kTypeFloat },
	/*   70 */ { kTypeFloat, kTypeFloat },
	/*   71 */ { kTypeFloat, kTypeFloat },
	/*   72 */ { kTypeFloat, kTypeFloat },
	/*   73 */ { kTypeFloat, kTypeFloat },
	/*   74 */ { kTypeFloat, kTypeFloat },
	/*   75 */ { kTypeFloat, kTypeFloat, kTypeFloat },
	/*   76 */ { kTypeFloat, kTypeFloat },
	/*   77 */ { kTypeInt, kTypeInt },
	/*   78 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*   79 */ { kTypeVoid, kTypeString },
	/*   80 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*   81 */ { kTypeInt },
	/*   82 */ { kTypeEngineType0, kTypeInt },
	/*   83 */ { kTypeInt },
	/*   84 */ { kTypeInt, kTypeObject, kTypeString },
	/*   85 */ { kTypeEngineType0, kTypeObject },
	/*   86 */ { kTypeEngineType0, kTypeObject },
	/*   87 */ { kTypeVoid, kTypeObject, kTypeEngineType0, kTypeInt, kTypeString },
	/*   88 */ { kTypeInt, kTypeEngineType0 },
	/*   89 */ { kTypeInt, kTypeEngineType0 },
	/*   90 */ { kTypeInt, kTypeEngineType0 },
	/*   91 */ { kTypeObject, kTypeEngineType0 },
	/*   92 */ { kTypeString, kTypeInt },
	/*   93 */ { kTypeVoid, kTypeObject },
	/*   94 */ { kTypeVoid, kTypeObject },
	/*   95 */ { kTypeInt, kTypeInt },
	/*   96 */ { kTypeInt, kTypeInt },
	/*   97 */ { kTypeInt, kTypeInt },
	/*   98 */ { kTypeInt, kTypeInt },
	/*   99 */ { kTypeInt, kTypeInt },
	/*  100 */ { kTypeInt, kTypeInt },
	/*  101 */ { kTypeInt, kTypeInt },
	/*  102 */ { kTypeInt, kTypeInt },
	/*  103 */ { kTypeInt, kTypeInt },
	/*  104 */ { kTypeFloat, kTypeVector },
	/*  105 */ { kTypeVoid, kTypeString },
	/*  106 */ { kTypeInt, kTypeObject },
	/*  107 */ { kTypeInt },
	/*  108 */ { kTypeInt, kTypeFloat, kTypeInt },
	/*  109 */ { kTypeInt, kTypeObject },
	/*  110 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  111 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  112 */ { kTypeVoid, kTypeObject },
	/*  113 */ { kTypeInt, kTypeObject },
	/*  114 */ { kTypeObject },
	/*  115 */ { kTypeInt },
	/*  116 */ { kTypeObject },
	/*  117 */ { kTypeString, kTypeObject },
	/*  118 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  119 */ { kTypeInt, kTypeObject },
	/*  120 */ { kTypeInt },
	/*  121 */ { kTypeFloat, kTypeInt },
	/*  122 */ { kTypeFloat, kTypeInt },
	/*  123 */ { kTypeFloat, kTypeInt },
	/*  124 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  125 */ { kTypeInt, kTypeObject },
	/*  126 */ { kTypeString, kTypeObject },
	/*  127 */ { kTypeInt, kTypeObject },
	/*  128 */ { kTypeObject, kTypeEngineType2, kTypeInt, kTypeFloat, kTypeInt, kTypeInt, kTypeVector },
	/*  129 */ { kTypeObject, kTypeEngineType2, kTypeInt, kTypeFloat, kTypeInt, kTypeInt, kTypeVector },
	/*  130 */ { kTypeVoid, kTypeInt },
	/*  131 */ { kTypeVoid, kTypeObject, kTypeEngineType1 },
	/*  132 */ { kTypeEngineType1, kTypeInt },
	/*  133 */ { kTypeVoid },
	/*  134 */ { kTypeString },
	/*  135 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  136 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  137 */ { kTypeVector, kTypeVector },
	/*  138 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  139 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  140 */ { kTypeInt, kTypeObject },
	/*  141 */ { kTypeVoid, kTypeVector, kTypeInt },
	/*  142 */ { kTypeVector, kTypeFloat, kTypeFloat, kTypeFloat },
	/*  143 */ { kTypeVoid, kTypeVector, kTypeInt, kTypeObject, kTypeInt },
	/*  144 */ { kTypeVector, kTypeFloat },
	/*  145 */ { kTypeFloat, kTypeVector },
	/*  146 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  147 */ { kTypeVoid, kTypeInt, kTypeString, kTypeString },
	/*  148 */ { kTypeVoid, kTypeObject },
	/*  149 */ { kTypeVoid, kTypeInt, kTypeEngineType2 },
	/*  150 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  151 */ { kTypeFloat, kTypeObject, kTypeObject },
	/*  152 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeEngineType2 },
	/*  153 */ { kTypeEngineType2, kTypeObject, kTypeInt },
	/*  154 */ { kTypeInt, kTypeEngineType2, kTypeObject },
	/*  155 */ { kTypeInt, kTypeInt },
	/*  156 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  157 */ { kTypeInt, kTypeInt },
	/*  158 */ { kTypeVoid, kTypeFloat },
	/*  159 */ { kTypeInt, kTypeObject },
	/*  160 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  161 */ { kTypeInt },
	/*  162 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  163 */ { kTypeInt, kTypeObject },
	/*  164 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  165 */ { kTypeEngineType0, kTypeInt },
	/*  166 */ { kTypeVoid, kTypeString, kTypeString },
	/*  167 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/*  168 */ { kTypeString, kTypeObject },
	/*  169 */ { kTypeVoid, kTypeString },
	/*  170 */ { kTypeInt, kTypeEngineType0 },
	/*  171 */ { kTypeInt },
	/*  172 */ { kTypeVoid, kTypeString, kTypeString, kTypeString },
	/*  173 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  174 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  175 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  176 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  177 */ { kTypeVoid, kTypeString },
	/*  178 */ { kTypeVoid, kTypeString, kTypeVector },
	/*  179 */ { kTypeVoid, kTypeString, kTypeVector },
	/*  180 */ { kTypeVoid, kTypeString, kTypeString, kTypeInt },
	/*  181 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat, kTypeFloat, kTypeInt },
	/*  182 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  183 */ { kTypeVoid, kTypeVector, kTypeFloat, kTypeInt },
	/*  184 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  185 */ { kTypeVoid, kTypeVector, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  186 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  187 */ { kTypeVoid, kTypeVector, kTypeFloat },
	/*  188 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/*  189 */ { kTypeVoid, kTypeString, kTypeString },
	/*  190 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  191 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  192 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  193 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  194 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  195 */ { kTypeInt },
	/*  196 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  197 */ { kTypeObject, kTypeString },
	/*  198 */ { kTypeObject, kTypeObject },
	/*  199 */ { kTypeEngineType0, kTypeEngineType0, kTypeEngineType0 },
	/*  200 */ { kTypeObject, kTypeString, kTypeInt },
	/*  201 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  202 */ { kTypeVoid, kTypeFloat, kTypeInt },
	/*  203 */ { kTypeVoid, kTypeInt },
	/*  204 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  205 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  206 */ { kTypeVoid, kTypeInt },
	/*  207 */ { kTypeString, kTypeObject, kTypeInt },
	/*  208 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  209 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  210 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  211 */ { kTypeVoid },
	/*  212 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  213 */ { kTypeEngineType2, kTypeObject },
	/*  214 */ { kTypeVoid, kTypeEngineType2, kTypeInt },
	/*  215 */ { kTypeEngineType2, kTypeObject, kTypeVector, kTypeFloat },
	/*  216 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeInt },
	/*  217 */ { kTypeInt, kTypeObject },
	/*  218 */ { kTypeFloat, kTypeFloat },
	/*  219 */ { kTypeFloat, kTypeFloat },
	/*  220 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeEngineType0, kTypeFloat },
	/*  221 */ { kTypeVoid },
	/*  222 */ { kTypeEngineType2 },
	/*  223 */ { kTypeVector, kTypeEngineType2 },
	/*  224 */ { kTypeObject, kTypeEngineType2 },
	/*  225 */ { kTypeFloat, kTypeEngineType2 },
	/*  226 */ { kTypeVoid, kTypeInt, kTypeString, kTypeString, kTypeString },
	/*  227 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  228 */ { kTypeObject, kTypeEngineType2, kTypeInt, kTypeInt },
	/*  229 */ { kTypeVoid, kTypeInt },
	/*  230 */ { kTypeFloat, kTypeInt },
	/*  231 */ { kTypeInt, kTypeFloat },
	/*  232 */ { kTypeInt, kTypeString },
	/*  233 */ { kTypeFloat, kTypeString },
	/*  234 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  235 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  236 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  237 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  238 */ { kTypeVoid },
	/*  239 */ { kTypeString, kTypeInt },
	/*  240 */ { kTypeVoid, kTypeInt },
	/*  241 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/*  242 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  243 */ { kTypeObject, kTypeInt, kTypeString, kTypeEngineType2 },
	/*  244 */ { kTypeEngineType1, kTypeObject, kTypeInt, kTypeInt },
	/*  245 */ { kTypeVoid, kTypeVector, kTypeFloat, kTypeInt },
	/*  246 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeInt, kTypeInt },
	/*  247 */ { kTypeInt },
	/*  248 */ { kTypeInt },
	/*  249 */ { kTypeString },
	/*  250 */ { kTypeEngineType0, kTypeInt },
	/*  251 */ { kTypeInt },
	/*  252 */ { kTypeObject },
	/*  253 */ { kTypeVoid, kTypeString, kTypeString, kTypeFloat, kTypeInt, kTypeInt },
	/*  254 */ { kTypeObject },
	/*  255 */ { kTypeInt, kTypeObject, kTypeString },
	/*  256 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeInt, kTypeInt, kTypeInt, kTypeFloat },
	/*  257 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt, kTypeFloat, kTypeInt, kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  258 */ { kTypeVoid, kTypeObject, kTypeVector },
	/*  259 */ { kTypeVoid, kTypeObject, kTypeVector },
	/*  260 */ { kTypeObject, kTypeObject },
	/*  261 */ { kTypeVoid },
	/*  262 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  263 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  264 */ { kTypeObject, kTypeObject },
	/*  265 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  266 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  267 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  268 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  269 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  270 */ { kTypeEngineType0 },
	/*  271 */ { kTypeEngineType0 },
	/*  272 */ { kTypeString, kTypeObject },
	/*  273 */ { kTypeEngineType0, kTypeInt },
	/*  274 */ { kTypeInt, kTypeObject, kTypeInt, kTypeObject },
	/*  275 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  276 */ { kTypeInt, kTypeObject },
	/*  277 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  278 */ { kTypeInt, kTypeObject },
	/*  279 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  280 */ { kTypeInt, kTypeObject },
	/*  281 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  282 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  283 */ { kTypeInt, kTypeObject },
	/*  284 */ { kTypeVoid, kTypeInt, kTypeString },
	/*  285 */ { kTypeInt, kTypeObject },
	/*  286 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  287 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  288 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  289 */ { kTypeInt, kTypeObject },
	/*  290 */ { kTypeVoid, kTypeInt },
	/*  291 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeObject },
	/*  292 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  293 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  294 */ { kTypeVoid, kTypeScriptState },
	/*  295 */ { kTypeEngineType1 },
	/*  296 */ { kTypeString },
	/*  297 */ { kTypeVoid, kTypeInt },
	/*  298 */ { kTypeFloat, kTypeEngineType2, kTypeEngineType2 },
	/*  299 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  300 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat },
	/*  301 */ { kTypeInt, kTypeInt, kTypeInt, kTypeString },
	/*  302 */ { kTypeFloat, kTypeInt, kTypeInt, kTypeString },
	/*  303 */ { kTypeString, kTypeInt, kTypeInt, kTypeString },
	/*  304 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  305 */ { kTypeInt, kTypeEngineType0 },
	/*  306 */ { kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  307 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/*  308 */ { kTypeInt, kTypeInt, kTypeInt },
	/*  309 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/*  310 */ { kTypeVoid, kTypeInt },
	/*  311 */ { kTypeVoid, kTypeInt },
	/*  312 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  313 */ { kTypeVoid, kTypeEngineType2, kTypeInt },
	/*  314 */ { kTypeEngineType0, kTypeInt },
	/*  315 */ { kTypeInt, kTypeInt },
	/*  316 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  317 */ { kTypeInt, kTypeInt },
	/*  318 */ { kTypeInt, kTypeObject },
	/*  319 */ { kTypeVoid },
	/*  320 */ { kTypeInt },
	/*  321 */ { kTypeVoid, kTypeInt },
	/*  322 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  323 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeFloat, kTypeInt },
	/*  324 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  325 */ { kTypeInt, kTypeObject },
	/*  326 */ { kTypeInt },
	/*  327 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  328 */ { kTypeVoid },
	/*  329 */ { kTypeVoid, kTypeObject },
	/*  330 */ { kTypeObject },
	/*  331 */ { kTypeInt },
	/*  332 */ { kTypeVoid, kTypeInt },
	/*  333 */ { kTypeVoid, kTypeString },
	/*  334 */ { kTypeVoid, kTypeString },
	/*  335 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  336 */ { kTypeObject },
	/*  337 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  338 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  339 */ { kTypeInt, kTypeObject },
	/*  340 */ { kTypeInt },
	/*  341 */ { kTypeInt, kTypeObject },
	/*  342 */ { kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeFloat, kTypeInt, kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  343 */ { kTypeInt, kTypeObject },
	/*  344 */ { kTypeInt, kTypeInt },
	/*  345 */ { kTypeInt },
	/*  346 */ { kTypeObject },
	/*  347 */ { kTypeObject },
	/*  348 */ { kTypeVoid, kTypeInt },
	/*  349 */ { kTypeObject },
	/*  350 */ { kTypeObject },
	/*  351 */ { kTypeFloat, kTypeObject },
	/*  352 */ { kTypeInt },
	/*  353 */ { kTypeInt, kTypeObject },
	/*  354 */ { kTypeObject },
	/*  355 */ { kTypeObject },
	/*  356 */ { kTypeVector },
	/*  357 */ { kTypeVector },
	/*  358 */ { kTypeInt, kTypeObject },
	/*  359 */ { kTypeVector, kTypeObject },
	/*  360 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeFloat, kTypeInt },
	/*  361 */ { kTypeObject },
	/*  362 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/*  363 */ { kTypeVoid, kTypeInt },
	/*  364 */ { kTypeObject, kTypeInt, kTypeObject },
	/*  365 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  366 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  367 */ { kTypeVoid, kTypeString, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/*  368 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt, kTypeInt },
	/*  369 */ { kTypeString, kTypeObject },
	/*  370 */ { kTypeString, kTypeObject },
	/*  371 */ { kTypeString, kTypeObject },
	/*  372 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  373 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  374 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  375 */ { kTypeObject },
	/*  376 */ { kTypeObject },
	/*  377 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  378 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  379 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  380 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  381 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  382 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeFloat, kTypeInt },
	/*  383 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat, kTypeFloat, kTypeInt },
	/*  384 */ { kTypeInt, kTypeString },
	/*  385 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  386 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  387 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  388 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  389 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  390 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeFloat },
	/*  391 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeFloat },
	/*  392 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeFloat },
	/*  393 */ { kTypeVoid, kTypeInt },
	/*  394 */ { kTypeVoid, kTypeInt },
	/*  395 */ { kTypeInt },
	/*  396 */ { kTypeString, kTypeInt },
	/*  397 */ { kTypeInt, kTypeObject },
	/*  398 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  399 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  400 */ { kTypeVoid, kTypeObject },
	/*  401 */ { kTypeInt, kTypeObject },
	/*  402 */ { kTypeVoid },
	/*  403 */ { kTypeVoid },
	/*  404 */ { kTypeVoid },
	/*  405 */ { kTypeInt },
	/*  406 */ { kTypeInt },
	/*  407 */ { kTypeInt },
	/*  408 */ { kTypeInt },
	/*  409 */ { kTypeInt, kTypeObject },
	/*  410 */ { kTypeObject },
	/*  411 */ { kTypeEngineType2 },
	/*  412 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  413 */ { kTypeVoid, kTypeObject },
	/*  414 */ { kTypeVoid, kTypeObject },
	/*  415 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  416 */ { kTypeVoid, kTypeObject, kTypeVector },
	/*  417 */ { kTypeVoid, kTypeString, kTypeInt },
	/*  418 */ { kTypeInt, kTypeObject },
	/*  419 */ { kTypeInt },
	/*  420 */ { kTypeVoid },
	/*  421 */ { kTypeVoid },
	/*  422 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  423 */ { kTypeInt },
	/*  424 */ { kTypeEngineType1, kTypeObject, kTypeEngineType2, kTypeObject },
	/*  425 */ { kTypeVoid, kTypeInt },
	/*  426 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  427 */ { kTypeVoid, kTypeInt },
	/*  428 */ { kTypeVoid, kTypeInt },
	/*  429 */ { kTypeInt },
	/*  430 */ { kTypeVoid, kTypeInt },
	/*  431 */ { kTypeVoid, kTypeString },
	/*  432 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  433 */ { kTypeVoid },
	/*  434 */ { kTypeVoid },
	/*  435 */ { kTypeVoid, kTypeInt },
	/*  436 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  437 */ { kTypeObject },
	/*  438 */ { kTypeObject },
	/*  439 */ { kTypeObject },
	/*  440 */ { kTypeObject },
	/*  441 */ { kTypeEngineType2 },
	/*  442 */ { kTypeObject },
	/*  443 */ { kTypeInt, kTypeObject },
	/*  444 */ { kTypeVoid, kTypeInt },
	/*  445 */ { kTypeInt, kTypeObject },
	/*  446 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  447 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  448 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  449 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  450 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  451 */ { kTypeEngineType0, kTypeInt },
	/*  452 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  453 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  454 */ { kTypeEngineType0, kTypeInt },
	/*  455 */ { kTypeInt, kTypeObject },
	/*  456 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  457 */ { kTypeEngineType0, kTypeInt },
	/*  458 */ { kTypeEngineType0, kTypeInt },
	/*  459 */ { kTypeEngineType0 },
	/*  460 */ { kTypeEngineType0, kTypeInt },
	/*  461 */ { kTypeEngineType0 },
	/*  462 */ { kTypeEngineType0 },
	/*  463 */ { kTypeEngineType0, kTypeInt },
	/*  464 */ { kTypeEngineType0 },
	/*  465 */ { kTypeEngineType0 },
	/*  466 */ { kTypeEngineType0 },
	/*  467 */ { kTypeEngineType0 },
	/*  468 */ { kTypeEngineType0 },
	/*  469 */ { kTypeInt },
	/*  470 */ { kTypeInt },
	/*  471 */ { kTypeInt },
	/*  472 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  473 */ { kTypeEngineType0, kTypeInt },
	/*  474 */ { kTypeVoid },
	/*  475 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  476 */ { kTypeVoid },
	/*  477 */ { kTypeEngineType0, kTypeInt },
	/*  478 */ { kTypeInt },
	/*  479 */ { kTypeInt, kTypeObject },
	/*  480 */ { kTypeEngineType0 },
	/*  481 */ { kTypeEngineType0 },
	/*  482 */ { kTypeEngineType0 },
	/*  483 */ { kTypeVoid, kTypeObject },
	/*  484 */ { kTypeVoid, kTypeObject },
	/*  485 */ { kTypeEngineType0, kTypeInt },
	/*  486 */ { kTypeObject, kTypeObject },
	/*  487 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  488 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  489 */ { kTypeVoid },
	/*  490 */ { kTypeVoid },
	/*  491 */ { kTypeInt, kTypeObject },
	/*  492 */ { kTypeInt, kTypeObject },
	/*  493 */ { kTypeInt, kTypeObject },
	/*  494 */ { kTypeFloat, kTypeObject },
	/*  495 */ { kTypeVoid },
	/*  496 */ { kTypeInt, kTypeObject },
	/*  497 */ { kTypeVoid, kTypeString, kTypeString },
	/*  498 */ { kTypeInt },
	/*  499 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  500 */ { kTypeInt, kTypeObject },
	/*  501 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  502 */ { kTypeInt, kTypeObject },
	/*  503 */ { kTypeString, kTypeObject },
	/*  504 */ { kTypeVoid, kTypeInt },
	/*  505 */ { kTypeVoid },
	/*  506 */ { kTypeVoid },
	/*  507 */ { kTypeVoid },
	/*  508 */ { kTypeVoid },
	/*  509 */ { kTypeVoid, kTypeString, kTypeString },
	/*  510 */ { kTypeVoid },
	/*  511 */ { kTypeInt, kTypeObject },
	/*  512 */ { kTypeVoid, kTypeString, kTypeString, kTypeInt },
	/*  513 */ { kTypeInt, kTypeInt },
	/*  514 */ { kTypeVoid },
	/*  515 */ { kTypeVoid },
	/*  516 */ { kTypeVoid },
	/*  517 */ { kTypeVoid },
	/*  518 */ { kTypeVoid },
	/*  519 */ { kTypeVoid },
	/*  520 */ { kTypeVoid },
	/*  521 */ { kTypeVoid },
	/*  522 */ { kTypeInt, kTypeObject },
	/*  523 */ { kTypeVoid },
	/*  524 */ { kTypeVoid },
	/*  525 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt },
	/*  526 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt },
	/*  527 */ { kTypeInt, kTypeObject },
	/*  528 */ { kTypeInt, kTypeObject },
	/*  529 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  530 */ { kTypeInt, kTypeObject },
	/*  531 */ { kTypeInt, kTypeObject },
	/*  532 */ { kTypeInt, kTypeObject },
	/*  533 */ { kTypeObject, kTypeObject },
	/*  534 */ { kTypeString, kTypeObject },
	/*  535 */ { kTypeInt, kTypeObject },
	/*  536 */ { kTypeInt, kTypeObject },
	/*  537 */ { kTypeInt, kTypeObject },
	/*  538 */ { kTypeInt, kTypeObject },
	/*  539 */ { kTypeInt, kTypeObject },
	/*  540 */ { kTypeInt, kTypeObject },
	/*  541 */ { kTypeInt, kTypeObject },
	/*  542 */ { kTypeObject },
	/*  543 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  544 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  545 */ { kTypeInt, kTypeObject },
	/*  546 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  547 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  548 */ { kTypeObject },
	/*  549 */ { kTypeObject },
	/*  550 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  551 */ { kTypeInt, kTypeObject },
	/*  552 */ { kTypeVoid },
	/*  553 */ { kTypeVoid },
	/*  554 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeString },
	/*  555 */ { kTypeVoid, kTypeObject },
	/*  556 */ { kTypeObject, kTypeObject },
	/*  557 */ { kTypeVoid },
	/*  558 */ { kTypeInt, kTypeObject },
	/*  559 */ { kTypeInt, kTypeObject },
	/*  560 */ { kTypeVoid, kTypeString },
	/*  561 */ { kTypeString },
	/*  562 */ { kTypeObject, kTypeObject },
	/*  563 */ { kTypeVoid },
	/*  564 */ { kTypeVoid, kTypeString },
	/*  565 */ { kTypeInt },
	/*  566 */ { kTypeInt, kTypeObject },
	/*  567 */ { kTypeVoid, kTypeInt },
	/*  568 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  569 */ { kTypeVoid },
	/*  570 */ { kTypeInt, kTypeObject },
	/*  571 */ { kTypeFloat, kTypeInt },
	/*  572 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  573 */ { kTypeVoid, kTypeObject },
	/*  574 */ { kTypeObject, kTypeString },
	/*  575 */ { kTypeVoid, kTypeString, kTypeObject },
	/*  576 */ { kTypeString, kTypeString },
	/*  577 */ { kTypeVoid, kTypeString, kTypeString },
	/*  578 */ { kTypeFloat, kTypeString },
	/*  579 */ { kTypeVoid, kTypeString, kTypeFloat },
	/*  580 */ { kTypeInt, kTypeString },
	/*  581 */ { kTypeVoid, kTypeString, kTypeInt },
	/*  582 */ { kTypeVoid, kTypeString, kTypeInt, kTypeInt, kTypeFloat },
	/*  583 */ { kTypeString },
	/*  584 */ { kTypeString },
	/*  585 */ { kTypeObject, kTypeString },
	/*  586 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt, kTypeInt, kTypeInt },
	/*  587 */ { kTypeInt },
	/*  588 */ { kTypeInt },
	/*  589 */ { kTypeObject },
	/*  590 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/*  591 */ { kTypeVoid },
	/*  592 */ { kTypeVoid },
	/*  593 */ { kTypeObject },
	/*  594 */ { kTypeObject },
	/*  595 */ { kTypeInt },
	/*  596 */ { kTypeInt },
	/*  597 */ { kTypeString, kTypeObject },
	/*  598 */ { kTypeVoid },
	/*  599 */ { kTypeInt, kTypeObject },
	/*  600 */ { kTypeInt, kTypeObject },
	/*  601 */ { kTypeInt, kTypeObject },
	/*  602 */ { kTypeInt, kTypeObject },
	/*  603 */ { kTypeInt, kTypeObject },
	/*  604 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  605 */ { kTypeVoid },
	/*  606 */ { kTypeInt },
	/*  607 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  608 */ { kTypeFloat },
	/*  609 */ { kTypeFloat },
	/*  610 */ { kTypeVoid, kTypeFloat, kTypeFloat },
	/*  611 */ { kTypeObject },
	/*  612 */ { kTypeInt },
	/*  613 */ { kTypeObject, kTypeInt },
	/*  614 */ { kTypeInt },
	/*  615 */ { kTypeObject, kTypeInt },
	/*  616 */ { kTypeInt, kTypeObject },
	/*  617 */ { kTypeInt, kTypeObject },
	/*  618 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  619 */ { kTypeFloat, kTypeObject },
	/*  620 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/*  621 */ { kTypeInt, kTypeObject },
	/*  622 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  623 */ { kTypeVector, kTypeObject },
	/*  624 */ { kTypeInt, kTypeObject },
	/*  625 */ { kTypeString, kTypeObject, kTypeInt },
	/*  626 */ { kTypeString, kTypeObject, kTypeInt },
	/*  627 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  628 */ { kTypeFloat, kTypeObject, kTypeInt },
	/*  629 */ { kTypeFloat, kTypeObject, kTypeInt },
	/*  630 */ { kTypeFloat, kTypeObject, kTypeInt },
	/*  631 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  632 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeString },
	/*  633 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeString },
	/*  634 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  635 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  636 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  637 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  638 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  639 */ { kTypeString },
	/*  640 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  641 */ { kTypeVector },
	/*  642 */ { kTypeFloat },
	/*  643 */ { kTypeFloat },
	/*  644 */ { kTypeFloat },
	/*  645 */ { kTypeFloat },
	/*  646 */ { kTypeVector },
	/*  647 */ { kTypeVoid, kTypeVector },
	/*  648 */ { kTypeVoid, kTypeFloat },
	/*  649 */ { kTypeVoid, kTypeFloat },
	/*  650 */ { kTypeVoid, kTypeFloat },
	/*  651 */ { kTypeVoid, kTypeFloat },
	/*  652 */ { kTypeVoid, kTypeVector },
	/*  653 */ { kTypeVector },
	/*  654 */ { kTypeVoid, kTypeVector },
	/*  655 */ { kTypeVector },
	/*  656 */ { kTypeVoid, kTypeVector },
	/*  657 */ { kTypeFloat, kTypeObject, kTypeInt },
	/*  658 */ { kTypeFloat, kTypeObject, kTypeInt },
	/*  659 */ { kTypeFloat, kTypeObject, kTypeInt },
	/*  660 */ { kTypeFloat, kTypeObject, kTypeInt },
	/*  661 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  662 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  663 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  664 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  665 */ { kTypeInt, kTypeObject },
	/*  666 */ { kTypeVoid, kTypeObject },
	/*  667 */ { kTypeFloat },
	/*  668 */ { kTypeVoid, kTypeFloat },
	/*  669 */ { kTypeVoid, kTypeInt, kTypeString, kTypeString },
	/*  670 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  671 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  672 */ { kTypeInt, kTypeObject },
	/*  673 */ { kTypeVoid, kTypeInt },
	/*  674 */ { kTypeVoid, kTypeInt },
	/*  675 */ { kTypeEngineType0, kTypeInt },
	/*  676 */ { kTypeEngineType0 },
	/*  677 */ { kTypeVoid, kTypeInt, kTypeEngineType2 },
	/*  678 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/*  679 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  680 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  681 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  682 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  683 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  684 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  685 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  686 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  687 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  688 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  689 */ { kTypeFloat, kTypeObject },
	/*  690 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/*  691 */ { kTypeInt, kTypeObject },
	/*  692 */ { kTypeEngineType2, kTypeString },
	/*  693 */ { kTypeVoid, kTypeString, kTypeEngineType2 },
	/*  694 */ { kTypeInt, kTypeInt, kTypeObject },
	/*  695 */ { kTypeInt, kTypeInt },
	/*  696 */ { kTypeInt, kTypeInt },
	/*  697 */ { kTypeInt, kTypeInt, kTypeString },
	/*  698 */ { kTypeObject, kTypeInt, kTypeEngineType2 },
	/*  699 */ { kTypeInt, kTypeInt },
	/*  700 */ { kTypeVoid, kTypeInt },
	/*  701 */ { kTypeInt },
	/*  702 */ { kTypeEngineType0, kTypeObject, kTypeObject, kTypeObject },
	/*  703 */ { kTypeEngineType0 },
	/*  704 */ { kTypeVoid, kTypeInt },
	/*  705 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  706 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  707 */ { kTypeInt, kTypeInt },
	/*  708 */ { kTypeInt, kTypeObject },
	/*  709 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  710 */ { kTypeVoid },
	/*  711 */ { kTypeString },
	/*  712 */ { kTypeInt, kTypeObject },
	/*  713 */ { kTypeInt, kTypeObject },
	/*  714 */ { kTypeVoid, kTypeString, kTypeInt },
	/*  715 */ { kTypeInt, kTypeObject },
	/*  716 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  717 */ { kTypeVector },
	/*  718 */ { kTypeVoid, kTypeVector },
	/*  719 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat },
	/*  720 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat },
	/*  721 */ { kTypeObject, kTypeObject },
	/*  722 */ { kTypeInt, kTypeObject },
	/*  723 */ { kTypeInt, kTypeObject },
	/*  724 */ { kTypeInt, kTypeObject },
	/*  725 */ { kTypeInt, kTypeObject },
	/*  726 */ { kTypeInt, kTypeObject },
	/*  727 */ { kTypeObject, kTypeObject },
	/*  728 */ { kTypeObject, kTypeObject },
	/*  729 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  730 */ { kTypeVoid },
	/*  731 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  732 */ { kTypeInt, kTypeObject },
	/*  733 */ { kTypeVoid, kTypeString, kTypeString },
	/*  734 */ { kTypeVoid, kTypeInt },
	/*  735 */ { kTypeInt, kTypeEngineType3 },
	/*  736 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat, kTypeVector },
	/*  737 */ { kTypeVoid },
	/*  738 */ { kTypeVoid },
	/*  739 */ { kTypeVoid, kTypeString, kTypeString },
	/*  740 */ { kTypeVoid, kTypeString },
	/*  741 */ { kTypeVoid, kTypeString },
	/*  742 */ { kTypeVoid, kTypeString, kTypeVector },
	/*  743 */ { kTypeInt, kTypeString, kTypeInt },
	/*  744 */ { kTypeInt, kTypeString, kTypeInt, kTypeInt },
	/*  745 */ { kTypeInt, kTypeString, kTypeInt },
	/*  746 */ { kTypeEngineType0, kTypeInt },
	/*  747 */ { kTypeEngineType0, kTypeInt },
	/*  748 */ { kTypeEngineType0, kTypeInt },
	/*  749 */ { kTypeVoid, kTypeString, kTypeInt, kTypeInt },
	/*  750 */ { kTypeVoid },
	/*  751 */ { kTypeVoid, kTypeInt },
	/*  752 */ { kTypeVoid, kTypeString },
	/*  753 */ { kTypeInt, kTypeString },
	/*  754 */ { kTypeVoid, kTypeString, kTypeInt },
	/*  755 */ { kTypeInt, kTypeObject },
	/*  756 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  757 */ { kTypeVoid, kTypeString },
	/*  758 */ { kTypeObject },
	/*  759 */ { kTypeVoid, kTypeInt },
	/*  760 */ { kTypeInt },
	/*  761 */ { kTypeVoid, kTypeInt },
	/*  762 */ { kTypeVoid, kTypeInt },
	/*  763 */ { kTypeVoid, kTypeInt, kTypeString },
	/*  764 */ { kTypeInt },
	/*  765 */ { kTypeInt },
	/*  766 */ { kTypeInt, kTypeObject, kTypeVector },
	/*  767 */ { kTypeInt, kTypeObject },
	/*  768 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  769 */ { kTypeInt, kTypeObject },
	/*  770 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  771 */ { kTypeEngineType0, kTypeInt },
	/*  772 */ { kTypeEngineType0, kTypeInt },
	/*  773 */ { kTypeEngineType0, kTypeInt },
	/*  774 */ { kTypeEngineType0, kTypeInt },
	/*  775 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  776 */ { kTypeInt, kTypeString },
	/*  777 */ { kTypeVoid, kTypeString, kTypeInt },
	/*  778 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  779 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  780 */ { kTypeEngineType0, kTypeInt },
	/*  781 */ { kTypeEngineType0 },
	/*  782 */ { kTypeEngineType0 },
	/*  783 */ { kTypeVoid, kTypeObject },
	/*  784 */ { kTypeInt, kTypeObject },
	/*  785 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  786 */ { kTypeVoid, kTypeString, kTypeInt },
	/*  787 */ { kTypeInt, kTypeString },
	/*  788 */ { kTypeVoid, kTypeString },
	/*  789 */ { kTypeInt, kTypeString },
	/*  790 */ { kTypeInt, kTypeString },
	/*  791 */ { kTypeInt, kTypeObject },
	/*  792 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  793 */ { kTypeFloat, kTypeObject },
	/*  794 */ { kTypeFloat, kTypeObject },
	/*  795 */ { kTypeFloat, kTypeObject },
	/*  796 */ { kTypeFloat, kTypeObject },
	/*  797 */ { kTypeFloat, kTypeObject },
	/*  798 */ { kTypeFloat, kTypeObject },
	/*  799 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat },
	/*  800 */ { kTypeFloat },
	/*  801 */ { kTypeVector },
	/*  802 */ { kTypeFloat },
	/*  803 */ { kTypeFloat },
	/*  804 */ { kTypeFloat },
	/*  805 */ { kTypeFloat },
	/*  806 */ { kTypeFloat },
	/*  807 */ { kTypeFloat },
	/*  808 */ { kTypeVector },
	/*  809 */ { kTypeFloat, kTypeInt },
	/*  810 */ { kTypeFloat, kTypeInt },
	/*  811 */ { kTypeFloat, kTypeInt },
	/*  812 */ { kTypeFloat, kTypeInt },
	/*  813 */ { kTypeFloat, kTypeInt },
	/*  814 */ { kTypeVector },
	/*  815 */ { kTypeFloat },
	/*  816 */ { kTypeFloat },
	/*  817 */ { kTypeVector },
	/*  818 */ { kTypeVector },
	/*  819 */ { kTypeVoid, kTypeFloat },
	/*  820 */ { kTypeVoid, kTypeVector },
	/*  821 */ { kTypeVoid, kTypeFloat },
	/*  822 */ { kTypeVoid, kTypeFloat },
	/*  823 */ { kTypeVoid, kTypeFloat },
	/*  824 */ { kTypeVoid, kTypeFloat },
	/*  825 */ { kTypeVoid, kTypeFloat },
	/*  826 */ { kTypeVoid, kTypeFloat },
	/*  827 */ { kTypeVoid, kTypeFloat, kTypeFloat },
	/*  828 */ { kTypeVoid, kTypeInt, kTypeFloat },
	/*  829 */ { kTypeVoid, kTypeInt, kTypeFloat },
	/*  830 */ { kTypeVoid, kTypeInt, kTypeFloat },
	/*  831 */ { kTypeVoid, kTypeInt, kTypeFloat },
	/*  832 */ { kTypeVoid, kTypeInt, kTypeFloat },
	/*  833 */ { kTypeVoid, kTypeVector },
	/*  834 */ { kTypeVoid, kTypeFloat },
	/*  835 */ { kTypeVoid, kTypeVector, kTypeFloat },
	/*  836 */ { kTypeVoid, kTypeVector },
	/*  837 */ { kTypeVoid, kTypeFloat, kTypeFloat },
	/*  838 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt },
	/*  839 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/*  840 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt },
	/*  841 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt },
	/*  842 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt },
	/*  843 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt },
	/*  844 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt },
	/*  845 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeInt },
	/*  846 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/*  847 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/*  848 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/*  849 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/*  850 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/*  851 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/*  852 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/*  853 */ { kTypeVoid, kTypeFloat, kTypeFloat },
	/*  854 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/*  855 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/*  856 */ { kTypeVoid, kTypeFloat, kTypeInt },
	/*  857 */ { kTypeEngineType0, kTypeInt, kTypeString, kTypeInt },
	/*  858 */ { kTypeEngineType0, kTypeString, kTypeString },
	/*  859 */ { kTypeString, kTypeInt, kTypeInt, kTypeInt },
	/*  860 */ { kTypeFloat, kTypeInt, kTypeInt, kTypeInt },
	/*  861 */ { kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  862 */ { kTypeInt, kTypeObject },
	/*  863 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  864 */ { kTypeInt, kTypeObject },
	/*  865 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  866 */ { kTypeInt, kTypeObject },
	/*  867 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  868 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeEngineType0, kTypeFloat, kTypeFloat, kTypeInt },
	/*  869 */ { kTypeVoid, kTypeInt },
	/*  870 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  871 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  872 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  873 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  874 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  875 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  876 */ { kTypeVoid, kTypeObject, kTypeObject },
	/*  877 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  878 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  879 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  880 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  881 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  882 */ { kTypeInt, kTypeObject },
	/*  883 */ { kTypeInt, kTypeObject },
	/*  884 */ { kTypeInt, kTypeObject, kTypeObject },
	/*  885 */ { kTypeObject, kTypeObject, kTypeString },
	/*  886 */ { kTypeEngineType0, kTypeInt },
	/*  887 */ { kTypeEngineType0, kTypeInt },
	/*  888 */ { kTypeEngineType0, kTypeInt },
	/*  889 */ { kTypeEngineType0, kTypeInt },
	/*  890 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  891 */ { kTypeVoid, kTypeInt },
	/*  892 */ { kTypeInt, kTypeObject },
	/*  893 */ { kTypeInt, kTypeObject },
	/*  894 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  895 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  896 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  897 */ { kTypeVoid, kTypeInt },
	/*  898 */ { kTypeInt, kTypeInt, kTypeInt },
	/*  899 */ { kTypeVoid, kTypeInt, kTypeString, kTypeInt },
	/*  900 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeString, kTypeFloat, kTypeInt, kTypeString, kTypeInt, kTypeVector, kTypeInt, kTypeVector, kTypeInt, kTypeString },
	/*  901 */ { kTypeInt, kTypeString, kTypeInt },
	/*  902 */ { kTypeVoid, kTypeObject },
	/*  903 */ { kTypeVoid, kTypeObject },
	/*  904 */ { kTypeVoid },
	/*  905 */ { kTypeInt, kTypeString },
	/*  906 */ { kTypeVoid },
	/*  907 */ { kTypeInt, kTypeObject },
	/*  908 */ { kTypeInt, kTypeObject },
	/*  909 */ { kTypeInt, kTypeObject },
	/*  910 */ { kTypeInt, kTypeObject },
	/*  911 */ { kTypeInt, kTypeObject },
	/*  912 */ { kTypeFloat, kTypeObject },
	/*  913 */ { kTypeInt, kTypeObject },
	/*  914 */ { kTypeFloat, kTypeObject },
	/*  915 */ { kTypeFloat, kTypeObject },
	/*  916 */ { kTypeInt, kTypeObject, kTypeFloat },
	/*  917 */ { kTypeVoid, kTypeInt },
	/*  918 */ { kTypeVoid, kTypeString },
	/*  919 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  920 */ { kTypeVoid, kTypeInt },
	/*  921 */ { kTypeVoid, kTypeObject },
	/*  922 */ { kTypeVoid },
	/*  923 */ { kTypeVoid },
	/*  924 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  925 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  926 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/*  927 */ { kTypeEngineType0, kTypeInt },
	/*  928 */ { kTypeInt, kTypeObject },
	/*  929 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  930 */ { kTypeVoid, kTypeInt },
	/*  931 */ { kTypeVoid, kTypeFloat },
	/*  932 */ { kTypeVoid, kTypeObject, kTypeVector },
	/*  933 */ { kTypeVoid, kTypeInt },
	/*  934 */ { kTypeVoid, kTypeInt },
	/*  935 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  936 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  937 */ { kTypeVoid, kTypeInt },
	/*  938 */ { kTypeVoid, kTypeInt },
	/*  939 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/*  940 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  941 */ { kTypeInt, kTypeObject },
	/*  942 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  943 */ { kTypeVoid, kTypeString },
	/*  944 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeString, kTypeString },
	/*  945 */ { kTypeVoid, kTypeInt, kTypeFloat },
	/*  946 */ { kTypeEngineType0, kTypeObject, kTypeInt },
	/*  947 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeString },
	/*  948 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt, kTypeString },
	/*  949 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  950 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  951 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  952 */ { kTypeVoid, kTypeInt },
	/*  953 */ { kTypeInt },
	/*  954 */ { kTypeVoid, kTypeInt },
	/*  955 */ { kTypeVoid },
	/*  956 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  957 */ { kTypeInt, kTypeObject, kTypeInt },
	/*  958 */ { kTypeInt, kTypeString, kTypeFloat },
	/*  959 */ { kTypeInt, kTypeObject },
	/*  960 */ { kTypeInt, kTypeObject },
	/*  961 */ { kTypeInt, kTypeObject },
	/*  962 */ { kTypeInt, kTypeObject },
	/*  963 */ { kTypeString, kTypeObject },
	/*  964 */ { kTypeInt, kTypeObject },
	/*  965 */ { kTypeInt, kTypeObject },
	/*  966 */ { kTypeInt, kTypeObject },
	/*  967 */ { kTypeInt, kTypeObject },
	/*  968 */ { kTypeInt, kTypeObject },
	/*  969 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  970 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  971 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  972 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  973 */ { kTypeVoid, kTypeObject, kTypeString },
	/*  974 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  975 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  976 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  977 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  978 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  979 */ { kTypeInt, kTypeObject, kTypeFloat, kTypeFloat },
	/*  980 */ { kTypeInt, kTypeObject, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeFloat, kTypeInt },
	/*  981 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  982 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeString },
	/*  983 */ { kTypeInt, kTypeObject },
	/*  984 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  985 */ { kTypeInt, kTypeObject },
	/*  986 */ { kTypeVoid },
	/*  987 */ { kTypeVoid },
	/*  988 */ { kTypeVoid, kTypeInt, kTypeInt },
	/*  989 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  990 */ { kTypeVoid },
	/*  991 */ { kTypeInt, kTypeObject, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeFloat, kTypeInt },
	/*  992 */ { kTypeInt },
	/*  993 */ { kTypeVoid, kTypeInt },
	/*  994 */ { kTypeVoid, kTypeInt },
	/*  995 */ { kTypeVoid, kTypeInt },
	/*  996 */ { kTypeInt },
	/*  997 */ { kTypeVoid, kTypeInt },
	/*  998 */ { kTypeInt },
	/*  999 */ { kTypeVoid, kTypeString },
	/* 1000 */ { kTypeVoid, kTypeInt },
	/* 1001 */ { kTypeVoid, kTypeObject },
	/* 1002 */ { kTypeVoid, kTypeInt },
	/* 1003 */ { kTypeVoid, kTypeInt },
	/* 1004 */ { kTypeInt, kTypeObject },
	/* 1005 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1006 */ { kTypeVoid, kTypeObject, kTypeVector, kTypeFloat },
	/* 1007 */ { kTypeVoid, kTypeObject },
	/* 1008 */ { kTypeInt, kTypeObject },
	/* 1009 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1010 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeFloat, kTypeInt, kTypeVector },
	/* 1011 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeInt },
	/* 1012 */ { kTypeVoid, kTypeInt },
	/* 1013 */ { kTypeVoid, kTypeEngineType0, kTypeFloat },
	/* 1014 */ { kTypeInt, kTypeObject },
	/* 1015 */ { kTypeInt, kTypeInt },
	/* 1016 */ { kTypeInt, kTypeInt },
	/* 1017 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1018 */ { kTypeVoid },
	/* 1019 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 1020 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1021 */ { kTypeInt, kTypeObject },
	/* 1022 */ { kTypeInt, kTypeObject },
	/* 1023 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1024 */ { kTypeVoid, kTypeInt },
	/* 1025 */ { kTypeVoid, kTypeInt, kTypeString },
	/* 1026 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 1027 */ { kTypeVoid, kTypeVector, kTypeInt },
	/* 1028 */ { kTypeInt, kTypeString, kTypeInt },
	/* 1029 */ { kTypeVoid, kTypeInt },
	/* 1030 */ { kTypeInt, kTypeObject, kTypeObject, kTypeString },
	/* 1031 */ { kTypeVoid, kTypeObject },
	/* 1032 */ { kTypeVoid },
	/* 1033 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt },
	/* 1034 */ { kTypeInt, kTypeString, kTypeInt },
	/* 1035 */ { kTypeVoid, kTypeInt },
	/* 1036 */ { kTypeInt, kTypeInt },
	/* 1037 */ { kTypeInt, kTypeObject },
	/* 1038 */ { kTypeInt, kTypeString },
	/* 1039 */ { kTypeObject },
	/* 1040 */ { kTypeInt },
	/* 1041 */ { kTypeInt },
	/* 1042 */ { kTypeInt, kTypeString },
	/* 1043 */ { kTypeInt, kTypeString },
	/* 1044 */ { kTypeInt, kTypeObject, kTypeObject, kTypeVector, kTypeInt, kTypeInt, kTypeInt },
	/* 1045 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 1046 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1047 */ { kTypeInt },
	/* 1048 */ { kTypeInt },
	/* 1049 */ { kTypeInt },
	/* 1050 */ { kTypeInt },
	/* 1051 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1052 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1053 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 1054 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 1055 */ { kTypeVoid, kTypeInt },
	/* 1056 */ { kTypeInt, kTypeObject },
	/* 1057 */ { kTypeInt, kTypeInt },
	/* 1058 */ { kTypeVoid }
};

} // End of namespace Jade

} // End of namespace NWScript

#endif // NWSCRIPT_GAME_JADE_H
