#region License
//
// The Open Toolkit Library License
//
// Copyright (c) 2006 - 2009 the Open Toolkit library.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to 
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
#endregion

#if EXPERIMENTAL

namespace OpenTK.Compute.CL10
{
    using System;
    using System.Text;
    using System.Runtime.InteropServices;
    #pragma warning disable 3019
    #pragma warning disable 1591
    #pragma warning disable 1572
    #pragma warning disable 1573

    partial class CL
    {

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram(IntPtr program, Int32 num_devices, IntPtr[] device_list, String options, IntPtr pfn_notify, IntPtr user_data)
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = device_list)
                {
                    return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, Int32 num_devices, IntPtr[] device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, Int32 num_devices, IntPtr[] device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, Int32 num_devices, IntPtr[] device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,,] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, Int32 num_devices, IntPtr[] device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T5 user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                        user_data = (T5)user_data_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram(IntPtr program, Int32 num_devices, ref IntPtr device_list, String options, IntPtr pfn_notify, IntPtr user_data)
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = &device_list)
                {
                    return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, Int32 num_devices, ref IntPtr device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = &device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, Int32 num_devices, ref IntPtr device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = &device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, Int32 num_devices, ref IntPtr device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,,] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = &device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, Int32 num_devices, ref IntPtr device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T5 user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = &device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                        user_data = (T5)user_data_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        unsafe int BuildProgram(IntPtr program, Int32 num_devices, IntPtr* device_list, String options, IntPtr pfn_notify, IntPtr user_data)
        {
            return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        unsafe int BuildProgram<T5>(IntPtr program, Int32 num_devices, IntPtr* device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[] user_data)
            where T5 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        unsafe int BuildProgram<T5>(IntPtr program, Int32 num_devices, IntPtr* device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,] user_data)
            where T5 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        unsafe int BuildProgram<T5>(IntPtr program, Int32 num_devices, IntPtr* device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,,] user_data)
            where T5 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        unsafe int BuildProgram<T5>(IntPtr program, Int32 num_devices, IntPtr* device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T5 user_data)
            where T5 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                user_data = (T5)user_data_ptr.Target;
                return retval;
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram(IntPtr program, uint num_devices, IntPtr[] device_list, String options, IntPtr pfn_notify, IntPtr user_data)
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = device_list)
                {
                    return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, uint num_devices, IntPtr[] device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, uint num_devices, IntPtr[] device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, uint num_devices, IntPtr[] device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,,] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, uint num_devices, IntPtr[] device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T5 user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                        user_data = (T5)user_data_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram(IntPtr program, uint num_devices, ref IntPtr device_list, String options, IntPtr pfn_notify, IntPtr user_data)
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = &device_list)
                {
                    return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, uint num_devices, ref IntPtr device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = &device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, uint num_devices, ref IntPtr device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = &device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, uint num_devices, ref IntPtr device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,,] user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = &device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        int BuildProgram<T5>(IntPtr program, uint num_devices, ref IntPtr device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T5 user_data)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* device_list_ptr = &device_list)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list_ptr, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                        user_data = (T5)user_data_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        unsafe int BuildProgram(IntPtr program, uint num_devices, IntPtr* device_list, String options, IntPtr pfn_notify, IntPtr user_data)
        {
            return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        unsafe int BuildProgram<T5>(IntPtr program, uint num_devices, IntPtr* device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[] user_data)
            where T5 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        unsafe int BuildProgram<T5>(IntPtr program, uint num_devices, IntPtr* device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,] user_data)
            where T5 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        unsafe int BuildProgram<T5>(IntPtr program, uint num_devices, IntPtr* device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] T5[,,] user_data)
            where T5 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clBuildProgram")]
        public static 
        unsafe int BuildProgram<T5>(IntPtr program, uint num_devices, IntPtr* device_list, String options, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T5 user_data)
            where T5 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clBuildProgram((IntPtr)program, (uint)num_devices, (IntPtr*)device_list, (String)options, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject());
                user_data = (T5)user_data_ptr.Target;
                return retval;
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        IntPtr CreateBuffer(IntPtr context, MemFlags flags, IntPtr size, IntPtr host_ptr, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    return Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        IntPtr CreateBuffer(IntPtr context, MemFlags flags, IntPtr size, IntPtr host_ptr, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    IntPtr retval = Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    errcode_ret = *errcode_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        unsafe IntPtr CreateBuffer(IntPtr context, MemFlags flags, IntPtr size, IntPtr host_ptr, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
        {
            return Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] T3[] host_ptr, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] T3[] host_ptr, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        unsafe IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] T3[] host_ptr, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T3 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] T3[,] host_ptr, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] T3[,] host_ptr, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        unsafe IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] T3[,] host_ptr, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T3 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] T3[,,] host_ptr, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] T3[,,] host_ptr, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        unsafe IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] T3[,,] host_ptr, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T3 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] ref T3 host_ptr, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        host_ptr = (T3)host_ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] ref T3 host_ptr, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        host_ptr = (T3)host_ptr_ptr.Target;
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateBuffer")]
        public static 
        unsafe IntPtr CreateBuffer<T3>(IntPtr context, MemFlags flags, IntPtr size, [InAttribute, OutAttribute] ref T3 host_ptr, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T3 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                IntPtr retval = Delegates.clCreateBuffer((IntPtr)context, (MemFlags)flags, (IntPtr)size, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
                host_ptr = (T3)host_ptr_ptr.Target;
                return retval;
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateCommandQueue")]
        public static 
        IntPtr CreateCommandQueue(IntPtr context, IntPtr device, CommandQueueFlags properties, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    return Delegates.clCreateCommandQueue((IntPtr)context, (IntPtr)device, (CommandQueueFlags)properties, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateCommandQueue")]
        public static 
        IntPtr CreateCommandQueue(IntPtr context, IntPtr device, CommandQueueFlags properties, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    IntPtr retval = Delegates.clCreateCommandQueue((IntPtr)context, (IntPtr)device, (CommandQueueFlags)properties, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    errcode_ret = *errcode_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateCommandQueue")]
        public static 
        unsafe IntPtr CreateCommandQueue(IntPtr context, IntPtr device, CommandQueueFlags properties, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
        {
            return Delegates.clCreateCommandQueue((IntPtr)context, (IntPtr)device, (CommandQueueFlags)properties, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext(IntPtr[] properties, Int32 num_devices, IntPtr[] devices, IntPtr pfn_notify, IntPtr user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (IntPtr* devices_ptr = devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    return Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(IntPtr[] properties, Int32 num_devices, IntPtr[] devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (IntPtr* devices_ptr = devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(IntPtr[] properties, Int32 num_devices, IntPtr[] devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (IntPtr* devices_ptr = devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(IntPtr[] properties, Int32 num_devices, IntPtr[] devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (IntPtr* devices_ptr = devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(IntPtr[] properties, Int32 num_devices, IntPtr[] devices, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T4 user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (IntPtr* devices_ptr = devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        user_data = (T4)user_data_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext(IntPtr[] properties, uint num_devices, IntPtr[] devices, IntPtr pfn_notify, IntPtr user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (IntPtr* devices_ptr = devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    return Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(IntPtr[] properties, uint num_devices, IntPtr[] devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (IntPtr* devices_ptr = devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(IntPtr[] properties, uint num_devices, IntPtr[] devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (IntPtr* devices_ptr = devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(IntPtr[] properties, uint num_devices, IntPtr[] devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (IntPtr* devices_ptr = devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(IntPtr[] properties, uint num_devices, IntPtr[] devices, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T4 user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (IntPtr* devices_ptr = devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        user_data = (T4)user_data_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext(ref IntPtr properties, Int32 num_devices, ref IntPtr devices, IntPtr pfn_notify, IntPtr user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (IntPtr* devices_ptr = &devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    errcode_ret = *errcode_ret_ptr;
                    return retval;
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(ref IntPtr properties, Int32 num_devices, ref IntPtr devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[] user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (IntPtr* devices_ptr = &devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(ref IntPtr properties, Int32 num_devices, ref IntPtr devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,] user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (IntPtr* devices_ptr = &devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(ref IntPtr properties, Int32 num_devices, ref IntPtr devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,,] user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (IntPtr* devices_ptr = &devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(ref IntPtr properties, Int32 num_devices, ref IntPtr devices, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T4 user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (IntPtr* devices_ptr = &devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        user_data = (T4)user_data_ptr.Target;
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext(ref IntPtr properties, uint num_devices, ref IntPtr devices, IntPtr pfn_notify, IntPtr user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (IntPtr* devices_ptr = &devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    errcode_ret = *errcode_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(ref IntPtr properties, uint num_devices, ref IntPtr devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[] user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (IntPtr* devices_ptr = &devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(ref IntPtr properties, uint num_devices, ref IntPtr devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,] user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (IntPtr* devices_ptr = &devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(ref IntPtr properties, uint num_devices, ref IntPtr devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,,] user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (IntPtr* devices_ptr = &devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        IntPtr CreateContext<T4>(ref IntPtr properties, uint num_devices, ref IntPtr devices, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T4 user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (IntPtr* devices_ptr = &devices)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContext((IntPtr*)properties_ptr, (uint)num_devices, (IntPtr*)devices_ptr, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        user_data = (T4)user_data_ptr.Target;
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        unsafe IntPtr CreateContext(IntPtr* properties, Int32 num_devices, IntPtr* devices, IntPtr pfn_notify, IntPtr user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
        {
            return Delegates.clCreateContext((IntPtr*)properties, (uint)num_devices, (IntPtr*)devices, (IntPtr)pfn_notify, (IntPtr)user_data, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        unsafe IntPtr CreateContext<T4>(IntPtr* properties, Int32 num_devices, IntPtr* devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T4 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateContext((IntPtr*)properties, (uint)num_devices, (IntPtr*)devices, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        unsafe IntPtr CreateContext<T4>(IntPtr* properties, Int32 num_devices, IntPtr* devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T4 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateContext((IntPtr*)properties, (uint)num_devices, (IntPtr*)devices, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        unsafe IntPtr CreateContext<T4>(IntPtr* properties, Int32 num_devices, IntPtr* devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T4 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateContext((IntPtr*)properties, (uint)num_devices, (IntPtr*)devices, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        unsafe IntPtr CreateContext<T4>(IntPtr* properties, Int32 num_devices, IntPtr* devices, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T4 user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T4 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                IntPtr retval = Delegates.clCreateContext((IntPtr*)properties, (uint)num_devices, (IntPtr*)devices, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
                user_data = (T4)user_data_ptr.Target;
                return retval;
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        unsafe IntPtr CreateContext(IntPtr* properties, uint num_devices, IntPtr* devices, IntPtr pfn_notify, IntPtr user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
        {
            return Delegates.clCreateContext((IntPtr*)properties, (uint)num_devices, (IntPtr*)devices, (IntPtr)pfn_notify, (IntPtr)user_data, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        unsafe IntPtr CreateContext<T4>(IntPtr* properties, uint num_devices, IntPtr* devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T4 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateContext((IntPtr*)properties, (uint)num_devices, (IntPtr*)devices, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        unsafe IntPtr CreateContext<T4>(IntPtr* properties, uint num_devices, IntPtr* devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T4 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateContext((IntPtr*)properties, (uint)num_devices, (IntPtr*)devices, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        unsafe IntPtr CreateContext<T4>(IntPtr* properties, uint num_devices, IntPtr* devices, IntPtr pfn_notify, [InAttribute, OutAttribute] T4[,,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T4 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateContext((IntPtr*)properties, (uint)num_devices, (IntPtr*)devices, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContext")]
        public static 
        unsafe IntPtr CreateContext<T4>(IntPtr* properties, uint num_devices, IntPtr* devices, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T4 user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T4 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                IntPtr retval = Delegates.clCreateContext((IntPtr*)properties, (uint)num_devices, (IntPtr*)devices, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
                user_data = (T4)user_data_ptr.Target;
                return retval;
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        IntPtr CreateContextFromType(IntPtr[] properties, DeviceTypeFlags device_type, IntPtr pfn_notify, IntPtr user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    return Delegates.clCreateContextFromType((IntPtr*)properties_ptr, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        IntPtr CreateContextFromType<T3>(IntPtr[] properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] T3[] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateContextFromType((IntPtr*)properties_ptr, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        IntPtr CreateContextFromType<T3>(IntPtr[] properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] T3[,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateContextFromType((IntPtr*)properties_ptr, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        IntPtr CreateContextFromType<T3>(IntPtr[] properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] T3[,,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateContextFromType((IntPtr*)properties_ptr, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        IntPtr CreateContextFromType<T3>(IntPtr[] properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T3 user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = properties)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContextFromType((IntPtr*)properties_ptr, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        user_data = (T3)user_data_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        IntPtr CreateContextFromType(ref IntPtr properties, DeviceTypeFlags device_type, IntPtr pfn_notify, IntPtr user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    IntPtr retval = Delegates.clCreateContextFromType((IntPtr*)properties_ptr, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    errcode_ret = *errcode_ret_ptr;
                    return retval;
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        IntPtr CreateContextFromType<T3>(ref IntPtr properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] T3[] user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContextFromType((IntPtr*)properties_ptr, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        IntPtr CreateContextFromType<T3>(ref IntPtr properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] T3[,] user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContextFromType((IntPtr*)properties_ptr, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        IntPtr CreateContextFromType<T3>(ref IntPtr properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] T3[,,] user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContextFromType((IntPtr*)properties_ptr, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        IntPtr CreateContextFromType<T3>(ref IntPtr properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T3 user_data, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* properties_ptr = &properties)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateContextFromType((IntPtr*)properties_ptr, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                        user_data = (T3)user_data_ptr.Target;
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        user_data_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        unsafe IntPtr CreateContextFromType(IntPtr* properties, DeviceTypeFlags device_type, IntPtr pfn_notify, IntPtr user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
        {
            return Delegates.clCreateContextFromType((IntPtr*)properties, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        unsafe IntPtr CreateContextFromType<T3>(IntPtr* properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] T3[] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T3 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateContextFromType((IntPtr*)properties, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        unsafe IntPtr CreateContextFromType<T3>(IntPtr* properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] T3[,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T3 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateContextFromType((IntPtr*)properties, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        unsafe IntPtr CreateContextFromType<T3>(IntPtr* properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] T3[,,] user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T3 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateContextFromType((IntPtr*)properties, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateContextFromType")]
        public static 
        unsafe IntPtr CreateContextFromType<T3>(IntPtr* properties, DeviceTypeFlags device_type, IntPtr pfn_notify, [InAttribute, OutAttribute] ref T3 user_data, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
            where T3 : struct
        {
            GCHandle user_data_ptr = GCHandle.Alloc(user_data, GCHandleType.Pinned);
            try
            {
                IntPtr retval = Delegates.clCreateContextFromType((IntPtr*)properties, (DeviceTypeFlags)device_type, (IntPtr)pfn_notify, (IntPtr)user_data_ptr.AddrOfPinnedObject(), (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
                user_data = (T3)user_data_ptr.Target;
                return retval;
            }
            finally
            {
                user_data_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        IntPtr CreateImage2D(IntPtr context, MemFlags flags, ImageFormat[] image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, IntPtr host_ptr, [OutAttribute] int[] errcode_ret)
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = image_format)
                fixed (int* errcode_ret_ptr = errcode_ret)
                {
                    return Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr, (int*)errcode_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ImageFormat[] image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] T6[] host_ptr, [OutAttribute] int[] errcode_ret)
            where T6 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = image_format)
                fixed (int* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ImageFormat[] image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] T6[,] host_ptr, [OutAttribute] int[] errcode_ret)
            where T6 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = image_format)
                fixed (int* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ImageFormat[] image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] T6[,,] host_ptr, [OutAttribute] int[] errcode_ret)
            where T6 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = image_format)
                fixed (int* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ImageFormat[] image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] ref T6 host_ptr, [OutAttribute] int[] errcode_ret)
            where T6 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = image_format)
                fixed (int* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                        host_ptr = (T6)host_ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        IntPtr CreateImage2D(IntPtr context, MemFlags flags, ref ImageFormat image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, IntPtr host_ptr, [OutAttribute] out int errcode_ret)
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = &image_format)
                fixed (int* errcode_ret_ptr = &errcode_ret)
                {
                    IntPtr retval = Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr, (int*)errcode_ret_ptr);
                    errcode_ret = *errcode_ret_ptr;
                    return retval;
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ref ImageFormat image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] T6[] host_ptr, [OutAttribute] out int errcode_ret)
            where T6 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = &image_format)
                fixed (int* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ref ImageFormat image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] T6[,] host_ptr, [OutAttribute] out int errcode_ret)
            where T6 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = &image_format)
                fixed (int* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ref ImageFormat image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] T6[,,] host_ptr, [OutAttribute] out int errcode_ret)
            where T6 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = &image_format)
                fixed (int* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ref ImageFormat image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] ref T6 host_ptr, [OutAttribute] out int errcode_ret)
            where T6 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = &image_format)
                fixed (int* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                        host_ptr = (T6)host_ptr_ptr.Target;
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        unsafe IntPtr CreateImage2D(IntPtr context, MemFlags flags, ImageFormat* image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, IntPtr host_ptr, [OutAttribute] int* errcode_ret)
        {
            return Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr, (int*)errcode_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        unsafe IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ImageFormat* image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] T6[] host_ptr, [OutAttribute] int* errcode_ret)
            where T6 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret);
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        unsafe IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ImageFormat* image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] T6[,] host_ptr, [OutAttribute] int* errcode_ret)
            where T6 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret);
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        unsafe IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ImageFormat* image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] T6[,,] host_ptr, [OutAttribute] int* errcode_ret)
            where T6 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret);
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage2D")]
        public static 
        unsafe IntPtr CreateImage2D<T6>(IntPtr context, MemFlags flags, ImageFormat* image_format, IntPtr image_width, IntPtr image_height, IntPtr image_row_pitch, [InAttribute, OutAttribute] ref T6 host_ptr, [OutAttribute] int* errcode_ret)
            where T6 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                IntPtr retval = Delegates.clCreateImage2D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_row_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret);
                host_ptr = (T6)host_ptr_ptr.Target;
                return retval;
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        IntPtr CreateImage3D(IntPtr context, MemFlags flags, ImageFormat[] image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, IntPtr host_ptr, [OutAttribute] int[] errcode_ret)
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = image_format)
                fixed (int* errcode_ret_ptr = errcode_ret)
                {
                    return Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr, (int*)errcode_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ImageFormat[] image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] T8[] host_ptr, [OutAttribute] int[] errcode_ret)
            where T8 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = image_format)
                fixed (int* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ImageFormat[] image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] T8[,] host_ptr, [OutAttribute] int[] errcode_ret)
            where T8 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = image_format)
                fixed (int* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ImageFormat[] image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] T8[,,] host_ptr, [OutAttribute] int[] errcode_ret)
            where T8 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = image_format)
                fixed (int* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ImageFormat[] image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] ref T8 host_ptr, [OutAttribute] int[] errcode_ret)
            where T8 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = image_format)
                fixed (int* errcode_ret_ptr = errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                        host_ptr = (T8)host_ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        IntPtr CreateImage3D(IntPtr context, MemFlags flags, ref ImageFormat image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, IntPtr host_ptr, [OutAttribute] out int errcode_ret)
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = &image_format)
                fixed (int* errcode_ret_ptr = &errcode_ret)
                {
                    IntPtr retval = Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr, (int*)errcode_ret_ptr);
                    errcode_ret = *errcode_ret_ptr;
                    return retval;
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ref ImageFormat image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] T8[] host_ptr, [OutAttribute] out int errcode_ret)
            where T8 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = &image_format)
                fixed (int* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ref ImageFormat image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] T8[,] host_ptr, [OutAttribute] out int errcode_ret)
            where T8 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = &image_format)
                fixed (int* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ref ImageFormat image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] T8[,,] host_ptr, [OutAttribute] out int errcode_ret)
            where T8 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = &image_format)
                fixed (int* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ref ImageFormat image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] ref T8 host_ptr, [OutAttribute] out int errcode_ret)
            where T8 : struct
        {
            unsafe
            {
                fixed (ImageFormat* image_format_ptr = &image_format)
                fixed (int* errcode_ret_ptr = &errcode_ret)
                {
                    GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
                    try
                    {
                        IntPtr retval = Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format_ptr, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret_ptr);
                        host_ptr = (T8)host_ptr_ptr.Target;
                        errcode_ret = *errcode_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        host_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        unsafe IntPtr CreateImage3D(IntPtr context, MemFlags flags, ImageFormat* image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, IntPtr host_ptr, [OutAttribute] int* errcode_ret)
        {
            return Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr, (int*)errcode_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        unsafe IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ImageFormat* image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] T8[] host_ptr, [OutAttribute] int* errcode_ret)
            where T8 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret);
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        unsafe IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ImageFormat* image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] T8[,] host_ptr, [OutAttribute] int* errcode_ret)
            where T8 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret);
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        unsafe IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ImageFormat* image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] T8[,,] host_ptr, [OutAttribute] int* errcode_ret)
            where T8 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret);
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateImage3D")]
        public static 
        unsafe IntPtr CreateImage3D<T8>(IntPtr context, MemFlags flags, ImageFormat* image_format, IntPtr image_width, IntPtr image_height, IntPtr image_depth, IntPtr image_row_pitch, IntPtr image_slice_pitch, [InAttribute, OutAttribute] ref T8 host_ptr, [OutAttribute] int* errcode_ret)
            where T8 : struct
        {
            GCHandle host_ptr_ptr = GCHandle.Alloc(host_ptr, GCHandleType.Pinned);
            try
            {
                IntPtr retval = Delegates.clCreateImage3D((IntPtr)context, (MemFlags)flags, (ImageFormat*)image_format, (IntPtr)image_width, (IntPtr)image_height, (IntPtr)image_depth, (IntPtr)image_row_pitch, (IntPtr)image_slice_pitch, (IntPtr)host_ptr_ptr.AddrOfPinnedObject(), (int*)errcode_ret);
                host_ptr = (T8)host_ptr_ptr.Target;
                return retval;
            }
            finally
            {
                host_ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateKernel")]
        public static 
        IntPtr CreateKernel(IntPtr program, String kernel_name, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    return Delegates.clCreateKernel((IntPtr)program, (String)kernel_name, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateKernel")]
        public static 
        IntPtr CreateKernel(IntPtr program, String kernel_name, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
        {
            unsafe
            {
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    IntPtr retval = Delegates.clCreateKernel((IntPtr)program, (String)kernel_name, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    errcode_ret = *errcode_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateKernel")]
        public static 
        unsafe IntPtr CreateKernel(IntPtr program, String kernel_name, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
        {
            return Delegates.clCreateKernel((IntPtr)program, (String)kernel_name, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateKernelsInProgram")]
        public static 
        int CreateKernelsInProgram(IntPtr program, Int32 num_kernels, IntPtr[] kernels, [OutAttribute] Int32[] num_kernels_ret)
        {
            unsafe
            {
                fixed (IntPtr* kernels_ptr = kernels)
                fixed (Int32* num_kernels_ret_ptr = num_kernels_ret)
                {
                    return Delegates.clCreateKernelsInProgram((IntPtr)program, (uint)num_kernels, (IntPtr*)kernels_ptr, (uint*)num_kernels_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateKernelsInProgram")]
        public static 
        int CreateKernelsInProgram(IntPtr program, Int32 num_kernels, ref IntPtr kernels, [OutAttribute] out Int32 num_kernels_ret)
        {
            unsafe
            {
                fixed (IntPtr* kernels_ptr = &kernels)
                fixed (Int32* num_kernels_ret_ptr = &num_kernels_ret)
                {
                    int retval = Delegates.clCreateKernelsInProgram((IntPtr)program, (uint)num_kernels, (IntPtr*)kernels_ptr, (uint*)num_kernels_ret_ptr);
                    num_kernels_ret = *num_kernels_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateKernelsInProgram")]
        public static 
        unsafe int CreateKernelsInProgram(IntPtr program, Int32 num_kernels, IntPtr* kernels, [OutAttribute] Int32* num_kernels_ret)
        {
            return Delegates.clCreateKernelsInProgram((IntPtr)program, (uint)num_kernels, (IntPtr*)kernels, (uint*)num_kernels_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateKernelsInProgram")]
        public static 
        int CreateKernelsInProgram(IntPtr program, uint num_kernels, IntPtr[] kernels, [OutAttribute] uint[] num_kernels_ret)
        {
            unsafe
            {
                fixed (IntPtr* kernels_ptr = kernels)
                fixed (uint* num_kernels_ret_ptr = num_kernels_ret)
                {
                    return Delegates.clCreateKernelsInProgram((IntPtr)program, (uint)num_kernels, (IntPtr*)kernels_ptr, (uint*)num_kernels_ret_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateKernelsInProgram")]
        public static 
        int CreateKernelsInProgram(IntPtr program, uint num_kernels, ref IntPtr kernels, [OutAttribute] out uint num_kernels_ret)
        {
            unsafe
            {
                fixed (IntPtr* kernels_ptr = &kernels)
                fixed (uint* num_kernels_ret_ptr = &num_kernels_ret)
                {
                    int retval = Delegates.clCreateKernelsInProgram((IntPtr)program, (uint)num_kernels, (IntPtr*)kernels_ptr, (uint*)num_kernels_ret_ptr);
                    num_kernels_ret = *num_kernels_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateKernelsInProgram")]
        public static 
        unsafe int CreateKernelsInProgram(IntPtr program, uint num_kernels, IntPtr* kernels, [OutAttribute] uint* num_kernels_ret)
        {
            return Delegates.clCreateKernelsInProgram((IntPtr)program, (uint)num_kernels, (IntPtr*)kernels, (uint*)num_kernels_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithBinary")]
        public static 
        unsafe IntPtr CreateProgramWithBinary(IntPtr context, Int32 num_devices, IntPtr[] device_list, IntPtr[] lengths, byte*[] binaries, int[] binary_status, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
        {
            fixed (IntPtr* device_list_ptr = device_list)
            fixed (IntPtr* lengths_ptr = lengths)
            fixed (byte** binaries_ptr = binaries)
            fixed (int* binary_status_ptr = binary_status)
            fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
            {
                return Delegates.clCreateProgramWithBinary((IntPtr)context, (uint)num_devices, (IntPtr*)device_list_ptr, (IntPtr*)lengths_ptr, (byte**)binaries_ptr, (int*)binary_status_ptr, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithBinary")]
        public static 
        unsafe IntPtr CreateProgramWithBinary(IntPtr context, Int32 num_devices, ref IntPtr device_list, ref IntPtr lengths, ref byte* binaries, ref int binary_status, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
        {
            fixed (IntPtr* device_list_ptr = &device_list)
            fixed (IntPtr* lengths_ptr = &lengths)
            fixed (byte** binaries_ptr = &binaries)
            fixed (int* binary_status_ptr = &binary_status)
            fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
            {
                IntPtr retval = Delegates.clCreateProgramWithBinary((IntPtr)context, (uint)num_devices, (IntPtr*)device_list_ptr, (IntPtr*)lengths_ptr, (byte**)binaries_ptr, (int*)binary_status_ptr, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                errcode_ret = *errcode_ret_ptr;
                return retval;
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithBinary")]
        public static 
        unsafe IntPtr CreateProgramWithBinary(IntPtr context, Int32 num_devices, IntPtr* device_list, IntPtr* lengths, byte** binaries, int* binary_status, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
        {
            return Delegates.clCreateProgramWithBinary((IntPtr)context, (uint)num_devices, (IntPtr*)device_list, (IntPtr*)lengths, (byte**)binaries, (int*)binary_status, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithBinary")]
        public static 
        unsafe IntPtr CreateProgramWithBinary(IntPtr context, uint num_devices, IntPtr[] device_list, IntPtr[] lengths, byte*[] binaries, int[] binary_status, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
        {
            fixed (IntPtr* device_list_ptr = device_list)
            fixed (IntPtr* lengths_ptr = lengths)
            fixed (byte** binaries_ptr = binaries)
            fixed (int* binary_status_ptr = binary_status)
            fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
            {
                return Delegates.clCreateProgramWithBinary((IntPtr)context, (uint)num_devices, (IntPtr*)device_list_ptr, (IntPtr*)lengths_ptr, (byte**)binaries_ptr, (int*)binary_status_ptr, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithBinary")]
        public static 
        unsafe IntPtr CreateProgramWithBinary(IntPtr context, uint num_devices, ref IntPtr device_list, ref IntPtr lengths, ref byte* binaries, ref int binary_status, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
        {
            fixed (IntPtr* device_list_ptr = &device_list)
            fixed (IntPtr* lengths_ptr = &lengths)
            fixed (byte** binaries_ptr = &binaries)
            fixed (int* binary_status_ptr = &binary_status)
            fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
            {
                IntPtr retval = Delegates.clCreateProgramWithBinary((IntPtr)context, (uint)num_devices, (IntPtr*)device_list_ptr, (IntPtr*)lengths_ptr, (byte**)binaries_ptr, (int*)binary_status_ptr, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                errcode_ret = *errcode_ret_ptr;
                return retval;
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithBinary")]
        public static 
        unsafe IntPtr CreateProgramWithBinary(IntPtr context, uint num_devices, IntPtr* device_list, IntPtr* lengths, byte** binaries, int* binary_status, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
        {
            return Delegates.clCreateProgramWithBinary((IntPtr)context, (uint)num_devices, (IntPtr*)device_list, (IntPtr*)lengths, (byte**)binaries, (int*)binary_status, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithSource")]
        public static 
        IntPtr CreateProgramWithSource(IntPtr context, Int32 count, String[] strings, IntPtr[] lengths, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
        {
            unsafe
            {
                fixed (IntPtr* lengths_ptr = lengths)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    return Delegates.clCreateProgramWithSource((IntPtr)context, (uint)count, (String[])strings, (IntPtr*)lengths_ptr, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithSource")]
        public static 
        IntPtr CreateProgramWithSource(IntPtr context, Int32 count, String[] strings, ref IntPtr lengths, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
        {
            unsafe
            {
                fixed (IntPtr* lengths_ptr = &lengths)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    IntPtr retval = Delegates.clCreateProgramWithSource((IntPtr)context, (uint)count, (String[])strings, (IntPtr*)lengths_ptr, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    errcode_ret = *errcode_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithSource")]
        public static 
        unsafe IntPtr CreateProgramWithSource(IntPtr context, Int32 count, String[] strings, IntPtr* lengths, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
        {
            return Delegates.clCreateProgramWithSource((IntPtr)context, (uint)count, (String[])strings, (IntPtr*)lengths, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithSource")]
        public static 
        IntPtr CreateProgramWithSource(IntPtr context, uint count, String[] strings, IntPtr[] lengths, [OutAttribute] OpenTK.Compute.CL10.ErrorCode[] errcode_ret)
        {
            unsafe
            {
                fixed (IntPtr* lengths_ptr = lengths)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = errcode_ret)
                {
                    return Delegates.clCreateProgramWithSource((IntPtr)context, (uint)count, (String[])strings, (IntPtr*)lengths_ptr, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithSource")]
        public static 
        IntPtr CreateProgramWithSource(IntPtr context, uint count, String[] strings, ref IntPtr lengths, [OutAttribute] out OpenTK.Compute.CL10.ErrorCode errcode_ret)
        {
            unsafe
            {
                fixed (IntPtr* lengths_ptr = &lengths)
                fixed (OpenTK.Compute.CL10.ErrorCode* errcode_ret_ptr = &errcode_ret)
                {
                    IntPtr retval = Delegates.clCreateProgramWithSource((IntPtr)context, (uint)count, (String[])strings, (IntPtr*)lengths_ptr, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret_ptr);
                    errcode_ret = *errcode_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateProgramWithSource")]
        public static 
        unsafe IntPtr CreateProgramWithSource(IntPtr context, uint count, String[] strings, IntPtr* lengths, [OutAttribute] OpenTK.Compute.CL10.ErrorCode* errcode_ret)
        {
            return Delegates.clCreateProgramWithSource((IntPtr)context, (uint)count, (String[])strings, (IntPtr*)lengths, (OpenTK.Compute.CL10.ErrorCode*)errcode_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateSampler")]
        public static 
        IntPtr CreateSampler(IntPtr context, bool normalized_coords, AddressingMode addressing_mode, FilterMode filter_mode, [OutAttribute] int[] errcode_ret)
        {
            unsafe
            {
                fixed (int* errcode_ret_ptr = errcode_ret)
                {
                    return Delegates.clCreateSampler((IntPtr)context, (bool)normalized_coords, (AddressingMode)addressing_mode, (FilterMode)filter_mode, (int*)errcode_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateSampler")]
        public static 
        IntPtr CreateSampler(IntPtr context, bool normalized_coords, AddressingMode addressing_mode, FilterMode filter_mode, [OutAttribute] out int errcode_ret)
        {
            unsafe
            {
                fixed (int* errcode_ret_ptr = &errcode_ret)
                {
                    IntPtr retval = Delegates.clCreateSampler((IntPtr)context, (bool)normalized_coords, (AddressingMode)addressing_mode, (FilterMode)filter_mode, (int*)errcode_ret_ptr);
                    errcode_ret = *errcode_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clCreateSampler")]
        public static 
        unsafe IntPtr CreateSampler(IntPtr context, bool normalized_coords, AddressingMode addressing_mode, FilterMode filter_mode, [OutAttribute] int* errcode_ret)
        {
            return Delegates.clCreateSampler((IntPtr)context, (bool)normalized_coords, (AddressingMode)addressing_mode, (FilterMode)filter_mode, (int*)errcode_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueBarrier")]
        public static 
        int EnqueueBarrier(IntPtr command_queue)
        {
            return Delegates.clEnqueueBarrier((IntPtr)command_queue);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBuffer")]
        public static 
        int EnqueueCopyBuffer(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_buffer, IntPtr src_offset, IntPtr dst_offset, IntPtr cb, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueCopyBuffer((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_buffer, (IntPtr)src_offset, (IntPtr)dst_offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBuffer")]
        public static 
        int EnqueueCopyBuffer(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_buffer, IntPtr src_offset, IntPtr dst_offset, IntPtr cb, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueCopyBuffer((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_buffer, (IntPtr)src_offset, (IntPtr)dst_offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBuffer")]
        public static 
        unsafe int EnqueueCopyBuffer(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_buffer, IntPtr src_offset, IntPtr dst_offset, IntPtr cb, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueCopyBuffer((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_buffer, (IntPtr)src_offset, (IntPtr)dst_offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBuffer")]
        public static 
        int EnqueueCopyBuffer(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_buffer, IntPtr src_offset, IntPtr dst_offset, IntPtr cb, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueCopyBuffer((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_buffer, (IntPtr)src_offset, (IntPtr)dst_offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBuffer")]
        public static 
        int EnqueueCopyBuffer(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_buffer, IntPtr src_offset, IntPtr dst_offset, IntPtr cb, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueCopyBuffer((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_buffer, (IntPtr)src_offset, (IntPtr)dst_offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBuffer")]
        public static 
        unsafe int EnqueueCopyBuffer(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_buffer, IntPtr src_offset, IntPtr dst_offset, IntPtr cb, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueCopyBuffer((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_buffer, (IntPtr)src_offset, (IntPtr)dst_offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBufferToImage")]
        public static 
        unsafe int EnqueueCopyBufferToImage(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_image, IntPtr src_offset, IntPtr*[] dst_origin, IntPtr*[] region, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            fixed (IntPtr** dst_origin_ptr = dst_origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                return Delegates.clEnqueueCopyBufferToImage((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_image, (IntPtr)src_offset, (IntPtr**)dst_origin_ptr, (IntPtr**)region_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBufferToImage")]
        public static 
        unsafe int EnqueueCopyBufferToImage(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_image, IntPtr src_offset, IntPtr*[] dst_origin, IntPtr*[] region, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            fixed (IntPtr** dst_origin_ptr = dst_origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                return Delegates.clEnqueueCopyBufferToImage((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_image, (IntPtr)src_offset, (IntPtr**)dst_origin_ptr, (IntPtr**)region_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBufferToImage")]
        public static 
        unsafe int EnqueueCopyBufferToImage(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_image, IntPtr src_offset, ref IntPtr* dst_origin, ref IntPtr* region, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            fixed (IntPtr** dst_origin_ptr = &dst_origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                return Delegates.clEnqueueCopyBufferToImage((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_image, (IntPtr)src_offset, (IntPtr**)dst_origin_ptr, (IntPtr**)region_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBufferToImage")]
        public static 
        unsafe int EnqueueCopyBufferToImage(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_image, IntPtr src_offset, ref IntPtr* dst_origin, ref IntPtr* region, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            fixed (IntPtr** dst_origin_ptr = &dst_origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                return Delegates.clEnqueueCopyBufferToImage((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_image, (IntPtr)src_offset, (IntPtr**)dst_origin_ptr, (IntPtr**)region_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBufferToImage")]
        public static 
        unsafe int EnqueueCopyBufferToImage(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_image, IntPtr src_offset, IntPtr** dst_origin, IntPtr** region, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueCopyBufferToImage((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_image, (IntPtr)src_offset, (IntPtr**)dst_origin, (IntPtr**)region, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyBufferToImage")]
        public static 
        unsafe int EnqueueCopyBufferToImage(IntPtr command_queue, IntPtr src_buffer, IntPtr dst_image, IntPtr src_offset, IntPtr** dst_origin, IntPtr** region, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueCopyBufferToImage((IntPtr)command_queue, (IntPtr)src_buffer, (IntPtr)dst_image, (IntPtr)src_offset, (IntPtr**)dst_origin, (IntPtr**)region, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImage")]
        public static 
        unsafe int EnqueueCopyImage(IntPtr command_queue, IntPtr src_image, IntPtr dst_image, IntPtr*[] src_origin, IntPtr*[] dst_origin, IntPtr*[] region, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            fixed (IntPtr** src_origin_ptr = src_origin)
            fixed (IntPtr** dst_origin_ptr = dst_origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                return Delegates.clEnqueueCopyImage((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_image, (IntPtr**)src_origin_ptr, (IntPtr**)dst_origin_ptr, (IntPtr**)region_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImage")]
        public static 
        unsafe int EnqueueCopyImage(IntPtr command_queue, IntPtr src_image, IntPtr dst_image, IntPtr*[] src_origin, IntPtr*[] dst_origin, IntPtr*[] region, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            fixed (IntPtr** src_origin_ptr = src_origin)
            fixed (IntPtr** dst_origin_ptr = dst_origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                return Delegates.clEnqueueCopyImage((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_image, (IntPtr**)src_origin_ptr, (IntPtr**)dst_origin_ptr, (IntPtr**)region_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImage")]
        public static 
        unsafe int EnqueueCopyImage(IntPtr command_queue, IntPtr src_image, IntPtr dst_image, ref IntPtr* src_origin, ref IntPtr* dst_origin, ref IntPtr* region, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            fixed (IntPtr** src_origin_ptr = &src_origin)
            fixed (IntPtr** dst_origin_ptr = &dst_origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                return Delegates.clEnqueueCopyImage((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_image, (IntPtr**)src_origin_ptr, (IntPtr**)dst_origin_ptr, (IntPtr**)region_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImage")]
        public static 
        unsafe int EnqueueCopyImage(IntPtr command_queue, IntPtr src_image, IntPtr dst_image, ref IntPtr* src_origin, ref IntPtr* dst_origin, ref IntPtr* region, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            fixed (IntPtr** src_origin_ptr = &src_origin)
            fixed (IntPtr** dst_origin_ptr = &dst_origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                return Delegates.clEnqueueCopyImage((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_image, (IntPtr**)src_origin_ptr, (IntPtr**)dst_origin_ptr, (IntPtr**)region_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImage")]
        public static 
        unsafe int EnqueueCopyImage(IntPtr command_queue, IntPtr src_image, IntPtr dst_image, IntPtr** src_origin, IntPtr** dst_origin, IntPtr** region, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueCopyImage((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_image, (IntPtr**)src_origin, (IntPtr**)dst_origin, (IntPtr**)region, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImage")]
        public static 
        unsafe int EnqueueCopyImage(IntPtr command_queue, IntPtr src_image, IntPtr dst_image, IntPtr** src_origin, IntPtr** dst_origin, IntPtr** region, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueCopyImage((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_image, (IntPtr**)src_origin, (IntPtr**)dst_origin, (IntPtr**)region, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImageToBuffer")]
        public static 
        unsafe int EnqueueCopyImageToBuffer(IntPtr command_queue, IntPtr src_image, IntPtr dst_buffer, IntPtr*[] src_origin, IntPtr*[] region, IntPtr dst_offset, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            fixed (IntPtr** src_origin_ptr = src_origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                return Delegates.clEnqueueCopyImageToBuffer((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_buffer, (IntPtr**)src_origin_ptr, (IntPtr**)region_ptr, (IntPtr)dst_offset, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImageToBuffer")]
        public static 
        unsafe int EnqueueCopyImageToBuffer(IntPtr command_queue, IntPtr src_image, IntPtr dst_buffer, IntPtr*[] src_origin, IntPtr*[] region, IntPtr dst_offset, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            fixed (IntPtr** src_origin_ptr = src_origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                return Delegates.clEnqueueCopyImageToBuffer((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_buffer, (IntPtr**)src_origin_ptr, (IntPtr**)region_ptr, (IntPtr)dst_offset, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImageToBuffer")]
        public static 
        unsafe int EnqueueCopyImageToBuffer(IntPtr command_queue, IntPtr src_image, IntPtr dst_buffer, ref IntPtr* src_origin, ref IntPtr* region, IntPtr dst_offset, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            fixed (IntPtr** src_origin_ptr = &src_origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                return Delegates.clEnqueueCopyImageToBuffer((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_buffer, (IntPtr**)src_origin_ptr, (IntPtr**)region_ptr, (IntPtr)dst_offset, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImageToBuffer")]
        public static 
        unsafe int EnqueueCopyImageToBuffer(IntPtr command_queue, IntPtr src_image, IntPtr dst_buffer, ref IntPtr* src_origin, ref IntPtr* region, IntPtr dst_offset, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            fixed (IntPtr** src_origin_ptr = &src_origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                return Delegates.clEnqueueCopyImageToBuffer((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_buffer, (IntPtr**)src_origin_ptr, (IntPtr**)region_ptr, (IntPtr)dst_offset, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImageToBuffer")]
        public static 
        unsafe int EnqueueCopyImageToBuffer(IntPtr command_queue, IntPtr src_image, IntPtr dst_buffer, IntPtr** src_origin, IntPtr** region, IntPtr dst_offset, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueCopyImageToBuffer((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_buffer, (IntPtr**)src_origin, (IntPtr**)region, (IntPtr)dst_offset, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueCopyImageToBuffer")]
        public static 
        unsafe int EnqueueCopyImageToBuffer(IntPtr command_queue, IntPtr src_image, IntPtr dst_buffer, IntPtr** src_origin, IntPtr** region, IntPtr dst_offset, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueCopyImageToBuffer((IntPtr)command_queue, (IntPtr)src_image, (IntPtr)dst_buffer, (IntPtr**)src_origin, (IntPtr**)region, (IntPtr)dst_offset, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapBuffer")]
        public static 
        unsafe System.IntPtr EnqueueMapBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_map, MapFlags map_flags, IntPtr offset, IntPtr cb, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event, [OutAttribute] int[] errcode_ret)
        {
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            fixed (int* errcode_ret_ptr = errcode_ret)
            {
                return Delegates.clEnqueueMapBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_map, (MapFlags)map_flags, (IntPtr)offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr, (int*)errcode_ret_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapBuffer")]
        public static 
        unsafe System.IntPtr EnqueueMapBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_map, MapFlags map_flags, IntPtr offset, IntPtr cb, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event, [OutAttribute] out int errcode_ret)
        {
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            fixed (int* errcode_ret_ptr = &errcode_ret)
            {
                System.IntPtr retval = Delegates.clEnqueueMapBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_map, (MapFlags)map_flags, (IntPtr)offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr, (int*)errcode_ret_ptr);
                errcode_ret = *errcode_ret_ptr;
                return retval;
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapBuffer")]
        public static 
        unsafe System.IntPtr EnqueueMapBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_map, MapFlags map_flags, IntPtr offset, IntPtr cb, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event, [OutAttribute] int* errcode_ret)
        {
            return Delegates.clEnqueueMapBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_map, (MapFlags)map_flags, (IntPtr)offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event, (int*)errcode_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapBuffer")]
        public static 
        unsafe System.IntPtr EnqueueMapBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_map, MapFlags map_flags, IntPtr offset, IntPtr cb, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event, [OutAttribute] int[] errcode_ret)
        {
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            fixed (int* errcode_ret_ptr = errcode_ret)
            {
                return Delegates.clEnqueueMapBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_map, (MapFlags)map_flags, (IntPtr)offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr, (int*)errcode_ret_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapBuffer")]
        public static 
        unsafe System.IntPtr EnqueueMapBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_map, MapFlags map_flags, IntPtr offset, IntPtr cb, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event, [OutAttribute] out int errcode_ret)
        {
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            fixed (int* errcode_ret_ptr = &errcode_ret)
            {
                System.IntPtr retval = Delegates.clEnqueueMapBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_map, (MapFlags)map_flags, (IntPtr)offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr, (int*)errcode_ret_ptr);
                errcode_ret = *errcode_ret_ptr;
                return retval;
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapBuffer")]
        public static 
        unsafe System.IntPtr EnqueueMapBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_map, MapFlags map_flags, IntPtr offset, IntPtr cb, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event, [OutAttribute] int* errcode_ret)
        {
            return Delegates.clEnqueueMapBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_map, (MapFlags)map_flags, (IntPtr)offset, (IntPtr)cb, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event, (int*)errcode_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapImage")]
        public static 
        unsafe System.IntPtr EnqueueMapImage(IntPtr command_queue, IntPtr image, bool blocking_map, MapFlags map_flags, IntPtr*[] origin, IntPtr*[] region, IntPtr[] image_row_pitch, IntPtr[] image_slice_pitch, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event, [OutAttribute] int[] errcode_ret)
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* image_row_pitch_ptr = image_row_pitch)
            fixed (IntPtr* image_slice_pitch_ptr = image_slice_pitch)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            fixed (int* errcode_ret_ptr = errcode_ret)
            {
                return Delegates.clEnqueueMapImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_map, (MapFlags)map_flags, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr*)image_row_pitch_ptr, (IntPtr*)image_slice_pitch_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr, (int*)errcode_ret_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapImage")]
        public static 
        unsafe System.IntPtr EnqueueMapImage(IntPtr command_queue, IntPtr image, bool blocking_map, MapFlags map_flags, IntPtr*[] origin, IntPtr*[] region, IntPtr[] image_row_pitch, IntPtr[] image_slice_pitch, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event, [OutAttribute] int[] errcode_ret)
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* image_row_pitch_ptr = image_row_pitch)
            fixed (IntPtr* image_slice_pitch_ptr = image_slice_pitch)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            fixed (int* errcode_ret_ptr = errcode_ret)
            {
                return Delegates.clEnqueueMapImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_map, (MapFlags)map_flags, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr*)image_row_pitch_ptr, (IntPtr*)image_slice_pitch_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr, (int*)errcode_ret_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapImage")]
        public static 
        unsafe System.IntPtr EnqueueMapImage(IntPtr command_queue, IntPtr image, bool blocking_map, MapFlags map_flags, ref IntPtr* origin, ref IntPtr* region, ref IntPtr image_row_pitch, ref IntPtr image_slice_pitch, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event, [OutAttribute] out int errcode_ret)
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* image_row_pitch_ptr = &image_row_pitch)
            fixed (IntPtr* image_slice_pitch_ptr = &image_slice_pitch)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            fixed (int* errcode_ret_ptr = &errcode_ret)
            {
                System.IntPtr retval = Delegates.clEnqueueMapImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_map, (MapFlags)map_flags, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr*)image_row_pitch_ptr, (IntPtr*)image_slice_pitch_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr, (int*)errcode_ret_ptr);
                errcode_ret = *errcode_ret_ptr;
                return retval;
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapImage")]
        public static 
        unsafe System.IntPtr EnqueueMapImage(IntPtr command_queue, IntPtr image, bool blocking_map, MapFlags map_flags, ref IntPtr* origin, ref IntPtr* region, ref IntPtr image_row_pitch, ref IntPtr image_slice_pitch, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event, [OutAttribute] out int errcode_ret)
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* image_row_pitch_ptr = &image_row_pitch)
            fixed (IntPtr* image_slice_pitch_ptr = &image_slice_pitch)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            fixed (int* errcode_ret_ptr = &errcode_ret)
            {
                System.IntPtr retval = Delegates.clEnqueueMapImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_map, (MapFlags)map_flags, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr*)image_row_pitch_ptr, (IntPtr*)image_slice_pitch_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr, (int*)errcode_ret_ptr);
                errcode_ret = *errcode_ret_ptr;
                return retval;
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapImage")]
        public static 
        unsafe System.IntPtr EnqueueMapImage(IntPtr command_queue, IntPtr image, bool blocking_map, MapFlags map_flags, IntPtr** origin, IntPtr** region, IntPtr* image_row_pitch, IntPtr* image_slice_pitch, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event, [OutAttribute] int* errcode_ret)
        {
            return Delegates.clEnqueueMapImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_map, (MapFlags)map_flags, (IntPtr**)origin, (IntPtr**)region, (IntPtr*)image_row_pitch, (IntPtr*)image_slice_pitch, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event, (int*)errcode_ret);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMapImage")]
        public static 
        unsafe System.IntPtr EnqueueMapImage(IntPtr command_queue, IntPtr image, bool blocking_map, MapFlags map_flags, IntPtr** origin, IntPtr** region, IntPtr* image_row_pitch, IntPtr* image_slice_pitch, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event, [OutAttribute] int* errcode_ret)
        {
            return Delegates.clEnqueueMapImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_map, (MapFlags)map_flags, (IntPtr**)origin, (IntPtr**)region, (IntPtr*)image_row_pitch, (IntPtr*)image_slice_pitch, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event, (int*)errcode_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMarker")]
        public static 
        int EnqueueMarker(IntPtr command_queue, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueMarker((IntPtr)command_queue, (IntPtr*)@event_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMarker")]
        public static 
        int EnqueueMarker(IntPtr command_queue, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueMarker((IntPtr)command_queue, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueMarker")]
        public static 
        unsafe int EnqueueMarker(IntPtr command_queue, IntPtr* @event)
        {
            return Delegates.clEnqueueMarker((IntPtr)command_queue, (IntPtr*)@event);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, IntPtr[] mem_list, IntPtr args_mem_loc, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[] args_mem_loc, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] ref T6 args_mem_loc, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        args_mem_loc = (T6)args_mem_loc_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, ref IntPtr mem_list, IntPtr args_mem_loc, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[] args_mem_loc, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,] args_mem_loc, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] ref T6 args_mem_loc, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        args_mem_loc = (T6)args_mem_loc_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, IntPtr* mem_list, IntPtr args_mem_loc, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[] args_mem_loc, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T6 : struct
        {
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_mem_loc_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T6 : struct
        {
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_mem_loc_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T6 : struct
        {
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_mem_loc_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, Int32 num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] ref T6 args_mem_loc, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T6 : struct
        {
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                args_mem_loc = (T6)args_mem_loc_ptr.Target;
                return retval;
            }
            finally
            {
                args_mem_loc_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, IntPtr[] mem_list, IntPtr args_mem_loc, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[] args_mem_loc, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,] args_mem_loc, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] ref T6 args_mem_loc, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        args_mem_loc = (T6)args_mem_loc_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, ref IntPtr mem_list, IntPtr args_mem_loc, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[] args_mem_loc, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,] args_mem_loc, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] ref T6 args_mem_loc, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        args_mem_loc = (T6)args_mem_loc_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, IntPtr* mem_list, IntPtr args_mem_loc, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[] args_mem_loc, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T6 : struct
        {
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_mem_loc_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,] args_mem_loc, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T6 : struct
        {
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_mem_loc_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T6 : struct
        {
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_mem_loc_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T6>(IntPtr command_queue, IntPtr user_func, IntPtr args, IntPtr cb_args, uint num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] ref T6 args_mem_loc, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T6 : struct
        {
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args, (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                args_mem_loc = (T6)args_mem_loc_ptr.Target;
                return retval;
            }
            finally
            {
                args_mem_loc_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[] args, IntPtr cb_args, Int32 num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[] args, IntPtr cb_args, Int32 num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[] args, IntPtr cb_args, Int32 num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
            where T6 : struct
        {
            GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_ptr.Free();
                args_mem_loc_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[] args, IntPtr cb_args, uint num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[] args, IntPtr cb_args, uint num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[] args, IntPtr cb_args, uint num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
            where T6 : struct
        {
            GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_ptr.Free();
                args_mem_loc_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,] args, IntPtr cb_args, Int32 num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,] args, IntPtr cb_args, Int32 num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,] args, IntPtr cb_args, Int32 num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
            where T6 : struct
        {
            GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_ptr.Free();
                args_mem_loc_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,] args, IntPtr cb_args, uint num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,] args, IntPtr cb_args, uint num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,] args, IntPtr cb_args, uint num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
            where T6 : struct
        {
            GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_ptr.Free();
                args_mem_loc_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,,] args, IntPtr cb_args, Int32 num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,,] args, IntPtr cb_args, Int32 num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,,] args, IntPtr cb_args, Int32 num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
            where T6 : struct
        {
            GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_ptr.Free();
                args_mem_loc_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,,] args, IntPtr cb_args, uint num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,,] args, IntPtr cb_args, uint num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] T2[,,] args, IntPtr cb_args, uint num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
            where T6 : struct
        {
            GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                args_ptr.Free();
                args_mem_loc_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] ref T2 args, IntPtr cb_args, Int32 num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        args = (T2)args_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] ref T2 args, IntPtr cb_args, Int32 num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        args = (T2)args_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] ref T2 args, IntPtr cb_args, Int32 num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
            where T6 : struct
        {
            GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                args = (T2)args_ptr.Target;
                return retval;
            }
            finally
            {
                args_ptr.Free();
                args_mem_loc_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] ref T2 args, IntPtr cb_args, uint num_mem_objects, IntPtr[] mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = mem_list)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        args = (T2)args_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] ref T2 args, IntPtr cb_args, uint num_mem_objects, ref IntPtr mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
            where T6 : struct
        {
            unsafe
            {
                fixed (IntPtr* mem_list_ptr = &mem_list)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
                    GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list_ptr, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        args = (T2)args_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        args_ptr.Free();
                        args_mem_loc_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNativeKernel")]
        public static 
        unsafe int EnqueueNativeKernel<T2,T6>(IntPtr command_queue, IntPtr user_func, [InAttribute, OutAttribute] ref T2 args, IntPtr cb_args, uint num_mem_objects, IntPtr* mem_list, [InAttribute, OutAttribute] T6[,,] args_mem_loc, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
            where T6 : struct
        {
            GCHandle args_ptr = GCHandle.Alloc(args, GCHandleType.Pinned);
            GCHandle args_mem_loc_ptr = GCHandle.Alloc(args_mem_loc, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueNativeKernel((IntPtr)command_queue, (IntPtr)user_func, (IntPtr)args_ptr.AddrOfPinnedObject(), (IntPtr)cb_args, (uint)num_mem_objects, (IntPtr*)mem_list, (IntPtr)args_mem_loc_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                args = (T2)args_ptr.Target;
                return retval;
            }
            finally
            {
                args_ptr.Free();
                args_mem_loc_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNDRangeKernel")]
        public static 
        int EnqueueNDRangeKernel(IntPtr command_queue, IntPtr kernel, Int32 work_dim, IntPtr[] global_work_offset, IntPtr[] global_work_size, IntPtr[] local_work_size, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* global_work_offset_ptr = global_work_offset)
                fixed (IntPtr* global_work_size_ptr = global_work_size)
                fixed (IntPtr* local_work_size_ptr = local_work_size)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueNDRangeKernel((IntPtr)command_queue, (IntPtr)kernel, (uint)work_dim, (IntPtr*)global_work_offset_ptr, (IntPtr*)global_work_size_ptr, (IntPtr*)local_work_size_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNDRangeKernel")]
        public static 
        int EnqueueNDRangeKernel(IntPtr command_queue, IntPtr kernel, Int32 work_dim, ref IntPtr global_work_offset, ref IntPtr global_work_size, ref IntPtr local_work_size, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* global_work_offset_ptr = &global_work_offset)
                fixed (IntPtr* global_work_size_ptr = &global_work_size)
                fixed (IntPtr* local_work_size_ptr = &local_work_size)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueNDRangeKernel((IntPtr)command_queue, (IntPtr)kernel, (uint)work_dim, (IntPtr*)global_work_offset_ptr, (IntPtr*)global_work_size_ptr, (IntPtr*)local_work_size_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNDRangeKernel")]
        public static 
        unsafe int EnqueueNDRangeKernel(IntPtr command_queue, IntPtr kernel, Int32 work_dim, IntPtr* global_work_offset, IntPtr* global_work_size, IntPtr* local_work_size, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueNDRangeKernel((IntPtr)command_queue, (IntPtr)kernel, (uint)work_dim, (IntPtr*)global_work_offset, (IntPtr*)global_work_size, (IntPtr*)local_work_size, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNDRangeKernel")]
        public static 
        int EnqueueNDRangeKernel(IntPtr command_queue, IntPtr kernel, uint work_dim, IntPtr[] global_work_offset, IntPtr[] global_work_size, IntPtr[] local_work_size, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* global_work_offset_ptr = global_work_offset)
                fixed (IntPtr* global_work_size_ptr = global_work_size)
                fixed (IntPtr* local_work_size_ptr = local_work_size)
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueNDRangeKernel((IntPtr)command_queue, (IntPtr)kernel, (uint)work_dim, (IntPtr*)global_work_offset_ptr, (IntPtr*)global_work_size_ptr, (IntPtr*)local_work_size_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNDRangeKernel")]
        public static 
        int EnqueueNDRangeKernel(IntPtr command_queue, IntPtr kernel, uint work_dim, ref IntPtr global_work_offset, ref IntPtr global_work_size, ref IntPtr local_work_size, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* global_work_offset_ptr = &global_work_offset)
                fixed (IntPtr* global_work_size_ptr = &global_work_size)
                fixed (IntPtr* local_work_size_ptr = &local_work_size)
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueNDRangeKernel((IntPtr)command_queue, (IntPtr)kernel, (uint)work_dim, (IntPtr*)global_work_offset_ptr, (IntPtr*)global_work_size_ptr, (IntPtr*)local_work_size_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueNDRangeKernel")]
        public static 
        unsafe int EnqueueNDRangeKernel(IntPtr command_queue, IntPtr kernel, uint work_dim, IntPtr* global_work_offset, IntPtr* global_work_size, IntPtr* local_work_size, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueNDRangeKernel((IntPtr)command_queue, (IntPtr)kernel, (uint)work_dim, (IntPtr*)global_work_offset, (IntPtr*)global_work_size, (IntPtr*)local_work_size, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, IntPtr ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, IntPtr ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        unsafe int EnqueueReadBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, IntPtr ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, IntPtr ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, IntPtr ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        unsafe int EnqueueReadBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, IntPtr ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        unsafe int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        unsafe int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        unsafe int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        unsafe int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        unsafe int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        unsafe int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        ptr = (T5)ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        ptr = (T5)ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        unsafe int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                ptr = (T5)ptr_ptr.Target;
                return retval;
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        ptr = (T5)ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        ptr = (T5)ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadBuffer")]
        public static 
        unsafe int EnqueueReadBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_read, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueReadBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_read, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                ptr = (T5)ptr_ptr.Target;
                return retval;
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr*[] origin, IntPtr*[] region, IntPtr row_pitch, IntPtr slice_pitch, IntPtr ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr*[] origin, IntPtr*[] region, IntPtr row_pitch, IntPtr slice_pitch, IntPtr ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr*[] origin, IntPtr*[] region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr*[] origin, IntPtr*[] region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr*[] origin, IntPtr*[] region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr*[] origin, IntPtr*[] region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr*[] origin, IntPtr*[] region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr*[] origin, IntPtr*[] region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr*[] origin, IntPtr*[] region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    int retval = Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    ptr = (T7)ptr_ptr.Target;
                    return retval;
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr*[] origin, IntPtr*[] region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    int retval = Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    ptr = (T7)ptr_ptr.Target;
                    return retval;
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage(IntPtr command_queue, IntPtr image, bool blocking_read, ref IntPtr* origin, ref IntPtr* region, IntPtr row_pitch, IntPtr slice_pitch, IntPtr ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage(IntPtr command_queue, IntPtr image, bool blocking_read, ref IntPtr* origin, ref IntPtr* region, IntPtr row_pitch, IntPtr slice_pitch, IntPtr ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, ref IntPtr* origin, ref IntPtr* region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, ref IntPtr* origin, ref IntPtr* region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, ref IntPtr* origin, ref IntPtr* region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, ref IntPtr* origin, ref IntPtr* region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, ref IntPtr* origin, ref IntPtr* region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, ref IntPtr* origin, ref IntPtr* region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, ref IntPtr* origin, ref IntPtr* region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    int retval = Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    ptr = (T7)ptr_ptr.Target;
                    return retval;
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, ref IntPtr* origin, ref IntPtr* region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    int retval = Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    ptr = (T7)ptr_ptr.Target;
                    return retval;
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr** origin, IntPtr** region, IntPtr row_pitch, IntPtr slice_pitch, IntPtr ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin, (IntPtr**)region, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr** origin, IntPtr** region, IntPtr row_pitch, IntPtr slice_pitch, IntPtr ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin, (IntPtr**)region, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr** origin, IntPtr** region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin, (IntPtr**)region, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr** origin, IntPtr** region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin, (IntPtr**)region, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr** origin, IntPtr** region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin, (IntPtr**)region, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr** origin, IntPtr** region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin, (IntPtr**)region, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr** origin, IntPtr** region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin, (IntPtr**)region, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr** origin, IntPtr** region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin, (IntPtr**)region, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr** origin, IntPtr** region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin, (IntPtr**)region, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                ptr = (T7)ptr_ptr.Target;
                return retval;
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueReadImage")]
        public static 
        unsafe int EnqueueReadImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_read, IntPtr** origin, IntPtr** region, IntPtr row_pitch, IntPtr slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueReadImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_read, (IntPtr**)origin, (IntPtr**)region, (IntPtr)row_pitch, (IntPtr)slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                ptr = (T7)ptr_ptr.Target;
                return retval;
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueTask")]
        public static 
        int EnqueueTask(IntPtr command_queue, IntPtr kernel, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueTask((IntPtr)command_queue, (IntPtr)kernel, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueTask")]
        public static 
        int EnqueueTask(IntPtr command_queue, IntPtr kernel, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueTask((IntPtr)command_queue, (IntPtr)kernel, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueTask")]
        public static 
        unsafe int EnqueueTask(IntPtr command_queue, IntPtr kernel, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueTask((IntPtr)command_queue, (IntPtr)kernel, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueTask")]
        public static 
        int EnqueueTask(IntPtr command_queue, IntPtr kernel, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueTask((IntPtr)command_queue, (IntPtr)kernel, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueTask")]
        public static 
        int EnqueueTask(IntPtr command_queue, IntPtr kernel, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueTask((IntPtr)command_queue, (IntPtr)kernel, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueTask")]
        public static 
        unsafe int EnqueueTask(IntPtr command_queue, IntPtr kernel, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueTask((IntPtr)command_queue, (IntPtr)kernel, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject(IntPtr command_queue, IntPtr memobj, IntPtr mapped_ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject(IntPtr command_queue, IntPtr memobj, IntPtr mapped_ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        unsafe int EnqueueUnmapMemObject(IntPtr command_queue, IntPtr memobj, IntPtr mapped_ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject(IntPtr command_queue, IntPtr memobj, IntPtr mapped_ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject(IntPtr command_queue, IntPtr memobj, IntPtr mapped_ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        unsafe int EnqueueUnmapMemObject(IntPtr command_queue, IntPtr memobj, IntPtr mapped_ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[] mapped_ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[] mapped_ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        unsafe int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[] mapped_ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
        {
            GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                mapped_ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[] mapped_ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[] mapped_ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        unsafe int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[] mapped_ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
        {
            GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                mapped_ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,] mapped_ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,] mapped_ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        unsafe int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,] mapped_ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
        {
            GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                mapped_ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,] mapped_ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,] mapped_ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        unsafe int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,] mapped_ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
        {
            GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                mapped_ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,,] mapped_ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,,] mapped_ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        unsafe int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,,] mapped_ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
        {
            GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                mapped_ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,,] mapped_ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,,] mapped_ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        unsafe int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] T2[,,] mapped_ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
        {
            GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                mapped_ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] ref T2 mapped_ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        mapped_ptr = (T2)mapped_ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] ref T2 mapped_ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        mapped_ptr = (T2)mapped_ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        unsafe int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] ref T2 mapped_ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
        {
            GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                mapped_ptr = (T2)mapped_ptr_ptr.Target;
                return retval;
            }
            finally
            {
                mapped_ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] ref T2 mapped_ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        mapped_ptr = (T2)mapped_ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] ref T2 mapped_ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T2 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        mapped_ptr = (T2)mapped_ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        mapped_ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueUnmapMemObject")]
        public static 
        unsafe int EnqueueUnmapMemObject<T2>(IntPtr command_queue, IntPtr memobj, [InAttribute, OutAttribute] ref T2 mapped_ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T2 : struct
        {
            GCHandle mapped_ptr_ptr = GCHandle.Alloc(mapped_ptr, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueUnmapMemObject((IntPtr)command_queue, (IntPtr)memobj, (IntPtr)mapped_ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                mapped_ptr = (T2)mapped_ptr_ptr.Target;
                return retval;
            }
            finally
            {
                mapped_ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWaitForEvents")]
        public static 
        int EnqueueWaitForEvents(IntPtr command_queue, Int32 num_events, IntPtr[] event_list)
        {
            unsafe
            {
                fixed (IntPtr* event_list_ptr = event_list)
                {
                    return Delegates.clEnqueueWaitForEvents((IntPtr)command_queue, (uint)num_events, (IntPtr*)event_list_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWaitForEvents")]
        public static 
        int EnqueueWaitForEvents(IntPtr command_queue, Int32 num_events, ref IntPtr event_list)
        {
            unsafe
            {
                fixed (IntPtr* event_list_ptr = &event_list)
                {
                    return Delegates.clEnqueueWaitForEvents((IntPtr)command_queue, (uint)num_events, (IntPtr*)event_list_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWaitForEvents")]
        public static 
        unsafe int EnqueueWaitForEvents(IntPtr command_queue, Int32 num_events, IntPtr* event_list)
        {
            return Delegates.clEnqueueWaitForEvents((IntPtr)command_queue, (uint)num_events, (IntPtr*)event_list);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWaitForEvents")]
        public static 
        int EnqueueWaitForEvents(IntPtr command_queue, uint num_events, IntPtr[] event_list)
        {
            unsafe
            {
                fixed (IntPtr* event_list_ptr = event_list)
                {
                    return Delegates.clEnqueueWaitForEvents((IntPtr)command_queue, (uint)num_events, (IntPtr*)event_list_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWaitForEvents")]
        public static 
        int EnqueueWaitForEvents(IntPtr command_queue, uint num_events, ref IntPtr event_list)
        {
            unsafe
            {
                fixed (IntPtr* event_list_ptr = &event_list)
                {
                    return Delegates.clEnqueueWaitForEvents((IntPtr)command_queue, (uint)num_events, (IntPtr*)event_list_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWaitForEvents")]
        public static 
        unsafe int EnqueueWaitForEvents(IntPtr command_queue, uint num_events, IntPtr* event_list)
        {
            return Delegates.clEnqueueWaitForEvents((IntPtr)command_queue, (uint)num_events, (IntPtr*)event_list);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, IntPtr ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, IntPtr ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        unsafe int EnqueueWriteBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, IntPtr ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, IntPtr ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, IntPtr ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        unsafe int EnqueueWriteBuffer(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, IntPtr ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        unsafe int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        unsafe int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        unsafe int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        unsafe int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        unsafe int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        unsafe int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] T5[,,] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        ptr = (T5)ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        ptr = (T5)ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        unsafe int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                ptr = (T5)ptr_ptr.Target;
                return retval;
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = event_wait_list)
                fixed (IntPtr* @event_ptr = @event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        ptr = (T5)ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T5 : struct
        {
            unsafe
            {
                fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
                fixed (IntPtr* @event_ptr = &@event)
                {
                    GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                        ptr = (T5)ptr_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        ptr_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteBuffer")]
        public static 
        unsafe int EnqueueWriteBuffer<T5>(IntPtr command_queue, IntPtr buffer, bool blocking_write, IntPtr offset, IntPtr cb, [InAttribute, OutAttribute] ref T5 ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T5 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueWriteBuffer((IntPtr)command_queue, (IntPtr)buffer, (bool)blocking_write, (IntPtr)offset, (IntPtr)cb, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                ptr = (T5)ptr_ptr.Target;
                return retval;
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr*[] origin, IntPtr*[] region, IntPtr input_row_pitch, IntPtr input_slice_pitch, IntPtr ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr*[] origin, IntPtr*[] region, IntPtr input_row_pitch, IntPtr input_slice_pitch, IntPtr ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr*[] origin, IntPtr*[] region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr*[] origin, IntPtr*[] region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr*[] origin, IntPtr*[] region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr*[] origin, IntPtr*[] region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr*[] origin, IntPtr*[] region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr*[] origin, IntPtr*[] region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr*[] origin, IntPtr*[] region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, Int32 num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    int retval = Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    ptr = (T7)ptr_ptr.Target;
                    return retval;
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr*[] origin, IntPtr*[] region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, uint num_events_in_wait_list, IntPtr[] event_wait_list, IntPtr[] @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = origin)
            fixed (IntPtr** region_ptr = region)
            fixed (IntPtr* event_wait_list_ptr = event_wait_list)
            fixed (IntPtr* @event_ptr = @event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    int retval = Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    ptr = (T7)ptr_ptr.Target;
                    return retval;
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage(IntPtr command_queue, IntPtr image, bool blocking_write, ref IntPtr* origin, ref IntPtr* region, IntPtr input_row_pitch, IntPtr input_slice_pitch, IntPtr ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage(IntPtr command_queue, IntPtr image, bool blocking_write, ref IntPtr* origin, ref IntPtr* region, IntPtr input_row_pitch, IntPtr input_slice_pitch, IntPtr ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, ref IntPtr* origin, ref IntPtr* region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, ref IntPtr* origin, ref IntPtr* region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, ref IntPtr* origin, ref IntPtr* region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, ref IntPtr* origin, ref IntPtr* region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, ref IntPtr* origin, ref IntPtr* region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, ref IntPtr* origin, ref IntPtr* region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, ref IntPtr* origin, ref IntPtr* region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, Int32 num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    int retval = Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    ptr = (T7)ptr_ptr.Target;
                    return retval;
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, ref IntPtr* origin, ref IntPtr* region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, uint num_events_in_wait_list, ref IntPtr event_wait_list, ref IntPtr @event)
            where T7 : struct
        {
            fixed (IntPtr** origin_ptr = &origin)
            fixed (IntPtr** region_ptr = &region)
            fixed (IntPtr* event_wait_list_ptr = &event_wait_list)
            fixed (IntPtr* @event_ptr = &@event)
            {
                GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
                try
                {
                    int retval = Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin_ptr, (IntPtr**)region_ptr, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list_ptr, (IntPtr*)@event_ptr);
                    ptr = (T7)ptr_ptr.Target;
                    return retval;
                }
                finally
                {
                    ptr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr** origin, IntPtr** region, IntPtr input_row_pitch, IntPtr input_slice_pitch, IntPtr ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin, (IntPtr**)region, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr** origin, IntPtr** region, IntPtr input_row_pitch, IntPtr input_slice_pitch, IntPtr ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
        {
            return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin, (IntPtr**)region, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr, (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr** origin, IntPtr** region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin, (IntPtr**)region, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr** origin, IntPtr** region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin, (IntPtr**)region, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr** origin, IntPtr** region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin, (IntPtr**)region, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr** origin, IntPtr** region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin, (IntPtr**)region, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr** origin, IntPtr** region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin, (IntPtr**)region, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr** origin, IntPtr** region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] T7[,,] ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                return Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin, (IntPtr**)region, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr** origin, IntPtr** region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, Int32 num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin, (IntPtr**)region, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                ptr = (T7)ptr_ptr.Target;
                return retval;
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clEnqueueWriteImage")]
        public static 
        unsafe int EnqueueWriteImage<T7>(IntPtr command_queue, IntPtr image, bool blocking_write, IntPtr** origin, IntPtr** region, IntPtr input_row_pitch, IntPtr input_slice_pitch, [InAttribute, OutAttribute] ref T7 ptr, uint num_events_in_wait_list, IntPtr* event_wait_list, IntPtr* @event)
            where T7 : struct
        {
            GCHandle ptr_ptr = GCHandle.Alloc(ptr, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clEnqueueWriteImage((IntPtr)command_queue, (IntPtr)image, (bool)blocking_write, (IntPtr**)origin, (IntPtr**)region, (IntPtr)input_row_pitch, (IntPtr)input_slice_pitch, (IntPtr)ptr_ptr.AddrOfPinnedObject(), (uint)num_events_in_wait_list, (IntPtr*)event_wait_list, (IntPtr*)@event);
                ptr = (T7)ptr_ptr.Target;
                return retval;
            }
            finally
            {
                ptr_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clFinish")]
        public static 
        int Finish(IntPtr command_queue)
        {
            return Delegates.clFinish((IntPtr)command_queue);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clFlush")]
        public static 
        int Flush(IntPtr command_queue)
        {
            return Delegates.clFlush((IntPtr)command_queue);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        int GetCommandQueueInfo(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        int GetCommandQueueInfo(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        unsafe int GetCommandQueueInfo(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        unsafe int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        unsafe int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        unsafe int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetCommandQueueInfo")]
        public static 
        unsafe int GetCommandQueueInfo<T3>(IntPtr command_queue, CommandQueueInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetCommandQueueInfo((IntPtr)command_queue, (CommandQueueInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T3)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        int GetContextInfo(IntPtr context, ContextInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        int GetContextInfo(IntPtr context, ContextInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        unsafe int GetContextInfo(IntPtr context, ContextInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        unsafe int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        unsafe int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        unsafe int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetContextInfo")]
        public static 
        unsafe int GetContextInfo<T3>(IntPtr context, ContextInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetContextInfo((IntPtr)context, (ContextInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T3)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceIDs")]
        public static 
        int GetDeviceIDs(IntPtr platform, DeviceTypeFlags device_type, Int32 num_entries, IntPtr[] devices, Int32[] num_devices)
        {
            unsafe
            {
                fixed (IntPtr* devices_ptr = devices)
                fixed (Int32* num_devices_ptr = num_devices)
                {
                    return Delegates.clGetDeviceIDs((IntPtr)platform, (DeviceTypeFlags)device_type, (uint)num_entries, (IntPtr*)devices_ptr, (uint*)num_devices_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceIDs")]
        public static 
        int GetDeviceIDs(IntPtr platform, DeviceTypeFlags device_type, Int32 num_entries, ref IntPtr devices, ref Int32 num_devices)
        {
            unsafe
            {
                fixed (IntPtr* devices_ptr = &devices)
                fixed (Int32* num_devices_ptr = &num_devices)
                {
                    return Delegates.clGetDeviceIDs((IntPtr)platform, (DeviceTypeFlags)device_type, (uint)num_entries, (IntPtr*)devices_ptr, (uint*)num_devices_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceIDs")]
        public static 
        unsafe int GetDeviceIDs(IntPtr platform, DeviceTypeFlags device_type, Int32 num_entries, IntPtr* devices, Int32* num_devices)
        {
            return Delegates.clGetDeviceIDs((IntPtr)platform, (DeviceTypeFlags)device_type, (uint)num_entries, (IntPtr*)devices, (uint*)num_devices);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceIDs")]
        public static 
        int GetDeviceIDs(IntPtr platform, DeviceTypeFlags device_type, uint num_entries, IntPtr[] devices, uint[] num_devices)
        {
            unsafe
            {
                fixed (IntPtr* devices_ptr = devices)
                fixed (uint* num_devices_ptr = num_devices)
                {
                    return Delegates.clGetDeviceIDs((IntPtr)platform, (DeviceTypeFlags)device_type, (uint)num_entries, (IntPtr*)devices_ptr, (uint*)num_devices_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceIDs")]
        public static 
        int GetDeviceIDs(IntPtr platform, DeviceTypeFlags device_type, uint num_entries, ref IntPtr devices, ref uint num_devices)
        {
            unsafe
            {
                fixed (IntPtr* devices_ptr = &devices)
                fixed (uint* num_devices_ptr = &num_devices)
                {
                    return Delegates.clGetDeviceIDs((IntPtr)platform, (DeviceTypeFlags)device_type, (uint)num_entries, (IntPtr*)devices_ptr, (uint*)num_devices_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceIDs")]
        public static 
        unsafe int GetDeviceIDs(IntPtr platform, DeviceTypeFlags device_type, uint num_entries, IntPtr* devices, uint* num_devices)
        {
            return Delegates.clGetDeviceIDs((IntPtr)platform, (DeviceTypeFlags)device_type, (uint)num_entries, (IntPtr*)devices, (uint*)num_devices);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        int GetDeviceInfo(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        int GetDeviceInfo(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        unsafe int GetDeviceInfo(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        unsafe int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        unsafe int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        unsafe int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetDeviceInfo")]
        public static 
        unsafe int GetDeviceInfo<T3>(IntPtr device, DeviceInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetDeviceInfo((IntPtr)device, (DeviceInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T3)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        int GetEventInfo(IntPtr @event, EventInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        int GetEventInfo(IntPtr @event, EventInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        unsafe int GetEventInfo(IntPtr @event, EventInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        unsafe int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        unsafe int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        unsafe int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventInfo")]
        public static 
        unsafe int GetEventInfo<T3>(IntPtr @event, EventInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetEventInfo((IntPtr)@event, (EventInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T3)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        int GetEventProfilingInfo(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        int GetEventProfilingInfo(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        unsafe int GetEventProfilingInfo(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        unsafe int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        unsafe int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        unsafe int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetEventProfilingInfo")]
        public static 
        unsafe int GetEventProfilingInfo<T3>(IntPtr @event, ProfilingInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetEventProfilingInfo((IntPtr)@event, (ProfilingInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T3)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        int GetImageInfo(IntPtr image, ImageInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        int GetImageInfo(IntPtr image, ImageInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        unsafe int GetImageInfo(IntPtr image, ImageInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        unsafe int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        unsafe int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        unsafe int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetImageInfo")]
        public static 
        unsafe int GetImageInfo<T3>(IntPtr image, ImageInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetImageInfo((IntPtr)image, (ImageInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T3)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        int GetKernelInfo(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        int GetKernelInfo(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        unsafe int GetKernelInfo(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        unsafe int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        unsafe int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        unsafe int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelInfo")]
        public static 
        unsafe int GetKernelInfo<T3>(IntPtr kernel, KernelInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetKernelInfo((IntPtr)kernel, (KernelInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T3)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        int GetKernelWorkGroupInfo(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        int GetKernelWorkGroupInfo(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        unsafe int GetKernelWorkGroupInfo(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        unsafe int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T4 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        unsafe int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T4 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        unsafe int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T4 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T4 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T4)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T4 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T4)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetKernelWorkGroupInfo")]
        public static 
        unsafe int GetKernelWorkGroupInfo<T4>(IntPtr kernel, IntPtr device, KernelWorkGroupInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T4 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T4 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetKernelWorkGroupInfo((IntPtr)kernel, (IntPtr)device, (KernelWorkGroupInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T4)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        int GetMemObjectInfo(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        int GetMemObjectInfo(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        unsafe int GetMemObjectInfo(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        unsafe int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        unsafe int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        unsafe int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetMemObjectInfo")]
        public static 
        unsafe int GetMemObjectInfo<T3>(IntPtr memobj, MemInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetMemObjectInfo((IntPtr)memobj, (MemInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T3)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformIDs")]
        public static 
        int GetPlatformIDs(Int32 num_entries, IntPtr[] platforms, Int32[] num_platforms)
        {
            unsafe
            {
                fixed (IntPtr* platforms_ptr = platforms)
                fixed (Int32* num_platforms_ptr = num_platforms)
                {
                    return Delegates.clGetPlatformIDs((uint)num_entries, (IntPtr*)platforms_ptr, (uint*)num_platforms_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformIDs")]
        public static 
        int GetPlatformIDs(Int32 num_entries, ref IntPtr platforms, ref Int32 num_platforms)
        {
            unsafe
            {
                fixed (IntPtr* platforms_ptr = &platforms)
                fixed (Int32* num_platforms_ptr = &num_platforms)
                {
                    return Delegates.clGetPlatformIDs((uint)num_entries, (IntPtr*)platforms_ptr, (uint*)num_platforms_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformIDs")]
        public static 
        unsafe int GetPlatformIDs(Int32 num_entries, IntPtr* platforms, Int32* num_platforms)
        {
            return Delegates.clGetPlatformIDs((uint)num_entries, (IntPtr*)platforms, (uint*)num_platforms);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformIDs")]
        public static 
        int GetPlatformIDs(uint num_entries, IntPtr[] platforms, uint[] num_platforms)
        {
            unsafe
            {
                fixed (IntPtr* platforms_ptr = platforms)
                fixed (uint* num_platforms_ptr = num_platforms)
                {
                    return Delegates.clGetPlatformIDs((uint)num_entries, (IntPtr*)platforms_ptr, (uint*)num_platforms_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformIDs")]
        public static 
        int GetPlatformIDs(uint num_entries, ref IntPtr platforms, ref uint num_platforms)
        {
            unsafe
            {
                fixed (IntPtr* platforms_ptr = &platforms)
                fixed (uint* num_platforms_ptr = &num_platforms)
                {
                    return Delegates.clGetPlatformIDs((uint)num_entries, (IntPtr*)platforms_ptr, (uint*)num_platforms_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformIDs")]
        public static 
        unsafe int GetPlatformIDs(uint num_entries, IntPtr* platforms, uint* num_platforms)
        {
            return Delegates.clGetPlatformIDs((uint)num_entries, (IntPtr*)platforms, (uint*)num_platforms);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        int GetPlatformInfo(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        int GetPlatformInfo(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        unsafe int GetPlatformInfo(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        unsafe int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        unsafe int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        unsafe int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetPlatformInfo")]
        public static 
        unsafe int GetPlatformInfo<T3>(IntPtr platform, PlatformInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetPlatformInfo((IntPtr)platform, (PlatformInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T3)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        int GetProgramBuildInfo(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        int GetProgramBuildInfo(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        unsafe int GetProgramBuildInfo(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        unsafe int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T4 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        unsafe int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T4 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        unsafe int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T4[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T4 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T4 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T4)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T4 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T4 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T4)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramBuildInfo")]
        public static 
        unsafe int GetProgramBuildInfo<T4>(IntPtr program, IntPtr device, ProgramBuildInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T4 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T4 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetProgramBuildInfo((IntPtr)program, (IntPtr)device, (ProgramBuildInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T4)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        int GetProgramInfo(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        int GetProgramInfo(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        unsafe int GetProgramInfo(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        unsafe int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        unsafe int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        unsafe int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetProgramInfo")]
        public static 
        unsafe int GetProgramInfo<T3>(IntPtr program, ProgramInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetProgramInfo((IntPtr)program, (ProgramInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T3)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        int GetSamplerInfo(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr[] param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    return Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        int GetSamplerInfo(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] out IntPtr param_value_size_ret)
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    int retval = Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret_ptr);
                    param_value_size_ret = *param_value_size_ret_ptr;
                    return retval;
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        unsafe int GetSamplerInfo(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, IntPtr param_value, [OutAttribute] IntPtr* param_value_size_ret)
        {
            return Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value, (IntPtr*)param_value_size_ret);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        unsafe int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        unsafe int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        return Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        unsafe int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] T3[,,] param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr[] param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] out IntPtr param_value_size_ret)
            where T3 : struct
        {
            unsafe
            {
                fixed (IntPtr* param_value_size_ret_ptr = &param_value_size_ret)
                {
                    GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
                    try
                    {
                        int retval = Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret_ptr);
                        param_value = (T3)param_value_ptr.Target;
                        param_value_size_ret = *param_value_size_ret_ptr;
                        return retval;
                    }
                    finally
                    {
                        param_value_ptr.Free();
                    }
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSamplerInfo")]
        public static 
        unsafe int GetSamplerInfo<T3>(IntPtr sampler, SamplerInfo param_name, IntPtr param_value_size, [InAttribute, OutAttribute] ref T3 param_value, [OutAttribute] IntPtr* param_value_size_ret)
            where T3 : struct
        {
            GCHandle param_value_ptr = GCHandle.Alloc(param_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clGetSamplerInfo((IntPtr)sampler, (SamplerInfo)param_name, (IntPtr)param_value_size, (IntPtr)param_value_ptr.AddrOfPinnedObject(), (IntPtr*)param_value_size_ret);
                param_value = (T3)param_value_ptr.Target;
                return retval;
            }
            finally
            {
                param_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSupportedImageFormats")]
        public static 
        int GetSupportedImageFormats(IntPtr context, MemFlags flags, MemObjectType image_type, Int32 num_entries, ImageFormat[] image_formats, Int32[] num_image_formats)
        {
            unsafe
            {
                fixed (ImageFormat* image_formats_ptr = image_formats)
                fixed (Int32* num_image_formats_ptr = num_image_formats)
                {
                    return Delegates.clGetSupportedImageFormats((IntPtr)context, (MemFlags)flags, (MemObjectType)image_type, (uint)num_entries, (ImageFormat*)image_formats_ptr, (uint*)num_image_formats_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSupportedImageFormats")]
        public static 
        int GetSupportedImageFormats(IntPtr context, MemFlags flags, MemObjectType image_type, Int32 num_entries, ref ImageFormat image_formats, ref Int32 num_image_formats)
        {
            unsafe
            {
                fixed (ImageFormat* image_formats_ptr = &image_formats)
                fixed (Int32* num_image_formats_ptr = &num_image_formats)
                {
                    return Delegates.clGetSupportedImageFormats((IntPtr)context, (MemFlags)flags, (MemObjectType)image_type, (uint)num_entries, (ImageFormat*)image_formats_ptr, (uint*)num_image_formats_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSupportedImageFormats")]
        public static 
        unsafe int GetSupportedImageFormats(IntPtr context, MemFlags flags, MemObjectType image_type, Int32 num_entries, ImageFormat* image_formats, Int32* num_image_formats)
        {
            return Delegates.clGetSupportedImageFormats((IntPtr)context, (MemFlags)flags, (MemObjectType)image_type, (uint)num_entries, (ImageFormat*)image_formats, (uint*)num_image_formats);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSupportedImageFormats")]
        public static 
        int GetSupportedImageFormats(IntPtr context, MemFlags flags, MemObjectType image_type, uint num_entries, ImageFormat[] image_formats, uint[] num_image_formats)
        {
            unsafe
            {
                fixed (ImageFormat* image_formats_ptr = image_formats)
                fixed (uint* num_image_formats_ptr = num_image_formats)
                {
                    return Delegates.clGetSupportedImageFormats((IntPtr)context, (MemFlags)flags, (MemObjectType)image_type, (uint)num_entries, (ImageFormat*)image_formats_ptr, (uint*)num_image_formats_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSupportedImageFormats")]
        public static 
        int GetSupportedImageFormats(IntPtr context, MemFlags flags, MemObjectType image_type, uint num_entries, ref ImageFormat image_formats, ref uint num_image_formats)
        {
            unsafe
            {
                fixed (ImageFormat* image_formats_ptr = &image_formats)
                fixed (uint* num_image_formats_ptr = &num_image_formats)
                {
                    return Delegates.clGetSupportedImageFormats((IntPtr)context, (MemFlags)flags, (MemObjectType)image_type, (uint)num_entries, (ImageFormat*)image_formats_ptr, (uint*)num_image_formats_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clGetSupportedImageFormats")]
        public static 
        unsafe int GetSupportedImageFormats(IntPtr context, MemFlags flags, MemObjectType image_type, uint num_entries, ImageFormat* image_formats, uint* num_image_formats)
        {
            return Delegates.clGetSupportedImageFormats((IntPtr)context, (MemFlags)flags, (MemObjectType)image_type, (uint)num_entries, (ImageFormat*)image_formats, (uint*)num_image_formats);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clReleaseCommandQueue")]
        public static 
        int ReleaseCommandQueue(IntPtr command_queue)
        {
            return Delegates.clReleaseCommandQueue((IntPtr)command_queue);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clReleaseContext")]
        public static 
        int ReleaseContext(IntPtr context)
        {
            return Delegates.clReleaseContext((IntPtr)context);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clReleaseEvent")]
        public static 
        int ReleaseEvent(IntPtr @event)
        {
            return Delegates.clReleaseEvent((IntPtr)@event);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clReleaseKernel")]
        public static 
        int ReleaseKernel(IntPtr kernel)
        {
            return Delegates.clReleaseKernel((IntPtr)kernel);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clReleaseMemObject")]
        public static 
        int ReleaseMemObject(IntPtr memobj)
        {
            return Delegates.clReleaseMemObject((IntPtr)memobj);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clReleaseProgram")]
        public static 
        int ReleaseProgram(IntPtr program)
        {
            return Delegates.clReleaseProgram((IntPtr)program);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clReleaseSampler")]
        public static 
        int ReleaseSampler(IntPtr sampler)
        {
            return Delegates.clReleaseSampler((IntPtr)sampler);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clRetainCommandQueue")]
        public static 
        int RetainCommandQueue(IntPtr command_queue)
        {
            return Delegates.clRetainCommandQueue((IntPtr)command_queue);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clRetainContext")]
        public static 
        int RetainContext(IntPtr context)
        {
            return Delegates.clRetainContext((IntPtr)context);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clRetainEvent")]
        public static 
        int RetainEvent(IntPtr @event)
        {
            return Delegates.clRetainEvent((IntPtr)@event);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clRetainKernel")]
        public static 
        int RetainKernel(IntPtr kernel)
        {
            return Delegates.clRetainKernel((IntPtr)kernel);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clRetainMemObject")]
        public static 
        int RetainMemObject(IntPtr memobj)
        {
            return Delegates.clRetainMemObject((IntPtr)memobj);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clRetainProgram")]
        public static 
        int RetainProgram(IntPtr program)
        {
            return Delegates.clRetainProgram((IntPtr)program);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clRetainSampler")]
        public static 
        int RetainSampler(IntPtr sampler)
        {
            return Delegates.clRetainSampler((IntPtr)sampler);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetCommandQueueProperty")]
        public static 
        int SetCommandQueueProperty(IntPtr command_queue, CommandQueueFlags properties, bool enable, CommandQueueFlags[] old_properties)
        {
            unsafe
            {
                fixed (CommandQueueFlags* old_properties_ptr = old_properties)
                {
                    return Delegates.clSetCommandQueueProperty((IntPtr)command_queue, (CommandQueueFlags)properties, (bool)enable, (CommandQueueFlags*)old_properties_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetCommandQueueProperty")]
        public static 
        int SetCommandQueueProperty(IntPtr command_queue, CommandQueueFlags properties, bool enable, ref CommandQueueFlags old_properties)
        {
            unsafe
            {
                fixed (CommandQueueFlags* old_properties_ptr = &old_properties)
                {
                    return Delegates.clSetCommandQueueProperty((IntPtr)command_queue, (CommandQueueFlags)properties, (bool)enable, (CommandQueueFlags*)old_properties_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetCommandQueueProperty")]
        public static 
        unsafe int SetCommandQueueProperty(IntPtr command_queue, CommandQueueFlags properties, bool enable, CommandQueueFlags* old_properties)
        {
            return Delegates.clSetCommandQueueProperty((IntPtr)command_queue, (CommandQueueFlags)properties, (bool)enable, (CommandQueueFlags*)old_properties);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetKernelArg")]
        public static 
        int SetKernelArg(IntPtr kernel, Int32 arg_index, IntPtr arg_size, IntPtr arg_value)
        {
            return Delegates.clSetKernelArg((IntPtr)kernel, (uint)arg_index, (IntPtr)arg_size, (IntPtr)arg_value);
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetKernelArg")]
        public static 
        int SetKernelArg<T3>(IntPtr kernel, Int32 arg_index, IntPtr arg_size, [InAttribute, OutAttribute] T3[] arg_value)
            where T3 : struct
        {
            GCHandle arg_value_ptr = GCHandle.Alloc(arg_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clSetKernelArg((IntPtr)kernel, (uint)arg_index, (IntPtr)arg_size, (IntPtr)arg_value_ptr.AddrOfPinnedObject());
            }
            finally
            {
                arg_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetKernelArg")]
        public static 
        int SetKernelArg<T3>(IntPtr kernel, Int32 arg_index, IntPtr arg_size, [InAttribute, OutAttribute] T3[,] arg_value)
            where T3 : struct
        {
            GCHandle arg_value_ptr = GCHandle.Alloc(arg_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clSetKernelArg((IntPtr)kernel, (uint)arg_index, (IntPtr)arg_size, (IntPtr)arg_value_ptr.AddrOfPinnedObject());
            }
            finally
            {
                arg_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetKernelArg")]
        public static 
        int SetKernelArg<T3>(IntPtr kernel, Int32 arg_index, IntPtr arg_size, [InAttribute, OutAttribute] T3[,,] arg_value)
            where T3 : struct
        {
            GCHandle arg_value_ptr = GCHandle.Alloc(arg_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clSetKernelArg((IntPtr)kernel, (uint)arg_index, (IntPtr)arg_size, (IntPtr)arg_value_ptr.AddrOfPinnedObject());
            }
            finally
            {
                arg_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetKernelArg")]
        public static 
        int SetKernelArg<T3>(IntPtr kernel, Int32 arg_index, IntPtr arg_size, [InAttribute, OutAttribute] ref T3 arg_value)
            where T3 : struct
        {
            GCHandle arg_value_ptr = GCHandle.Alloc(arg_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clSetKernelArg((IntPtr)kernel, (uint)arg_index, (IntPtr)arg_size, (IntPtr)arg_value_ptr.AddrOfPinnedObject());
                arg_value = (T3)arg_value_ptr.Target;
                return retval;
            }
            finally
            {
                arg_value_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetKernelArg")]
        public static 
        int SetKernelArg(IntPtr kernel, uint arg_index, IntPtr arg_size, IntPtr arg_value)
        {
            return Delegates.clSetKernelArg((IntPtr)kernel, (uint)arg_index, (IntPtr)arg_size, (IntPtr)arg_value);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetKernelArg")]
        public static 
        int SetKernelArg<T3>(IntPtr kernel, uint arg_index, IntPtr arg_size, [InAttribute, OutAttribute] T3[] arg_value)
            where T3 : struct
        {
            GCHandle arg_value_ptr = GCHandle.Alloc(arg_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clSetKernelArg((IntPtr)kernel, (uint)arg_index, (IntPtr)arg_size, (IntPtr)arg_value_ptr.AddrOfPinnedObject());
            }
            finally
            {
                arg_value_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetKernelArg")]
        public static 
        int SetKernelArg<T3>(IntPtr kernel, uint arg_index, IntPtr arg_size, [InAttribute, OutAttribute] T3[,] arg_value)
            where T3 : struct
        {
            GCHandle arg_value_ptr = GCHandle.Alloc(arg_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clSetKernelArg((IntPtr)kernel, (uint)arg_index, (IntPtr)arg_size, (IntPtr)arg_value_ptr.AddrOfPinnedObject());
            }
            finally
            {
                arg_value_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetKernelArg")]
        public static 
        int SetKernelArg<T3>(IntPtr kernel, uint arg_index, IntPtr arg_size, [InAttribute, OutAttribute] T3[,,] arg_value)
            where T3 : struct
        {
            GCHandle arg_value_ptr = GCHandle.Alloc(arg_value, GCHandleType.Pinned);
            try
            {
                return Delegates.clSetKernelArg((IntPtr)kernel, (uint)arg_index, (IntPtr)arg_size, (IntPtr)arg_value_ptr.AddrOfPinnedObject());
            }
            finally
            {
                arg_value_ptr.Free();
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clSetKernelArg")]
        public static 
        int SetKernelArg<T3>(IntPtr kernel, uint arg_index, IntPtr arg_size, [InAttribute, OutAttribute] ref T3 arg_value)
            where T3 : struct
        {
            GCHandle arg_value_ptr = GCHandle.Alloc(arg_value, GCHandleType.Pinned);
            try
            {
                int retval = Delegates.clSetKernelArg((IntPtr)kernel, (uint)arg_index, (IntPtr)arg_size, (IntPtr)arg_value_ptr.AddrOfPinnedObject());
                arg_value = (T3)arg_value_ptr.Target;
                return retval;
            }
            finally
            {
                arg_value_ptr.Free();
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clUnloadCompiler")]
        public static 
        int UnloadCompiler()
        {
            return Delegates.clUnloadCompiler();
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clWaitForEvents")]
        public static 
        int WaitForEvents(Int32 num_events, IntPtr[] event_list)
        {
            unsafe
            {
                fixed (IntPtr* event_list_ptr = event_list)
                {
                    return Delegates.clWaitForEvents((uint)num_events, (IntPtr*)event_list_ptr);
                }
            }
        }

        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clWaitForEvents")]
        public static 
        int WaitForEvents(Int32 num_events, ref IntPtr event_list)
        {
            unsafe
            {
                fixed (IntPtr* event_list_ptr = &event_list)
                {
                    return Delegates.clWaitForEvents((uint)num_events, (IntPtr*)event_list_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clWaitForEvents")]
        public static 
        unsafe int WaitForEvents(Int32 num_events, IntPtr* event_list)
        {
            return Delegates.clWaitForEvents((uint)num_events, (IntPtr*)event_list);
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clWaitForEvents")]
        public static 
        int WaitForEvents(uint num_events, IntPtr[] event_list)
        {
            unsafe
            {
                fixed (IntPtr* event_list_ptr = event_list)
                {
                    return Delegates.clWaitForEvents((uint)num_events, (IntPtr*)event_list_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clWaitForEvents")]
        public static 
        int WaitForEvents(uint num_events, ref IntPtr event_list)
        {
            unsafe
            {
                fixed (IntPtr* event_list_ptr = &event_list)
                {
                    return Delegates.clWaitForEvents((uint)num_events, (IntPtr*)event_list_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "1.0", Version = "1.0", EntryPoint = "clWaitForEvents")]
        public static 
        unsafe int WaitForEvents(uint num_events, IntPtr* event_list)
        {
            return Delegates.clWaitForEvents((uint)num_events, (IntPtr*)event_list);
        }

    }
}

#endif