#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 mortalius
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hammerwatch
# send your bug reports to contact@dotslashplay.it
###

script_version=20230101.2

GAME_ID='hammerwatch'
GAME_NAME='Hammerwatch'

ARCHIVE_BASE_GOG_0='gog_hammerwatch_2.1.0.7.sh'
ARCHIVE_BASE_GOG_0_MD5='2d1f01b73f43e0b6399ab578c52c6cb6'
ARCHIVE_BASE_GOG_0_TYPE='mojosetup'
ARCHIVE_BASE_GOG_0_SIZE='230000'
ARCHIVE_BASE_GOG_0_VERSION='1.32-gog2.1.0.7'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/hammerwatch'

ARCHIVE_BASE_HUMBLE_1='hammerwatch_linux_141.zip'
ARCHIVE_BASE_HUMBLE_1_MD5='a342298f2201a33a616e412b70c4a7f8'
ARCHIVE_BASE_HUMBLE_1_SIZE='230000'
ARCHIVE_BASE_HUMBLE_1_VERSION='1.41-humble180913'
ARCHIVE_BASE_HUMBLE_1_URL='https://www.humblebundle.com/store/hammerwatch'

ARCHIVE_BASE_HUMBLE_0='hammerwatch_linux1.32.zip'
ARCHIVE_BASE_HUMBLE_0_MD5='c31f4053bcde3dc34bc8efe5f232c26e'
ARCHIVE_BASE_HUMBLE_0_SIZE='230000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.32-humble160405'

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE='.'
CONTENT_PATH_DEFAULT_HUMBLE_0='Hammerwatch'
CONTENT_GAME_MAIN_FILES='
editor
levels
mono
assets.bin
Hammerwatch.exe
FarseerPhysicsOTK.dll
Lidgren.Network.dll
Pngcs.dll
SDL2-CS.dll
SDL2-CS.dll.config
ICSharpCode.SharpZipLib.dll
Steamworks.NET.dll
Steamworks.NET.dll.config
TiltedEngine.dll'

APP_MAIN_EXE='Hammerwatch.exe'
APP_MAIN_ICON='Hammerwatch.exe'

USER_PERSISTENT_FILES='
*.txt
*.xml'
USER_PERSISTENT_DIRECTORIES='
levels'

PKG_MAIN_DEPS='mono'
PKG_MAIN_DEPS_DEB='libmono-corlib4.5-cil, libmono-posix4.0-cil, libmono-security4.0-cil, libmono-system4.0-cil, libmono-system-core4.0-cil, libmono-system-configuration4.0-cil, libmono-system-data4.0-cil, libmono-system-drawing4.0-cil, libmono-system-runtime-serialization4.0-cil, libmono-system-security4.0-cil, libmono-system-xml4.0-cil, libmono-system-xml-linq4.0-cil'

# Include shipped libraries that can not be replaced by system ones

CONTENT_LIBS_LIBS32_PATH_GOG="${CONTENT_PATH_DEFAULT_GOG}/lib"
CONTENT_LIBS_LIBS32_PATH_HUMBLE="${CONTENT_PATH_DEFAULT_HUMBLE}/lib"
CONTENT_LIBS_LIBS32_PATH_HUMBLE_0="${CONTENT_PATH_DEFAULT_HUMBLE_0}/lib"
CONTENT_LIBS_LIBS32_FILES='
libCSteamworks.so
libfmod.so
libfmod.so.6
libfmod.so.6.0
libsteam_api.so'
CONTENT_LIBS_LIBS64_PATH_GOG="${CONTENT_PATH_DEFAULT_GOG}/lib64"
CONTENT_LIBS_LIBS64_PATH_HUMBLE="${CONTENT_PATH_DEFAULT_HUMBLE}/lib64"
CONTENT_LIBS_LIBS64_PATH_HUMBLE_0="${CONTENT_PATH_DEFAULT_HUMBLE_0}/lib64"
CONTENT_LIBS_LIBS64_FILES='
libCSteamworks.so
libfmod.so
libfmod.so.6
libfmod.so.6.0
libsteam_api.so'

PACKAGES_LIST='PKG_MAIN PKG_LIBS32 PKG_LIBS64'

PKG_LIBS_ID="${GAME_ID}-libs"

PKG_LIBS32_ID="$PKG_LIBS_ID"
PKG_LIBS32_ARCH='32'
PKG_LIBS32_DEPENDENCIES_LIBRARIES='
ld-linux-x86-64.so.2
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6'

PKG_LIBS64_ID="$PKG_LIBS_ID"
PKG_LIBS64_ARCH='64'
PKG_LIBS64_DEPENDENCIES_LIBRARIES="$PKG_LIBS32_DEPENDENCIES_LIBRARIES"

PKG_MAIN_DEPS="$PKG_MAIN_DEPS $PKG_LIBS_ID"

# Copy the game binary in the prefix

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Copy the game binary in the prefix
cp --remove-destination "${PATH_GAME}/${APP_EXE}" "$APP_EXE"'

# Load common functions

target_version='2.20'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Replace duplicated libraries with symbolic links
	rm \
		'lib/libfmod.so' 'lib/libfmod.so.6' \
		'lib64/libfmod.so' 'lib64/libfmod.so.6'
	ln --symbolic 'libfmod.so.6.0' 'lib/libfmod.so.6'
	ln --symbolic 'libfmod.so.6' 'lib/libfmod.so'
	ln --symbolic 'libfmod.so.6.0' 'lib64/libfmod.so.6'
	ln --symbolic 'libfmod.so.6' 'lib64/libfmod.so'
)

# Include game icons

icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
