/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_PHYSICALASSETCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_PHYSICALASSETCONFORMSTOPROFILEACCESS_H_

#include "PhysicalAsset_Common.h"

#include "OpenDRIM_PhysicalAssetConformsToProfile.h"
#include "assocOpenDRIM_PhysicalAssetConformsToProfile.h"

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_unload(string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PhysicalAssetConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PhysicalAssetConformsToProfile& instance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalAssetConformsToProfile& newInstance, const OpenDRIM_PhysicalAssetConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalAssetConformsToProfile& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalAssetConformsToProfile& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_PhysicalAssetConformsToProfile>& OpenDRIM_PhysicalAssetConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_PhysicalAssetConformsToProfile>& OpenDRIM_PhysicalAssetConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalAssetConformsToProfile_populate(OpenDRIM_PhysicalAssetConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_PHYSICALASSETCONFORMSTOPROFILEACCESS_H_*/
