#!/bin/sh

SPU=0
MODE=dvd
TMP_DIR=/tmp

usage() {
  echo "usage: `basename "${0}"` [options] <xml file> <mpeg file>"
  echo "  -o, --output <output>   Specify the name of the output file (default: mpeg file)"
  echo "  -m, --mode <mode>       Specify the mode (dvd, vcd, svcd, default: dvd)"
  echo "  -s, --spu <n>           Specify the number of the SPU (default: 0)"
  echo "  -t, --tmp <dir>         Specify the temporary directory (default: /tmp)"
  echo "  -h, --help              Show this message"
}

if [ $# -eq 0 ]; then
  usage
  exit 1
fi

while [ $# != 2 ]; do
  case ${1} in
    -o|--output)
      OUT_FILE=${2}
      shift
      ;;
    -m|--mode)
      MODE=${2}
      shift
      ;;
    -s|--spu)
      SPU=${2}
      shift
      ;;
    -t|--tmp)
      TMP_DIR=${2}
      shift
      ;;
    -h|--help)
      usage
      exit 0
      ;;
    *)
      ;;
  esac
  shift
done

XML_FILE=${1}
if [ ! -f "${XML_FILE}" ]; then
  echo "${XML_FILE}: No such file" > /dev/stderr
  exit 1
fi

MPEG_FILE=${2}
if [ ! -f "${MPEG_FILE}" ]; then
  echo "${MPEG_FILE}: No such file" > /dev/stderr
  exit 1
fi

if [ -z "${OUT_FILE}" ]; then
  OUT_FILE="${MPEG_FILE}"
else
  if [ -f "${OUT_FILE}" ]; then
    echo "${OUT_FILE}: Already exists" > /dev/stderr
    exit 1
  fi
fi

if [ ! -d "${TMP_DIR}" ]; then
  echo "${TMP_DIR}: No such directory"
  exit 1
fi

case ${MODE} in
  dvd)
    MODE="d"
    ;;
  vcd)
    MODE="c"
    ;;
  svcd)
    MODE="s"
    ;;
  *)
    echo "${MODE}: No such mode" > /dev/stderr
    exit 1
    ;;
esac

TMP_FILE=`basename "${OUT_FILE}"`
TMP_FILE="${TMP_DIR}/${TMP_FILE}.tmp"

\spumux -P -m ${MODE} -s ${SPU} "${XML_FILE}" < "${MPEG_FILE}" > "${TMP_FILE}"
\mv "${TMP_FILE}" "${OUT_FILE}"

