/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.Keyword;
import edu.harvard.hul.ois.jhove.module.pdf.Numeric;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfProfile;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import java.util.Vector;

public final class LinearizedProfile
extends PdfProfile {
    public LinearizedProfile(PdfModule pdfModule) {
        super(pdfModule);
        this._profileText = "Linearized PDF";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean satisfiesThisProfile() {
        try {
            long l = this._raf.length();
            PdfObject pdfObject = this.findFirstObject();
            if (!(pdfObject instanceof PdfDictionary)) {
                return false;
            }
            PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
            if (pdfDictionary.get("Linearized") == null) return false;
            PdfObject pdfObject2 = pdfDictionary.get("L");
            if (!(pdfObject2 instanceof PdfSimpleObject)) return false;
            Object object = ((PdfSimpleObject)pdfObject2).getToken();
            if (!(object instanceof Numeric)) return false;
            long l2 = ((Numeric)object).getLongValue();
            if (l2 != l) {
                return false;
            }
            pdfObject2 = (PdfArray)pdfDictionary.get("H");
            if (pdfObject2 == null) return false;
            object = ((PdfArray)pdfObject2).getContent();
            int n = ((Vector)object).size();
            if (n != 2 && n != 4) {
                return false;
            }
            for (int i = 0; i < n; i += 2) {
                long l3;
                PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)this._module.resolveIndirectObject((PdfObject)((Vector)object).elementAt(i));
                Numeric numeric = (Numeric)pdfSimpleObject.getToken();
                long l4 = numeric.getLongValue();
                if (l4 + (l3 = (numeric = (Numeric)(pdfSimpleObject = (PdfSimpleObject)((Vector)object).elementAt(i + 1)).getToken()).getLongValue()) > l) {
                    return false;
                }
                this._parser.seek(l4);
                PdfObject pdfObject3 = this._parser.readObject();
                if (pdfObject3 instanceof PdfSimpleObject) {
                    this._parser.readObject();
                    this._parser.readObject();
                    pdfObject3 = this._parser.readObject();
                }
                if (!(pdfObject3 instanceof PdfDictionary)) {
                    return false;
                }
                if (this.validateHintStream((PdfDictionary)pdfObject3)) continue;
                return false;
            }
            object = (PdfSimpleObject)pdfDictionary.get("O");
            if (!(((PdfSimpleObject)object).getToken() instanceof Numeric)) {
                return false;
            }
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("E");
            Numeric numeric = (Numeric)pdfSimpleObject.getToken();
            long l5 = numeric.getLongValue();
            if (l5 > l) {
                return false;
            }
            PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary.get("N");
            if (!(pdfSimpleObject2.getToken() instanceof Numeric)) {
                return false;
            }
            PdfSimpleObject pdfSimpleObject3 = (PdfSimpleObject)pdfDictionary.get("T");
            Numeric numeric2 = (Numeric)pdfSimpleObject3.getToken();
            long l6 = numeric2.getLongValue();
            if (this.verifyXRef(l6)) return true;
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private PdfObject findFirstObject() {
        try {
            this._parser.seek(8L);
            do {
                Token token;
                if (!((token = this._parser.getNext()) instanceof Keyword) || !"obj".equals(((Keyword)token).getValue())) continue;
                PdfObject pdfObject = this._parser.readObject();
                if (this._parser.getOffset() <= 1024L) {
                    return pdfObject;
                }
                return null;
            } while (this._parser.getOffset() <= 1024L);
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean verifyXRef(long l) {
        try {
            this._parser.seek(l);
            this._parser.getNext(Numeric.class, "");
            this._parser.getNext(Numeric.class, "");
            this._parser.getNext(Keyword.class, "");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean validateHintStream(PdfDictionary pdfDictionary) {
        try {
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("S");
            if (pdfSimpleObject == null) {
                return false;
            }
            int n = pdfSimpleObject.getIntValue();
            if (n < 0) {
                return false;
            }
            pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("T");
            if (pdfSimpleObject != null && (n = pdfSimpleObject.getIntValue()) < 0) {
                return false;
            }
            pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("O");
            if (pdfSimpleObject != null && (n = pdfSimpleObject.getIntValue()) < 0) {
                return false;
            }
            pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("A");
            if (pdfSimpleObject != null && (n = pdfSimpleObject.getIntValue()) < 0) {
                return false;
            }
            pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("E");
            if (pdfSimpleObject != null && (n = pdfSimpleObject.getIntValue()) < 0) {
                return false;
            }
            pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("V");
            if (pdfSimpleObject != null && (n = pdfSimpleObject.getIntValue()) < 0) {
                return false;
            }
            pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("I");
            if (pdfSimpleObject != null && (n = pdfSimpleObject.getIntValue()) < 0) {
                return false;
            }
            pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("L");
            if (pdfSimpleObject != null && (n = pdfSimpleObject.getIntValue()) < 0) {
                return false;
            }
            pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("C");
            return pdfSimpleObject == null || (n = pdfSimpleObject.getIntValue()) >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

