/*
* Copyright (c) 2017, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     media_interfaces_g11_icllp.h
//! \brief    All interfaces used for ICLLP that require factory creation
//!

#ifndef __MEDIA_INTERFACES_G11_ICLLP_H__
#define __MEDIA_INTERFACES_G11_ICLLP_H__

#include "media_interfaces_mhw.h"
#include "media_interfaces_codechal.h"
#include "media_interfaces_mmd.h"

#include "media_interfaces_cmhal.h"

#include "media_interfaces_vphal.h"
#include "media_interfaces_renderhal.h"
#include "media_interfaces_nv12top010.h"
#include "media_interfaces_decode_histogram.h"
#include "media_interfaces_hwinfo_device.h"

#include "mhw_cp_interface.h"
#include "mhw_mi_g11_X.h"
#include "mhw_render_g11_X.h"
#include "mhw_sfc_g11_X.h"
#include "mhw_state_heap_g11.h"
#include "mhw_vebox_g11_X.h"
#include "mhw_vdbox_mfx_g11_X.h"
#include "mhw_vdbox_hcp_g11_X.h"
#include "mhw_vdbox_huc_g11_X.h"
#include "mhw_vdbox_vdenc_g11_X.h"

#include "codechal_hw_g11_X.h"

#ifdef _AVC_DECODE_SUPPORTED
#include "codechal_decode_avc_g11.h"
#endif

#include "codechal_decode_downsampling_g11_icllp.h"

#ifdef _HEVC_DECODE_SUPPORTED
#include "codechal_decode_hevc_g11.h"
#endif

#ifdef _JPEG_DECODE_SUPPORTED
#include "codechal_decode_jpeg_g11.h"
#endif

#ifdef _MPEG2_DECODE_SUPPORTED
#include "codechal_decode_mpeg2_g11.h"
#endif

#ifdef _VC1_DECODE_SUPPORTED
#include "codechal_decode_vc1_g11.h"
#endif

#ifdef _VP8_DECODE_SUPPORTED
#include "codechal_decode_vp8_g11.h"
#endif

#ifdef _VP9_DECODE_SUPPORTED
#include "codechal_decode_vp9_g11.h"
#endif

#include "codechal_memdecomp_g11_icllp.h"
#ifdef _AVC_ENCODE_VME_SUPPORTED
#include "codechal_encode_avc_g11_lp.h"
#endif
#ifdef _AVC_ENCODE_VDENC_SUPPORTED
#include "codechal_vdenc_avc_g11_lp.h"
#endif
#include "codechal_encode_sfc.h"
#include "codechal_encode_csc_ds_g11.h"

#ifdef _VP9_ENCODE_VDENC_SUPPORTED
#include "codechal_vdenc_vp9_g11.h"
#endif

#ifdef _JPEG_ENCODE_SUPPORTED
#include "codechal_encode_jpeg_g11.h"
#endif

#ifdef _MPEG2_ENCODE_VME_SUPPORTED
#include "codechal_encode_mpeg2_g11.h"
#endif

#ifdef _HEVC_ENCODE_VME_SUPPORTED
#include "codechal_encode_hevc_g11.h"
#endif
#ifdef _HEVC_ENCODE_VDENC_SUPPORTED
#include "codechal_vdenc_hevc_g11.h"
#endif

#ifdef _VP8_ENCODE_SUPPORTED
#include "codechal_encode_vp8_g11.h"
#endif

#include "cm_hal_g11.h"

#include "mos_util_user_interface.h"
#include "vphal_g11_icllp.h"

#include "renderhal_g11.h"

#include "codechal_decode_histogram_vebox_g11.h"

class MhwInterfacesG11Icllp : public MhwInterfaces
{
public:
    using Mi = MhwMiInterfaceG11;
    using Cp = MhwCpInterface;
    using Render = MhwRenderInterfaceG11;
    using Sfc = MhwSfcInterfaceG11;
    using StateHeap = MHW_STATE_HEAP_INTERFACE_G11_X;
    using Mfx = MhwVdboxMfxInterfaceG11;
    using Hcp = MhwVdboxHcpInterfaceG11;
    using Huc = MhwVdboxHucInterfaceG11;
    using Vdenc = MhwVdboxVdencInterfaceG11Icl;
    using Vebox = MhwVeboxInterfaceG11;

    MOS_STATUS Initialize(
        CreateParams params,
        PMOS_INTERFACE osInterface);
};

class MmdDeviceG11Icllp : public MmdDevice
{
public:
    using Mmd  = MediaMemDecompStateIcllp;

    MOS_STATUS Initialize(
        PMOS_INTERFACE osInterface,
        MhwInterfaces *mhwInterfaces);
};

class Nv12ToP010DeviceG11Icllp : public Nv12ToP010Device
{
public:

    MOS_STATUS Initialize(
        PMOS_INTERFACE osInterface);
};

class CodechalDecodeInterfacesG11Icllp
{
public:
#ifdef _AVC_DECODE_SUPPORTED
    using Avc = CodechalDecodeAvcG11;
#endif
#ifdef _HEVC_DECODE_SUPPORTED
    using Hevc = CodechalDecodeHevcG11;
#endif
#ifdef _JPEG_DECODE_SUPPORTED
    using Jpeg = CodechalDecodeJpegG11;
#endif
#ifdef _MPEG2_DECODE_SUPPORTED
    using Mpeg2 = CodechalDecodeMpeg2G11;
#endif
#ifdef _VC1_DECODE_SUPPORTED
    using Vc1 = CodechalDecodeVc1G11;
#endif
#ifdef _VP8_DECODE_SUPPORTED
    using Vp8 = CodechalDecodeVp8G11;
#endif
#ifdef _VP9_DECODE_SUPPORTED
    using Vp9 = CodechalDecodeVp9G11;
#endif
#ifdef _DECODE_PROCESSING_SUPPORTED
    using FieldScaling = FieldScalingInterfaceG11IclLp;
#endif
};

class CodechalEncodeInterfacesG11Icllp
{
public:
#ifdef _AVC_ENCODE_VME_SUPPORTED
    using AvcEnc = CodechalEncodeAvcEncG11LP;
#endif
#ifdef _AVC_ENCODE_VDENC_SUPPORTED
    using AvcVdenc = CodechalVdencAvcStateG11LP;
#endif
    using CscDs = CodechalEncodeCscDsG11;
#ifdef _VP9_ENCODE_VDENC_SUPPORTED
    using Vp9 = CodechalVdencVp9StateG11;
#endif
#ifdef _JPEG_ENCODE_SUPPORTED
    using Jpeg = CodechalEncodeJpegStateG11;
#endif
#ifdef _MPEG2_ENCODE_VME_SUPPORTED
    using Mpeg2 = CodechalEncodeMpeg2G11;
#endif
#ifdef _HEVC_ENCODE_VME_SUPPORTED
    using HevcEnc = CodechalEncHevcStateG11;
#endif
#ifdef _HEVC_ENCODE_VDENC_SUPPORTED
    using HevcVdenc = CodechalVdencHevcStateG11;
#endif
#ifdef _VP8_ENCODE_SUPPORTED
    using Vp8 = CodechalEncodeVp8G11;
#endif
};

class CodechalInterfacesG11Icllp : public CodechalDevice
{
public:
    using Decode = CodechalDecodeInterfacesG11Icllp;
    using Hw = CodechalHwInterfaceG11;
    using Encode = CodechalEncodeInterfacesG11Icllp;

    MOS_STATUS Initialize(
        void *standardInfo,
        void *settings,
        MhwInterfaces *mhwInterfaces,
        PMOS_INTERFACE osInterface) override;
};


class CMHalInterfacesG11Icllp : public CMHalDevice
{
protected:
    using CMHal = CM_HAL_G11_X;
    MOS_STATUS Initialize(
        CM_HAL_STATE *pCmState);
};

class VphalInterfacesG11Icllp : public VphalDevice
{
public:
    using VphalState = VphalStateG11Icllp;

    MOS_STATUS Initialize(
        PMOS_INTERFACE  osInterface,
        bool            bInitVphalState,
        MOS_STATUS      *eStatus,
        bool            clearViewMode = false);
};

class RenderHalInterfacesG11Icllp : public RenderHalDevice
{
protected:
    using XRenderHal = XRenderHal_Interface_g11;
    MOS_STATUS Initialize();
};

class DecodeHistogramDeviceG11Icllp : public DecodeHistogramDevice
{
public:
    using DecodeHistogramVebox = CodechalDecodeHistogramVeboxG11;

    MOS_STATUS Initialize(
        CodechalHwInterface *hwInterface,
        PMOS_INTERFACE osInterface);
};

class MediaInterfacesHwInfoDeviceG11Icllp : public MediaInterfacesHwInfoDevice
{
public:
    MOS_STATUS Initialize(PLATFORM platform);
};

#endif // __MEDIA_INTERFACES_G11_ICLLP_H__
