/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.haplotypeBAMWriter;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.gatk.utils.haplotype.Haplotype;
import org.broadinstitute.gatk.utils.haplotypeBAMWriter.HaplotypeBAMWriter;
import org.broadinstitute.gatk.utils.haplotypeBAMWriter.ReadDestination;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

class CalledHaplotypeBAMWriter
extends HaplotypeBAMWriter {
    public CalledHaplotypeBAMWriter(ReadDestination destination) {
        super(destination);
    }

    @Override
    public void writeReadsAlignedToHaplotypes(Collection<Haplotype> haplotypes, GenomeLoc paddedReferenceLoc, Collection<Haplotype> bestHaplotypes, Set<Haplotype> calledHaplotypes, Map<String, PerReadAlleleLikelihoodMap> stratifiedReadMap) {
        if (calledHaplotypes.isEmpty()) {
            return;
        }
        this.writeHaplotypesAsReads(calledHaplotypes, calledHaplotypes, paddedReferenceLoc);
        for (PerReadAlleleLikelihoodMap readAlleleLikelihoodMap : stratifiedReadMap.values()) {
            for (GATKSAMRecord read : readAlleleLikelihoodMap.getLikelihoodReadMap().keySet()) {
                this.writeReadAgainstHaplotype(read);
            }
        }
    }
}

