/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import java.io.File;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTag;
import net.sf.samtools.SAMUtils;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.collections.NestedIntegerArray;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.recalibration.QuantizationInfo;
import org.broadinstitute.sting.utils.recalibration.ReadCovariates;
import org.broadinstitute.sting.utils.recalibration.RecalDatum;
import org.broadinstitute.sting.utils.recalibration.RecalUtils;
import org.broadinstitute.sting.utils.recalibration.RecalibrationReport;
import org.broadinstitute.sting.utils.recalibration.RecalibrationTables;
import org.broadinstitute.sting.utils.recalibration.covariates.Covariate;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class BaseRecalibration {
    private static final int MAXIMUM_RECALIBRATED_READ_LENGTH = 5000;
    private final QuantizationInfo quantizationInfo;
    private final RecalibrationTables recalibrationTables;
    private final Covariate[] requestedCovariates;
    private final boolean disableIndelQuals;
    private final int preserveQLessThan;
    private final boolean emitOriginalQuals;

    public BaseRecalibration(File RECAL_FILE, int quantizationLevels, boolean disableIndelQuals, int preserveQLessThan, boolean emitOriginalQuals) {
        RecalibrationReport recalibrationReport = new RecalibrationReport(RECAL_FILE);
        this.recalibrationTables = recalibrationReport.getRecalibrationTables();
        this.requestedCovariates = recalibrationReport.getRequestedCovariates();
        this.quantizationInfo = recalibrationReport.getQuantizationInfo();
        if (quantizationLevels == 0) {
            this.quantizationInfo.noQuantization();
        } else if (quantizationLevels > 0 && quantizationLevels != this.quantizationInfo.getQuantizationLevels()) {
            this.quantizationInfo.quantizeQualityScores(quantizationLevels);
        }
        this.disableIndelQuals = disableIndelQuals;
        this.preserveQLessThan = preserveQLessThan;
        this.emitOriginalQuals = emitOriginalQuals;
    }

    public void recalibrateRead(GATKSAMRecord read) {
        if (this.emitOriginalQuals && read.getAttribute(SAMTag.OQ.name()) == null) {
            try {
                read.setAttribute(SAMTag.OQ.name(), SAMUtils.phredToFastq((byte[])read.getBaseQualities()));
            }
            catch (IllegalArgumentException e) {
                throw new UserException.MalformedBAM((SAMRecord)read, "illegal base quality encountered; " + e.getMessage());
            }
        }
        ReadCovariates readCovariates = RecalUtils.computeCovariates(read, this.requestedCovariates);
        for (EventType errorModel : EventType.values()) {
            if (this.disableIndelQuals && errorModel != EventType.BASE_SUBSTITUTION) {
                read.setBaseQualities(null, errorModel);
                continue;
            }
            byte[] quals = read.getBaseQualities(errorModel);
            int[][] fullReadKeySet = readCovariates.getKeySet(errorModel);
            int readLength = read.getReadLength();
            for (int offset = 0; offset < readLength; ++offset) {
                byte recalibratedQualityScore;
                byte originalQualityScore = quals[offset];
                if (originalQualityScore < this.preserveQLessThan) continue;
                int[] keySet = fullReadKeySet[offset];
                quals[offset] = recalibratedQualityScore = this.performSequentialQualityCalculation(keySet, errorModel);
            }
            read.setBaseQualities(quals, errorModel);
        }
    }

    private byte performSequentialQualityCalculation(int[] key, EventType errorModel) {
        byte qualFromRead = (byte)key[1];
        double globalDeltaQ = this.calculateGlobalDeltaQ(this.recalibrationTables.getReadGroupTable(), key, errorModel);
        double deltaQReported = this.calculateDeltaQReported(this.recalibrationTables.getQualityScoreTable(), key, errorModel, globalDeltaQ, qualFromRead);
        double deltaQCovariates = this.calculateDeltaQCovariates(this.recalibrationTables, key, errorModel, globalDeltaQ, deltaQReported, qualFromRead);
        double recalibratedQual = (double)qualFromRead + globalDeltaQ + deltaQReported + deltaQCovariates;
        recalibratedQual = QualityUtils.boundQual(MathUtils.fastRound(recalibratedQual), (byte)93);
        return this.quantizationInfo.getQuantizedQuals().get((int)recalibratedQual);
    }

    private double calculateGlobalDeltaQ(NestedIntegerArray<RecalDatum> table, int[] key, EventType errorModel) {
        double result = 0.0;
        RecalDatum empiricalQualRG = table.get(key[0], errorModel.index);
        if (empiricalQualRG != null) {
            double globalDeltaQEmpirical = empiricalQualRG.getEmpiricalQuality();
            double aggregrateQReported = empiricalQualRG.getEstimatedQReported();
            result = globalDeltaQEmpirical - aggregrateQReported;
        }
        return result;
    }

    private double calculateDeltaQReported(NestedIntegerArray<RecalDatum> table, int[] key, EventType errorModel, double globalDeltaQ, byte qualFromRead) {
        double result = 0.0;
        RecalDatum empiricalQualQS = table.get(key[0], key[1], errorModel.index);
        if (empiricalQualQS != null) {
            double deltaQReportedEmpirical = empiricalQualQS.getEmpiricalQuality();
            result = deltaQReportedEmpirical - (double)qualFromRead - globalDeltaQ;
        }
        return result;
    }

    private double calculateDeltaQCovariates(RecalibrationTables recalibrationTables, int[] key, EventType errorModel, double globalDeltaQ, double deltaQReported, byte qualFromRead) {
        double result = 0.0;
        for (int i = 2; i < this.requestedCovariates.length; ++i) {
            if (key[i] < 0) continue;
            RecalDatum empiricalQualCO = recalibrationTables.getTable(i).get(key[0], key[1], key[i], errorModel.index);
            if (empiricalQualCO == null) continue;
            double deltaQCovariateEmpirical = empiricalQualCO.getEmpiricalQuality();
            result += deltaQCovariateEmpirical - (double)qualFromRead - (globalDeltaQ + deltaQReported);
        }
        return result;
    }
}

