/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.nanoScheduler;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.MultiThreadedErrorTracker;
import org.broadinstitute.sting.utils.SimpleTimer;
import org.broadinstitute.sting.utils.nanoScheduler.MapResult;
import org.broadinstitute.sting.utils.nanoScheduler.NSReduceFunction;

class Reducer<MapType, ReduceType> {
    private static final Logger logger = Logger.getLogger(Reducer.class);
    private static final int UNSET_NUM_SUBMITTED_JOBS = -2;
    final CountDownLatch countDownLatch = new CountDownLatch(1);
    final NSReduceFunction<MapType, ReduceType> reduce;
    final SimpleTimer reduceTimer;
    final MultiThreadedErrorTracker errorTracker;
    ReduceType sum;
    int numSubmittedJobs = -2;
    int prevJobID = -1;
    int numJobsReduced = 0;

    public Reducer(NSReduceFunction<MapType, ReduceType> reduce, MultiThreadedErrorTracker errorTracker, SimpleTimer reduceTimer, ReduceType initialSum) {
        if (errorTracker == null) {
            throw new IllegalArgumentException("Error tracker cannot be null");
        }
        if (reduce == null) {
            throw new IllegalArgumentException("Reduce function cannot be null");
        }
        if (reduceTimer == null) {
            throw new IllegalArgumentException("reduceTimer cannot be null");
        }
        this.errorTracker = errorTracker;
        this.reduce = reduce;
        this.reduceTimer = reduceTimer;
        this.sum = initialSum;
    }

    @Requires(value={"mapResultQueue != null"})
    private synchronized boolean reduceNextValueInQueue(PriorityBlockingQueue<MapResult<MapType>> mapResultQueue) {
        MapResult<MapType> nextMapResult = mapResultQueue.peek();
        if (nextMapResult == null) {
            return false;
        }
        if (nextMapResult.getJobID() < this.prevJobID + 1) {
            throw new IllegalStateException("Next job ID " + nextMapResult.getJobID() + " is < previous job id " + this.prevJobID);
        }
        return nextMapResult.getJobID() == this.prevJobID + 1;
    }

    @Ensures(value={"result >= 0"})
    public synchronized int reduceAsMuchAsPossible(PriorityBlockingQueue<MapResult<MapType>> mapResultQueue) {
        if (mapResultQueue == null) {
            throw new IllegalArgumentException("mapResultQueue cannot be null");
        }
        int nReducesNow = 0;
        try {
            while (this.reduceNextValueInQueue(mapResultQueue)) {
                MapResult<MapType> result = mapResultQueue.take();
                this.prevJobID = result.getJobID();
                if (!result.isEOFMarker()) {
                    ++nReducesNow;
                    this.reduceTimer.restart();
                    this.sum = this.reduce.apply(result.getValue(), this.sum);
                    this.reduceTimer.stop();
                }
                ++this.numJobsReduced;
                this.maybeReleaseLatch();
            }
        }
        catch (Exception ex) {
            this.errorTracker.notifyOfError(ex);
            this.countDownLatch.countDown();
        }
        return nReducesNow;
    }

    private synchronized void maybeReleaseLatch() {
        if (this.numJobsReduced == this.numSubmittedJobs) {
            this.countDownLatch.countDown();
        }
    }

    protected synchronized boolean latchIsReleased() {
        return this.countDownLatch.getCount() == 0L;
    }

    public synchronized void setTotalJobCount(int numOfSubmittedJobs) {
        if (numOfSubmittedJobs < 0) {
            throw new IllegalArgumentException("numOfSubmittedJobs must be >= 0, but saw " + numOfSubmittedJobs);
        }
        if (this.numSubmittedJobs != -2) {
            throw new IllegalStateException("setlastJobID called multiple times, but should only be called once");
        }
        this.numSubmittedJobs = numOfSubmittedJobs;
        this.maybeReleaseLatch();
    }

    public ReduceType waitForFinalReduce() throws InterruptedException {
        this.countDownLatch.await();
        return this.sum;
    }
}

