/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.io;

import java.io.IOException;
import org.apache.commons.io.output.ThresholdingOutputStream;

public abstract class HardThresholdingOutputStream
extends ThresholdingOutputStream {
    protected HardThresholdingOutputStream(int threshold) {
        super(threshold);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int remaining = this.getThreshold() - (int)this.getByteCount();
        if (!this.isThresholdExceeded() && len > remaining) {
            super.write(b, off, remaining);
            super.write(b, off + remaining, len - remaining);
        } else {
            super.write(b, off, len);
        }
    }
}

