/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.Iterator;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTag;

public class SamPairUtil {
    public static PairOrientation getPairOrientation(SAMRecord r) {
        boolean readIsOnReverseStrand = r.getReadNegativeStrandFlag();
        if (r.getReadUnmappedFlag() || !r.getReadPairedFlag() || r.getMateUnmappedFlag()) {
            throw new IllegalArgumentException("Invalid SAMRecord: " + r.getReadName() + ". This method only works for SAMRecords " + "that are paired reads with both reads aligned.");
        }
        if (readIsOnReverseStrand == r.getMateNegativeStrandFlag()) {
            return PairOrientation.TANDEM;
        }
        long positiveStrandFivePrimePos = readIsOnReverseStrand ? r.getMateAlignmentStart() : r.getAlignmentStart();
        long negativeStrandFivePrimePos = readIsOnReverseStrand ? r.getAlignmentEnd() : r.getAlignmentStart() + r.getInferredInsertSize();
        return positiveStrandFivePrimePos < negativeStrandFivePrimePos ? PairOrientation.FR : PairOrientation.RF;
    }

    public static boolean isProperPair(SAMRecord firstEnd, SAMRecord secondEnd, List<PairOrientation> expectedOrientations) {
        if (firstEnd.getReadUnmappedFlag() || secondEnd.getReadUnmappedFlag()) {
            return false;
        }
        if (firstEnd.getReferenceName().equals("*")) {
            return false;
        }
        if (!firstEnd.getReferenceName().equals(secondEnd.getReferenceName())) {
            return false;
        }
        PairOrientation actual = SamPairUtil.getPairOrientation(firstEnd);
        return expectedOrientations.contains((Object)actual);
    }

    public static void assertMate(SAMRecord firstOfPair, SAMRecord secondOfPair) {
        if (firstOfPair == null) {
            throw new PicardException("First record does not exist - cannot perform mate assertion!");
        }
        if (secondOfPair == null) {
            throw new PicardException(firstOfPair.toString() + " is missing its mate");
        }
        if (!firstOfPair.getReadPairedFlag()) {
            throw new PicardException("First record is not marked as paired: " + firstOfPair.toString());
        }
        if (!secondOfPair.getReadPairedFlag()) {
            throw new PicardException("Second record is not marked as paired: " + secondOfPair.toString());
        }
        if (!firstOfPair.getFirstOfPairFlag()) {
            throw new PicardException("First record is not marked as first of pair: " + firstOfPair.toString());
        }
        if (!secondOfPair.getSecondOfPairFlag()) {
            throw new PicardException("Second record is not marked as second of pair: " + secondOfPair.toString());
        }
        if (!firstOfPair.getReadName().equals(secondOfPair.getReadName())) {
            throw new PicardException("First [" + firstOfPair.getReadName() + "] and Second [" + secondOfPair.getReadName() + "] readnames do not match!");
        }
    }

    public static SAMRecord obtainAssertedMate(Iterator<SAMRecord> samRecordIterator, SAMRecord firstOfPair) {
        if (samRecordIterator.hasNext()) {
            SAMRecord secondOfPair = samRecordIterator.next();
            SamPairUtil.assertMate(firstOfPair, secondOfPair);
            return secondOfPair;
        }
        throw new PicardException("Second record does not exist: " + firstOfPair.getReadName());
    }

    public static int computeInsertSize(SAMRecord firstEnd, SAMRecord secondEnd) {
        if (firstEnd.getReadUnmappedFlag() || secondEnd.getReadUnmappedFlag()) {
            return 0;
        }
        if (!firstEnd.getReferenceName().equals(secondEnd.getReferenceName())) {
            return 0;
        }
        int firstEnd5PrimePosition = firstEnd.getReadNegativeStrandFlag() ? firstEnd.getAlignmentEnd() : firstEnd.getAlignmentStart();
        int secondEnd5PrimePosition = secondEnd.getReadNegativeStrandFlag() ? secondEnd.getAlignmentEnd() : secondEnd.getAlignmentStart();
        int adjustment = secondEnd5PrimePosition >= firstEnd5PrimePosition ? 1 : -1;
        return secondEnd5PrimePosition - firstEnd5PrimePosition + adjustment;
    }

    public static void setMateInfo(SAMRecord rec1, SAMRecord rec2, SAMFileHeader header) {
        if (!rec1.getReadUnmappedFlag() && !rec2.getReadUnmappedFlag()) {
            rec1.setMateReferenceIndex(rec2.getReferenceIndex().intValue());
            rec1.setMateAlignmentStart(rec2.getAlignmentStart());
            rec1.setMateNegativeStrandFlag(rec2.getReadNegativeStrandFlag());
            rec1.setMateUnmappedFlag(false);
            rec1.setAttribute(SAMTag.MQ.name(), (Object)rec2.getMappingQuality());
            rec2.setMateReferenceIndex(rec1.getReferenceIndex().intValue());
            rec2.setMateAlignmentStart(rec1.getAlignmentStart());
            rec2.setMateNegativeStrandFlag(rec1.getReadNegativeStrandFlag());
            rec2.setMateUnmappedFlag(false);
            rec2.setAttribute(SAMTag.MQ.name(), (Object)rec1.getMappingQuality());
        } else if (rec1.getReadUnmappedFlag() && rec2.getReadUnmappedFlag()) {
            rec1.setReferenceIndex(-1);
            rec1.setAlignmentStart(0);
            rec1.setMateReferenceIndex(-1);
            rec1.setMateAlignmentStart(0);
            rec1.setMateNegativeStrandFlag(rec2.getReadNegativeStrandFlag());
            rec1.setMateUnmappedFlag(true);
            rec1.setAttribute(SAMTag.MQ.name(), null);
            rec1.setInferredInsertSize(0);
            rec2.setReferenceIndex(-1);
            rec2.setAlignmentStart(0);
            rec2.setMateReferenceIndex(-1);
            rec2.setMateAlignmentStart(0);
            rec2.setMateNegativeStrandFlag(rec1.getReadNegativeStrandFlag());
            rec2.setMateUnmappedFlag(true);
            rec2.setAttribute(SAMTag.MQ.name(), null);
            rec2.setInferredInsertSize(0);
        } else {
            SAMRecord mapped = rec1.getReadUnmappedFlag() ? rec2 : rec1;
            SAMRecord unmapped = rec1.getReadUnmappedFlag() ? rec1 : rec2;
            unmapped.setReferenceIndex(mapped.getReferenceIndex().intValue());
            unmapped.setAlignmentStart(mapped.getAlignmentStart());
            mapped.setMateReferenceIndex(unmapped.getReferenceIndex().intValue());
            mapped.setMateAlignmentStart(unmapped.getAlignmentStart());
            mapped.setMateNegativeStrandFlag(unmapped.getReadNegativeStrandFlag());
            mapped.setMateUnmappedFlag(true);
            mapped.setInferredInsertSize(0);
            unmapped.setMateReferenceIndex(mapped.getReferenceIndex().intValue());
            unmapped.setMateAlignmentStart(mapped.getAlignmentStart());
            unmapped.setMateNegativeStrandFlag(mapped.getReadNegativeStrandFlag());
            unmapped.setMateUnmappedFlag(false);
            unmapped.setInferredInsertSize(0);
        }
        int insertSize = SamPairUtil.computeInsertSize(rec1, rec2);
        rec1.setInferredInsertSize(insertSize);
        rec2.setInferredInsertSize(-insertSize);
    }

    public static void setProperPairAndMateInfo(SAMRecord rec1, SAMRecord rec2, SAMFileHeader header, List<PairOrientation> exepectedOrientations) {
        SamPairUtil.setMateInfo(rec1, rec2, header);
        SamPairUtil.setProperPairFlags(rec1, rec2, exepectedOrientations);
    }

    public static void setProperPairFlags(SAMRecord rec1, SAMRecord rec2, List<PairOrientation> exepectedOrientations) {
        boolean properPair = !rec1.getReadUnmappedFlag() && !rec2.getReadUnmappedFlag() ? SamPairUtil.isProperPair(rec1, rec2, exepectedOrientations) : false;
        rec1.setProperPairFlag(properPair);
        rec2.setProperPairFlag(properPair);
    }

    public static enum PairOrientation {
        FR,
        RF,
        TANDEM;

    }
}

