/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.liftover;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.liftover.Chain;
import net.sf.picard.util.Interval;
import net.sf.picard.util.Log;
import net.sf.picard.util.OverlapDetector;
import net.sf.samtools.SAMSequenceDictionary;

public class LiftOver {
    private static final Log LOG = Log.getInstance(LiftOver.class);
    public static final double DEFAULT_LIFTOVER_MINMATCH = 0.95;
    private double liftOverMinMatch = 0.95;
    private final OverlapDetector<Chain> chains;

    public LiftOver(File chainFile) {
        IoUtil.assertFileIsReadable(chainFile);
        this.chains = Chain.loadChains(chainFile);
    }

    public void validateToSequences(SAMSequenceDictionary sequenceDictionary) {
        for (Chain chain : this.chains.getAll()) {
            if (sequenceDictionary.getSequence(chain.toSequenceName) != null) continue;
            throw new PicardException("Sequence " + chain.toSequenceName + " from chain file is not found in sequence dictionary.");
        }
    }

    public Interval liftOver(Interval interval) {
        return this.liftOver(interval, this.liftOverMinMatch);
    }

    public Interval liftOver(Interval interval, double liftOverMinMatch) {
        if (interval.length() == 0) {
            throw new IllegalArgumentException("Zero-length interval cannot be lifted over.  Interval: " + interval.getName());
        }
        Chain chainHit = null;
        TargetIntersection targetIntersection = null;
        double minMatchSize = liftOverMinMatch * (double)interval.length();
        for (Chain chain : this.chains.getOverlaps(interval)) {
            TargetIntersection candidateIntersection = LiftOver.targetIntersection(chain, interval);
            if (candidateIntersection != null && (double)candidateIntersection.intersectionLength >= minMatchSize) {
                if (chainHit != null) {
                    return null;
                }
                chainHit = chain;
                targetIntersection = candidateIntersection;
                continue;
            }
            if (candidateIntersection == null) continue;
            LOG.info("Interval " + interval.getName() + " failed to match chain " + chain.id + " because intersection length " + candidateIntersection.intersectionLength + " < minMatchSize " + minMatchSize + " (" + (float)candidateIntersection.intersectionLength / (float)interval.length() + " < " + liftOverMinMatch + ")");
        }
        if (chainHit == null) {
            return null;
        }
        return LiftOver.createToInterval(interval.getName(), targetIntersection);
    }

    public List<PartialLiftover> diagnosticLiftover(Interval interval) {
        ArrayList<PartialLiftover> ret = new ArrayList<PartialLiftover>();
        if (interval.length() == 0) {
            throw new IllegalArgumentException("Zero-length interval cannot be lifted over.  Interval: " + interval.getName());
        }
        for (Chain chain : this.chains.getOverlaps(interval)) {
            Interval intersectingChain;
            TargetIntersection targetIntersection = LiftOver.targetIntersection(chain, intersectingChain = interval.intersect(chain.interval));
            if (targetIntersection == null) {
                ret.add(new PartialLiftover(intersectingChain, chain.id));
                continue;
            }
            Interval toInterval = LiftOver.createToInterval(interval.getName(), targetIntersection);
            float percentLiftedOver = (float)targetIntersection.intersectionLength / (float)interval.length();
            ret.add(new PartialLiftover(intersectingChain, toInterval, targetIntersection.chain.id, percentLiftedOver));
        }
        return ret;
    }

    private static Interval createToInterval(String intervalName, TargetIntersection targetIntersection) {
        int toStart = targetIntersection.chain.getBlock((int)targetIntersection.firstBlockIndex).toStart + targetIntersection.startOffset;
        int toEnd = targetIntersection.chain.getBlock(targetIntersection.lastBlockIndex).getToEnd() - targetIntersection.offsetFromEnd;
        if (toEnd <= toStart || toStart < 0) {
            throw new PicardException("Something strange lifting over interval " + intervalName);
        }
        if (targetIntersection.chain.toNegativeStrand) {
            int negativeStart = targetIntersection.chain.toSequenceSize - toEnd;
            int negativeEnd = targetIntersection.chain.toSequenceSize - toStart;
            toStart = negativeStart;
            toEnd = negativeEnd;
        }
        return new Interval(targetIntersection.chain.toSequenceName, toStart + 1, toEnd, targetIntersection.chain.toNegativeStrand, intervalName);
    }

    private static TargetIntersection targetIntersection(Chain chain, Interval interval) {
        int intersectionLength = 0;
        int start = interval.getStart() - 1;
        int end = interval.getEnd();
        int firstBlockIndex = -1;
        int lastBlockIndex = -1;
        int startOffset = -1;
        int offsetFromEnd = -1;
        List<Chain.ContinuousBlock> blockList = chain.getBlocks();
        for (int i = 0; i < blockList.size(); ++i) {
            Chain.ContinuousBlock block = blockList.get(i);
            if (block.fromStart >= end) break;
            if (block.getFromEnd() <= start) continue;
            if (firstBlockIndex == -1) {
                firstBlockIndex = i;
                startOffset = start > block.fromStart ? start - block.fromStart : 0;
            }
            lastBlockIndex = i;
            offsetFromEnd = block.getFromEnd() > end ? block.getFromEnd() - end : 0;
            int thisIntersection = Math.min(end, block.getFromEnd()) - Math.max(start, block.fromStart);
            if (thisIntersection <= 0) {
                throw new PicardException("Should have been some intersection.");
            }
            intersectionLength += thisIntersection;
        }
        if (intersectionLength == 0) {
            return null;
        }
        return new TargetIntersection(chain, intersectionLength, startOffset, offsetFromEnd, firstBlockIndex, lastBlockIndex);
    }

    public double getLiftOverMinMatch() {
        return this.liftOverMinMatch;
    }

    public void setLiftOverMinMatch(double liftOverMinMatch) {
        this.liftOverMinMatch = liftOverMinMatch;
    }

    public static class PartialLiftover {
        final Interval fromInterval;
        final Interval toInterval;
        final int chainId;
        final float percentLiftedOver;

        PartialLiftover(Interval fromInterval, Interval toInterval, int chainId, float percentLiftedOver) {
            this.fromInterval = fromInterval;
            this.toInterval = toInterval;
            this.chainId = chainId;
            this.percentLiftedOver = percentLiftedOver;
        }

        PartialLiftover(Interval fromInterval, int chainId) {
            this.fromInterval = fromInterval;
            this.toInterval = null;
            this.chainId = chainId;
            this.percentLiftedOver = 0.0f;
        }

        public String toString() {
            if (this.toInterval == null) {
                return this.fromInterval.toString() + " (len " + this.fromInterval.length() + ")=>null using chain " + this.chainId;
            }
            String strand = this.toInterval.isNegativeStrand() ? "-" : "+";
            return this.fromInterval.toString() + " (len " + this.fromInterval.length() + ")=>" + this.toInterval + "(" + strand + ") using chain " + this.chainId + " ; pct matched " + this.percentLiftedOver;
        }
    }

    private static class TargetIntersection {
        final Chain chain;
        final int intersectionLength;
        final int startOffset;
        final int offsetFromEnd;
        final int firstBlockIndex;
        final int lastBlockIndex;

        TargetIntersection(Chain chain, int intersectionLength, int startOffset, int offsetFromEnd, int firstBlockIndex, int lastBlockIndex) {
            this.chain = chain;
            this.intersectionLength = intersectionLength;
            this.startOffset = startOffset;
            this.offsetFromEnd = offsetFromEnd;
            this.firstBlockIndex = firstBlockIndex;
            this.lastBlockIndex = lastBlockIndex;
        }
    }
}

