/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.cmdline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineParseException;
import net.sf.picard.cmdline.CommandLineParserDefinitionException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.NestedOptions;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.PositionalArguments;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.util.CollectionUtil;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.StringUtil;

public class CommandLineParser {
    private static final int OPTION_COLUMN_WIDTH = 30;
    private static final int DESCRIPTION_COLUMN_WIDTH = 90;
    private static final Boolean[] TRUE_FALSE_VALUES = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    private static final String[] PACKAGES_WITH_WEB_DOCUMENTATION = new String[]{"net.sf.picard"};
    private static final String defaultUsagePreamble = "Usage: program [options...]\n";
    private static final String defaultUsagePreambleWithPositionalArguments = "Usage: program [options...] [positional-arguments...]\n";
    private static final String OPTIONS_FILE = "OPTIONS_FILE";
    private static final String PRECEDENCE_SYMBOL = "++";
    private static final String[][] FRAMEWORK_OPTION_DOC = new String[][]{{"--help", "-h", "Displays options specific to this tool."}, {"--stdhelp", "-H", "Displays options specific to this tool AND options common to all Picard command line tools."}, {"--version", null, "Displays program version."}};
    private final Set<String> optionsThatCannotBeOverridden = new HashSet<String>();
    private final Object callerOptions;
    private final String prefix;
    private final String prefixDot;
    private String usagePreamble;
    private Field positionalArguments;
    private int minPositionalArguments;
    private int maxPositionalArguments;
    private final List<OptionDefinition> optionDefinitions = new ArrayList<OptionDefinition>();
    private final Map<String, OptionDefinition> optionMap = new HashMap<String, OptionDefinition>();
    private final Map<String, CommandLineParser> childOptionsMap = new LinkedHashMap<String, CommandLineParser>();
    private final CollectionUtil.MultiMap<String, ChildOptionArg> childOptionArguments = new CollectionUtil.MultiMap();
    private PrintStream messageStream;
    private String[] argv;
    private String programVersion = "";
    private String commandLine = "";
    public File IGNORE_THIS_PROPERTY;

    public static String getStandardUsagePreamble(Class mainClass) {
        return "USAGE: " + mainClass.getSimpleName() + " [options]\n\n" + (CommandLineParser.hasWebDocumentation(mainClass) ? "Documentation: http://picard.sourceforge.net/command-line-overview.shtml#" + mainClass.getSimpleName() + "\n\n" : "");
    }

    public static boolean hasWebDocumentation(Class clazz) {
        for (String pkg : PACKAGES_WITH_WEB_DOCUMENTATION) {
            if (!clazz.getPackage().getName().startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    public static String getFaqLink() {
        return "To get help, see http://picard.sourceforge.net/index.shtml#GettingHelp";
    }

    static Map<String, Object> getNestedOptions(Object callerOptions) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        Class<?> clazz = callerOptions.getClass();
        for (Field field : CommandLineParser.getAllFields(clazz)) {
            if (field.getAnnotation(NestedOptions.class) == null) continue;
            field.setAccessible(true);
            try {
                ret.put(field.getName(), field.get(callerOptions));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Should never happen.", e);
            }
        }
        return ret;
    }

    public CommandLineParser(Object callerOptions) {
        this(callerOptions, "");
    }

    private CommandLineParser(Object callerOptions, String prefix) {
        this.callerOptions = callerOptions;
        this.prefix = prefix;
        this.prefixDot = prefix.isEmpty() ? "" : prefix + ".";
        for (Field field : CommandLineParser.getAllFields(this.callerOptions.getClass())) {
            if (field.getAnnotation(PositionalArguments.class) != null) {
                this.handlePositionalArgumentAnnotation(field);
            }
            if (field.getAnnotation(Usage.class) != null) {
                this.handleUsageAnnotation(field);
            }
            if (field.getAnnotation(Option.class) != null) {
                this.handleOptionAnnotation(field);
                continue;
            }
            if (this.isCommandLineProgram() || field.getAnnotation(NestedOptions.class) == null) continue;
            this.handleNestedOptionsAnnotation(field);
        }
        if (this.usagePreamble == null) {
            this.usagePreamble = this.positionalArguments == null ? defaultUsagePreamble : defaultUsagePreambleWithPositionalArguments;
        }
    }

    private boolean isCommandLineProgram() {
        return this.callerOptions instanceof CommandLineProgram;
    }

    private static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> ret = new ArrayList<Field>();
        do {
            ret.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return ret;
    }

    public String getVersion() {
        return this.callerOptions.getClass().getPackage().getImplementationVersion();
    }

    public void usage(PrintStream stream, boolean printCommon) {
        if (this.prefix.isEmpty()) {
            stream.print(this.usagePreamble);
            stream.println("\nVersion: " + this.getVersion());
            stream.println("\n\nOptions:\n");
            for (String[] optionDoc : FRAMEWORK_OPTION_DOC) {
                this.printOptionParamUsage(stream, optionDoc[0], optionDoc[1], null, optionDoc[2]);
            }
        }
        if (!this.optionDefinitions.isEmpty()) {
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (!printCommon && optionDefinition.isCommon) continue;
                this.printOptionUsage(stream, optionDefinition);
            }
        }
        if (printCommon) {
            Field fileField;
            try {
                fileField = this.getClass().getField("IGNORE_THIS_PROPERTY");
            }
            catch (NoSuchFieldException e) {
                throw new PicardException("Should never happen", e);
            }
            OptionDefinition optionsFileOptionDefinition = new OptionDefinition(fileField, OPTIONS_FILE, "", "File of OPTION_NAME=value pairs.  No positional parameters allowed.  Unlike command-line options, unrecognized options are ignored.  A single-valued option set in an options file may be overridden by a subsequent command-line option.  A line starting with '#' is considered a comment.", false, true, 0, Integer.MAX_VALUE, null, true, new String[0]);
            this.printOptionUsage(stream, optionsFileOptionDefinition);
        }
        Collection<CommandLineParser> childClps = this.getChildParsersForHelp();
        for (CommandLineParser childClp : childClps) {
            childClp.usage(stream, printCommon);
        }
    }

    private Collection<CommandLineParser> getChildParsersForHelp() {
        ArrayList<CommandLineParser> childClps;
        if (this.isCommandLineProgram()) {
            childClps = new ArrayList();
            for (Map.Entry<String, Object> entry : ((CommandLineProgram)this.callerOptions).getNestedOptionsForHelp().entrySet()) {
                if (entry.getKey().contains(".")) {
                    throw new IllegalArgumentException("Prefix for nested options should not contain period: " + entry.getKey());
                }
                childClps.add(new CommandLineParser(entry.getValue(), this.prefixDot + entry.getKey()));
            }
        } else {
            childClps = this.childOptionsMap.values();
        }
        return childClps;
    }

    public void htmlUsage(PrintStream stream, String programName, boolean printCommon) {
        stream.println("<a name=\"" + programName + "\"/>");
        stream.println("<h3>" + programName + "</h3>");
        stream.println("<p>" + CommandLineParser.htmlEscape(this.usagePreamble) + "</p>");
        boolean hasOptions = false;
        for (OptionDefinition optionDefinition : this.optionDefinitions) {
            if (optionDefinition.isCommon && !printCommon) continue;
            hasOptions = true;
            break;
        }
        if (hasOptions) {
            this.htmlPrintOptions(stream, printCommon);
        }
        stream.println("<br/>");
    }

    public void htmlPrintOptions(PrintStream stream, boolean printCommon) {
        stream.println("<table>");
        stream.println("<tr><th>Option</th><th>Description</th></tr>");
        if (printCommon) {
            for (String[] optionDoc : FRAMEWORK_OPTION_DOC) {
                stream.println("<tr><td>" + optionDoc[0] + "</td><td>" + CommandLineParser.htmlEscape(optionDoc[2]) + "</td></tr>");
            }
        }
        this.htmlPrintOptionTableRows(stream, printCommon);
        stream.println("</table>");
    }

    private void htmlPrintOptionTableRows(PrintStream stream, boolean printCommon) {
        for (OptionDefinition optionDefinition : this.optionDefinitions) {
            if (optionDefinition.isCommon && !printCommon) continue;
            this.printHtmlOptionUsage(stream, optionDefinition);
        }
        for (CommandLineParser childParser : this.getChildParsersForHelp()) {
            childParser.htmlPrintOptionTableRows(stream, false);
        }
    }

    private static String htmlEscape(String str) {
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll("\n", "\n<p>");
        return str;
    }

    public boolean parseOptions(PrintStream messageStream, String[] args) {
        this.argv = args;
        this.messageStream = messageStream;
        if (this.prefix.isEmpty()) {
            this.commandLine = this.callerOptions.getClass().getName();
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                this.usage(messageStream, false);
                return false;
            }
            if (arg.equals("-H") || arg.equals("--stdhelp")) {
                this.usage(messageStream, true);
                return false;
            }
            if (arg.equals("--version")) {
                messageStream.println(this.getVersion());
                return false;
            }
            String[] pair = arg.split("=", 2);
            if (pair.length == 2 && pair[1].length() == 0 && i < args.length - 1) {
                pair[1] = args[++i];
            }
            if (pair.length == 2) {
                if (this.parseOption(pair[0], pair[1], false)) continue;
                messageStream.println();
                this.usage(messageStream, true);
                return false;
            }
            if (this.parsePositionalArgument(arg)) continue;
            messageStream.println();
            this.usage(messageStream, false);
            return false;
        }
        if (!this.checkNumArguments()) {
            messageStream.println();
            this.usage(messageStream, false);
            return false;
        }
        if (!this.parseChildOptions()) {
            messageStream.println();
            this.usage(messageStream, false);
            return false;
        }
        return true;
    }

    private boolean checkNumArguments() {
        StringBuilder commandLineString = new StringBuilder();
        try {
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                String fullName = this.prefixDot + optionDefinition.name;
                StringBuilder mutextOptionNames = new StringBuilder();
                for (String mutexOption : optionDefinition.mutuallyExclusive) {
                    OptionDefinition mutextOptionDef = this.optionMap.get(mutexOption);
                    if (mutextOptionDef == null || !mutextOptionDef.hasBeenSet) continue;
                    mutextOptionNames.append(" ").append(this.prefixDot + mutextOptionDef.name);
                }
                if (optionDefinition.hasBeenSet && mutextOptionNames.length() > 0) {
                    this.messageStream.println("ERROR: Option '" + fullName + "' cannot be used in conjunction with option(s)" + mutextOptionNames.toString());
                    return false;
                }
                if (optionDefinition.isCollection) {
                    Collection c = (Collection)optionDefinition.field.get(this.callerOptions);
                    if (c.size() >= optionDefinition.minElements) continue;
                    this.messageStream.println("ERROR: Option '" + fullName + "' must be specified at least " + optionDefinition.minElements + " times.");
                    return false;
                }
                if (optionDefinition.optional || optionDefinition.hasBeenSet || optionDefinition.hasBeenSetFromParent || mutextOptionNames.length() != 0) continue;
                this.messageStream.print("ERROR: Option '" + fullName + "' is required");
                if (optionDefinition.mutuallyExclusive.isEmpty()) {
                    this.messageStream.println(".");
                } else {
                    this.messageStream.println(" unless any of " + optionDefinition.mutuallyExclusive + " are specified.");
                }
                return false;
            }
            if (this.positionalArguments != null) {
                Collection c = (Collection)this.positionalArguments.get(this.callerOptions);
                if (c.size() < this.minPositionalArguments) {
                    this.messageStream.println("ERROR: At least " + this.minPositionalArguments + " positional arguments must be specified.");
                    return false;
                }
                for (Object posArg : c) {
                    commandLineString.append(" " + posArg.toString());
                }
            }
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (!optionDefinition.hasBeenSet) continue;
                commandLineString.append(" " + this.prefixDot + optionDefinition.name + "=" + optionDefinition.field.get(this.callerOptions));
            }
            commandLineString.append("   ");
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (optionDefinition.hasBeenSet || optionDefinition.defaultValue.equals("null")) continue;
                commandLineString.append(" " + this.prefixDot + optionDefinition.name + "=" + optionDefinition.defaultValue);
            }
            this.commandLine = this.commandLine + commandLineString.toString();
            return true;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean parsePositionalArgument(String stringValue) {
        Collection c;
        Object value;
        if (this.positionalArguments == null) {
            this.messageStream.println("ERROR: Invalid argument '" + stringValue + "'.");
            return false;
        }
        try {
            value = this.constructFromString(this.getUnderlyingType(this.positionalArguments), stringValue);
        }
        catch (CommandLineParseException e) {
            this.messageStream.println("ERROR: " + e.getMessage());
            return false;
        }
        try {
            c = (Collection)this.positionalArguments.get(this.callerOptions);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (c.size() >= this.maxPositionalArguments) {
            this.messageStream.println("ERROR: No more than " + this.maxPositionalArguments + " positional arguments may be specified on the command line.");
            return false;
        }
        c.add(value);
        return true;
    }

    private boolean parseOption(String key, String stringValue, boolean optionsFile) {
        return this.parseOption(key, stringValue, optionsFile, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseOption(String key, String stringValue, boolean optionsFile, boolean precedenceSet) {
        Object value;
        Integer prefixIndex;
        if ((key = key.toUpperCase()).equals(OPTIONS_FILE)) {
            this.commandLine = this.commandLine + " " + this.prefix + OPTIONS_FILE + "=" + stringValue;
            return this.parseOptionsFile(stringValue);
        }
        if (key.startsWith(PRECEDENCE_SYMBOL)) {
            key = key.substring(PRECEDENCE_SYMBOL.length());
            precedenceSet = true;
        }
        if ((prefixIndex = Integer.valueOf(key.indexOf(46))) != -1) {
            String prefix = key.substring(0, prefixIndex);
            String subKey = key.substring(prefixIndex + 1);
            if (!subKey.isEmpty()) {
                this.childOptionArguments.append(prefix, new ChildOptionArg(subKey, stringValue, optionsFile, precedenceSet));
                return true;
            }
            this.messageStream.println("ERROR: Unrecognized option: " + key);
            return false;
        }
        OptionDefinition optionDefinition = this.optionMap.get(key);
        if (optionDefinition == null) {
            if (optionsFile) {
                return true;
            }
            this.messageStream.println("ERROR: Unrecognized option: " + key);
            return false;
        }
        if (this.optionsThatCannotBeOverridden.contains(optionDefinition.name)) {
            return true;
        }
        if (precedenceSet) {
            this.optionsThatCannotBeOverridden.add(optionDefinition.name);
        }
        if (!optionDefinition.isCollection && optionDefinition.hasBeenSet && !optionDefinition.hasBeenSetFromOptionsFile) {
            this.messageStream.println("ERROR: Option '" + key + "' cannot be specified more than once.");
            return false;
        }
        try {
            if (stringValue.equals("null")) {
                if (!optionDefinition.optional) {
                    this.messageStream.println("ERROR: non-null value must be provided for '" + key + "'.");
                    return false;
                }
                value = null;
            } else {
                value = this.constructFromString(this.getUnderlyingType(optionDefinition.field), stringValue);
            }
        }
        catch (CommandLineParseException e) {
            this.messageStream.println("ERROR: " + e.getMessage());
            return false;
        }
        try {
            if (!optionDefinition.isCollection) {
                optionDefinition.field.set(this.callerOptions, value);
                optionDefinition.hasBeenSet = true;
                optionDefinition.hasBeenSetFromOptionsFile = optionsFile;
                return true;
            }
            Collection c = (Collection)optionDefinition.field.get(this.callerOptions);
            if (value == null) {
                c.clear();
            } else {
                if (c.size() >= optionDefinition.maxElements) {
                    this.messageStream.println("ERROR: Option '" + key + "' cannot be used more than " + optionDefinition.maxElements + " times.");
                    return false;
                }
                c.add(value);
            }
            optionDefinition.hasBeenSet = true;
            optionDefinition.hasBeenSetFromOptionsFile = optionsFile;
            return true;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseOptionsFile(String optionsFile) {
        block8: {
            reader = null;
            try {
                reader = new BufferedReader(new FileReader(optionsFile));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().length() == 0) continue;
                    pair = line.split("=", 2);
                    if (pair.length == 2) {
                        if (this.parseOption(pair[0], pair[1], true)) continue;
                        this.messageStream.println();
                        this.usage(this.messageStream, true);
                        var5_7 = false;
                        break block8;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl-1000
            }
            catch (IOException e) {
                try {
                    throw new PicardException("I/O error loading OPTIONS_FILE=" + optionsFile, e);
                }
                catch (Throwable var6_9) {
                    CloserUtil.close(reader);
                    throw var6_9;
                }
            }
        }
        CloserUtil.close((Object)reader);
        return var5_7;
lbl-1000:
        // 1 sources

        {
            this.messageStream.println("Strange line in OPTIONS_FILE " + optionsFile + ": " + line);
            this.usage(this.messageStream, true);
            var5_8 = false;
        }
        CloserUtil.close((Object)reader);
        return var5_8;
lbl-1000:
        // 1 sources

        {
            reader.close();
            var4_6 = true;
        }
        CloserUtil.close((Object)reader);
        return var4_6;
    }

    private void printHtmlOptionUsage(PrintStream stream, OptionDefinition optionDefinition) {
        String type = this.getUnderlyingType(optionDefinition.field).getSimpleName();
        String optionLabel = this.prefixDot + optionDefinition.name + "=" + type;
        stream.println("<tr><td>" + optionLabel + "</td><td>" + CommandLineParser.htmlEscape(this.makeOptionDescription(optionDefinition)) + "</td></tr>");
    }

    private void printOptionUsage(PrintStream stream, OptionDefinition optionDefinition) {
        this.printOptionParamUsage(stream, optionDefinition.name, optionDefinition.shortName, this.getUnderlyingType(optionDefinition.field).getSimpleName(), this.makeOptionDescription(optionDefinition));
    }

    private void printOptionParamUsage(PrintStream stream, String name, String shortName, String type, String optionDescription) {
        String optionLabel = this.prefixDot + name;
        if (type != null) {
            optionLabel = optionLabel + "=" + type;
        }
        stream.print(optionLabel);
        if (shortName != null && shortName.length() > 0) {
            stream.println();
            optionLabel = this.prefixDot + shortName;
            if (type != null) {
                optionLabel = optionLabel + "=" + type;
            }
            stream.print(optionLabel);
        }
        int numSpaces = 30 - optionLabel.length();
        if (optionLabel.length() > 30) {
            stream.println();
            numSpaces = 30;
        }
        this.printSpaces(stream, numSpaces);
        String wrappedDescription = StringUtil.wordWrap((String)optionDescription, (int)90);
        String[] descriptionLines = wrappedDescription.split("\n");
        for (int i = 0; i < descriptionLines.length; ++i) {
            if (i > 0) {
                this.printSpaces(stream, 30);
            }
            stream.println(descriptionLines[i]);
        }
        stream.println();
    }

    private String makeOptionDescription(OptionDefinition optionDefinition) {
        Object[] enumConstants;
        StringBuilder sb = new StringBuilder();
        if (optionDefinition.doc.length() > 0) {
            sb.append(optionDefinition.doc);
            sb.append("  ");
        }
        if (optionDefinition.optional && !optionDefinition.isCollection) {
            sb.append("Default value: ");
            sb.append(optionDefinition.defaultValue);
            sb.append(". ");
            if (!optionDefinition.defaultValue.equals("null")) {
                sb.append("This option can be set to 'null' to clear the default value. ");
            }
        } else if (!optionDefinition.isCollection) {
            sb.append("Required. ");
        }
        if ((enumConstants = this.getUnderlyingType(optionDefinition.field).getEnumConstants()) == null && this.getUnderlyingType(optionDefinition.field) == Boolean.class) {
            enumConstants = TRUE_FALSE_VALUES;
        }
        if (enumConstants != null) {
            sb.append("Possible values: {");
            for (int i = 0; i < enumConstants.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(enumConstants[i].toString());
            }
            sb.append("} ");
        }
        if (optionDefinition.isCollection) {
            if (optionDefinition.minElements == 0) {
                if (optionDefinition.maxElements == Integer.MAX_VALUE) {
                    sb.append("This option may be specified 0 or more times. ");
                } else {
                    sb.append("This option must be specified no more than " + optionDefinition.maxElements + " times. ");
                }
            } else if (optionDefinition.maxElements == Integer.MAX_VALUE) {
                sb.append("This option must be specified at least " + optionDefinition.minElements + " times. ");
            } else {
                sb.append("This option may be specified between " + optionDefinition.minElements + " and " + optionDefinition.maxElements + " times. ");
            }
            if (!optionDefinition.defaultValue.equals("null")) {
                sb.append("This option can be set to 'null' to clear the default list. ");
            }
        }
        if (!optionDefinition.mutuallyExclusive.isEmpty()) {
            sb.append(" Cannot be used in conjuction with option(s)");
            for (String option : optionDefinition.mutuallyExclusive) {
                OptionDefinition mutextOptionDefinition = this.optionMap.get(option);
                if (mutextOptionDefinition == null) {
                    throw new PicardException("Invalid option definition in source code.  " + option + " doesn't match any known option.");
                }
                sb.append(" ").append(mutextOptionDefinition.name);
                if (mutextOptionDefinition.shortName.length() <= 0) continue;
                sb.append(" (").append(mutextOptionDefinition.shortName).append(")");
            }
        }
        return sb.toString();
    }

    private void printSpaces(PrintStream stream, int numSpaces) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numSpaces; ++i) {
            sb.append(" ");
        }
        stream.print(sb);
    }

    private void handleOptionAnnotation(Field field) {
        try {
            field.setAccessible(true);
            Option optionAnnotation = field.getAnnotation(Option.class);
            boolean isCollection = this.isCollectionField(field);
            if (isCollection) {
                if (optionAnnotation.maxElements() == 0) {
                    throw new CommandLineParserDefinitionException("@Option member " + field.getName() + "has maxElements = 0");
                }
                if (optionAnnotation.minElements() > optionAnnotation.maxElements()) {
                    throw new CommandLineParserDefinitionException("In @Option member " + field.getName() + ", minElements cannot be > maxElements");
                }
                if (field.get(this.callerOptions) == null) {
                    this.createCollection(field, this.callerOptions, "@Option");
                }
            }
            if (!this.canBeMadeFromString(this.getUnderlyingType(field))) {
                throw new CommandLineParserDefinitionException("@Option member " + field.getName() + " must have a String ctor or be an enum");
            }
            OptionDefinition optionDefinition = new OptionDefinition(field, field.getName(), optionAnnotation.shortName(), optionAnnotation.doc(), optionAnnotation.optional() || field.get(this.callerOptions) != null, isCollection, optionAnnotation.minElements(), optionAnnotation.maxElements(), field.get(this.callerOptions), optionAnnotation.common(), optionAnnotation.mutex());
            for (String option : optionAnnotation.mutex()) {
                OptionDefinition mutextOptionDef = this.optionMap.get(option);
                if (mutextOptionDef == null) continue;
                mutextOptionDef.mutuallyExclusive.add(field.getName());
            }
            if (this.optionMap.containsKey(optionDefinition.name)) {
                throw new CommandLineParserDefinitionException(optionDefinition.name + " has already been used");
            }
            this.optionMap.put(optionDefinition.name, optionDefinition);
            if (optionDefinition.shortName.length() > 0) {
                if (this.optionMap.containsKey(optionDefinition.shortName)) {
                    throw new CommandLineParserDefinitionException(optionDefinition.shortName + " has already been used");
                }
                this.optionMap.put(optionDefinition.shortName, optionDefinition);
            }
            this.optionDefinitions.add(optionDefinition);
        }
        catch (IllegalAccessException e) {
            throw new CommandLineParserDefinitionException(field.getName() + " must have public visibility to have @Option annotation");
        }
    }

    private void handleUsageAnnotation(Field field) {
        if (this.usagePreamble != null) {
            throw new CommandLineParserDefinitionException("@Usage cannot be used more than once in an option class.");
        }
        try {
            field.setAccessible(true);
            this.usagePreamble = (String)field.get(this.callerOptions);
            Usage usageAnnotation = field.getAnnotation(Usage.class);
            if (usageAnnotation.programVersion().length() > 0) {
                this.programVersion = usageAnnotation.programVersion();
                this.usagePreamble = this.usagePreamble + "Version: " + usageAnnotation.programVersion() + "\n";
            }
        }
        catch (IllegalAccessException e) {
            throw new CommandLineParserDefinitionException("@Usage data member must be public");
        }
        catch (ClassCastException e) {
            throw new CommandLineParserDefinitionException("@Usage can only be applied to a String data member.");
        }
    }

    private void handlePositionalArgumentAnnotation(Field field) {
        if (this.positionalArguments != null) {
            throw new CommandLineParserDefinitionException("@PositionalArguments cannot be used more than once in an option class.");
        }
        field.setAccessible(true);
        this.positionalArguments = field;
        if (!this.isCollectionField(field)) {
            throw new CommandLineParserDefinitionException("@PositionalArguments must be applied to a Collection");
        }
        if (!this.canBeMadeFromString(this.getUnderlyingType(field))) {
            throw new CommandLineParserDefinitionException("@PositionalParameters member " + field.getName() + "does not have a String ctor");
        }
        PositionalArguments positionalArgumentsAnnotation = field.getAnnotation(PositionalArguments.class);
        this.minPositionalArguments = positionalArgumentsAnnotation.minElements();
        this.maxPositionalArguments = positionalArgumentsAnnotation.maxElements();
        if (this.minPositionalArguments > this.maxPositionalArguments) {
            throw new CommandLineParserDefinitionException("In @PositionalArguments, minElements cannot be > maxElements");
        }
        try {
            if (field.get(this.callerOptions) == null) {
                this.createCollection(field, this.callerOptions, "@PositionalParameters");
            }
        }
        catch (IllegalAccessException e) {
            throw new CommandLineParserDefinitionException(field.getName() + " must have public visibility to have @PositionalParameters annotation");
        }
    }

    private void handleNestedOptionsAnnotation(Field field) {
        field.setAccessible(true);
        try {
            this.childOptionsMap.put(field.getName(), new CommandLineParser(field.get(this.callerOptions), this.prefixDot + field.getName()));
        }
        catch (IllegalAccessException e) {
            throw new CommandLineParserDefinitionException("Should never happen.", e);
        }
    }

    private boolean isCollectionField(Field field) {
        try {
            field.getType().asSubclass(Collection.class);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private void createCollection(Field field, Object callerOptions, String annotationType) throws IllegalAccessException {
        try {
            field.set(callerOptions, field.getType().newInstance());
        }
        catch (Exception ex) {
            try {
                field.set(callerOptions, new ArrayList());
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineParserDefinitionException("In collection " + annotationType + " member " + field.getName() + " cannot be constructed or auto-initialized with ArrayList, so collection must be initialized explicitly.");
            }
        }
    }

    private Class getUnderlyingType(Field field) {
        if (this.isCollectionField(field)) {
            ParameterizedType clazz = (ParameterizedType)field.getGenericType();
            Type[] genericTypes = clazz.getActualTypeArguments();
            if (genericTypes.length != 1) {
                throw new CommandLineParserDefinitionException("Strange collection type for field " + field.getName());
            }
            return (Class)genericTypes[0];
        }
        Class<?> type = field.getType();
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    private boolean canBeMadeFromString(Class clazz) {
        if (clazz.isEnum()) {
            return true;
        }
        try {
            clazz.getConstructor(String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private Object constructFromString(Class clazz, String s) {
        try {
            if (clazz.isEnum()) {
                try {
                    return Enum.valueOf(clazz, s);
                }
                catch (IllegalArgumentException e) {
                    throw new CommandLineParseException("'" + s + "' is not a valid value for " + clazz.getSimpleName() + ".", e);
                }
            }
            Constructor ctor = clazz.getConstructor(String.class);
            return ctor.newInstance(s);
        }
        catch (NoSuchMethodException e) {
            throw new CommandLineParseException("Cannot find string ctor for " + clazz.getName(), e);
        }
        catch (InstantiationException e) {
            throw new CommandLineParseException("Abstract class '" + clazz.getSimpleName() + "'cannot be used for an option value type.", e);
        }
        catch (IllegalAccessException e) {
            throw new CommandLineParseException("String constructor for option value type '" + clazz.getSimpleName() + "' must be public.", e);
        }
        catch (InvocationTargetException e) {
            throw new CommandLineParseException("Problem constructing " + clazz.getSimpleName() + " from the string '" + s + "'.", e.getCause());
        }
    }

    public String[] getArgv() {
        return this.argv;
    }

    private boolean parseChildOptions() {
        if (this.isCommandLineProgram()) {
            CommandLineProgram commandLineProgram = (CommandLineProgram)this.callerOptions;
            for (Map.Entry entry : commandLineProgram.getNestedOptions().entrySet()) {
                if (((String)entry.getKey()).contains(".")) {
                    throw new IllegalArgumentException("Prefix for nested options should not contain period: " + (String)entry.getKey());
                }
                this.childOptionsMap.put((String)entry.getKey(), new CommandLineParser(entry.getValue(), this.prefixDot + (String)entry.getKey()));
            }
        }
        boolean retval = true;
        for (String string : this.childOptionArguments.keySet()) {
            if (this.childOptionsMap.containsKey(string)) continue;
            this.messageStream.println("ERROR: Option prefix '" + string + "' is not valid.");
            retval = false;
        }
        try {
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                Object value;
                if (optionDefinition.isCollection || (value = optionDefinition.field.get(this.callerOptions)) == null) continue;
                for (CommandLineParser childParser : this.childOptionsMap.values()) {
                    this.maybePropagateValueToChild(childParser, optionDefinition, value);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Should never happen", e);
        }
        for (Map.Entry entry : this.childOptionsMap.entrySet()) {
            String prefix = (String)entry.getKey();
            CommandLineParser childParser = (CommandLineParser)entry.getValue();
            childParser.messageStream = this.messageStream;
            Collection childOptionArgs = (Collection)this.childOptionArguments.get(prefix);
            if (childOptionArgs != null) {
                for (ChildOptionArg arg : childOptionArgs) {
                    childParser.parseOption(arg.name, arg.value, arg.fromFile, arg.precedenceSet);
                }
            }
            if (!childParser.checkNumArguments()) {
                retval = false;
            }
            if (!childParser.parseChildOptions()) {
                retval = false;
            }
            this.commandLine = this.commandLine + " " + childParser.getCommandLine();
        }
        return retval;
    }

    private void maybePropagateValueToChild(CommandLineParser childParser, OptionDefinition optionDefinition, Object value) {
        try {
            Object childValue;
            OptionDefinition childOptionDefinition = childParser.optionMap.get(optionDefinition.name);
            if (childOptionDefinition != null && ((childValue = childOptionDefinition.field.get(childParser.callerOptions)) == null || optionDefinition.hasBeenSet)) {
                childOptionDefinition.field.set(childParser.callerOptions, value);
                childOptionDefinition.hasBeenSetFromParent = true;
                childOptionDefinition.hasBeenSetFromOptionsFile = optionDefinition.hasBeenSetFromOptionsFile;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    public String getProgramVersion() {
        return this.programVersion;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    private static class ChildOptionArg {
        final String name;
        final String value;
        final boolean fromFile;
        final boolean precedenceSet;

        private ChildOptionArg(String name, String value, boolean fromFile, boolean precedenceSet) {
            this.name = name;
            this.value = value;
            this.fromFile = fromFile;
            this.precedenceSet = precedenceSet;
        }
    }

    protected static class OptionDefinition {
        final Field field;
        final String name;
        final String shortName;
        final String doc;
        final boolean optional;
        final boolean isCollection;
        final int minElements;
        final int maxElements;
        final String defaultValue;
        final boolean isCommon;
        boolean hasBeenSet = false;
        boolean hasBeenSetFromOptionsFile = false;
        boolean hasBeenSetFromParent = false;
        final Set<String> mutuallyExclusive;

        private OptionDefinition(Field field, String name, String shortName, String doc, boolean optional, boolean collection, int minElements, int maxElements, Object defaultValue, boolean isCommon, String[] mutuallyExclusive) {
            this.field = field;
            this.name = name.toUpperCase();
            this.shortName = shortName.toUpperCase();
            this.doc = doc;
            this.optional = optional;
            this.isCollection = collection;
            this.minElements = minElements;
            this.maxElements = maxElements;
            this.defaultValue = defaultValue != null ? (this.isCollection && ((Collection)defaultValue).isEmpty() ? "null" : defaultValue.toString()) : "null";
            this.isCommon = isCommon;
            this.mutuallyExclusive = new HashSet<String>(Arrays.asList(mutuallyExclusive));
        }
    }
}

