/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class GeneralUtils {
    public static final boolean DEBUG_MODE_ENABLED = false;
    public static final double LOG10_P_OF_ZERO = -1000000.0;

    public static <T> String join(String separator, Collection<T> objects) {
        if (objects.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objects.iterator();
        T first = iter.next();
        if (!iter.hasNext()) {
            return first.toString();
        }
        StringBuilder ret = new StringBuilder(first.toString());
        while (iter.hasNext()) {
            ret.append(separator);
            ret.append(iter.next().toString());
        }
        return ret.toString();
    }

    public static double[] normalizeFromLog10(double[] array) {
        return GeneralUtils.normalizeFromLog10(array, false);
    }

    public static double[] normalizeFromLog10(double[] array, boolean takeLog10OfOutput) {
        return GeneralUtils.normalizeFromLog10(array, takeLog10OfOutput, false);
    }

    public static double[] normalizeFromLog10(double[] array, boolean takeLog10OfOutput, boolean keepInLogSpace) {
        int i;
        double maxValue = GeneralUtils.arrayMax(array);
        if (keepInLogSpace) {
            int i2 = 0;
            while (i2 < array.length) {
                int n = i2++;
                array[n] = array[n] - maxValue;
            }
            return array;
        }
        double[] normalized = new double[array.length];
        for (int i3 = 0; i3 < array.length; ++i3) {
            normalized[i3] = Math.pow(10.0, array[i3] - maxValue);
        }
        double sum = 0.0;
        for (i = 0; i < array.length; ++i) {
            sum += normalized[i];
        }
        for (i = 0; i < array.length; ++i) {
            double x = normalized[i] / sum;
            if (takeLog10OfOutput && ((x = Math.log10(x)) < -1000000.0 || Double.isInfinite(x))) {
                x = array[i] - maxValue;
            }
            normalized[i] = x;
        }
        return normalized;
    }

    public static double arrayMax(double[] array) {
        return array[GeneralUtils.maxElementIndex(array, array.length)];
    }

    public static int maxElementIndex(double[] array) {
        return GeneralUtils.maxElementIndex(array, array.length);
    }

    public static int maxElementIndex(double[] array, int endIndex) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int maxI = 0;
        for (int i = 1; i < endIndex; ++i) {
            if (!(array[i] > array[maxI])) continue;
            maxI = i;
        }
        return maxI;
    }

    public static <T> List<T> cons(T elt, List<T> l) {
        ArrayList<T> l2 = new ArrayList<T>();
        l2.add(elt);
        if (l != null) {
            l2.addAll(l);
        }
        return l2;
    }

    public static <T> List<List<T>> makePermutations(List<T> objects, int n, boolean withReplacement) {
        ArrayList<List<T>> combinations;
        block5: {
            combinations = new ArrayList<List<T>>();
            if (n <= 0) break block5;
            if (n == 1) {
                for (T o : objects) {
                    combinations.add(Collections.singletonList(o));
                }
            } else {
                List<List<T>> sub = GeneralUtils.makePermutations(objects, n - 1, withReplacement);
                for (List<T> subI : sub) {
                    for (T a : objects) {
                        if (!withReplacement && subI.contains(a)) continue;
                        combinations.add(GeneralUtils.cons(a, subI));
                    }
                }
            }
        }
        return combinations;
    }

    public static byte compareDoubles(double a, double b) {
        return GeneralUtils.compareDoubles(a, b, 1.0E-6);
    }

    public static byte compareDoubles(double a, double b, double epsilon) {
        if (Math.abs(a - b) < epsilon) {
            return 0;
        }
        if (a > b) {
            return -1;
        }
        return 1;
    }

    public static final <T> List<T> reverse(List<T> l) {
        ArrayList<T> newL = new ArrayList<T>(l);
        Collections.reverse(newL);
        return newL;
    }
}

