/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.transform;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class STRTransform
extends TransformSpi {
    public static final String implementedTransformURI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$transform$STRTransform == null ? (class$org$apache$ws$security$transform$STRTransform = STRTransform.class$("org.apache.ws.security.transform.STRTransform")) : class$org$apache$ws$security$transform$STRTransform).getName());
    private static boolean doDebug = false;
    private static String FAKE_NS = "urn:X";
    private static String XMLNS = "xmlns=";
    private WSDocInfo wsDocInfo = null;
    static /* synthetic */ Class class$org$apache$ws$security$transform$STRTransform;

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        doDebug = log.isDebugEnabled();
        if (doDebug) {
            log.debug((Object)("Beginning STRTransform..." + input.toString()));
        }
        try {
            Document thisDoc = this._transformObject.getDocument();
            int docHash = thisDoc.hashCode();
            if (doDebug) {
                log.debug((Object)("doc: " + thisDoc.toString() + ", " + docHash));
            }
            this.wsDocInfo = WSDocInfoStore.lookup(docHash);
            if (this.wsDocInfo == null) {
                throw new CanonicalizationException("no WSDocInfo found");
            }
            String canonAlgo = null;
            if (this._transformObject.length("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "TransformationParameters") == 1) {
                Element tmpE = XMLUtils.selectNode((Node)this._transformObject.getElement().getFirstChild(), (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", (String)"TransformationParameters", (int)0);
                Element canonElem = (Element)WSSecurityUtil.getDirectChild(tmpE, "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#");
                canonAlgo = canonElem.getAttribute("Algorithm");
                if (doDebug) {
                    log.debug((Object)("CanonAlgo: " + canonAlgo));
                }
            }
            Canonicalizer canon = Canonicalizer.getInstance(canonAlgo);
            ByteArrayOutputStream bos = null;
            byte[] buf = null;
            if (doDebug) {
                buf = input.getBytes();
                bos = new ByteArrayOutputStream(buf.length);
                bos.write(buf, 0, buf.length);
                log.debug((Object)("canon bos: " + bos.toString()));
            }
            Element str = null;
            if (!input.isElement()) {
                throw new CanonicalizationException("Wrong input format - only element input supported");
            }
            str = (Element)input.getSubNode();
            if (doDebug) {
                log.debug((Object)("STR: " + str.toString()));
            }
            SecurityTokenReference secRef = new SecurityTokenReference(str);
            Element dereferencedToken = this.dereferenceSTR(thisDoc, secRef);
            buf = canon.canonicalizeSubtree((Node)dereferencedToken, "#default");
            if (doDebug) {
                bos = new ByteArrayOutputStream(buf.length);
                bos.write(buf, 0, buf.length);
                log.debug((Object)("after c14n: " + bos.toString()));
            }
            StringBuffer bf = new StringBuffer(new String(buf));
            String bf1 = bf.toString();
            int lt = bf1.indexOf("<");
            int gt = bf1.indexOf(">");
            int idx = bf1.indexOf(XMLNS);
            if (idx < 0 || idx > gt) {
                idx = bf1.indexOf(" ");
                bf.insert(idx + 1, "xmlns=\"\" ");
                bf1 = bf.toString();
            }
            if (doDebug) {
                log.debug((Object)"last result: ");
                log.debug((Object)bf1);
            }
            return new XMLSignatureInput(bf1.getBytes());
        }
        catch (WSSecurityException ex) {
            throw new CanonicalizationException("WS Security Exception", (Exception)ex);
        }
    }

    private Element dereferenceSTR(Document doc, SecurityTokenReference secRef) throws WSSecurityException {
        Element tokElement = null;
        if (secRef.containsReference()) {
            if (doDebug) {
                log.debug((Object)"STR: Reference");
            }
            tokElement = secRef.getTokenElement(doc, this.wsDocInfo, null);
        } else if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
            if (doDebug) {
                log.debug((Object)"STR: IssuerSerial");
            }
            X509Certificate cert = null;
            X509Certificate[] certs = secRef.getX509IssuerSerial(this.wsDocInfo.getCrypto());
            if (certs == null || certs.length == 0 || certs[0] == null) {
                throw new WSSecurityException(6);
            }
            cert = certs[0];
            tokElement = this.createBSTX509(doc, cert, secRef.getElement());
        } else if (secRef.containsKeyIdentifier()) {
            if (doDebug) {
                log.debug((Object)"STR: KeyIdentifier");
            }
            X509Certificate cert = null;
            X509Certificate[] certs = secRef.getKeyIdentifier(this.wsDocInfo.getCrypto());
            if (certs == null || certs.length == 0 || certs[0] == null) {
                throw new WSSecurityException(6);
            }
            cert = certs[0];
            tokElement = this.createBSTX509(doc, cert, secRef.getElement());
        }
        return tokElement;
    }

    private Element createBSTX509(Document doc, X509Certificate cert, Element secRefE) throws WSSecurityException {
        byte[] data;
        try {
            data = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError");
        }
        String prefix = WSSecurityUtil.getPrefixNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", secRefE);
        Element elem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", prefix + ":BinarySecurityToken");
        WSSecurityUtil.setNamespace(elem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", prefix);
        elem.setAttributeNS(null, "ValueType", X509Security.getType());
        Text certText = doc.createTextNode(Base64.encode(data));
        elem.appendChild(certText);
        return elem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

