/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.Util;

public class EC2PosixParser
extends PosixParser {
    private ArrayList tokens = new ArrayList();
    private boolean eatTheRest;
    private Option currentOption;
    private Options options;

    private void init() {
        this.eatTheRest = false;
        this.tokens.clear();
        this.currentOption = null;
    }

    protected String[] flatten(Options options, String[] arguments, boolean stopAtNonOption) {
        this.init();
        this.options = options;
        Iterator<String> iter = Arrays.asList(arguments).iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            if (token.startsWith("--")) {
                if (token.indexOf(61) != -1) {
                    this.tokens.add(token.substring(0, token.indexOf(61)));
                    this.tokens.add(token.substring(token.indexOf(61) + 1, token.length()));
                } else if (options.hasOption(token)) {
                    this.processOptionToken(token, stopAtNonOption);
                } else {
                    this.tokens.add(token);
                }
            } else if ("-".equals(token)) {
                this.processSingleHyphen(token);
            } else if (token.startsWith("-")) {
                int tokenLength = token.length();
                if (tokenLength == 2) {
                    this.processOptionToken(token, stopAtNonOption);
                } else if (options.hasOption(token)) {
                    this.tokens.add(token);
                } else {
                    this.burstToken(token, stopAtNonOption);
                }
            } else if (stopAtNonOption) {
                this.process(token);
            } else {
                this.tokens.add(token);
            }
            this.gobble(iter);
        }
        return this.tokens.toArray(new String[this.tokens.size()]);
    }

    private void gobble(Iterator iter) {
        if (this.eatTheRest) {
            while (iter.hasNext()) {
                this.tokens.add(iter.next());
            }
        }
    }

    private void process(String value) {
        if (this.currentOption != null && this.currentOption.hasArg()) {
            if (this.currentOption.hasArg()) {
                this.tokens.add(value);
                this.currentOption = null;
            } else if (this.currentOption.hasArgs()) {
                this.tokens.add(value);
            }
        } else {
            this.eatTheRest = true;
            this.tokens.add("--");
            this.tokens.add(value);
        }
    }

    private void processSingleHyphen(String hyphen) {
        try {
            String[] stdinLines = this.parseStdin();
            for (int i = 0; i < stdinLines.length; ++i) {
                if (this.currentOption != null && i > 0) {
                    this.tokens.add("-" + this.currentOption.getOpt());
                }
                this.tokens.add(stdinLines[i]);
            }
            this.currentOption = null;
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    private void processOptionToken(String token, boolean stopAtNonOption) {
        if (this.options.hasOption(token)) {
            this.currentOption = this.options.getOption(token);
            this.tokens.add(token);
        } else if (stopAtNonOption) {
            this.eatTheRest = true;
        } else {
            this.tokens.add(token);
        }
    }

    private String[] parseStdin() throws IOException {
        System.out.println("-- waiting for stdin --");
        ArrayList<String> params = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        while ((line = r.readLine()) != null) {
            params.add(line);
        }
        return params.toArray(new String[0]);
    }

    public void processArgs(Option opt, ListIterator iter) throws ParseException {
        if (!iter.hasNext() && !opt.hasOptionalArg()) {
            throw new MissingArgumentException("Missing argument for option:" + opt.getKey());
        }
        if (iter.hasNext()) {
            String str = (String)iter.next();
            if (this.options.hasOption(str) && str.startsWith("-")) {
                if (!opt.hasOptionalArg()) {
                    throw new MissingArgumentException("Missing argument for option:" + opt.getKey());
                }
                iter.previous();
            } else {
                try {
                    opt.addValueForProcessing(Util.stripLeadingAndTrailingQuotes((String)str));
                }
                catch (RuntimeException exp) {
                    iter.previous();
                }
            }
        }
        if (opt.getValues() == null && !opt.hasOptionalArg()) {
            throw new MissingArgumentException("Missing argument for option:" + opt.getKey());
        }
    }

    protected void burstToken(String token, boolean stopAtNonOption) {
        int tokenLength = token.length();
        for (int i = 1; i < tokenLength; ++i) {
            String ch = String.valueOf(token.charAt(i));
            boolean hasOption = this.options.hasOption(ch);
            if (hasOption) {
                this.tokens.add("-" + ch);
                this.currentOption = this.options.getOption(ch);
                if (!this.currentOption.hasArg() || token.length() == i + 1) continue;
                this.tokens.add(token.substring(i + 1));
                break;
            }
            if (stopAtNonOption) {
                this.process(token.substring(i));
                continue;
            }
            this.tokens.add(token);
            break;
        }
    }
}

