/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PurchaseReservedInstancesOfferingRequestMarshaller
implements Marshaller<Request<PurchaseReservedInstancesOfferingRequest>, PurchaseReservedInstancesOfferingRequest> {
    public Request<PurchaseReservedInstancesOfferingRequest> marshall(PurchaseReservedInstancesOfferingRequest purchaseReservedInstancesOfferingRequest) {
        ReservedInstanceLimitPrice reservedInstanceLimitPriceLimitPrice;
        if (purchaseReservedInstancesOfferingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)purchaseReservedInstancesOfferingRequest, "AmazonEC2");
        request.addParameter("Action", "PurchaseReservedInstancesOffering");
        request.addParameter("Version", "2013-10-15");
        if (purchaseReservedInstancesOfferingRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)purchaseReservedInstancesOfferingRequest.isDryRun()));
        }
        if (purchaseReservedInstancesOfferingRequest.getReservedInstancesOfferingId() != null) {
            request.addParameter("ReservedInstancesOfferingId", StringUtils.fromString((String)purchaseReservedInstancesOfferingRequest.getReservedInstancesOfferingId()));
        }
        if (purchaseReservedInstancesOfferingRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)purchaseReservedInstancesOfferingRequest.getInstanceCount()));
        }
        if ((reservedInstanceLimitPriceLimitPrice = purchaseReservedInstancesOfferingRequest.getLimitPrice()) != null) {
            if (reservedInstanceLimitPriceLimitPrice.getAmount() != null) {
                request.addParameter("LimitPrice.Amount", StringUtils.fromDouble((Double)reservedInstanceLimitPriceLimitPrice.getAmount()));
            }
            if (reservedInstanceLimitPriceLimitPrice.getCurrencyCode() != null) {
                request.addParameter("LimitPrice.CurrencyCode", StringUtils.fromString((String)reservedInstanceLimitPriceLimitPrice.getCurrencyCode()));
            }
        }
        return request;
    }
}

